// components/services/unzip/public/mojom/unzipper.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_TEST_UTILS_H_
#define COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_TEST_UTILS_H_

#include "components/services/unzip/public/mojom/unzipper.mojom.h"


namespace unzip::mojom {


class  UnzipFilterInterceptorForTesting : public UnzipFilter {
  virtual UnzipFilter* GetForwardingInterface() = 0;
  void ShouldUnzipFile(const ::base::FilePath& path, ShouldUnzipFileCallback callback) override;
};
class  UnzipFilterAsyncWaiter {
 public:
  explicit UnzipFilterAsyncWaiter(UnzipFilter* proxy);

  UnzipFilterAsyncWaiter(const UnzipFilterAsyncWaiter&) = delete;
  UnzipFilterAsyncWaiter& operator=(const UnzipFilterAsyncWaiter&) = delete;

  ~UnzipFilterAsyncWaiter();
  void ShouldUnzipFile(
      const ::base::FilePath& path, bool* out_result);
  bool ShouldUnzipFile(const ::base::FilePath& path);

 private:
  UnzipFilter* const proxy_;
};


class  UnzipListenerInterceptorForTesting : public UnzipListener {
  virtual UnzipListener* GetForwardingInterface() = 0;
  void OnProgress(uint64_t bytes) override;
};
class  UnzipListenerAsyncWaiter {
 public:
  explicit UnzipListenerAsyncWaiter(UnzipListener* proxy);

  UnzipListenerAsyncWaiter(const UnzipListenerAsyncWaiter&) = delete;
  UnzipListenerAsyncWaiter& operator=(const UnzipListenerAsyncWaiter&) = delete;

  ~UnzipListenerAsyncWaiter();

 private:
  UnzipListener* const proxy_;
};


class  UnzipperInterceptorForTesting : public Unzipper {
  virtual Unzipper* GetForwardingInterface() = 0;
  void Unzip(::base::File zip_file, ::mojo::PendingRemote<::storage::mojom::Directory> output_dir, UnzipOptionsPtr options, ::mojo::PendingRemote<UnzipFilter> filter, ::mojo::PendingRemote<UnzipListener> listener, UnzipCallback callback) override;
  void DetectEncoding(::base::File zip_file, DetectEncodingCallback callback) override;
  void GetExtractedInfo(::base::File zip_file, GetExtractedInfoCallback callback) override;
  void DecodeXz(::base::File in_file, ::base::File out_file, DecodeXzCallback callback) override;
};
class  UnzipperAsyncWaiter {
 public:
  explicit UnzipperAsyncWaiter(Unzipper* proxy);

  UnzipperAsyncWaiter(const UnzipperAsyncWaiter&) = delete;
  UnzipperAsyncWaiter& operator=(const UnzipperAsyncWaiter&) = delete;

  ~UnzipperAsyncWaiter();
  void Unzip(
      ::base::File zip_file, ::mojo::PendingRemote<::storage::mojom::Directory> output_dir, UnzipOptionsPtr options, ::mojo::PendingRemote<UnzipFilter> filter, ::mojo::PendingRemote<UnzipListener> listener, bool* out_result);
  bool Unzip(::base::File zip_file, ::mojo::PendingRemote<::storage::mojom::Directory> output_dir, UnzipOptionsPtr options, ::mojo::PendingRemote<UnzipFilter> filter, ::mojo::PendingRemote<UnzipListener> listener);
  void DetectEncoding(
      ::base::File zip_file, int32_t* out_encoding);
  int32_t DetectEncoding(::base::File zip_file);
  void GetExtractedInfo(
      ::base::File zip_file, InfoPtr* out_info);
  InfoPtr GetExtractedInfo(::base::File zip_file);
  void DecodeXz(
      ::base::File in_file, ::base::File out_file, bool* out_result);
  bool DecodeXz(::base::File in_file, ::base::File out_file);

 private:
  Unzipper* const proxy_;
};




}  // unzip::mojom

#endif  // COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_TEST_UTILS_H_