// components/services/unzip/public/mojom/unzipper.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/unzip/public/mojom/unzipper.mojom-shared-internal.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/services/unzip/public/mojom/unzipper.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unzip::mojom::UnzipOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::unzip::mojom::UnzipOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::unzip::mojom::internal::UnzipOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::encoding(input)) in_encoding = Traits::encoding(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->encoding)::BaseType> encoding_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_encoding,
      encoding_fragment);

    fragment->encoding.Set(
        encoding_fragment.is_null() ? nullptr : encoding_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->encoding.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null encoding in UnzipOptions struct");

    decltype(Traits::password(input)) in_password = Traits::password(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->password)::BaseType> password_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_password,
      password_fragment);

    fragment->password.Set(
        password_fragment.is_null() ? nullptr : password_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->password.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null password in UnzipOptions struct");
  }

  static bool Deserialize(::unzip::mojom::internal::UnzipOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::unzip::mojom::UnzipOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::unzip::mojom::InfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::unzip::mojom::InfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::unzip::mojom::internal::Info_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->size_is_valid = Traits::size_is_valid(input);

    fragment->size = Traits::size(input);

    fragment->is_encrypted = Traits::is_encrypted(input);

    fragment->uses_aes_encryption = Traits::uses_aes_encryption(input);
  }

  static bool Deserialize(::unzip::mojom::internal::Info_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::unzip::mojom::InfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace unzip::mojom {

inline void UnzipOptionsDataView::GetEncodingDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->encoding.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UnzipOptionsDataView::GetPasswordDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->password.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // unzip::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_SHARED_H_