// components/services/unzip/public/mojom/unzipper.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace unzip::mojom {
namespace internal {
class  UnzipFilter_ShouldUnzipFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> path;

 private:
  friend class mojo::internal::MessageFragment<UnzipFilter_ShouldUnzipFile_Params_Data>;

  UnzipFilter_ShouldUnzipFile_Params_Data();
  ~UnzipFilter_ShouldUnzipFile_Params_Data() = delete;
};
static_assert(sizeof(UnzipFilter_ShouldUnzipFile_Params_Data) == 16,
              "Bad sizeof(UnzipFilter_ShouldUnzipFile_Params_Data)");
class  UnzipFilter_ShouldUnzipFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t result : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<UnzipFilter_ShouldUnzipFile_ResponseParams_Data>;

  UnzipFilter_ShouldUnzipFile_ResponseParams_Data();
  ~UnzipFilter_ShouldUnzipFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(UnzipFilter_ShouldUnzipFile_ResponseParams_Data) == 16,
              "Bad sizeof(UnzipFilter_ShouldUnzipFile_ResponseParams_Data)");
class  UnzipListener_OnProgress_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t bytes;

 private:
  friend class mojo::internal::MessageFragment<UnzipListener_OnProgress_Params_Data>;

  UnzipListener_OnProgress_Params_Data();
  ~UnzipListener_OnProgress_Params_Data() = delete;
};
static_assert(sizeof(UnzipListener_OnProgress_Params_Data) == 16,
              "Bad sizeof(UnzipListener_OnProgress_Params_Data)");
class  Unzipper_Unzip_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyFile_Data> zip_file;
  mojo::internal::Interface_Data output_dir;
  mojo::internal::Pointer<internal::UnzipOptions_Data> options;
  mojo::internal::Interface_Data filter;
  mojo::internal::Interface_Data listener;

 private:
  friend class mojo::internal::MessageFragment<Unzipper_Unzip_Params_Data>;

  Unzipper_Unzip_Params_Data();
  ~Unzipper_Unzip_Params_Data() = delete;
};
static_assert(sizeof(Unzipper_Unzip_Params_Data) == 48,
              "Bad sizeof(Unzipper_Unzip_Params_Data)");
class  Unzipper_Unzip_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t result : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Unzipper_Unzip_ResponseParams_Data>;

  Unzipper_Unzip_ResponseParams_Data();
  ~Unzipper_Unzip_ResponseParams_Data() = delete;
};
static_assert(sizeof(Unzipper_Unzip_ResponseParams_Data) == 16,
              "Bad sizeof(Unzipper_Unzip_ResponseParams_Data)");
class  Unzipper_DetectEncoding_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyFile_Data> zip_file;

 private:
  friend class mojo::internal::MessageFragment<Unzipper_DetectEncoding_Params_Data>;

  Unzipper_DetectEncoding_Params_Data();
  ~Unzipper_DetectEncoding_Params_Data() = delete;
};
static_assert(sizeof(Unzipper_DetectEncoding_Params_Data) == 16,
              "Bad sizeof(Unzipper_DetectEncoding_Params_Data)");
class  Unzipper_DetectEncoding_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t encoding;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Unzipper_DetectEncoding_ResponseParams_Data>;

  Unzipper_DetectEncoding_ResponseParams_Data();
  ~Unzipper_DetectEncoding_ResponseParams_Data() = delete;
};
static_assert(sizeof(Unzipper_DetectEncoding_ResponseParams_Data) == 16,
              "Bad sizeof(Unzipper_DetectEncoding_ResponseParams_Data)");
class  Unzipper_GetExtractedInfo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyFile_Data> zip_file;

 private:
  friend class mojo::internal::MessageFragment<Unzipper_GetExtractedInfo_Params_Data>;

  Unzipper_GetExtractedInfo_Params_Data();
  ~Unzipper_GetExtractedInfo_Params_Data() = delete;
};
static_assert(sizeof(Unzipper_GetExtractedInfo_Params_Data) == 16,
              "Bad sizeof(Unzipper_GetExtractedInfo_Params_Data)");
class  Unzipper_GetExtractedInfo_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::Info_Data> info;

 private:
  friend class mojo::internal::MessageFragment<Unzipper_GetExtractedInfo_ResponseParams_Data>;

  Unzipper_GetExtractedInfo_ResponseParams_Data();
  ~Unzipper_GetExtractedInfo_ResponseParams_Data() = delete;
};
static_assert(sizeof(Unzipper_GetExtractedInfo_ResponseParams_Data) == 16,
              "Bad sizeof(Unzipper_GetExtractedInfo_ResponseParams_Data)");
class  Unzipper_DecodeXz_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyFile_Data> in_file;
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> out_file;

 private:
  friend class mojo::internal::MessageFragment<Unzipper_DecodeXz_Params_Data>;

  Unzipper_DecodeXz_Params_Data();
  ~Unzipper_DecodeXz_Params_Data() = delete;
};
static_assert(sizeof(Unzipper_DecodeXz_Params_Data) == 24,
              "Bad sizeof(Unzipper_DecodeXz_Params_Data)");
class  Unzipper_DecodeXz_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t result : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Unzipper_DecodeXz_ResponseParams_Data>;

  Unzipper_DecodeXz_ResponseParams_Data();
  ~Unzipper_DecodeXz_ResponseParams_Data() = delete;
};
static_assert(sizeof(Unzipper_DecodeXz_ResponseParams_Data) == 16,
              "Bad sizeof(Unzipper_DecodeXz_ResponseParams_Data)");

}  // namespace internal


class UnzipFilter_ShouldUnzipFile_ParamsDataView {
 public:
  UnzipFilter_ShouldUnzipFile_ParamsDataView() = default;

  UnzipFilter_ShouldUnzipFile_ParamsDataView(
      internal::UnzipFilter_ShouldUnzipFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::UnzipFilter_ShouldUnzipFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UnzipFilter_ShouldUnzipFile_ResponseParamsDataView {
 public:
  UnzipFilter_ShouldUnzipFile_ResponseParamsDataView() = default;

  UnzipFilter_ShouldUnzipFile_ResponseParamsDataView(
      internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool result() const {
    return data_->result;
  }
 private:
  internal::UnzipFilter_ShouldUnzipFile_ResponseParams_Data* data_ = nullptr;
};


class UnzipListener_OnProgress_ParamsDataView {
 public:
  UnzipListener_OnProgress_ParamsDataView() = default;

  UnzipListener_OnProgress_ParamsDataView(
      internal::UnzipListener_OnProgress_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t bytes() const {
    return data_->bytes;
  }
 private:
  internal::UnzipListener_OnProgress_Params_Data* data_ = nullptr;
};


class Unzipper_Unzip_ParamsDataView {
 public:
  Unzipper_Unzip_ParamsDataView() = default;

  Unzipper_Unzip_ParamsDataView(
      internal::Unzipper_Unzip_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetZipFileDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadZipFile(UserType* output) {
    
    auto* pointer = data_->zip_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeOutputDir() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::storage::mojom::DirectoryInterfaceBase>>(
            &data_->output_dir, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetOptionsDataView(
      UnzipOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptions(UserType* output) {
    
    auto* pointer = data_->options.Get();
    return mojo::internal::Deserialize<::unzip::mojom::UnzipOptionsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeFilter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::unzip::mojom::UnzipFilterInterfaceBase>>(
            &data_->filter, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::unzip::mojom::UnzipListenerInterfaceBase>>(
            &data_->listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Unzipper_Unzip_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Unzipper_Unzip_ResponseParamsDataView {
 public:
  Unzipper_Unzip_ResponseParamsDataView() = default;

  Unzipper_Unzip_ResponseParamsDataView(
      internal::Unzipper_Unzip_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool result() const {
    return data_->result;
  }
 private:
  internal::Unzipper_Unzip_ResponseParams_Data* data_ = nullptr;
};


class Unzipper_DetectEncoding_ParamsDataView {
 public:
  Unzipper_DetectEncoding_ParamsDataView() = default;

  Unzipper_DetectEncoding_ParamsDataView(
      internal::Unzipper_DetectEncoding_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetZipFileDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadZipFile(UserType* output) {
    
    auto* pointer = data_->zip_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
 private:
  internal::Unzipper_DetectEncoding_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Unzipper_DetectEncoding_ResponseParamsDataView {
 public:
  Unzipper_DetectEncoding_ResponseParamsDataView() = default;

  Unzipper_DetectEncoding_ResponseParamsDataView(
      internal::Unzipper_DetectEncoding_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t encoding() const {
    return data_->encoding;
  }
 private:
  internal::Unzipper_DetectEncoding_ResponseParams_Data* data_ = nullptr;
};


class Unzipper_GetExtractedInfo_ParamsDataView {
 public:
  Unzipper_GetExtractedInfo_ParamsDataView() = default;

  Unzipper_GetExtractedInfo_ParamsDataView(
      internal::Unzipper_GetExtractedInfo_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetZipFileDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadZipFile(UserType* output) {
    
    auto* pointer = data_->zip_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
 private:
  internal::Unzipper_GetExtractedInfo_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Unzipper_GetExtractedInfo_ResponseParamsDataView {
 public:
  Unzipper_GetExtractedInfo_ResponseParamsDataView() = default;

  Unzipper_GetExtractedInfo_ResponseParamsDataView(
      internal::Unzipper_GetExtractedInfo_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      InfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::unzip::mojom::InfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::Unzipper_GetExtractedInfo_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Unzipper_DecodeXz_ParamsDataView {
 public:
  Unzipper_DecodeXz_ParamsDataView() = default;

  Unzipper_DecodeXz_ParamsDataView(
      internal::Unzipper_DecodeXz_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInFileDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInFile(UserType* output) {
    
    auto* pointer = data_->in_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  inline void GetOutFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutFile(UserType* output) {
    
    auto* pointer = data_->out_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
 private:
  internal::Unzipper_DecodeXz_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Unzipper_DecodeXz_ResponseParamsDataView {
 public:
  Unzipper_DecodeXz_ResponseParamsDataView() = default;

  Unzipper_DecodeXz_ResponseParamsDataView(
      internal::Unzipper_DecodeXz_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool result() const {
    return data_->result;
  }
 private:
  internal::Unzipper_DecodeXz_ResponseParams_Data* data_ = nullptr;
};

inline void UnzipFilter_ShouldUnzipFile_ParamsDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}






inline void Unzipper_Unzip_ParamsDataView::GetZipFileDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->zip_file.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}
inline void Unzipper_Unzip_ParamsDataView::GetOptionsDataView(
    UnzipOptionsDataView* output) {
  auto pointer = data_->options.Get();
  *output = UnzipOptionsDataView(pointer, message_);
}




inline void Unzipper_DetectEncoding_ParamsDataView::GetZipFileDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->zip_file.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}




inline void Unzipper_GetExtractedInfo_ParamsDataView::GetZipFileDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->zip_file.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}


inline void Unzipper_GetExtractedInfo_ResponseParamsDataView::GetInfoDataView(
    InfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = InfoDataView(pointer, message_);
}


inline void Unzipper_DecodeXz_ParamsDataView::GetInFileDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->in_file.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}
inline void Unzipper_DecodeXz_ParamsDataView::GetOutFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->out_file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}





}  // unzip::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SERVICES_UNZIP_PUBLIC_MOJOM_UNZIPPER_MOJOM_PARAMS_DATA_H_