// components/services/storage/public/mojom/storage_usage_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_USAGE_INFO_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_USAGE_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/storage_usage_info.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/storage_usage_info.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/storage_usage_info.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"
#include <string>
#include <vector>








namespace storage::mojom {








class  StorageUsageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StorageUsageInfo, T>::value>;
  using DataView = StorageUsageInfoDataView;
  using Data_ = internal::StorageUsageInfo_Data;

  template <typename... Args>
  static StorageUsageInfoPtr New(Args&&... args) {
    return StorageUsageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StorageUsageInfoPtr From(const U& u) {
    return mojo::TypeConverter<StorageUsageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StorageUsageInfo>::Convert(*this);
  }


  StorageUsageInfo();

  StorageUsageInfo(
      const ::blink::StorageKey& storage_key,
      int64_t total_size_bytes,
      ::base::Time last_modified);


  ~StorageUsageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StorageUsageInfoPtr>
  StorageUsageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StorageUsageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StorageUsageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StorageUsageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StorageUsageInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StorageUsageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StorageUsageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StorageUsageInfo_UnserializedMessageContext<
            UserType, StorageUsageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StorageUsageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StorageUsageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StorageUsageInfo_UnserializedMessageContext<
            UserType, StorageUsageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StorageUsageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::StorageKey storage_key;
  
  int64_t total_size_bytes;
  
  ::base::Time last_modified;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
StorageUsageInfoPtr StorageUsageInfo::Clone() const {
  return New(
      mojo::Clone(storage_key),
      mojo::Clone(total_size_bytes),
      mojo::Clone(last_modified)
  );
}

template <typename T, StorageUsageInfo::EnableIfSame<T>*>
bool StorageUsageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->storage_key, other_struct.storage_key))
    return false;
  if (!mojo::Equals(this->total_size_bytes, other_struct.total_size_bytes))
    return false;
  if (!mojo::Equals(this->last_modified, other_struct.last_modified))
    return false;
  return true;
}

template <typename T, StorageUsageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.storage_key < rhs.storage_key)
    return true;
  if (rhs.storage_key < lhs.storage_key)
    return false;
  if (lhs.total_size_bytes < rhs.total_size_bytes)
    return true;
  if (rhs.total_size_bytes < lhs.total_size_bytes)
    return false;
  if (lhs.last_modified < rhs.last_modified)
    return true;
  if (rhs.last_modified < lhs.last_modified)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::StorageUsageInfo::DataView,
                                         ::storage::mojom::StorageUsageInfoPtr> {
  static bool IsNull(const ::storage::mojom::StorageUsageInfoPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::StorageUsageInfoPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::StorageUsageInfo::storage_key)& storage_key(
      const ::storage::mojom::StorageUsageInfoPtr& input) {
    return input->storage_key;
  }

  static decltype(::storage::mojom::StorageUsageInfo::total_size_bytes) total_size_bytes(
      const ::storage::mojom::StorageUsageInfoPtr& input) {
    return input->total_size_bytes;
  }

  static const decltype(::storage::mojom::StorageUsageInfo::last_modified)& last_modified(
      const ::storage::mojom::StorageUsageInfoPtr& input) {
    return input->last_modified;
  }

  static bool Read(::storage::mojom::StorageUsageInfo::DataView input, ::storage::mojom::StorageUsageInfoPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_USAGE_INFO_MOJOM_H_