// components/services/storage/public/mojom/storage_policy_update.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_POLICY_UPDATE_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_POLICY_UPDATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/storage_policy_update.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/storage_policy_update.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/storage_policy_update.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>








namespace storage::mojom {








class  StoragePolicyUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StoragePolicyUpdate, T>::value>;
  using DataView = StoragePolicyUpdateDataView;
  using Data_ = internal::StoragePolicyUpdate_Data;

  template <typename... Args>
  static StoragePolicyUpdatePtr New(Args&&... args) {
    return StoragePolicyUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StoragePolicyUpdatePtr From(const U& u) {
    return mojo::TypeConverter<StoragePolicyUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StoragePolicyUpdate>::Convert(*this);
  }


  StoragePolicyUpdate();

  StoragePolicyUpdate(
      const ::url::Origin& origin,
      bool purge_on_shutdown);


  ~StoragePolicyUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StoragePolicyUpdatePtr>
  StoragePolicyUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StoragePolicyUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StoragePolicyUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StoragePolicyUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StoragePolicyUpdate::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StoragePolicyUpdate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StoragePolicyUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StoragePolicyUpdate_UnserializedMessageContext<
            UserType, StoragePolicyUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StoragePolicyUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StoragePolicyUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StoragePolicyUpdate_UnserializedMessageContext<
            UserType, StoragePolicyUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StoragePolicyUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  bool purge_on_shutdown;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
StoragePolicyUpdatePtr StoragePolicyUpdate::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(purge_on_shutdown)
  );
}

template <typename T, StoragePolicyUpdate::EnableIfSame<T>*>
bool StoragePolicyUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->purge_on_shutdown, other_struct.purge_on_shutdown))
    return false;
  return true;
}

template <typename T, StoragePolicyUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.purge_on_shutdown < rhs.purge_on_shutdown)
    return true;
  if (rhs.purge_on_shutdown < lhs.purge_on_shutdown)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::StoragePolicyUpdate::DataView,
                                         ::storage::mojom::StoragePolicyUpdatePtr> {
  static bool IsNull(const ::storage::mojom::StoragePolicyUpdatePtr& input) { return !input; }
  static void SetToNull(::storage::mojom::StoragePolicyUpdatePtr* output) { output->reset(); }

  static const decltype(::storage::mojom::StoragePolicyUpdate::origin)& origin(
      const ::storage::mojom::StoragePolicyUpdatePtr& input) {
    return input->origin;
  }

  static decltype(::storage::mojom::StoragePolicyUpdate::purge_on_shutdown) purge_on_shutdown(
      const ::storage::mojom::StoragePolicyUpdatePtr& input) {
    return input->purge_on_shutdown;
  }

  static bool Read(::storage::mojom::StoragePolicyUpdate::DataView input, ::storage::mojom::StoragePolicyUpdatePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_STORAGE_POLICY_UPDATE_MOJOM_H_