// components/services/storage/public/mojom/session_storage_control.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/session_storage_control.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared.h"
#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/services/storage/public/mojom/session_storage_control.mojom-data-view.h"




namespace std {

template <>
struct hash<::storage::mojom::SessionStorageCloneType>
    : public mojo::internal::EnumHashImpl<::storage::mojom::SessionStorageCloneType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::SessionStorageCloneType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::SessionStorageCloneType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::SessionStorageCloneType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::SessionStorageUsageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::SessionStorageUsageInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::SessionStorageUsageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::storage_key(input)) in_storage_key = Traits::storage_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->storage_key)::BaseType> storage_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_storage_key,
      storage_key_fragment);

    fragment->storage_key.Set(
        storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->storage_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_key in SessionStorageUsageInfo struct");

    decltype(Traits::namespace_id(input)) in_namespace_id = Traits::namespace_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->namespace_id)::BaseType> namespace_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_namespace_id,
      namespace_id_fragment);

    fragment->namespace_id.Set(
        namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->namespace_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null namespace_id in SessionStorageUsageInfo struct");
  }

  static bool Deserialize(::storage::mojom::internal::SessionStorageUsageInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::SessionStorageUsageInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void SessionStorageUsageInfoDataView::GetStorageKeyDataView(
    ::blink::mojom::StorageKeyDataView* output) {
  auto pointer = data_->storage_key.Get();
  *output = ::blink::mojom::StorageKeyDataView(pointer, message_);
}
inline void SessionStorageUsageInfoDataView::GetNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->namespace_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::storage::mojom::SessionStorageCloneType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::SessionStorageCloneType value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_SHARED_H_