// components/services/storage/public/mojom/session_storage_control.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_SEND_VALIDATION_H_

#include "components/services/storage/public/mojom/session_storage_control.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared.h"
#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"

#include "components/services/storage/public/mojom/session_storage_control.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::storage::mojom::SessionStorageCloneType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::SessionStorageUsageInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::SessionStorageUsageInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::SessionStorageUsageInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::storage_key(input)) in_storage_key = Traits::storage_key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->storage_key)::BaseType> storage_key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::StorageKeyDataView, send_validation>(
        in_storage_key,
        storage_key_fragment);

      fragment->storage_key.Set(
          storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->storage_key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null storage_key in SessionStorageUsageInfo struct");

      decltype(Traits::namespace_id(input)) in_namespace_id = Traits::namespace_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->namespace_id)::BaseType> namespace_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_namespace_id,
        namespace_id_fragment);

      fragment->namespace_id.Set(
          namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->namespace_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null namespace_id in SessionStorageUsageInfo struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_SEND_VALIDATION_H_