// components/services/storage/public/mojom/session_storage_control.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/services/storage/public/mojom/session_storage_control.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared.h"
#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"


namespace storage::mojom {
class SessionStorageUsageInfoDataView;



}  // storage::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::SessionStorageUsageInfoDataView> {
  using Data = ::storage::mojom::internal::SessionStorageUsageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {


enum class SessionStorageCloneType : int32_t {
  
  kImmediate = 0,
  
  kWaitForCloneOnNamespace = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SessionStorageCloneType value);
inline bool IsKnownEnumValue(SessionStorageCloneType value) {
  return internal::SessionStorageCloneType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SessionStorageControlInterfaceBase {};

using SessionStorageControlPtrDataView =
    mojo::InterfacePtrDataView<SessionStorageControlInterfaceBase>;
using SessionStorageControlRequestDataView =
    mojo::InterfaceRequestDataView<SessionStorageControlInterfaceBase>;
using SessionStorageControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SessionStorageControlInterfaceBase>;
using SessionStorageControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SessionStorageControlInterfaceBase>;


class SessionStorageUsageInfoDataView {
 public:
  SessionStorageUsageInfoDataView() = default;

  SessionStorageUsageInfoDataView(
      internal::SessionStorageUsageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStorageKeyDataView(
      ::blink::mojom::StorageKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorageKey(UserType* output) {
    
    auto* pointer = data_->storage_key.Get();
    return mojo::internal::Deserialize<::blink::mojom::StorageKeyDataView>(
        pointer, output, message_);
  }
  inline void GetNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNamespaceId(UserType* output) {
    
    auto* pointer = data_->namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SessionStorageUsageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SESSION_STORAGE_CONTROL_MOJOM_DATA_VIEW_H_