// components/services/storage/public/mojom/service_worker_storage_control.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/service_worker_database.mojom.h"
#include "components/services/storage/public/mojom/storage_policy_update.mojom-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-forward.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace storage::mojom {

class ServiceWorkerLiveVersionRefProxy;

template <typename ImplRefTraits>
class ServiceWorkerLiveVersionRefStub;

class ServiceWorkerLiveVersionRefRequestValidator;


class ServiceWorkerLiveVersionRef
    : public ServiceWorkerLiveVersionRefInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.ServiceWorkerLiveVersionRef";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerLiveVersionRefInterfaceBase;
  using Proxy_ = ServiceWorkerLiveVersionRefProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerLiveVersionRefStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerLiveVersionRefRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerLiveVersionRef() = default;
};

class ServiceWorkerResourceReaderProxy;

template <typename ImplRefTraits>
class ServiceWorkerResourceReaderStub;

class ServiceWorkerResourceReaderRequestValidator;
class ServiceWorkerResourceReaderResponseValidator;


class ServiceWorkerResourceReader
    : public ServiceWorkerResourceReaderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.ServiceWorkerResourceReader";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerResourceReaderInterfaceBase;
  using Proxy_ = ServiceWorkerResourceReaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerResourceReaderStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerResourceReaderRequestValidator;
  using ResponseValidator_ = ServiceWorkerResourceReaderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadResponseHeadMinVersion = 0,
    kPrepareReadDataMinVersion = 0,
    kReadDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReadResponseHead_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrepareReadData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerResourceReader() = default;

  using ReadResponseHeadCallback = base::OnceCallback<void(int32_t, ::network::mojom::URLResponseHeadPtr, std::optional<::mojo_base::BigBuffer>)>;
  using ReadResponseHeadMojoCallback = base::OnceCallback<void(int32_t, ::network::mojom::URLResponseHeadPtr, std::optional<::mojo_base::BigBuffer>)>;

  virtual void ReadResponseHead(ReadResponseHeadCallback callback) = 0;

  using PrepareReadDataCallback = base::OnceCallback<void(::mojo::ScopedDataPipeConsumerHandle)>;
  using PrepareReadDataMojoCallback = base::OnceCallback<void(::mojo::ScopedDataPipeConsumerHandle)>;

  virtual void PrepareReadData(int64_t size, PrepareReadDataCallback callback) = 0;

  using ReadDataCallback = base::OnceCallback<void(int32_t)>;
  using ReadDataMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void ReadData(ReadDataCallback callback) = 0;
};

class ServiceWorkerResourceWriterProxy;

template <typename ImplRefTraits>
class ServiceWorkerResourceWriterStub;

class ServiceWorkerResourceWriterRequestValidator;
class ServiceWorkerResourceWriterResponseValidator;


class ServiceWorkerResourceWriter
    : public ServiceWorkerResourceWriterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.ServiceWorkerResourceWriter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerResourceWriterInterfaceBase;
  using Proxy_ = ServiceWorkerResourceWriterProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerResourceWriterStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerResourceWriterRequestValidator;
  using ResponseValidator_ = ServiceWorkerResourceWriterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kWriteResponseHeadMinVersion = 0,
    kWriteDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct WriteResponseHead_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerResourceWriter() = default;

  using WriteResponseHeadCallback = base::OnceCallback<void(int32_t)>;
  using WriteResponseHeadMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void WriteResponseHead(::network::mojom::URLResponseHeadPtr response_head, WriteResponseHeadCallback callback) = 0;

  using WriteDataCallback = base::OnceCallback<void(int32_t)>;
  using WriteDataMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void WriteData(::mojo_base::BigBuffer data, WriteDataCallback callback) = 0;
};

class ServiceWorkerResourceMetadataWriterProxy;

template <typename ImplRefTraits>
class ServiceWorkerResourceMetadataWriterStub;

class ServiceWorkerResourceMetadataWriterRequestValidator;
class ServiceWorkerResourceMetadataWriterResponseValidator;


class ServiceWorkerResourceMetadataWriter
    : public ServiceWorkerResourceMetadataWriterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.ServiceWorkerResourceMetadataWriter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerResourceMetadataWriterInterfaceBase;
  using Proxy_ = ServiceWorkerResourceMetadataWriterProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerResourceMetadataWriterStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerResourceMetadataWriterRequestValidator;
  using ResponseValidator_ = ServiceWorkerResourceMetadataWriterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kWriteMetadataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct WriteMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerResourceMetadataWriter() = default;

  using WriteMetadataCallback = base::OnceCallback<void(int32_t)>;
  using WriteMetadataMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void WriteMetadata(::mojo_base::BigBuffer data, WriteMetadataCallback callback) = 0;
};

class ServiceWorkerStorageControlProxy;

template <typename ImplRefTraits>
class ServiceWorkerStorageControlStub;

class ServiceWorkerStorageControlRequestValidator;
class ServiceWorkerStorageControlResponseValidator;


class ServiceWorkerStorageControl
    : public ServiceWorkerStorageControlInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.ServiceWorkerStorageControl";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerStorageControlInterfaceBase;
  using Proxy_ = ServiceWorkerStorageControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerStorageControlStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerStorageControlRequestValidator;
  using ResponseValidator_ = ServiceWorkerStorageControlResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDisableMinVersion = 0,
    kDeleteMinVersion = 0,
    kRecoverMinVersion = 0,
    kGetRegisteredStorageKeysMinVersion = 0,
    kFindRegistrationForClientUrlMinVersion = 0,
    kFindRegistrationForScopeMinVersion = 0,
    kFindRegistrationForIdMinVersion = 0,
    kGetRegistrationsForStorageKeyMinVersion = 0,
    kGetUsageForStorageKeyMinVersion = 0,
    kGetAllRegistrationsDeprecatedMinVersion = 0,
    kGetFakeRegistrationForClientUrlMinVersion = 0,
    kStoreRegistrationMinVersion = 0,
    kDeleteRegistrationMinVersion = 0,
    kUpdateToActiveStateMinVersion = 0,
    kUpdateLastUpdateCheckTimeMinVersion = 0,
    kUpdateNavigationPreloadEnabledMinVersion = 0,
    kUpdateNavigationPreloadHeaderMinVersion = 0,
    kUpdateFetchHandlerTypeMinVersion = 0,
    kUpdateResourceSha256ChecksumsMinVersion = 0,
    kGetNewRegistrationIdMinVersion = 0,
    kGetNewVersionIdMinVersion = 0,
    kGetNewResourceIdMinVersion = 0,
    kCreateResourceReaderMinVersion = 0,
    kCreateResourceWriterMinVersion = 0,
    kCreateResourceMetadataWriterMinVersion = 0,
    kStoreUncommittedResourceIdMinVersion = 0,
    kDoomUncommittedResourcesMinVersion = 0,
    kGetUserDataMinVersion = 0,
    kStoreUserDataMinVersion = 0,
    kClearUserDataMinVersion = 0,
    kGetUserDataByKeyPrefixMinVersion = 0,
    kGetUserKeysAndDataByKeyPrefixMinVersion = 0,
    kClearUserDataByKeyPrefixesMinVersion = 0,
    kGetUserDataForAllRegistrationsMinVersion = 0,
    kGetUserDataForAllRegistrationsByKeyPrefixMinVersion = 0,
    kClearUserDataForAllRegistrationsByKeyPrefixMinVersion = 0,
    kPerformStorageCleanupMinVersion = 0,
    kApplyPolicyUpdatesMinVersion = 0,
    kGetPurgingResourceIdsForTestMinVersion = 0,
    kGetPurgingResourceIdsForLiveVersionForTestMinVersion = 0,
    kGetPurgeableResourceIdsForTestMinVersion = 0,
    kGetUncommittedResourceIdsForTestMinVersion = 0,
    kSetPurgingCompleteCallbackForTestMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Disable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Delete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Recover_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRegisteredStorageKeys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FindRegistrationForClientUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FindRegistrationForScope_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FindRegistrationForId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRegistrationsForStorageKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUsageForStorageKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllRegistrationsDeprecated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFakeRegistrationForClientUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StoreRegistration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteRegistration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateToActiveState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateLastUpdateCheckTime_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateNavigationPreloadEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateNavigationPreloadHeader_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateFetchHandlerType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateResourceSha256Checksums_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNewRegistrationId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNewVersionId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNewResourceId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateResourceReader_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateResourceWriter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateResourceMetadataWriter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StoreUncommittedResourceId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DoomUncommittedResources_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUserData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StoreUserData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearUserData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUserDataByKeyPrefix_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUserKeysAndDataByKeyPrefix_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearUserDataByKeyPrefixes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUserDataForAllRegistrations_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUserDataForAllRegistrationsByKeyPrefix_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearUserDataForAllRegistrationsByKeyPrefix_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PerformStorageCleanup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ApplyPolicyUpdates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPurgingResourceIdsForTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPurgingResourceIdsForLiveVersionForTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPurgeableResourceIdsForTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUncommittedResourceIdsForTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPurgingCompleteCallbackForTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerStorageControl() = default;

  using DisableCallback = base::OnceCallback<void()>;
  using DisableMojoCallback = base::OnceCallback<void()>;

  virtual void Disable(DisableCallback callback) = 0;

  using DeleteCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using DeleteMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void Delete(DeleteCallback callback) = 0;

  using RecoverCallback = base::OnceCallback<void()>;
  using RecoverMojoCallback = base::OnceCallback<void()>;

  virtual void Recover(std::vector<ServiceWorkerLiveVersionInfoPtr> versions, RecoverCallback callback) = 0;

  using GetRegisteredStorageKeysCallback = base::OnceCallback<void(const std::vector<::blink::StorageKey>&)>;
  using GetRegisteredStorageKeysMojoCallback = base::OnceCallback<void(const std::vector<::blink::StorageKey>&)>;

  virtual void GetRegisteredStorageKeys(GetRegisteredStorageKeysCallback callback) = 0;

  using FindRegistrationForClientUrlCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr, const std::optional<std::vector<::GURL>>&)>;
  using FindRegistrationForClientUrlMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr, const std::optional<std::vector<::GURL>>&)>;

  virtual void FindRegistrationForClientUrl(const ::GURL& client_url, const ::blink::StorageKey& key, FindRegistrationForClientUrlCallback callback) = 0;

  using FindRegistrationForScopeCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr)>;
  using FindRegistrationForScopeMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr)>;

  virtual void FindRegistrationForScope(const ::GURL& scope, const ::blink::StorageKey& key, FindRegistrationForScopeCallback callback) = 0;

  using FindRegistrationForIdCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr)>;
  using FindRegistrationForIdMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr)>;

  virtual void FindRegistrationForId(int64_t registration_id, const std::optional<::blink::StorageKey>& key, FindRegistrationForIdCallback callback) = 0;

  using GetRegistrationsForStorageKeyCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<ServiceWorkerFindRegistrationResultPtr>)>;
  using GetRegistrationsForStorageKeyMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<ServiceWorkerFindRegistrationResultPtr>)>;

  virtual void GetRegistrationsForStorageKey(const ::blink::StorageKey& key, GetRegistrationsForStorageKeyCallback callback) = 0;

  using GetUsageForStorageKeyCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, int64_t)>;
  using GetUsageForStorageKeyMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, int64_t)>;

  virtual void GetUsageForStorageKey(const ::blink::StorageKey& key, GetUsageForStorageKeyCallback callback) = 0;

  using GetAllRegistrationsDeprecatedCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr>)>;
  using GetAllRegistrationsDeprecatedMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr>)>;

  virtual void GetAllRegistrationsDeprecated(GetAllRegistrationsDeprecatedCallback callback) = 0;

  using GetFakeRegistrationForClientUrlCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr, const std::optional<std::vector<::GURL>>&)>;
  using GetFakeRegistrationForClientUrlMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, ServiceWorkerFindRegistrationResultPtr, const std::optional<std::vector<::GURL>>&)>;

  virtual void GetFakeRegistrationForClientUrl(const ::GURL& client_url, const ::blink::StorageKey& key, GetFakeRegistrationForClientUrlCallback callback) = 0;

  using StoreRegistrationCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, uint64_t)>;
  using StoreRegistrationMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, uint64_t)>;

  virtual void StoreRegistration(::storage::mojom::ServiceWorkerRegistrationDataPtr registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources, StoreRegistrationCallback callback) = 0;

  using DeleteRegistrationCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, uint64_t, ServiceWorkerStorageStorageKeyState)>;
  using DeleteRegistrationMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, uint64_t, ServiceWorkerStorageStorageKeyState)>;

  virtual void DeleteRegistration(int64_t registration_id, const ::blink::StorageKey& key, DeleteRegistrationCallback callback) = 0;

  using UpdateToActiveStateCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using UpdateToActiveStateMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void UpdateToActiveState(int64_t registration_id, const ::blink::StorageKey& key, UpdateToActiveStateCallback callback) = 0;

  using UpdateLastUpdateCheckTimeCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using UpdateLastUpdateCheckTimeMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void UpdateLastUpdateCheckTime(int64_t registration_id, const ::blink::StorageKey& key, ::base::Time last_update_check_time, UpdateLastUpdateCheckTimeCallback callback) = 0;

  using UpdateNavigationPreloadEnabledCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using UpdateNavigationPreloadEnabledMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void UpdateNavigationPreloadEnabled(int64_t registration_id, const ::blink::StorageKey& key, bool enable, UpdateNavigationPreloadEnabledCallback callback) = 0;

  using UpdateNavigationPreloadHeaderCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using UpdateNavigationPreloadHeaderMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void UpdateNavigationPreloadHeader(int64_t registration_id, const ::blink::StorageKey& key, const std::string& value, UpdateNavigationPreloadHeaderCallback callback) = 0;

  using UpdateFetchHandlerTypeCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using UpdateFetchHandlerTypeMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void UpdateFetchHandlerType(int64_t registration_id, const ::blink::StorageKey& key, ::blink::mojom::ServiceWorkerFetchHandlerType type, UpdateFetchHandlerTypeCallback callback) = 0;

  using UpdateResourceSha256ChecksumsCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using UpdateResourceSha256ChecksumsMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void UpdateResourceSha256Checksums(int64_t registratation_id, const ::blink::StorageKey& key, const base::flat_map<int64_t, std::string>& updated_sha256_checksums, UpdateResourceSha256ChecksumsCallback callback) = 0;

  using GetNewRegistrationIdCallback = base::OnceCallback<void(int64_t)>;
  using GetNewRegistrationIdMojoCallback = base::OnceCallback<void(int64_t)>;

  virtual void GetNewRegistrationId(GetNewRegistrationIdCallback callback) = 0;

  using GetNewVersionIdCallback = base::OnceCallback<void(int64_t, ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>)>;
  using GetNewVersionIdMojoCallback = base::OnceCallback<void(int64_t, ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>)>;

  virtual void GetNewVersionId(GetNewVersionIdCallback callback) = 0;

  using GetNewResourceIdCallback = base::OnceCallback<void(int64_t)>;
  using GetNewResourceIdMojoCallback = base::OnceCallback<void(int64_t)>;

  virtual void GetNewResourceId(GetNewResourceIdCallback callback) = 0;

  virtual void CreateResourceReader(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceReader> reader) = 0;

  virtual void CreateResourceWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceWriter> writer) = 0;

  virtual void CreateResourceMetadataWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> writer) = 0;

  using StoreUncommittedResourceIdCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using StoreUncommittedResourceIdMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void StoreUncommittedResourceId(int64_t resource_id, StoreUncommittedResourceIdCallback callback) = 0;

  using DoomUncommittedResourcesCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using DoomUncommittedResourcesMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void DoomUncommittedResources(const std::vector<int64_t>& resource_ids, DoomUncommittedResourcesCallback callback) = 0;

  using GetUserDataCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<std::string>&)>;
  using GetUserDataMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<std::string>&)>;

  virtual void GetUserData(int64_t registration_id, const std::vector<std::string>& keys, GetUserDataCallback callback) = 0;

  using StoreUserDataCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using StoreUserDataMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void StoreUserData(int64_t registration_id, const ::blink::StorageKey& key, std::vector<ServiceWorkerUserDataPtr> user_data, StoreUserDataCallback callback) = 0;

  using ClearUserDataCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using ClearUserDataMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void ClearUserData(int64_t registration_id, const std::vector<std::string>& keys, ClearUserDataCallback callback) = 0;

  using GetUserDataByKeyPrefixCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<std::string>&)>;
  using GetUserDataByKeyPrefixMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<std::string>&)>;

  virtual void GetUserDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserDataByKeyPrefixCallback callback) = 0;

  using GetUserKeysAndDataByKeyPrefixCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const base::flat_map<std::string, std::string>&)>;
  using GetUserKeysAndDataByKeyPrefixMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const base::flat_map<std::string, std::string>&)>;

  virtual void GetUserKeysAndDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserKeysAndDataByKeyPrefixCallback callback) = 0;

  using ClearUserDataByKeyPrefixesCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using ClearUserDataByKeyPrefixesMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void ClearUserDataByKeyPrefixes(int64_t registratation_id, const std::vector<std::string>& key_prefixes, ClearUserDataByKeyPrefixesCallback callback) = 0;

  using GetUserDataForAllRegistrationsCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<ServiceWorkerUserDataPtr>)>;
  using GetUserDataForAllRegistrationsMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<ServiceWorkerUserDataPtr>)>;

  virtual void GetUserDataForAllRegistrations(const std::string& key, GetUserDataForAllRegistrationsCallback callback) = 0;

  using GetUserDataForAllRegistrationsByKeyPrefixCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<ServiceWorkerUserDataPtr>)>;
  using GetUserDataForAllRegistrationsByKeyPrefixMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, std::vector<ServiceWorkerUserDataPtr>)>;

  virtual void GetUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, GetUserDataForAllRegistrationsByKeyPrefixCallback callback) = 0;

  using ClearUserDataForAllRegistrationsByKeyPrefixCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using ClearUserDataForAllRegistrationsByKeyPrefixMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void ClearUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, ClearUserDataForAllRegistrationsByKeyPrefixCallback callback) = 0;

  using PerformStorageCleanupCallback = base::OnceCallback<void()>;
  using PerformStorageCleanupMojoCallback = base::OnceCallback<void()>;

  virtual void PerformStorageCleanup(PerformStorageCleanupCallback callback) = 0;

  using ApplyPolicyUpdatesCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;
  using ApplyPolicyUpdatesMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus)>;

  virtual void ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates, ApplyPolicyUpdatesCallback callback) = 0;

  using GetPurgingResourceIdsForTestCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<int64_t>&)>;
  using GetPurgingResourceIdsForTestMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<int64_t>&)>;

  virtual void GetPurgingResourceIdsForTest(GetPurgingResourceIdsForTestCallback callback) = 0;

  using GetPurgingResourceIdsForLiveVersionForTestCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<int64_t>&)>;
  using GetPurgingResourceIdsForLiveVersionForTestMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<int64_t>&)>;

  virtual void GetPurgingResourceIdsForLiveVersionForTest(int64_t version_id, GetPurgingResourceIdsForLiveVersionForTestCallback callback) = 0;

  using GetPurgeableResourceIdsForTestCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<int64_t>&)>;
  using GetPurgeableResourceIdsForTestMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<int64_t>&)>;

  virtual void GetPurgeableResourceIdsForTest(GetPurgeableResourceIdsForTestCallback callback) = 0;

  using GetUncommittedResourceIdsForTestCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<int64_t>&)>;
  using GetUncommittedResourceIdsForTestMojoCallback = base::OnceCallback<void(::storage::mojom::ServiceWorkerDatabaseStatus, const std::vector<int64_t>&)>;

  virtual void GetUncommittedResourceIdsForTest(GetUncommittedResourceIdsForTestCallback callback) = 0;

  using SetPurgingCompleteCallbackForTestCallback = base::OnceCallback<void()>;
  using SetPurgingCompleteCallbackForTestMojoCallback = base::OnceCallback<void()>;

  virtual void SetPurgingCompleteCallbackForTest(SetPurgingCompleteCallbackForTestCallback callback) = 0;
};



class  ServiceWorkerLiveVersionRefProxy
    : public ServiceWorkerLiveVersionRef {
 public:
  using InterfaceType = ServiceWorkerLiveVersionRef;

  explicit ServiceWorkerLiveVersionRefProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ServiceWorkerResourceReaderProxy
    : public ServiceWorkerResourceReader {
 public:
  using InterfaceType = ServiceWorkerResourceReader;

  explicit ServiceWorkerResourceReaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReadResponseHead(ReadResponseHeadCallback callback) final;
  
  void PrepareReadData(int64_t size, PrepareReadDataCallback callback) final;
  
  void ReadData(ReadDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ServiceWorkerResourceWriterProxy
    : public ServiceWorkerResourceWriter {
 public:
  using InterfaceType = ServiceWorkerResourceWriter;

  explicit ServiceWorkerResourceWriterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void WriteResponseHead(::network::mojom::URLResponseHeadPtr response_head, WriteResponseHeadCallback callback) final;
  
  void WriteData(::mojo_base::BigBuffer data, WriteDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ServiceWorkerResourceMetadataWriterProxy
    : public ServiceWorkerResourceMetadataWriter {
 public:
  using InterfaceType = ServiceWorkerResourceMetadataWriter;

  explicit ServiceWorkerResourceMetadataWriterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void WriteMetadata(::mojo_base::BigBuffer data, WriteMetadataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ServiceWorkerStorageControlProxy
    : public ServiceWorkerStorageControl {
 public:
  using InterfaceType = ServiceWorkerStorageControl;

  explicit ServiceWorkerStorageControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Disable(DisableCallback callback) final;
  
  void Delete(DeleteCallback callback) final;
  
  void Recover(std::vector<ServiceWorkerLiveVersionInfoPtr> versions, RecoverCallback callback) final;
  
  void GetRegisteredStorageKeys(GetRegisteredStorageKeysCallback callback) final;
  
  void FindRegistrationForClientUrl(const ::GURL& client_url, const ::blink::StorageKey& key, FindRegistrationForClientUrlCallback callback) final;
  
  void FindRegistrationForScope(const ::GURL& scope, const ::blink::StorageKey& key, FindRegistrationForScopeCallback callback) final;
  
  void FindRegistrationForId(int64_t registration_id, const std::optional<::blink::StorageKey>& key, FindRegistrationForIdCallback callback) final;
  
  void GetRegistrationsForStorageKey(const ::blink::StorageKey& key, GetRegistrationsForStorageKeyCallback callback) final;
  
  void GetUsageForStorageKey(const ::blink::StorageKey& key, GetUsageForStorageKeyCallback callback) final;
  
  void GetAllRegistrationsDeprecated(GetAllRegistrationsDeprecatedCallback callback) final;
  
  void GetFakeRegistrationForClientUrl(const ::GURL& client_url, const ::blink::StorageKey& key, GetFakeRegistrationForClientUrlCallback callback) final;
  
  void StoreRegistration(::storage::mojom::ServiceWorkerRegistrationDataPtr registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources, StoreRegistrationCallback callback) final;
  
  void DeleteRegistration(int64_t registration_id, const ::blink::StorageKey& key, DeleteRegistrationCallback callback) final;
  
  void UpdateToActiveState(int64_t registration_id, const ::blink::StorageKey& key, UpdateToActiveStateCallback callback) final;
  
  void UpdateLastUpdateCheckTime(int64_t registration_id, const ::blink::StorageKey& key, ::base::Time last_update_check_time, UpdateLastUpdateCheckTimeCallback callback) final;
  
  void UpdateNavigationPreloadEnabled(int64_t registration_id, const ::blink::StorageKey& key, bool enable, UpdateNavigationPreloadEnabledCallback callback) final;
  
  void UpdateNavigationPreloadHeader(int64_t registration_id, const ::blink::StorageKey& key, const std::string& value, UpdateNavigationPreloadHeaderCallback callback) final;
  
  void UpdateFetchHandlerType(int64_t registration_id, const ::blink::StorageKey& key, ::blink::mojom::ServiceWorkerFetchHandlerType type, UpdateFetchHandlerTypeCallback callback) final;
  
  void UpdateResourceSha256Checksums(int64_t registratation_id, const ::blink::StorageKey& key, const base::flat_map<int64_t, std::string>& updated_sha256_checksums, UpdateResourceSha256ChecksumsCallback callback) final;
  
  void GetNewRegistrationId(GetNewRegistrationIdCallback callback) final;
  
  void GetNewVersionId(GetNewVersionIdCallback callback) final;
  
  void GetNewResourceId(GetNewResourceIdCallback callback) final;
  
  void CreateResourceReader(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceReader> reader) final;
  
  void CreateResourceWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceWriter> writer) final;
  
  void CreateResourceMetadataWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> writer) final;
  
  void StoreUncommittedResourceId(int64_t resource_id, StoreUncommittedResourceIdCallback callback) final;
  
  void DoomUncommittedResources(const std::vector<int64_t>& resource_ids, DoomUncommittedResourcesCallback callback) final;
  
  void GetUserData(int64_t registration_id, const std::vector<std::string>& keys, GetUserDataCallback callback) final;
  
  void StoreUserData(int64_t registration_id, const ::blink::StorageKey& key, std::vector<ServiceWorkerUserDataPtr> user_data, StoreUserDataCallback callback) final;
  
  void ClearUserData(int64_t registration_id, const std::vector<std::string>& keys, ClearUserDataCallback callback) final;
  
  void GetUserDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserDataByKeyPrefixCallback callback) final;
  
  void GetUserKeysAndDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserKeysAndDataByKeyPrefixCallback callback) final;
  
  void ClearUserDataByKeyPrefixes(int64_t registratation_id, const std::vector<std::string>& key_prefixes, ClearUserDataByKeyPrefixesCallback callback) final;
  
  void GetUserDataForAllRegistrations(const std::string& key, GetUserDataForAllRegistrationsCallback callback) final;
  
  void GetUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, GetUserDataForAllRegistrationsByKeyPrefixCallback callback) final;
  
  void ClearUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, ClearUserDataForAllRegistrationsByKeyPrefixCallback callback) final;
  
  void PerformStorageCleanup(PerformStorageCleanupCallback callback) final;
  
  void ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates, ApplyPolicyUpdatesCallback callback) final;
  
  void GetPurgingResourceIdsForTest(GetPurgingResourceIdsForTestCallback callback) final;
  
  void GetPurgingResourceIdsForLiveVersionForTest(int64_t version_id, GetPurgingResourceIdsForLiveVersionForTestCallback callback) final;
  
  void GetPurgeableResourceIdsForTest(GetPurgeableResourceIdsForTestCallback callback) final;
  
  void GetUncommittedResourceIdsForTest(GetUncommittedResourceIdsForTestCallback callback) final;
  
  void SetPurgingCompleteCallbackForTest(SetPurgingCompleteCallbackForTestCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ServiceWorkerLiveVersionRefStubDispatch {
 public:
  static bool Accept(ServiceWorkerLiveVersionRef* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerLiveVersionRef* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerLiveVersionRef>>
class ServiceWorkerLiveVersionRefStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerLiveVersionRefStub() = default;
  ~ServiceWorkerLiveVersionRefStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerLiveVersionRefStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerLiveVersionRefStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerResourceReaderStubDispatch {
 public:
  static bool Accept(ServiceWorkerResourceReader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerResourceReader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerResourceReader>>
class ServiceWorkerResourceReaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerResourceReaderStub() = default;
  ~ServiceWorkerResourceReaderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceReaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceReaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerResourceWriterStubDispatch {
 public:
  static bool Accept(ServiceWorkerResourceWriter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerResourceWriter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerResourceWriter>>
class ServiceWorkerResourceWriterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerResourceWriterStub() = default;
  ~ServiceWorkerResourceWriterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceWriterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceWriterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerResourceMetadataWriterStubDispatch {
 public:
  static bool Accept(ServiceWorkerResourceMetadataWriter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerResourceMetadataWriter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerResourceMetadataWriter>>
class ServiceWorkerResourceMetadataWriterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerResourceMetadataWriterStub() = default;
  ~ServiceWorkerResourceMetadataWriterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceMetadataWriterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerResourceMetadataWriterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerStorageControlStubDispatch {
 public:
  static bool Accept(ServiceWorkerStorageControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerStorageControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerStorageControl>>
class ServiceWorkerStorageControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerStorageControlStub() = default;
  ~ServiceWorkerStorageControlStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStorageControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerStorageControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ServiceWorkerLiveVersionRefRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceReaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceWriterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceMetadataWriterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerStorageControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceReaderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceWriterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerResourceMetadataWriterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ServiceWorkerStorageControlResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  ServiceWorkerLiveVersionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerLiveVersionInfo, T>::value>;
  using DataView = ServiceWorkerLiveVersionInfoDataView;
  using Data_ = internal::ServiceWorkerLiveVersionInfo_Data;

  template <typename... Args>
  static ServiceWorkerLiveVersionInfoPtr New(Args&&... args) {
    return ServiceWorkerLiveVersionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerLiveVersionInfoPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerLiveVersionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerLiveVersionInfo>::Convert(*this);
  }


  ServiceWorkerLiveVersionInfo();

  ServiceWorkerLiveVersionInfo(
      int64_t id,
      std::vector<int64_t> purgeable_resources,
      ::mojo::PendingReceiver<ServiceWorkerLiveVersionRef> reference);

ServiceWorkerLiveVersionInfo(const ServiceWorkerLiveVersionInfo&) = delete;
ServiceWorkerLiveVersionInfo& operator=(const ServiceWorkerLiveVersionInfo&) = delete;

  ~ServiceWorkerLiveVersionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerLiveVersionInfoPtr>
  ServiceWorkerLiveVersionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerLiveVersionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerLiveVersionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerLiveVersionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerLiveVersionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerLiveVersionInfo_UnserializedMessageContext<
            UserType, ServiceWorkerLiveVersionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerLiveVersionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerLiveVersionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerLiveVersionInfo_UnserializedMessageContext<
            UserType, ServiceWorkerLiveVersionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerLiveVersionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  std::vector<int64_t> purgeable_resources;
  
  ::mojo::PendingReceiver<ServiceWorkerLiveVersionRef> reference;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerLiveVersionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerLiveVersionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerLiveVersionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerLiveVersionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ServiceWorkerFindRegistrationResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerFindRegistrationResult, T>::value>;
  using DataView = ServiceWorkerFindRegistrationResultDataView;
  using Data_ = internal::ServiceWorkerFindRegistrationResult_Data;

  template <typename... Args>
  static ServiceWorkerFindRegistrationResultPtr New(Args&&... args) {
    return ServiceWorkerFindRegistrationResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerFindRegistrationResultPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerFindRegistrationResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerFindRegistrationResult>::Convert(*this);
  }


  ServiceWorkerFindRegistrationResult();

  ServiceWorkerFindRegistrationResult(
      ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> version_reference,
      ::storage::mojom::ServiceWorkerRegistrationDataPtr registration,
      std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources);

ServiceWorkerFindRegistrationResult(const ServiceWorkerFindRegistrationResult&) = delete;
ServiceWorkerFindRegistrationResult& operator=(const ServiceWorkerFindRegistrationResult&) = delete;

  ~ServiceWorkerFindRegistrationResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerFindRegistrationResultPtr>
  ServiceWorkerFindRegistrationResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerFindRegistrationResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerFindRegistrationResult_UnserializedMessageContext<
            UserType, ServiceWorkerFindRegistrationResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerFindRegistrationResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerFindRegistrationResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerFindRegistrationResult_UnserializedMessageContext<
            UserType, ServiceWorkerFindRegistrationResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerFindRegistrationResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> version_reference;
  
  ::storage::mojom::ServiceWorkerRegistrationDataPtr registration;
  
  std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ServiceWorkerUserData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerUserData, T>::value>;
  using DataView = ServiceWorkerUserDataDataView;
  using Data_ = internal::ServiceWorkerUserData_Data;

  template <typename... Args>
  static ServiceWorkerUserDataPtr New(Args&&... args) {
    return ServiceWorkerUserDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerUserDataPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerUserDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerUserData>::Convert(*this);
  }


  ServiceWorkerUserData();

  ServiceWorkerUserData(
      int64_t registration_id,
      const std::string& key,
      const std::string& value);


  ~ServiceWorkerUserData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerUserDataPtr>
  ServiceWorkerUserDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerUserData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerUserData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerUserData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerUserData_UnserializedMessageContext<
            UserType, ServiceWorkerUserData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerUserData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerUserData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerUserData_UnserializedMessageContext<
            UserType, ServiceWorkerUserData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerUserData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t registration_id;
  
  std::string key;
  
  std::string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerUserData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ServiceWorkerLiveVersionInfoPtr ServiceWorkerLiveVersionInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(purgeable_resources),
      mojo::Clone(reference)
  );
}

template <typename T, ServiceWorkerLiveVersionInfo::EnableIfSame<T>*>
bool ServiceWorkerLiveVersionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->purgeable_resources, other_struct.purgeable_resources))
    return false;
  if (!mojo::Equals(this->reference, other_struct.reference))
    return false;
  return true;
}

template <typename T, ServiceWorkerLiveVersionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.purgeable_resources < rhs.purgeable_resources)
    return true;
  if (rhs.purgeable_resources < lhs.purgeable_resources)
    return false;
  if (lhs.reference < rhs.reference)
    return true;
  if (rhs.reference < lhs.reference)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerFindRegistrationResultPtr ServiceWorkerFindRegistrationResult::Clone() const {
  return New(
      mojo::Clone(version_reference),
      mojo::Clone(registration),
      mojo::Clone(resources)
  );
}

template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>*>
bool ServiceWorkerFindRegistrationResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version_reference, other_struct.version_reference))
    return false;
  if (!mojo::Equals(this->registration, other_struct.registration))
    return false;
  if (!mojo::Equals(this->resources, other_struct.resources))
    return false;
  return true;
}

template <typename T, ServiceWorkerFindRegistrationResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.version_reference < rhs.version_reference)
    return true;
  if (rhs.version_reference < lhs.version_reference)
    return false;
  if (lhs.registration < rhs.registration)
    return true;
  if (rhs.registration < lhs.registration)
    return false;
  if (lhs.resources < rhs.resources)
    return true;
  if (rhs.resources < lhs.resources)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerUserDataPtr ServiceWorkerUserData::Clone() const {
  return New(
      mojo::Clone(registration_id),
      mojo::Clone(key),
      mojo::Clone(value)
  );
}

template <typename T, ServiceWorkerUserData::EnableIfSame<T>*>
bool ServiceWorkerUserData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->registration_id, other_struct.registration_id))
    return false;
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, ServiceWorkerUserData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.registration_id < rhs.registration_id)
    return true;
  if (rhs.registration_id < lhs.registration_id)
    return false;
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::ServiceWorkerLiveVersionInfo::DataView,
                                         ::storage::mojom::ServiceWorkerLiveVersionInfoPtr> {
  static bool IsNull(const ::storage::mojom::ServiceWorkerLiveVersionInfoPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::ServiceWorkerLiveVersionInfoPtr* output) { output->reset(); }

  static decltype(::storage::mojom::ServiceWorkerLiveVersionInfo::id) id(
      const ::storage::mojom::ServiceWorkerLiveVersionInfoPtr& input) {
    return input->id;
  }

  static const decltype(::storage::mojom::ServiceWorkerLiveVersionInfo::purgeable_resources)& purgeable_resources(
      const ::storage::mojom::ServiceWorkerLiveVersionInfoPtr& input) {
    return input->purgeable_resources;
  }

  static  decltype(::storage::mojom::ServiceWorkerLiveVersionInfo::reference)& reference(
       ::storage::mojom::ServiceWorkerLiveVersionInfoPtr& input) {
    return input->reference;
  }

  static bool Read(::storage::mojom::ServiceWorkerLiveVersionInfo::DataView input, ::storage::mojom::ServiceWorkerLiveVersionInfoPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::ServiceWorkerFindRegistrationResult::DataView,
                                         ::storage::mojom::ServiceWorkerFindRegistrationResultPtr> {
  static bool IsNull(const ::storage::mojom::ServiceWorkerFindRegistrationResultPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::ServiceWorkerFindRegistrationResultPtr* output) { output->reset(); }

  static  decltype(::storage::mojom::ServiceWorkerFindRegistrationResult::version_reference)& version_reference(
       ::storage::mojom::ServiceWorkerFindRegistrationResultPtr& input) {
    return input->version_reference;
  }

  static const decltype(::storage::mojom::ServiceWorkerFindRegistrationResult::registration)& registration(
      const ::storage::mojom::ServiceWorkerFindRegistrationResultPtr& input) {
    return input->registration;
  }

  static const decltype(::storage::mojom::ServiceWorkerFindRegistrationResult::resources)& resources(
      const ::storage::mojom::ServiceWorkerFindRegistrationResultPtr& input) {
    return input->resources;
  }

  static bool Read(::storage::mojom::ServiceWorkerFindRegistrationResult::DataView input, ::storage::mojom::ServiceWorkerFindRegistrationResultPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::ServiceWorkerUserData::DataView,
                                         ::storage::mojom::ServiceWorkerUserDataPtr> {
  static bool IsNull(const ::storage::mojom::ServiceWorkerUserDataPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::ServiceWorkerUserDataPtr* output) { output->reset(); }

  static decltype(::storage::mojom::ServiceWorkerUserData::registration_id) registration_id(
      const ::storage::mojom::ServiceWorkerUserDataPtr& input) {
    return input->registration_id;
  }

  static const decltype(::storage::mojom::ServiceWorkerUserData::key)& key(
      const ::storage::mojom::ServiceWorkerUserDataPtr& input) {
    return input->key;
  }

  static const decltype(::storage::mojom::ServiceWorkerUserData::value)& value(
      const ::storage::mojom::ServiceWorkerUserDataPtr& input) {
    return input->value;
  }

  static bool Read(::storage::mojom::ServiceWorkerUserData::DataView input, ::storage::mojom::ServiceWorkerUserDataPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_H_