// components/services/storage/public/mojom/service_worker_storage_control.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-params-data.h"
#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-import-headers.h"
#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"
#include "third_party/blink/public/common/service_worker/service_worker_router_rule_mojom_traits.h"


namespace storage::mojom {
ServiceWorkerLiveVersionInfo::ServiceWorkerLiveVersionInfo()
    : id(),
      purgeable_resources(),
      reference() {}

ServiceWorkerLiveVersionInfo::ServiceWorkerLiveVersionInfo(
    int64_t id_in,
    std::vector<int64_t> purgeable_resources_in,
    ::mojo::PendingReceiver<ServiceWorkerLiveVersionRef> reference_in)
    : id(std::move(id_in)),
      purgeable_resources(std::move(purgeable_resources_in)),
      reference(std::move(reference_in)) {}

ServiceWorkerLiveVersionInfo::~ServiceWorkerLiveVersionInfo() = default;

void ServiceWorkerLiveVersionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "purgeable_resources"), this->purgeable_resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reference"), this->reference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<ServiceWorkerLiveVersionRef>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerLiveVersionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerFindRegistrationResult::ServiceWorkerFindRegistrationResult()
    : version_reference(),
      registration(),
      resources() {}

ServiceWorkerFindRegistrationResult::ServiceWorkerFindRegistrationResult(
    ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> version_reference_in,
    ::storage::mojom::ServiceWorkerRegistrationDataPtr registration_in,
    std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources_in)
    : version_reference(std::move(version_reference_in)),
      registration(std::move(registration_in)),
      resources(std::move(resources_in)) {}

ServiceWorkerFindRegistrationResult::~ServiceWorkerFindRegistrationResult() = default;

void ServiceWorkerFindRegistrationResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_reference"), this->version_reference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration"), this->registration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::storage::mojom::ServiceWorkerRegistrationDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resources"), this->resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerFindRegistrationResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceWorkerUserData::ServiceWorkerUserData()
    : registration_id(),
      key(),
      value() {}

ServiceWorkerUserData::ServiceWorkerUserData(
    int64_t registration_id_in,
    const std::string& key_in,
    const std::string& value_in)
    : registration_id(std::move(registration_id_in)),
      key(std::move(key_in)),
      value(std::move(value_in)) {}

ServiceWorkerUserData::~ServiceWorkerUserData() = default;

void ServiceWorkerUserData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration_id"), this->registration_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerUserData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ServiceWorkerLiveVersionRef::IPCStableHashFunction ServiceWorkerLiveVersionRef::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerLiveVersionRef::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

ServiceWorkerLiveVersionRefProxy::ServiceWorkerLiveVersionRefProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool ServiceWorkerLiveVersionRefStubDispatch::Accept(
    ServiceWorkerLiveVersionRef* impl,
    mojo::Message* message) {
  return false;
}

// static
bool ServiceWorkerLiveVersionRefStubDispatch::AcceptWithResponder(
    ServiceWorkerLiveVersionRef* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool ServiceWorkerLiveVersionRefRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::storage::mojom::ServiceWorkerLiveVersionRef::Name_,
    {});
}

// The declaration includes the definition on other builds.

ServiceWorkerResourceReader::IPCStableHashFunction ServiceWorkerResourceReader::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerResourceReader>(message.name())) {
    case messages::ServiceWorkerResourceReader::kReadResponseHead: {
      return &ServiceWorkerResourceReader::ReadResponseHead_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerResourceReader::kPrepareReadData: {
      return &ServiceWorkerResourceReader::PrepareReadData_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerResourceReader::kReadData: {
      return &ServiceWorkerResourceReader::ReadData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerResourceReader::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerResourceReader>(message.name())) {
      case messages::ServiceWorkerResourceReader::kReadResponseHead:
            return "Receive storage::mojom::ServiceWorkerResourceReader::ReadResponseHead";
      case messages::ServiceWorkerResourceReader::kPrepareReadData:
            return "Receive storage::mojom::ServiceWorkerResourceReader::PrepareReadData";
      case messages::ServiceWorkerResourceReader::kReadData:
            return "Receive storage::mojom::ServiceWorkerResourceReader::ReadData";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerResourceReader>(message.name())) {
      case messages::ServiceWorkerResourceReader::kReadResponseHead:
            return "Receive reply storage::mojom::ServiceWorkerResourceReader::ReadResponseHead";
      case messages::ServiceWorkerResourceReader::kPrepareReadData:
            return "Receive reply storage::mojom::ServiceWorkerResourceReader::PrepareReadData";
      case messages::ServiceWorkerResourceReader::kReadData:
            return "Receive reply storage::mojom::ServiceWorkerResourceReader::ReadData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerResourceReader::ReadResponseHead_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1783f5a9;  // IPCStableHash for storage::mojom::ServiceWorkerResourceReader::ReadResponseHead
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerResourceReader::PrepareReadData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8c3b85df;  // IPCStableHash for storage::mojom::ServiceWorkerResourceReader::PrepareReadData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerResourceReader::ReadData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8139e484;  // IPCStableHash for storage::mojom::ServiceWorkerResourceReader::ReadData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback(
      ServiceWorkerResourceReader::ReadResponseHeadCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback(const ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback&) = delete;
  ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback& operator=(const ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceReader::ReadResponseHeadCallback callback_;
};

class ServiceWorkerResourceReader_PrepareReadData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceReader_PrepareReadData_ForwardToCallback(
      ServiceWorkerResourceReader::PrepareReadDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerResourceReader_PrepareReadData_ForwardToCallback(const ServiceWorkerResourceReader_PrepareReadData_ForwardToCallback&) = delete;
  ServiceWorkerResourceReader_PrepareReadData_ForwardToCallback& operator=(const ServiceWorkerResourceReader_PrepareReadData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceReader::PrepareReadDataCallback callback_;
};

class ServiceWorkerResourceReader_ReadData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceReader_ReadData_ForwardToCallback(
      ServiceWorkerResourceReader::ReadDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerResourceReader_ReadData_ForwardToCallback(const ServiceWorkerResourceReader_ReadData_ForwardToCallback&) = delete;
  ServiceWorkerResourceReader_ReadData_ForwardToCallback& operator=(const ServiceWorkerResourceReader_ReadData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceReader::ReadDataCallback callback_;
};

ServiceWorkerResourceReaderProxy::ServiceWorkerResourceReaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerResourceReaderProxy::ReadResponseHead(
    ReadResponseHeadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerResourceReader::ReadResponseHead");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceReader::kReadResponseHead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceReader_ReadResponseHead_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceReader::Name_);
  message.set_method_name("ReadResponseHead");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerResourceReaderProxy::PrepareReadData(
    int64_t in_size, PrepareReadDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerResourceReader::PrepareReadData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceReader::kPrepareReadData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceReader_PrepareReadData_Params_Data> params(
          message);
  params.Allocate();

  params->size = in_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceReader::Name_);
  message.set_method_name("PrepareReadData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceReader_PrepareReadData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerResourceReaderProxy::ReadData(
    ReadDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerResourceReader::ReadData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceReader::kReadData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceReader_ReadData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceReader::Name_);
  message.set_method_name("ReadData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceReader_ReadData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerResourceReader::ReadResponseHeadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder> proxy(
        new ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerResourceReader::ReadResponseHeadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status, ::network::mojom::URLResponseHeadPtr in_response_head, std::optional<::mojo_base::BigBuffer> in_metadata);
};

bool ServiceWorkerResourceReader_ReadResponseHead_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerResourceReader.0
  bool success = true;
  int32_t p_status{};
  ::network::mojom::URLResponseHeadPtr p_response_head{};
  std::optional<::mojo_base::BigBuffer> p_metadata{};
  ServiceWorkerResourceReader_ReadResponseHead_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (success && !input_data_view.ReadResponseHead(&p_response_head))
    success = false;
  if (success && !input_data_view.ReadMetadata(&p_metadata))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceReader::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_response_head), 
std::move(p_metadata));
  }
  return true;
}

void ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder::Run(
    int32_t in_status, ::network::mojom::URLResponseHeadPtr in_response_head, std::optional<::mojo_base::BigBuffer> in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerResourceReader::ReadResponseHead", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_head"), in_response_head,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceReader::kReadResponseHead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->status = in_status;
  mojo::internal::MessageFragment<
      typename decltype(params->response_head)::BaseType> response_head_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
    in_response_head,
    response_head_fragment);

  params->response_head.Set(
      response_head_fragment.is_null() ? nullptr : response_head_fragment.data());
  mojo::internal::MessageFragment<decltype(params->metadata)>
      metadata_fragment(params.message());
  metadata_fragment.Claim(&params->metadata);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_metadata,
    metadata_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceReader::Name_);
  message.set_method_name("ReadResponseHead");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerResourceReader_PrepareReadData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerResourceReader::PrepareReadDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerResourceReader_PrepareReadData_ProxyToResponder> proxy(
        new ServiceWorkerResourceReader_PrepareReadData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerResourceReader_PrepareReadData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceReader_PrepareReadData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerResourceReader_PrepareReadData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerResourceReader::PrepareReadDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::ScopedDataPipeConsumerHandle in_pipe);
};

bool ServiceWorkerResourceReader_PrepareReadData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceReader_PrepareReadData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceReader_PrepareReadData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerResourceReader.1
  bool success = true;
  ::mojo::ScopedDataPipeConsumerHandle p_pipe{};
  ServiceWorkerResourceReader_PrepareReadData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_pipe = input_data_view.TakePipe();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceReader::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_pipe));
  }
  return true;
}

void ServiceWorkerResourceReader_PrepareReadData_ProxyToResponder::Run(
    ::mojo::ScopedDataPipeConsumerHandle in_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerResourceReader::PrepareReadData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceReader::kPrepareReadData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceReader_PrepareReadData_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_pipe,
    &params->pipe,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceReader::Name_);
  message.set_method_name("PrepareReadData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerResourceReader_ReadData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerResourceReader::ReadDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerResourceReader_ReadData_ProxyToResponder> proxy(
        new ServiceWorkerResourceReader_ReadData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerResourceReader_ReadData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceReader_ReadData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerResourceReader_ReadData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerResourceReader::ReadDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status);
};

bool ServiceWorkerResourceReader_ReadData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceReader_ReadData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceReader_ReadData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerResourceReader.2
  bool success = true;
  int32_t p_status{};
  ServiceWorkerResourceReader_ReadData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceReader::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerResourceReader_ReadData_ProxyToResponder::Run(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerResourceReader::ReadData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceReader::kReadData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceReader_ReadData_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->status = in_status;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceReader::Name_);
  message.set_method_name("ReadData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerResourceReaderStubDispatch::Accept(
    ServiceWorkerResourceReader* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerResourceReader>(message->header()->name)) {
    case messages::ServiceWorkerResourceReader::kReadResponseHead: {
      break;
    }
    case messages::ServiceWorkerResourceReader::kPrepareReadData: {
      break;
    }
    case messages::ServiceWorkerResourceReader::kReadData: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerResourceReaderStubDispatch::AcceptWithResponder(
    ServiceWorkerResourceReader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerResourceReader>(message->header()->name)) {
    case messages::ServiceWorkerResourceReader::kReadResponseHead: {
      internal::ServiceWorkerResourceReader_ReadResponseHead_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceReader_ReadResponseHead_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerResourceReader.0
      bool success = true;
      ServiceWorkerResourceReader_ReadResponseHead_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceReader::Name_, 0, false);
        return false;
      }
      auto callback =
          ServiceWorkerResourceReader_ReadResponseHead_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadResponseHead(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerResourceReader::kPrepareReadData: {
      internal::ServiceWorkerResourceReader_PrepareReadData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceReader_PrepareReadData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerResourceReader.1
      bool success = true;
      int64_t p_size{};
      ServiceWorkerResourceReader_PrepareReadData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_size = input_data_view.size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceReader::Name_, 1, false);
        return false;
      }
      auto callback =
          ServiceWorkerResourceReader_PrepareReadData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrepareReadData(        
        std::move(p_size), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerResourceReader::kReadData: {
      internal::ServiceWorkerResourceReader_ReadData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceReader_ReadData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerResourceReader.2
      bool success = true;
      ServiceWorkerResourceReader_ReadData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceReader::Name_, 2, false);
        return false;
      }
      auto callback =
          ServiceWorkerResourceReader_ReadData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadData(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerResourceReaderValidationInfo[] = {
    { &internal::ServiceWorkerResourceReader_ReadResponseHead_Params_Data::Validate,
     &internal::ServiceWorkerResourceReader_ReadResponseHead_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerResourceReader_PrepareReadData_Params_Data::Validate,
     &internal::ServiceWorkerResourceReader_PrepareReadData_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerResourceReader_ReadData_Params_Data::Validate,
     &internal::ServiceWorkerResourceReader_ReadData_ResponseParams_Data::Validate},
};

bool ServiceWorkerResourceReaderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::storage::mojom::ServiceWorkerResourceReader::Name_,
    kServiceWorkerResourceReaderValidationInfo);
}

bool ServiceWorkerResourceReaderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::storage::mojom::ServiceWorkerResourceReader::Name_,
    kServiceWorkerResourceReaderValidationInfo);
}
// The declaration includes the definition on other builds.

ServiceWorkerResourceWriter::IPCStableHashFunction ServiceWorkerResourceWriter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerResourceWriter>(message.name())) {
    case messages::ServiceWorkerResourceWriter::kWriteResponseHead: {
      return &ServiceWorkerResourceWriter::WriteResponseHead_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerResourceWriter::kWriteData: {
      return &ServiceWorkerResourceWriter::WriteData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerResourceWriter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerResourceWriter>(message.name())) {
      case messages::ServiceWorkerResourceWriter::kWriteResponseHead:
            return "Receive storage::mojom::ServiceWorkerResourceWriter::WriteResponseHead";
      case messages::ServiceWorkerResourceWriter::kWriteData:
            return "Receive storage::mojom::ServiceWorkerResourceWriter::WriteData";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerResourceWriter>(message.name())) {
      case messages::ServiceWorkerResourceWriter::kWriteResponseHead:
            return "Receive reply storage::mojom::ServiceWorkerResourceWriter::WriteResponseHead";
      case messages::ServiceWorkerResourceWriter::kWriteData:
            return "Receive reply storage::mojom::ServiceWorkerResourceWriter::WriteData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerResourceWriter::WriteResponseHead_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5de3d911;  // IPCStableHash for storage::mojom::ServiceWorkerResourceWriter::WriteResponseHead
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerResourceWriter::WriteData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x084ea79c;  // IPCStableHash for storage::mojom::ServiceWorkerResourceWriter::WriteData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback(
      ServiceWorkerResourceWriter::WriteResponseHeadCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback(const ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback&) = delete;
  ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback& operator=(const ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceWriter::WriteResponseHeadCallback callback_;
};

class ServiceWorkerResourceWriter_WriteData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceWriter_WriteData_ForwardToCallback(
      ServiceWorkerResourceWriter::WriteDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerResourceWriter_WriteData_ForwardToCallback(const ServiceWorkerResourceWriter_WriteData_ForwardToCallback&) = delete;
  ServiceWorkerResourceWriter_WriteData_ForwardToCallback& operator=(const ServiceWorkerResourceWriter_WriteData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceWriter::WriteDataCallback callback_;
};

ServiceWorkerResourceWriterProxy::ServiceWorkerResourceWriterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerResourceWriterProxy::WriteResponseHead(
    ::network::mojom::URLResponseHeadPtr in_response_head, WriteResponseHeadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerResourceWriter::WriteResponseHead", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response_head"), in_response_head,
                        "<value of type ::network::mojom::URLResponseHeadPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceWriter::kWriteResponseHead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceWriter_WriteResponseHead_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response_head)::BaseType> response_head_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
    in_response_head,
    response_head_fragment);

  params->response_head.Set(
      response_head_fragment.is_null() ? nullptr : response_head_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response_head.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response_head in ServiceWorkerResourceWriter.WriteResponseHead request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceWriter::Name_);
  message.set_method_name("WriteResponseHead");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerResourceWriterProxy::WriteData(
    ::mojo_base::BigBuffer in_data, WriteDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerResourceWriter::WriteData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceWriter::kWriteData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceWriter_WriteData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ServiceWorkerResourceWriter.WriteData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceWriter::Name_);
  message.set_method_name("WriteData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceWriter_WriteData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerResourceWriter::WriteResponseHeadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder> proxy(
        new ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerResourceWriter::WriteResponseHeadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status);
};

bool ServiceWorkerResourceWriter_WriteResponseHead_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerResourceWriter.0
  bool success = true;
  int32_t p_status{};
  ServiceWorkerResourceWriter_WriteResponseHead_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceWriter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder::Run(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerResourceWriter::WriteResponseHead", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceWriter::kWriteResponseHead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->status = in_status;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceWriter::Name_);
  message.set_method_name("WriteResponseHead");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerResourceWriter_WriteData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerResourceWriter::WriteDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerResourceWriter_WriteData_ProxyToResponder> proxy(
        new ServiceWorkerResourceWriter_WriteData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerResourceWriter_WriteData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceWriter_WriteData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerResourceWriter_WriteData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerResourceWriter::WriteDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status);
};

bool ServiceWorkerResourceWriter_WriteData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceWriter_WriteData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceWriter_WriteData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerResourceWriter.1
  bool success = true;
  int32_t p_status{};
  ServiceWorkerResourceWriter_WriteData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceWriter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerResourceWriter_WriteData_ProxyToResponder::Run(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerResourceWriter::WriteData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceWriter::kWriteData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceWriter_WriteData_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->status = in_status;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceWriter::Name_);
  message.set_method_name("WriteData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerResourceWriterStubDispatch::Accept(
    ServiceWorkerResourceWriter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerResourceWriter>(message->header()->name)) {
    case messages::ServiceWorkerResourceWriter::kWriteResponseHead: {
      break;
    }
    case messages::ServiceWorkerResourceWriter::kWriteData: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerResourceWriterStubDispatch::AcceptWithResponder(
    ServiceWorkerResourceWriter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerResourceWriter>(message->header()->name)) {
    case messages::ServiceWorkerResourceWriter::kWriteResponseHead: {
      internal::ServiceWorkerResourceWriter_WriteResponseHead_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceWriter_WriteResponseHead_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerResourceWriter.0
      bool success = true;
      ::network::mojom::URLResponseHeadPtr p_response_head{};
      ServiceWorkerResourceWriter_WriteResponseHead_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponseHead(&p_response_head))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceWriter::Name_, 0, false);
        return false;
      }
      auto callback =
          ServiceWorkerResourceWriter_WriteResponseHead_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteResponseHead(        
        std::move(p_response_head), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerResourceWriter::kWriteData: {
      internal::ServiceWorkerResourceWriter_WriteData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceWriter_WriteData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerResourceWriter.1
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      ServiceWorkerResourceWriter_WriteData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceWriter::Name_, 1, false);
        return false;
      }
      auto callback =
          ServiceWorkerResourceWriter_WriteData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteData(        
        std::move(p_data), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerResourceWriterValidationInfo[] = {
    { &internal::ServiceWorkerResourceWriter_WriteResponseHead_Params_Data::Validate,
     &internal::ServiceWorkerResourceWriter_WriteResponseHead_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerResourceWriter_WriteData_Params_Data::Validate,
     &internal::ServiceWorkerResourceWriter_WriteData_ResponseParams_Data::Validate},
};

bool ServiceWorkerResourceWriterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::storage::mojom::ServiceWorkerResourceWriter::Name_,
    kServiceWorkerResourceWriterValidationInfo);
}

bool ServiceWorkerResourceWriterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::storage::mojom::ServiceWorkerResourceWriter::Name_,
    kServiceWorkerResourceWriterValidationInfo);
}
// The declaration includes the definition on other builds.

ServiceWorkerResourceMetadataWriter::IPCStableHashFunction ServiceWorkerResourceMetadataWriter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerResourceMetadataWriter>(message.name())) {
    case messages::ServiceWorkerResourceMetadataWriter::kWriteMetadata: {
      return &ServiceWorkerResourceMetadataWriter::WriteMetadata_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerResourceMetadataWriter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerResourceMetadataWriter>(message.name())) {
      case messages::ServiceWorkerResourceMetadataWriter::kWriteMetadata:
            return "Receive storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadata";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerResourceMetadataWriter>(message.name())) {
      case messages::ServiceWorkerResourceMetadataWriter::kWriteMetadata:
            return "Receive reply storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadata";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerResourceMetadataWriter::WriteMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a9acd19;  // IPCStableHash for storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback(
      ServiceWorkerResourceMetadataWriter::WriteMetadataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback(const ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback&) = delete;
  ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback& operator=(const ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerResourceMetadataWriter::WriteMetadataCallback callback_;
};

ServiceWorkerResourceMetadataWriterProxy::ServiceWorkerResourceMetadataWriterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerResourceMetadataWriterProxy::WriteMetadata(
    ::mojo_base::BigBuffer in_data, WriteMetadataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceMetadataWriter::kWriteMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ServiceWorkerResourceMetadataWriter.WriteMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceMetadataWriter::Name_);
  message.set_method_name("WriteMetadata");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerResourceMetadataWriter::WriteMetadataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder> proxy(
        new ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerResourceMetadataWriter::WriteMetadataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status);
};

bool ServiceWorkerResourceMetadataWriter_WriteMetadata_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerResourceMetadataWriter.0
  bool success = true;
  int32_t p_status{};
  ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerResourceMetadataWriter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder::Run(
    int32_t in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerResourceMetadataWriter::WriteMetadata", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerResourceMetadataWriter::kWriteMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->status = in_status;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerResourceMetadataWriter::Name_);
  message.set_method_name("WriteMetadata");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerResourceMetadataWriterStubDispatch::Accept(
    ServiceWorkerResourceMetadataWriter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerResourceMetadataWriter>(message->header()->name)) {
    case messages::ServiceWorkerResourceMetadataWriter::kWriteMetadata: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerResourceMetadataWriterStubDispatch::AcceptWithResponder(
    ServiceWorkerResourceMetadataWriter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerResourceMetadataWriter>(message->header()->name)) {
    case messages::ServiceWorkerResourceMetadataWriter::kWriteMetadata: {
      internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerResourceMetadataWriter.0
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      ServiceWorkerResourceMetadataWriter_WriteMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerResourceMetadataWriter::Name_, 0, false);
        return false;
      }
      auto callback =
          ServiceWorkerResourceMetadataWriter_WriteMetadata_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteMetadata(        
        std::move(p_data), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerResourceMetadataWriterValidationInfo[] = {
    { &internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_Params_Data::Validate,
     &internal::ServiceWorkerResourceMetadataWriter_WriteMetadata_ResponseParams_Data::Validate},
};

bool ServiceWorkerResourceMetadataWriterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::storage::mojom::ServiceWorkerResourceMetadataWriter::Name_,
    kServiceWorkerResourceMetadataWriterValidationInfo);
}

bool ServiceWorkerResourceMetadataWriterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::storage::mojom::ServiceWorkerResourceMetadataWriter::Name_,
    kServiceWorkerResourceMetadataWriterValidationInfo);
}
// The declaration includes the definition on other builds.

ServiceWorkerStorageControl::IPCStableHashFunction ServiceWorkerStorageControl::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerStorageControl>(message.name())) {
    case messages::ServiceWorkerStorageControl::kDisable: {
      return &ServiceWorkerStorageControl::Disable_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kDelete: {
      return &ServiceWorkerStorageControl::Delete_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kRecover: {
      return &ServiceWorkerStorageControl::Recover_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetRegisteredStorageKeys: {
      return &ServiceWorkerStorageControl::GetRegisteredStorageKeys_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kFindRegistrationForClientUrl: {
      return &ServiceWorkerStorageControl::FindRegistrationForClientUrl_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kFindRegistrationForScope: {
      return &ServiceWorkerStorageControl::FindRegistrationForScope_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kFindRegistrationForId: {
      return &ServiceWorkerStorageControl::FindRegistrationForId_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetRegistrationsForStorageKey: {
      return &ServiceWorkerStorageControl::GetRegistrationsForStorageKey_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetUsageForStorageKey: {
      return &ServiceWorkerStorageControl::GetUsageForStorageKey_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetAllRegistrationsDeprecated: {
      return &ServiceWorkerStorageControl::GetAllRegistrationsDeprecated_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetFakeRegistrationForClientUrl: {
      return &ServiceWorkerStorageControl::GetFakeRegistrationForClientUrl_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kStoreRegistration: {
      return &ServiceWorkerStorageControl::StoreRegistration_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kDeleteRegistration: {
      return &ServiceWorkerStorageControl::DeleteRegistration_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kUpdateToActiveState: {
      return &ServiceWorkerStorageControl::UpdateToActiveState_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kUpdateLastUpdateCheckTime: {
      return &ServiceWorkerStorageControl::UpdateLastUpdateCheckTime_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadEnabled: {
      return &ServiceWorkerStorageControl::UpdateNavigationPreloadEnabled_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadHeader: {
      return &ServiceWorkerStorageControl::UpdateNavigationPreloadHeader_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kUpdateFetchHandlerType: {
      return &ServiceWorkerStorageControl::UpdateFetchHandlerType_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kUpdateResourceSha256Checksums: {
      return &ServiceWorkerStorageControl::UpdateResourceSha256Checksums_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetNewRegistrationId: {
      return &ServiceWorkerStorageControl::GetNewRegistrationId_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetNewVersionId: {
      return &ServiceWorkerStorageControl::GetNewVersionId_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetNewResourceId: {
      return &ServiceWorkerStorageControl::GetNewResourceId_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kCreateResourceReader: {
      return &ServiceWorkerStorageControl::CreateResourceReader_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kCreateResourceWriter: {
      return &ServiceWorkerStorageControl::CreateResourceWriter_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kCreateResourceMetadataWriter: {
      return &ServiceWorkerStorageControl::CreateResourceMetadataWriter_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kStoreUncommittedResourceId: {
      return &ServiceWorkerStorageControl::StoreUncommittedResourceId_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kDoomUncommittedResources: {
      return &ServiceWorkerStorageControl::DoomUncommittedResources_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetUserData: {
      return &ServiceWorkerStorageControl::GetUserData_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kStoreUserData: {
      return &ServiceWorkerStorageControl::StoreUserData_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kClearUserData: {
      return &ServiceWorkerStorageControl::ClearUserData_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetUserDataByKeyPrefix: {
      return &ServiceWorkerStorageControl::GetUserDataByKeyPrefix_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetUserKeysAndDataByKeyPrefix: {
      return &ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefix_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kClearUserDataByKeyPrefixes: {
      return &ServiceWorkerStorageControl::ClearUserDataByKeyPrefixes_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrations: {
      return &ServiceWorkerStorageControl::GetUserDataForAllRegistrations_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrationsByKeyPrefix: {
      return &ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefix_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kClearUserDataForAllRegistrationsByKeyPrefix: {
      return &ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefix_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kPerformStorageCleanup: {
      return &ServiceWorkerStorageControl::PerformStorageCleanup_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kApplyPolicyUpdates: {
      return &ServiceWorkerStorageControl::ApplyPolicyUpdates_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForTest: {
      return &ServiceWorkerStorageControl::GetPurgingResourceIdsForTest_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForLiveVersionForTest: {
      return &ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTest_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetPurgeableResourceIdsForTest: {
      return &ServiceWorkerStorageControl::GetPurgeableResourceIdsForTest_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kGetUncommittedResourceIdsForTest: {
      return &ServiceWorkerStorageControl::GetUncommittedResourceIdsForTest_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStorageControl::kSetPurgingCompleteCallbackForTest: {
      return &ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTest_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerStorageControl::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerStorageControl>(message.name())) {
      case messages::ServiceWorkerStorageControl::kDisable:
            return "Receive storage::mojom::ServiceWorkerStorageControl::Disable";
      case messages::ServiceWorkerStorageControl::kDelete:
            return "Receive storage::mojom::ServiceWorkerStorageControl::Delete";
      case messages::ServiceWorkerStorageControl::kRecover:
            return "Receive storage::mojom::ServiceWorkerStorageControl::Recover";
      case messages::ServiceWorkerStorageControl::kGetRegisteredStorageKeys:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetRegisteredStorageKeys";
      case messages::ServiceWorkerStorageControl::kFindRegistrationForClientUrl:
            return "Receive storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrl";
      case messages::ServiceWorkerStorageControl::kFindRegistrationForScope:
            return "Receive storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScope";
      case messages::ServiceWorkerStorageControl::kFindRegistrationForId:
            return "Receive storage::mojom::ServiceWorkerStorageControl::FindRegistrationForId";
      case messages::ServiceWorkerStorageControl::kGetRegistrationsForStorageKey:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForStorageKey";
      case messages::ServiceWorkerStorageControl::kGetUsageForStorageKey:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetUsageForStorageKey";
      case messages::ServiceWorkerStorageControl::kGetAllRegistrationsDeprecated:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecated";
      case messages::ServiceWorkerStorageControl::kGetFakeRegistrationForClientUrl:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetFakeRegistrationForClientUrl";
      case messages::ServiceWorkerStorageControl::kStoreRegistration:
            return "Receive storage::mojom::ServiceWorkerStorageControl::StoreRegistration";
      case messages::ServiceWorkerStorageControl::kDeleteRegistration:
            return "Receive storage::mojom::ServiceWorkerStorageControl::DeleteRegistration";
      case messages::ServiceWorkerStorageControl::kUpdateToActiveState:
            return "Receive storage::mojom::ServiceWorkerStorageControl::UpdateToActiveState";
      case messages::ServiceWorkerStorageControl::kUpdateLastUpdateCheckTime:
            return "Receive storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTime";
      case messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadEnabled:
            return "Receive storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabled";
      case messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadHeader:
            return "Receive storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeader";
      case messages::ServiceWorkerStorageControl::kUpdateFetchHandlerType:
            return "Receive storage::mojom::ServiceWorkerStorageControl::UpdateFetchHandlerType";
      case messages::ServiceWorkerStorageControl::kUpdateResourceSha256Checksums:
            return "Receive storage::mojom::ServiceWorkerStorageControl::UpdateResourceSha256Checksums";
      case messages::ServiceWorkerStorageControl::kGetNewRegistrationId:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationId";
      case messages::ServiceWorkerStorageControl::kGetNewVersionId:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetNewVersionId";
      case messages::ServiceWorkerStorageControl::kGetNewResourceId:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetNewResourceId";
      case messages::ServiceWorkerStorageControl::kCreateResourceReader:
            return "Receive storage::mojom::ServiceWorkerStorageControl::CreateResourceReader";
      case messages::ServiceWorkerStorageControl::kCreateResourceWriter:
            return "Receive storage::mojom::ServiceWorkerStorageControl::CreateResourceWriter";
      case messages::ServiceWorkerStorageControl::kCreateResourceMetadataWriter:
            return "Receive storage::mojom::ServiceWorkerStorageControl::CreateResourceMetadataWriter";
      case messages::ServiceWorkerStorageControl::kStoreUncommittedResourceId:
            return "Receive storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceId";
      case messages::ServiceWorkerStorageControl::kDoomUncommittedResources:
            return "Receive storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResources";
      case messages::ServiceWorkerStorageControl::kGetUserData:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetUserData";
      case messages::ServiceWorkerStorageControl::kStoreUserData:
            return "Receive storage::mojom::ServiceWorkerStorageControl::StoreUserData";
      case messages::ServiceWorkerStorageControl::kClearUserData:
            return "Receive storage::mojom::ServiceWorkerStorageControl::ClearUserData";
      case messages::ServiceWorkerStorageControl::kGetUserDataByKeyPrefix:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefix";
      case messages::ServiceWorkerStorageControl::kGetUserKeysAndDataByKeyPrefix:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefix";
      case messages::ServiceWorkerStorageControl::kClearUserDataByKeyPrefixes:
            return "Receive storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixes";
      case messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrations:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrations";
      case messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrationsByKeyPrefix:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefix";
      case messages::ServiceWorkerStorageControl::kClearUserDataForAllRegistrationsByKeyPrefix:
            return "Receive storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefix";
      case messages::ServiceWorkerStorageControl::kPerformStorageCleanup:
            return "Receive storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanup";
      case messages::ServiceWorkerStorageControl::kApplyPolicyUpdates:
            return "Receive storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdates";
      case messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForTest:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTest";
      case messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForLiveVersionForTest:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTest";
      case messages::ServiceWorkerStorageControl::kGetPurgeableResourceIdsForTest:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTest";
      case messages::ServiceWorkerStorageControl::kGetUncommittedResourceIdsForTest:
            return "Receive storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTest";
      case messages::ServiceWorkerStorageControl::kSetPurgingCompleteCallbackForTest:
            return "Receive storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTest";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerStorageControl>(message.name())) {
      case messages::ServiceWorkerStorageControl::kDisable:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::Disable";
      case messages::ServiceWorkerStorageControl::kDelete:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::Delete";
      case messages::ServiceWorkerStorageControl::kRecover:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::Recover";
      case messages::ServiceWorkerStorageControl::kGetRegisteredStorageKeys:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetRegisteredStorageKeys";
      case messages::ServiceWorkerStorageControl::kFindRegistrationForClientUrl:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrl";
      case messages::ServiceWorkerStorageControl::kFindRegistrationForScope:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScope";
      case messages::ServiceWorkerStorageControl::kFindRegistrationForId:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::FindRegistrationForId";
      case messages::ServiceWorkerStorageControl::kGetRegistrationsForStorageKey:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForStorageKey";
      case messages::ServiceWorkerStorageControl::kGetUsageForStorageKey:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetUsageForStorageKey";
      case messages::ServiceWorkerStorageControl::kGetAllRegistrationsDeprecated:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecated";
      case messages::ServiceWorkerStorageControl::kGetFakeRegistrationForClientUrl:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetFakeRegistrationForClientUrl";
      case messages::ServiceWorkerStorageControl::kStoreRegistration:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::StoreRegistration";
      case messages::ServiceWorkerStorageControl::kDeleteRegistration:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::DeleteRegistration";
      case messages::ServiceWorkerStorageControl::kUpdateToActiveState:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::UpdateToActiveState";
      case messages::ServiceWorkerStorageControl::kUpdateLastUpdateCheckTime:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTime";
      case messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadEnabled:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabled";
      case messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadHeader:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeader";
      case messages::ServiceWorkerStorageControl::kUpdateFetchHandlerType:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::UpdateFetchHandlerType";
      case messages::ServiceWorkerStorageControl::kUpdateResourceSha256Checksums:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::UpdateResourceSha256Checksums";
      case messages::ServiceWorkerStorageControl::kGetNewRegistrationId:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationId";
      case messages::ServiceWorkerStorageControl::kGetNewVersionId:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetNewVersionId";
      case messages::ServiceWorkerStorageControl::kGetNewResourceId:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetNewResourceId";
      case messages::ServiceWorkerStorageControl::kCreateResourceReader:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::CreateResourceReader";
      case messages::ServiceWorkerStorageControl::kCreateResourceWriter:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::CreateResourceWriter";
      case messages::ServiceWorkerStorageControl::kCreateResourceMetadataWriter:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::CreateResourceMetadataWriter";
      case messages::ServiceWorkerStorageControl::kStoreUncommittedResourceId:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceId";
      case messages::ServiceWorkerStorageControl::kDoomUncommittedResources:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResources";
      case messages::ServiceWorkerStorageControl::kGetUserData:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetUserData";
      case messages::ServiceWorkerStorageControl::kStoreUserData:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::StoreUserData";
      case messages::ServiceWorkerStorageControl::kClearUserData:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::ClearUserData";
      case messages::ServiceWorkerStorageControl::kGetUserDataByKeyPrefix:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefix";
      case messages::ServiceWorkerStorageControl::kGetUserKeysAndDataByKeyPrefix:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefix";
      case messages::ServiceWorkerStorageControl::kClearUserDataByKeyPrefixes:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixes";
      case messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrations:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrations";
      case messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrationsByKeyPrefix:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefix";
      case messages::ServiceWorkerStorageControl::kClearUserDataForAllRegistrationsByKeyPrefix:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefix";
      case messages::ServiceWorkerStorageControl::kPerformStorageCleanup:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanup";
      case messages::ServiceWorkerStorageControl::kApplyPolicyUpdates:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdates";
      case messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForTest:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTest";
      case messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForLiveVersionForTest:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTest";
      case messages::ServiceWorkerStorageControl::kGetPurgeableResourceIdsForTest:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTest";
      case messages::ServiceWorkerStorageControl::kGetUncommittedResourceIdsForTest:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTest";
      case messages::ServiceWorkerStorageControl::kSetPurgingCompleteCallbackForTest:
            return "Receive reply storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTest";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerStorageControl::Disable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xda378ca6;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::Disable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::Delete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x40df6701;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::Delete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::Recover_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0fc6ddae;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::Recover
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetRegisteredStorageKeys_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x11d80322;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetRegisteredStorageKeys
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::FindRegistrationForClientUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f3225cb;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::FindRegistrationForScope_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdea3c771;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScope
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::FindRegistrationForId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6eeb6e33;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::FindRegistrationForId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetRegistrationsForStorageKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e75ae5a;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForStorageKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetUsageForStorageKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x12288ebd;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetUsageForStorageKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetAllRegistrationsDeprecated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7fb11dce;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetFakeRegistrationForClientUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd87fd9a7;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetFakeRegistrationForClientUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::StoreRegistration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbdfc1211;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::StoreRegistration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::DeleteRegistration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x507d1730;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::DeleteRegistration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::UpdateToActiveState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x575366d0;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::UpdateToActiveState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::UpdateLastUpdateCheckTime_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa347b39e;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTime
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::UpdateNavigationPreloadEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaedbd5ee;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::UpdateNavigationPreloadHeader_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb55a0c5b;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeader
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::UpdateFetchHandlerType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5529e1a2;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::UpdateFetchHandlerType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::UpdateResourceSha256Checksums_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfad7d0aa;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::UpdateResourceSha256Checksums
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetNewRegistrationId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x17662e75;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetNewVersionId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x63bc9093;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetNewVersionId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetNewResourceId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3ce2b93c;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetNewResourceId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::CreateResourceReader_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b1f0e5b;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::CreateResourceReader
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::CreateResourceWriter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5ce055f4;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::CreateResourceWriter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::CreateResourceMetadataWriter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa6ad3e87;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::CreateResourceMetadataWriter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::StoreUncommittedResourceId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f0cf42e;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::DoomUncommittedResources_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe6c2b68a;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResources
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetUserData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcf497243;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetUserData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::StoreUserData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf8258bc;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::StoreUserData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::ClearUserData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed13b74f;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::ClearUserData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetUserDataByKeyPrefix_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2ebca3c9;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefix
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefix_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7c1796d;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefix
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::ClearUserDataByKeyPrefixes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7895644b;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetUserDataForAllRegistrations_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6eef85d1;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrations
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefix_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7029c6a0;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefix
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefix_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb61177ae;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefix
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::PerformStorageCleanup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21c7c3e0;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::ApplyPolicyUpdates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8d972c07;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetPurgingResourceIdsForTest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4ff5b98d;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x28f1dccb;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetPurgeableResourceIdsForTest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9c7deec4;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::GetUncommittedResourceIdsForTest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54c5268c;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c14a1bd;  // IPCStableHash for storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ServiceWorkerStorageControl_Disable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_Disable_ForwardToCallback(
      ServiceWorkerStorageControl::DisableCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_Disable_ForwardToCallback(const ServiceWorkerStorageControl_Disable_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_Disable_ForwardToCallback& operator=(const ServiceWorkerStorageControl_Disable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::DisableCallback callback_;
};

class ServiceWorkerStorageControl_Delete_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_Delete_ForwardToCallback(
      ServiceWorkerStorageControl::DeleteCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_Delete_ForwardToCallback(const ServiceWorkerStorageControl_Delete_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_Delete_ForwardToCallback& operator=(const ServiceWorkerStorageControl_Delete_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::DeleteCallback callback_;
};

class ServiceWorkerStorageControl_Recover_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_Recover_ForwardToCallback(
      ServiceWorkerStorageControl::RecoverCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_Recover_ForwardToCallback(const ServiceWorkerStorageControl_Recover_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_Recover_ForwardToCallback& operator=(const ServiceWorkerStorageControl_Recover_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::RecoverCallback callback_;
};

class ServiceWorkerStorageControl_GetRegisteredStorageKeys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetRegisteredStorageKeys_ForwardToCallback(
      ServiceWorkerStorageControl::GetRegisteredStorageKeysCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetRegisteredStorageKeys_ForwardToCallback(const ServiceWorkerStorageControl_GetRegisteredStorageKeys_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetRegisteredStorageKeys_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetRegisteredStorageKeys_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetRegisteredStorageKeysCallback callback_;
};

class ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback(
      ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback(const ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback& operator=(const ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback callback_;
};

class ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback(
      ServiceWorkerStorageControl::FindRegistrationForScopeCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback(const ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback& operator=(const ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::FindRegistrationForScopeCallback callback_;
};

class ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback(
      ServiceWorkerStorageControl::FindRegistrationForIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback(const ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback& operator=(const ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::FindRegistrationForIdCallback callback_;
};

class ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ForwardToCallback(
      ServiceWorkerStorageControl::GetRegistrationsForStorageKeyCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ForwardToCallback(const ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetRegistrationsForStorageKeyCallback callback_;
};

class ServiceWorkerStorageControl_GetUsageForStorageKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUsageForStorageKey_ForwardToCallback(
      ServiceWorkerStorageControl::GetUsageForStorageKeyCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetUsageForStorageKey_ForwardToCallback(const ServiceWorkerStorageControl_GetUsageForStorageKey_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetUsageForStorageKey_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetUsageForStorageKey_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUsageForStorageKeyCallback callback_;
};

class ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback(
      ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback(const ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback callback_;
};

class ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ForwardToCallback(
      ServiceWorkerStorageControl::GetFakeRegistrationForClientUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ForwardToCallback(const ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetFakeRegistrationForClientUrlCallback callback_;
};

class ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback(
      ServiceWorkerStorageControl::StoreRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback(const ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback& operator=(const ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::StoreRegistrationCallback callback_;
};

class ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback(
      ServiceWorkerStorageControl::DeleteRegistrationCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback(const ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback& operator=(const ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::DeleteRegistrationCallback callback_;
};

class ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback(
      ServiceWorkerStorageControl::UpdateToActiveStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback(const ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback& operator=(const ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::UpdateToActiveStateCallback callback_;
};

class ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback(
      ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback(const ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback& operator=(const ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback callback_;
};

class ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback(
      ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback(const ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback& operator=(const ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback callback_;
};

class ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback(
      ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback(const ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback& operator=(const ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback callback_;
};

class ServiceWorkerStorageControl_UpdateFetchHandlerType_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_UpdateFetchHandlerType_ForwardToCallback(
      ServiceWorkerStorageControl::UpdateFetchHandlerTypeCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_UpdateFetchHandlerType_ForwardToCallback(const ServiceWorkerStorageControl_UpdateFetchHandlerType_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_UpdateFetchHandlerType_ForwardToCallback& operator=(const ServiceWorkerStorageControl_UpdateFetchHandlerType_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::UpdateFetchHandlerTypeCallback callback_;
};

class ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ForwardToCallback(
      ServiceWorkerStorageControl::UpdateResourceSha256ChecksumsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ForwardToCallback(const ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ForwardToCallback& operator=(const ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::UpdateResourceSha256ChecksumsCallback callback_;
};

class ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback(
      ServiceWorkerStorageControl::GetNewRegistrationIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback(const ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetNewRegistrationIdCallback callback_;
};

class ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback(
      ServiceWorkerStorageControl::GetNewVersionIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback(const ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetNewVersionIdCallback callback_;
};

class ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback(
      ServiceWorkerStorageControl::GetNewResourceIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback(const ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetNewResourceIdCallback callback_;
};

class ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback(
      ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback(const ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback& operator=(const ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback callback_;
};

class ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback(
      ServiceWorkerStorageControl::DoomUncommittedResourcesCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback(const ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback& operator=(const ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::DoomUncommittedResourcesCallback callback_;
};

class ServiceWorkerStorageControl_GetUserData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUserData_ForwardToCallback(
      ServiceWorkerStorageControl::GetUserDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetUserData_ForwardToCallback(const ServiceWorkerStorageControl_GetUserData_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetUserData_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetUserData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUserDataCallback callback_;
};

class ServiceWorkerStorageControl_StoreUserData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_StoreUserData_ForwardToCallback(
      ServiceWorkerStorageControl::StoreUserDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_StoreUserData_ForwardToCallback(const ServiceWorkerStorageControl_StoreUserData_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_StoreUserData_ForwardToCallback& operator=(const ServiceWorkerStorageControl_StoreUserData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::StoreUserDataCallback callback_;
};

class ServiceWorkerStorageControl_ClearUserData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_ClearUserData_ForwardToCallback(
      ServiceWorkerStorageControl::ClearUserDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_ClearUserData_ForwardToCallback(const ServiceWorkerStorageControl_ClearUserData_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_ClearUserData_ForwardToCallback& operator=(const ServiceWorkerStorageControl_ClearUserData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::ClearUserDataCallback callback_;
};

class ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback(
      ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback(const ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback callback_;
};

class ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback(
      ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback(const ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback callback_;
};

class ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback(
      ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback(const ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback& operator=(const ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback callback_;
};

class ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback(
      ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback(const ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback callback_;
};

class ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback(
      ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback(const ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback callback_;
};

class ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback(
      ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback(const ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback& operator=(const ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback callback_;
};

class ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback(
      ServiceWorkerStorageControl::PerformStorageCleanupCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback(const ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback& operator=(const ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::PerformStorageCleanupCallback callback_;
};

class ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback(
      ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback(const ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback& operator=(const ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback callback_;
};

class ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback(
      ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback(const ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback callback_;
};

class ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ForwardToCallback(
      ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTestCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ForwardToCallback(const ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTestCallback callback_;
};

class ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback(
      ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback(const ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback callback_;
};

class ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback(
      ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback(const ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback& operator=(const ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback callback_;
};

class ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback(
      ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback callback
      ) : callback_(std::move(callback)) {
  }

  ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback(const ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback&) = delete;
  ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback& operator=(const ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback callback_;
};

ServiceWorkerStorageControlProxy::ServiceWorkerStorageControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerStorageControlProxy::Disable(
    DisableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::Disable");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kDisable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Disable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Disable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_Disable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::Delete(
    DeleteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::Delete");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Delete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Delete");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_Delete_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::Recover(
    std::vector<ServiceWorkerLiveVersionInfoPtr> in_versions, RecoverCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::Recover", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("versions"), in_versions,
                        "<value of type std::vector<ServiceWorkerLiveVersionInfoPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kRecover), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Recover_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->versions)::BaseType>
      versions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& versions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerLiveVersionInfoDataView>>(
    in_versions,
    versions_fragment,
    &versions_validate_params);

  params->versions.Set(
      versions_fragment.is_null() ? nullptr : versions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->versions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null versions in ServiceWorkerStorageControl.Recover request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Recover");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_Recover_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetRegisteredStorageKeys(
    GetRegisteredStorageKeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetRegisteredStorageKeys");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetRegisteredStorageKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetRegisteredStorageKeys_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetRegisteredStorageKeys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetRegisteredStorageKeys_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::FindRegistrationForClientUrl(
    const ::GURL& in_client_url, const ::blink::StorageKey& in_key, FindRegistrationForClientUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_url"), in_client_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kFindRegistrationForClientUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_url)::BaseType> client_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_client_url,
    client_url_fragment);

  params->client_url.Set(
      client_url_fragment.is_null() ? nullptr : client_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_url in ServiceWorkerStorageControl.FindRegistrationForClientUrl request");
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.FindRegistrationForClientUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForClientUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::FindRegistrationForScope(
    const ::GURL& in_scope, const ::blink::StorageKey& in_key, FindRegistrationForScopeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScope", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scope"), in_scope,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kFindRegistrationForScope), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->scope)::BaseType> scope_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_scope,
    scope_fragment);

  params->scope.Set(
      scope_fragment.is_null() ? nullptr : scope_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->scope.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null scope in ServiceWorkerStorageControl.FindRegistrationForScope request");
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.FindRegistrationForScope request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForScope");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::FindRegistrationForId(
    int64_t in_registration_id, const std::optional<::blink::StorageKey>& in_key, FindRegistrationForIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::FindRegistrationForId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::optional<::blink::StorageKey>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kFindRegistrationForId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForId_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetRegistrationsForStorageKey(
    const ::blink::StorageKey& in_key, GetRegistrationsForStorageKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForStorageKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetRegistrationsForStorageKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetRegistrationsForStorageKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.GetRegistrationsForStorageKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetRegistrationsForStorageKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetUsageForStorageKey(
    const ::blink::StorageKey& in_key, GetUsageForStorageKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetUsageForStorageKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUsageForStorageKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUsageForStorageKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.GetUsageForStorageKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUsageForStorageKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUsageForStorageKey_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetAllRegistrationsDeprecated(
    GetAllRegistrationsDeprecatedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecated");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetAllRegistrationsDeprecated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetAllRegistrationsDeprecated");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetFakeRegistrationForClientUrl(
    const ::GURL& in_client_url, const ::blink::StorageKey& in_key, GetFakeRegistrationForClientUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetFakeRegistrationForClientUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_url"), in_client_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetFakeRegistrationForClientUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_url)::BaseType> client_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_client_url,
    client_url_fragment);

  params->client_url.Set(
      client_url_fragment.is_null() ? nullptr : client_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->client_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null client_url in ServiceWorkerStorageControl.GetFakeRegistrationForClientUrl request");
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.GetFakeRegistrationForClientUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetFakeRegistrationForClientUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::StoreRegistration(
    ::storage::mojom::ServiceWorkerRegistrationDataPtr in_registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> in_resources, StoreRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::StoreRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration"), in_registration,
                        "<value of type ::storage::mojom::ServiceWorkerRegistrationDataPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resources"), in_resources,
                        "<value of type std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kStoreRegistration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreRegistration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->registration)::BaseType> registration_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerRegistrationDataDataView>(
    in_registration,
    registration_fragment);

  params->registration.Set(
      registration_fragment.is_null() ? nullptr : registration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registration in ServiceWorkerStorageControl.StoreRegistration request");
  mojo::internal::MessageFragment<
      typename decltype(params->resources)::BaseType>
      resources_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>>(
    in_resources,
    resources_fragment,
    &resources_validate_params);

  params->resources.Set(
      resources_fragment.is_null() ? nullptr : resources_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resources.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resources in ServiceWorkerStorageControl.StoreRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::DeleteRegistration(
    int64_t in_registration_id, const ::blink::StorageKey& in_key, DeleteRegistrationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::DeleteRegistration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kDeleteRegistration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_DeleteRegistration_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.DeleteRegistration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("DeleteRegistration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::UpdateToActiveState(
    int64_t in_registration_id, const ::blink::StorageKey& in_key, UpdateToActiveStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::UpdateToActiveState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateToActiveState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateToActiveState_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.UpdateToActiveState request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateToActiveState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::UpdateLastUpdateCheckTime(
    int64_t in_registration_id, const ::blink::StorageKey& in_key, ::base::Time in_last_update_check_time, UpdateLastUpdateCheckTimeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("last_update_check_time"), in_last_update_check_time,
                        "<value of type ::base::Time>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateLastUpdateCheckTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.UpdateLastUpdateCheckTime request");
  mojo::internal::MessageFragment<
      typename decltype(params->last_update_check_time)::BaseType> last_update_check_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_last_update_check_time,
    last_update_check_time_fragment);

  params->last_update_check_time.Set(
      last_update_check_time_fragment.is_null() ? nullptr : last_update_check_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->last_update_check_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null last_update_check_time in ServiceWorkerStorageControl.UpdateLastUpdateCheckTime request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateLastUpdateCheckTime");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::UpdateNavigationPreloadEnabled(
    int64_t in_registration_id, const ::blink::StorageKey& in_key, bool in_enable, UpdateNavigationPreloadEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.UpdateNavigationPreloadEnabled request");

  params->enable = in_enable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateNavigationPreloadEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::UpdateNavigationPreloadHeader(
    int64_t in_registration_id, const ::blink::StorageKey& in_key, const std::string& in_value, UpdateNavigationPreloadHeaderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadHeader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.UpdateNavigationPreloadHeader request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in ServiceWorkerStorageControl.UpdateNavigationPreloadHeader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateNavigationPreloadHeader");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::UpdateFetchHandlerType(
    int64_t in_registration_id, const ::blink::StorageKey& in_key, ::blink::mojom::ServiceWorkerFetchHandlerType in_type, UpdateFetchHandlerTypeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::UpdateFetchHandlerType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::blink::mojom::ServiceWorkerFetchHandlerType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateFetchHandlerType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateFetchHandlerType_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.UpdateFetchHandlerType request");

  
  mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchHandlerType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateFetchHandlerType");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_UpdateFetchHandlerType_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::UpdateResourceSha256Checksums(
    int64_t in_registratation_id, const ::blink::StorageKey& in_key, const base::flat_map<int64_t, std::string>& in_updated_sha256_checksums, UpdateResourceSha256ChecksumsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::UpdateResourceSha256Checksums", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registratation_id"), in_registratation_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updated_sha256_checksums"), in_updated_sha256_checksums,
                        "<value of type const base::flat_map<int64_t, std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateResourceSha256Checksums), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateResourceSha256Checksums_Params_Data> params(
          message);
  params.Allocate();

  params->registratation_id = in_registratation_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.UpdateResourceSha256Checksums request");
  mojo::internal::MessageFragment<
      typename decltype(params->updated_sha256_checksums)::BaseType>
      updated_sha256_checksums_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& updated_sha256_checksums_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<int64_t, mojo::StringDataView>>(
    in_updated_sha256_checksums,
    updated_sha256_checksums_fragment,
    &updated_sha256_checksums_validate_params);

  params->updated_sha256_checksums.Set(
      updated_sha256_checksums_fragment.is_null() ? nullptr : updated_sha256_checksums_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->updated_sha256_checksums.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null updated_sha256_checksums in ServiceWorkerStorageControl.UpdateResourceSha256Checksums request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateResourceSha256Checksums");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetNewRegistrationId(
    GetNewRegistrationIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetNewRegistrationId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewRegistrationId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetNewVersionId(
    GetNewVersionIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetNewVersionId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetNewVersionId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewVersionId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewVersionId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetNewResourceId(
    GetNewResourceIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetNewResourceId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetNewResourceId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewResourceId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewResourceId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::CreateResourceReader(
    int64_t in_resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceReader> in_reader) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::CreateResourceReader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_id"), in_resource_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reader"), in_reader,
                        "<value of type ::mojo::PendingReceiver<ServiceWorkerResourceReader>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kCreateResourceReader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_CreateResourceReader_Params_Data> params(
          message);
  params.Allocate();

  params->resource_id = in_resource_id;

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::ServiceWorkerResourceReaderInterfaceBase>>(
    in_reader,
    &params->reader,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->reader)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid reader in ServiceWorkerStorageControl.CreateResourceReader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("CreateResourceReader");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerStorageControlProxy::CreateResourceWriter(
    int64_t in_resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceWriter> in_writer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::CreateResourceWriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_id"), in_resource_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writer"), in_writer,
                        "<value of type ::mojo::PendingReceiver<ServiceWorkerResourceWriter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kCreateResourceWriter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_CreateResourceWriter_Params_Data> params(
          message);
  params.Allocate();

  params->resource_id = in_resource_id;

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::ServiceWorkerResourceWriterInterfaceBase>>(
    in_writer,
    &params->writer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->writer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid writer in ServiceWorkerStorageControl.CreateResourceWriter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("CreateResourceWriter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerStorageControlProxy::CreateResourceMetadataWriter(
    int64_t in_resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> in_writer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::CreateResourceMetadataWriter", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_id"), in_resource_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("writer"), in_writer,
                        "<value of type ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kCreateResourceMetadataWriter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data> params(
          message);
  params.Allocate();

  params->resource_id = in_resource_id;

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::ServiceWorkerResourceMetadataWriterInterfaceBase>>(
    in_writer,
    &params->writer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->writer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid writer in ServiceWorkerStorageControl.CreateResourceMetadataWriter request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("CreateResourceMetadataWriter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerStorageControlProxy::StoreUncommittedResourceId(
    int64_t in_resource_id, StoreUncommittedResourceIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_id"), in_resource_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kStoreUncommittedResourceId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data> params(
          message);
  params.Allocate();

  params->resource_id = in_resource_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreUncommittedResourceId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::DoomUncommittedResources(
    const std::vector<int64_t>& in_resource_ids, DoomUncommittedResourcesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResources", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_ids"), in_resource_ids,
                        "<value of type const std::vector<int64_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kDoomUncommittedResources), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resource_ids)::BaseType>
      resource_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resource_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_resource_ids,
    resource_ids_fragment,
    &resource_ids_validate_params);

  params->resource_ids.Set(
      resource_ids_fragment.is_null() ? nullptr : resource_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resource_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resource_ids in ServiceWorkerStorageControl.DoomUncommittedResources request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("DoomUncommittedResources");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetUserData(
    int64_t in_registration_id, const std::vector<std::string>& in_keys, GetUserDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetUserData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUserData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserData_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_keys,
    keys_fragment,
    &keys_validate_params);

  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keys in ServiceWorkerStorageControl.GetUserData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUserData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::StoreUserData(
    int64_t in_registration_id, const ::blink::StorageKey& in_key, std::vector<ServiceWorkerUserDataPtr> in_user_data, StoreUserDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::StoreUserData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const ::blink::StorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_data"), in_user_data,
                        "<value of type std::vector<ServiceWorkerUserDataPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kStoreUserData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreUserData_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.StoreUserData request");
  mojo::internal::MessageFragment<
      typename decltype(params->user_data)::BaseType>
      user_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& user_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerUserDataDataView>>(
    in_user_data,
    user_data_fragment,
    &user_data_validate_params);

  params->user_data.Set(
      user_data_fragment.is_null() ? nullptr : user_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->user_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null user_data in ServiceWorkerStorageControl.StoreUserData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreUserData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_StoreUserData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::ClearUserData(
    int64_t in_registration_id, const std::vector<std::string>& in_keys, ClearUserDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::ClearUserData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kClearUserData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserData_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_keys,
    keys_fragment,
    &keys_validate_params);

  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keys in ServiceWorkerStorageControl.ClearUserData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_ClearUserData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetUserDataByKeyPrefix(
    int64_t in_registration_id, const std::string& in_key_prefix, GetUserDataByKeyPrefixCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_prefix"), in_key_prefix,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUserDataByKeyPrefix), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_prefix)::BaseType> key_prefix_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key_prefix,
    key_prefix_fragment);

  params->key_prefix.Set(
      key_prefix_fragment.is_null() ? nullptr : key_prefix_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_prefix.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_prefix in ServiceWorkerStorageControl.GetUserDataByKeyPrefix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataByKeyPrefix");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetUserKeysAndDataByKeyPrefix(
    int64_t in_registration_id, const std::string& in_key_prefix, GetUserKeysAndDataByKeyPrefixCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_prefix"), in_key_prefix,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUserKeysAndDataByKeyPrefix), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_prefix)::BaseType> key_prefix_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key_prefix,
    key_prefix_fragment);

  params->key_prefix.Set(
      key_prefix_fragment.is_null() ? nullptr : key_prefix_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_prefix.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_prefix in ServiceWorkerStorageControl.GetUserKeysAndDataByKeyPrefix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserKeysAndDataByKeyPrefix");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::ClearUserDataByKeyPrefixes(
    int64_t in_registratation_id, const std::vector<std::string>& in_key_prefixes, ClearUserDataByKeyPrefixesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registratation_id"), in_registratation_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_prefixes"), in_key_prefixes,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kClearUserDataByKeyPrefixes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data> params(
          message);
  params.Allocate();

  params->registratation_id = in_registratation_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_prefixes)::BaseType>
      key_prefixes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_prefixes_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_key_prefixes,
    key_prefixes_fragment,
    &key_prefixes_validate_params);

  params->key_prefixes.Set(
      key_prefixes_fragment.is_null() ? nullptr : key_prefixes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_prefixes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_prefixes in ServiceWorkerStorageControl.ClearUserDataByKeyPrefixes request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserDataByKeyPrefixes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetUserDataForAllRegistrations(
    const std::string& in_key, GetUserDataForAllRegistrationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrations", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key)::BaseType> key_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key,
    key_fragment);

  params->key.Set(
      key_fragment.is_null() ? nullptr : key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in ServiceWorkerStorageControl.GetUserDataForAllRegistrations request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataForAllRegistrations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetUserDataForAllRegistrationsByKeyPrefix(
    const std::string& in_key_prefix, GetUserDataForAllRegistrationsByKeyPrefixCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_prefix"), in_key_prefix,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrationsByKeyPrefix), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_prefix)::BaseType> key_prefix_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key_prefix,
    key_prefix_fragment);

  params->key_prefix.Set(
      key_prefix_fragment.is_null() ? nullptr : key_prefix_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_prefix.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_prefix in ServiceWorkerStorageControl.GetUserDataForAllRegistrationsByKeyPrefix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataForAllRegistrationsByKeyPrefix");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::ClearUserDataForAllRegistrationsByKeyPrefix(
    const std::string& in_key_prefix, ClearUserDataForAllRegistrationsByKeyPrefixCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefix", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_prefix"), in_key_prefix,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kClearUserDataForAllRegistrationsByKeyPrefix), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_prefix)::BaseType> key_prefix_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_key_prefix,
    key_prefix_fragment);

  params->key_prefix.Set(
      key_prefix_fragment.is_null() ? nullptr : key_prefix_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_prefix.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_prefix in ServiceWorkerStorageControl.ClearUserDataForAllRegistrationsByKeyPrefix request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserDataForAllRegistrationsByKeyPrefix");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::PerformStorageCleanup(
    PerformStorageCleanupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanup");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kPerformStorageCleanup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("PerformStorageCleanup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> in_policy_updates, ApplyPolicyUpdatesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy_updates"), in_policy_updates,
                        "<value of type std::vector<::storage::mojom::StoragePolicyUpdatePtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kApplyPolicyUpdates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->policy_updates)::BaseType>
      policy_updates_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& policy_updates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::StoragePolicyUpdateDataView>>(
    in_policy_updates,
    policy_updates_fragment,
    &policy_updates_validate_params);

  params->policy_updates.Set(
      policy_updates_fragment.is_null() ? nullptr : policy_updates_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy_updates.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy_updates in ServiceWorkerStorageControl.ApplyPolicyUpdates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetPurgingResourceIdsForTest(
    GetPurgingResourceIdsForTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTest");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetPurgingResourceIdsForTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetPurgingResourceIdsForLiveVersionForTest(
    int64_t in_version_id, GetPurgingResourceIdsForLiveVersionForTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version_id"), in_version_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForLiveVersionForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_Params_Data> params(
          message);
  params.Allocate();

  params->version_id = in_version_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetPurgingResourceIdsForLiveVersionForTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetPurgeableResourceIdsForTest(
    GetPurgeableResourceIdsForTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTest");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetPurgeableResourceIdsForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetPurgeableResourceIdsForTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::GetUncommittedResourceIdsForTest(
    GetUncommittedResourceIdsForTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTest");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUncommittedResourceIdsForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUncommittedResourceIdsForTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceWorkerStorageControlProxy::SetPurgingCompleteCallbackForTest(
    SetPurgingCompleteCallbackForTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTest");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kSetPurgingCompleteCallbackForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("SetPurgingCompleteCallbackForTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ServiceWorkerStorageControl_Disable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::DisableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_Disable_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_Disable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_Disable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_Disable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_Disable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::DisableCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ServiceWorkerStorageControl_Disable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_Disable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_Disable_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.0
  bool success = true;
  ServiceWorkerStorageControl_Disable_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ServiceWorkerStorageControl_Disable_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::Disable");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kDisable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Disable_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Disable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_Delete_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::DeleteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_Delete_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_Delete_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_Delete_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_Delete_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_Delete_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::DeleteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_Delete_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_Delete_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_Delete_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.1
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_Delete_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_Delete_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::Delete", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Delete_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Delete");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_Recover_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::RecoverCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_Recover_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_Recover_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_Recover_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_Recover_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_Recover_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::RecoverCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ServiceWorkerStorageControl_Recover_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_Recover_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_Recover_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.2
  bool success = true;
  ServiceWorkerStorageControl_Recover_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ServiceWorkerStorageControl_Recover_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::Recover");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kRecover), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_Recover_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("Recover");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetRegisteredStorageKeys_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetRegisteredStorageKeysCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetRegisteredStorageKeys_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetRegisteredStorageKeys_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetRegisteredStorageKeys_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetRegisteredStorageKeys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetRegisteredStorageKeys_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetRegisteredStorageKeysCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::blink::StorageKey>& in_keys);
};

bool ServiceWorkerStorageControl_GetRegisteredStorageKeys_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetRegisteredStorageKeys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetRegisteredStorageKeys_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.3
  bool success = true;
  std::vector<::blink::StorageKey> p_keys{};
  ServiceWorkerStorageControl_GetRegisteredStorageKeys_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadKeys(&p_keys))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_keys));
  }
  return true;
}

void ServiceWorkerStorageControl_GetRegisteredStorageKeys_ProxyToResponder::Run(
    const std::vector<::blink::StorageKey>& in_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetRegisteredStorageKeys", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keys"), in_keys,
                        "<value of type const std::vector<::blink::StorageKey>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetRegisteredStorageKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetRegisteredStorageKeys_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->keys)::BaseType>
      keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::StorageKeyDataView>>(
    in_keys,
    keys_fragment,
    &keys_validate_params);

  params->keys.Set(
      keys_fragment.is_null() ? nullptr : keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null keys in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetRegisteredStorageKeys");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::FindRegistrationForClientUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result, const std::optional<std::vector<::GURL>>& in_scopes);
};

bool ServiceWorkerStorageControl_FindRegistrationForClientUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.4
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerFindRegistrationResultPtr p_result{};
  std::optional<std::vector<::GURL>> p_scopes{};
  ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadScopes(&p_scopes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_result), 
std::move(p_scopes));
  }
  return true;
}

void ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result, const std::optional<std::vector<::GURL>>& in_scopes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::FindRegistrationForClientUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ServiceWorkerFindRegistrationResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scopes"), in_scopes,
                        "<value of type const std::optional<std::vector<::GURL>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kFindRegistrationForClientUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerFindRegistrationResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->scopes)::BaseType>
      scopes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& scopes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_scopes,
    scopes_fragment,
    &scopes_validate_params);

  params->scopes.Set(
      scopes_fragment.is_null() ? nullptr : scopes_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForClientUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::FindRegistrationForScopeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::FindRegistrationForScopeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result);
};

bool ServiceWorkerStorageControl_FindRegistrationForScope_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.5
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerFindRegistrationResultPtr p_result{};
  ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_result));
  }
  return true;
}

void ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::FindRegistrationForScope", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ServiceWorkerFindRegistrationResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kFindRegistrationForScope), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerFindRegistrationResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForScope");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::FindRegistrationForIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::FindRegistrationForIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result);
};

bool ServiceWorkerStorageControl_FindRegistrationForId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.6
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerFindRegistrationResultPtr p_result{};
  ServiceWorkerStorageControl_FindRegistrationForId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_result));
  }
  return true;
}

void ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::FindRegistrationForId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ServiceWorkerFindRegistrationResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kFindRegistrationForId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerFindRegistrationResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("FindRegistrationForId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetRegistrationsForStorageKeyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetRegistrationsForStorageKeyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerFindRegistrationResultPtr> in_registrations);
};

bool ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.7
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<ServiceWorkerFindRegistrationResultPtr> p_registrations{};
  ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadRegistrations(&p_registrations))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_registrations));
  }
  return true;
}

void ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerFindRegistrationResultPtr> in_registrations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetRegistrationsForStorageKey", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registrations"), in_registrations,
                        "<value of type std::vector<ServiceWorkerFindRegistrationResultPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetRegistrationsForStorageKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->registrations)::BaseType>
      registrations_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& registrations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerFindRegistrationResultDataView>>(
    in_registrations,
    registrations_fragment,
    &registrations_validate_params);

  params->registrations.Set(
      registrations_fragment.is_null() ? nullptr : registrations_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registrations.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registrations in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetRegistrationsForStorageKey");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUsageForStorageKey_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUsageForStorageKeyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUsageForStorageKey_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUsageForStorageKey_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUsageForStorageKey_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUsageForStorageKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetUsageForStorageKey_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetUsageForStorageKeyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, int64_t in_usage);
};

bool ServiceWorkerStorageControl_GetUsageForStorageKey_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUsageForStorageKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUsageForStorageKey_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.8
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  int64_t p_usage{};
  ServiceWorkerStorageControl_GetUsageForStorageKey_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_usage = input_data_view.usage();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_usage));
  }
  return true;
}

void ServiceWorkerStorageControl_GetUsageForStorageKey_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, int64_t in_usage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetUsageForStorageKey", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage"), in_usage,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUsageForStorageKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUsageForStorageKey_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

  params->usage = in_usage;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUsageForStorageKey");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetAllRegistrationsDeprecatedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr> in_registrations);
};

bool ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.9
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr> p_registrations{};
  ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadRegistrations(&p_registrations))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_registrations));
  }
  return true;
}

void ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr> in_registrations) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetAllRegistrationsDeprecated", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registrations"), in_registrations,
                        "<value of type std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetAllRegistrationsDeprecated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->registrations)::BaseType>
      registrations_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& registrations_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerRegistrationDataDataView>>(
    in_registrations,
    registrations_fragment,
    &registrations_validate_params);

  params->registrations.Set(
      registrations_fragment.is_null() ? nullptr : registrations_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->registrations.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null registrations in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetAllRegistrationsDeprecated");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetFakeRegistrationForClientUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetFakeRegistrationForClientUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result, const std::optional<std::vector<::GURL>>& in_scopes);
};

bool ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.10
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerFindRegistrationResultPtr p_result{};
  std::optional<std::vector<::GURL>> p_scopes{};
  ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadScopes(&p_scopes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_result), 
std::move(p_scopes));
  }
  return true;
}

void ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, ServiceWorkerFindRegistrationResultPtr in_result, const std::optional<std::vector<::GURL>>& in_scopes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetFakeRegistrationForClientUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ServiceWorkerFindRegistrationResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scopes"), in_scopes,
                        "<value of type const std::optional<std::vector<::GURL>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetFakeRegistrationForClientUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerFindRegistrationResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->scopes)::BaseType>
      scopes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& scopes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_scopes,
    scopes_fragment,
    &scopes_validate_params);

  params->scopes.Set(
      scopes_fragment.is_null() ? nullptr : scopes_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetFakeRegistrationForClientUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::StoreRegistrationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::StoreRegistrationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, uint64_t in_deleted_resources_size);
};

bool ServiceWorkerStorageControl_StoreRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.11
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  uint64_t p_deleted_resources_size{};
  ServiceWorkerStorageControl_StoreRegistration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_deleted_resources_size = input_data_view.deleted_resources_size();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_deleted_resources_size));
  }
  return true;
}

void ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, uint64_t in_deleted_resources_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::StoreRegistration", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deleted_resources_size"), in_deleted_resources_size,
                        "<value of type uint64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kStoreRegistration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

  params->deleted_resources_size = in_deleted_resources_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreRegistration");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::DeleteRegistrationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::DeleteRegistrationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, uint64_t in_deleted_resources_size, ServiceWorkerStorageStorageKeyState in_storage_key_state);
};

bool ServiceWorkerStorageControl_DeleteRegistration_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.12
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  uint64_t p_deleted_resources_size{};
  ServiceWorkerStorageStorageKeyState p_storage_key_state{};
  ServiceWorkerStorageControl_DeleteRegistration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success)
    p_deleted_resources_size = input_data_view.deleted_resources_size();
  if (success && !input_data_view.ReadStorageKeyState(&p_storage_key_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_deleted_resources_size), 
std::move(p_storage_key_state));
  }
  return true;
}

void ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, uint64_t in_deleted_resources_size, ServiceWorkerStorageStorageKeyState in_storage_key_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::DeleteRegistration", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deleted_resources_size"), in_deleted_resources_size,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key_state"), in_storage_key_state,
                        "<value of type ServiceWorkerStorageStorageKeyState>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kDeleteRegistration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

  params->deleted_resources_size = in_deleted_resources_size;

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerStorageStorageKeyState>(
    in_storage_key_state,
    &params->storage_key_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("DeleteRegistration");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::UpdateToActiveStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::UpdateToActiveStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_UpdateToActiveState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.13
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_UpdateToActiveState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::UpdateToActiveState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateToActiveState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateToActiveState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::UpdateLastUpdateCheckTimeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.14
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::UpdateLastUpdateCheckTime", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateLastUpdateCheckTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateLastUpdateCheckTime");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::UpdateNavigationPreloadEnabledCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.15
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadEnabled", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateNavigationPreloadEnabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::UpdateNavigationPreloadHeaderCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.16
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::UpdateNavigationPreloadHeader", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadHeader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateNavigationPreloadHeader");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_UpdateFetchHandlerType_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::UpdateFetchHandlerTypeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_UpdateFetchHandlerType_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_UpdateFetchHandlerType_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_UpdateFetchHandlerType_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_UpdateFetchHandlerType_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_UpdateFetchHandlerType_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::UpdateFetchHandlerTypeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_UpdateFetchHandlerType_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_UpdateFetchHandlerType_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_UpdateFetchHandlerType_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.17
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_UpdateFetchHandlerType_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 17, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_UpdateFetchHandlerType_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::UpdateFetchHandlerType", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateFetchHandlerType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateFetchHandlerType_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateFetchHandlerType");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::UpdateResourceSha256ChecksumsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::UpdateResourceSha256ChecksumsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.18
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::UpdateResourceSha256Checksums", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kUpdateResourceSha256Checksums), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("UpdateResourceSha256Checksums");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetNewRegistrationIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetNewRegistrationIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_registration_id);
};

bool ServiceWorkerStorageControl_GetNewRegistrationId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.19
  bool success = true;
  int64_t p_registration_id{};
  ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_registration_id = input_data_view.registration_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 19, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_registration_id));
  }
  return true;
}

void ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder::Run(
    int64_t in_registration_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetNewRegistrationId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("registration_id"), in_registration_id,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetNewRegistrationId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->registration_id = in_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewRegistrationId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetNewVersionIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetNewVersionIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_version_id, ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> in_version_reference);
};

bool ServiceWorkerStorageControl_GetNewVersionId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.20
  bool success = true;
  int64_t p_version_id{};
  ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> p_version_reference{};
  ServiceWorkerStorageControl_GetNewVersionId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_version_id = input_data_view.version_id();
  if (success) {
    p_version_reference =
        input_data_view.TakeVersionReference<decltype(p_version_reference)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_version_id), 
std::move(p_version_reference));
  }
  return true;
}

void ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder::Run(
    int64_t in_version_id, ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> in_version_reference) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetNewVersionId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version_id"), in_version_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version_reference"), in_version_reference,
                        "<value of type ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetNewVersionId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->version_id = in_version_id;

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::ServiceWorkerLiveVersionRefInterfaceBase>>(
    in_version_reference,
    &params->version_reference,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewVersionId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetNewResourceIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetNewResourceIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_resource_id);
};

bool ServiceWorkerStorageControl_GetNewResourceId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.21
  bool success = true;
  int64_t p_resource_id{};
  ServiceWorkerStorageControl_GetNewResourceId_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_resource_id = input_data_view.resource_id();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 21, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_resource_id));
  }
  return true;
}

void ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder::Run(
    int64_t in_resource_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetNewResourceId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_id"), in_resource_id,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetNewResourceId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->resource_id = in_resource_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetNewResourceId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::StoreUncommittedResourceIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_StoreUncommittedResourceId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.25
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 25, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::StoreUncommittedResourceId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kStoreUncommittedResourceId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreUncommittedResourceId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::DoomUncommittedResourcesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::DoomUncommittedResourcesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_DoomUncommittedResources_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.26
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 26, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::DoomUncommittedResources", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kDoomUncommittedResources), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("DoomUncommittedResources");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUserData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUserDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUserData_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUserData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUserData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUserData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetUserData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetUserDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<std::string>& in_values);
};

bool ServiceWorkerStorageControl_GetUserData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUserData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUserData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.27
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<std::string> p_values{};
  ServiceWorkerStorageControl_GetUserData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadValues(&p_values))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 27, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_values));
  }
  return true;
}

void ServiceWorkerStorageControl_GetUserData_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<std::string>& in_values) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetUserData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("values"), in_values,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUserData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserData_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->values)::BaseType>
      values_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& values_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>>(
    in_values,
    values_fragment,
    &values_validate_params);

  params->values.Set(
      values_fragment.is_null() ? nullptr : values_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->values.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null values in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_StoreUserData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::StoreUserDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_StoreUserData_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_StoreUserData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_StoreUserData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_StoreUserData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_StoreUserData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::StoreUserDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_StoreUserData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.28
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_StoreUserData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 28, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_StoreUserData_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::StoreUserData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kStoreUserData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("StoreUserData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_ClearUserData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::ClearUserDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_ClearUserData_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_ClearUserData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_ClearUserData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_ClearUserData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_ClearUserData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::ClearUserDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_ClearUserData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.29
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_ClearUserData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 29, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_ClearUserData_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::ClearUserData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kClearUserData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetUserDataByKeyPrefixCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<std::string>& in_values);
};

bool ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.30
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<std::string> p_values{};
  ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadValues(&p_values))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 30, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_values));
  }
  return true;
}

void ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<std::string>& in_values) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetUserDataByKeyPrefix", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("values"), in_values,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUserDataByKeyPrefix), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->values)::BaseType>
      values_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& values_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ByteStringDataView>>(
    in_values,
    values_fragment,
    &values_validate_params);

  params->values.Set(
      values_fragment.is_null() ? nullptr : values_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->values.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null values in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataByKeyPrefix");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefixCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const base::flat_map<std::string, std::string>& in_user_data);
};

bool ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.31
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  base::flat_map<std::string, std::string> p_user_data{};
  ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadUserData(&p_user_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 31, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_user_data));
  }
  return true;
}

void ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const base::flat_map<std::string, std::string>& in_user_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetUserKeysAndDataByKeyPrefix", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_data"), in_user_data,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUserKeysAndDataByKeyPrefix), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->user_data)::BaseType>
      user_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& user_data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::ByteStringDataView>>(
    in_user_data,
    user_data_fragment,
    &user_data_validate_params);

  params->user_data.Set(
      user_data_fragment.is_null() ? nullptr : user_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->user_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null user_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserKeysAndDataByKeyPrefix");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::ClearUserDataByKeyPrefixesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.32
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 32, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::ClearUserDataByKeyPrefixes", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kClearUserDataByKeyPrefixes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserDataByKeyPrefixes");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetUserDataForAllRegistrationsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerUserDataPtr> in_values);
};

bool ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.33
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<ServiceWorkerUserDataPtr> p_values{};
  ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadValues(&p_values))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 33, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_values));
  }
  return true;
}

void ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerUserDataPtr> in_values) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrations", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("values"), in_values,
                        "<value of type std::vector<ServiceWorkerUserDataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->values)::BaseType>
      values_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& values_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerUserDataDataView>>(
    in_values,
    values_fragment,
    &values_validate_params);

  params->values.Set(
      values_fragment.is_null() ? nullptr : values_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->values.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null values in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataForAllRegistrations");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefixCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerUserDataPtr> in_values);
};

bool ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.34
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<ServiceWorkerUserDataPtr> p_values{};
  ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadValues(&p_values))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 34, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_values));
  }
  return true;
}

void ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, std::vector<ServiceWorkerUserDataPtr> in_values) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetUserDataForAllRegistrationsByKeyPrefix", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("values"), in_values,
                        "<value of type std::vector<ServiceWorkerUserDataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrationsByKeyPrefix), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->values)::BaseType>
      values_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& values_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerUserDataDataView>>(
    in_values,
    values_fragment,
    &values_validate_params);

  params->values.Set(
      values_fragment.is_null() ? nullptr : values_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->values.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null values in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUserDataForAllRegistrationsByKeyPrefix");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefixCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.35
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 35, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::ClearUserDataForAllRegistrationsByKeyPrefix", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kClearUserDataForAllRegistrationsByKeyPrefix), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ClearUserDataForAllRegistrationsByKeyPrefix");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::PerformStorageCleanupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::PerformStorageCleanupCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ServiceWorkerStorageControl_PerformStorageCleanup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.36
  bool success = true;
  ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 36, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::PerformStorageCleanup");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kPerformStorageCleanup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("PerformStorageCleanup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::ApplyPolicyUpdatesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status);
};

bool ServiceWorkerStorageControl_ApplyPolicyUpdates_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.37
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 37, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::ApplyPolicyUpdates", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kApplyPolicyUpdates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("ApplyPolicyUpdates");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetPurgingResourceIdsForTestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids);
};

bool ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.38
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<int64_t> p_resource_ids{};
  ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResourceIds(&p_resource_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 38, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_resource_ids));
  }
  return true;
}

void ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForTest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_ids"), in_resource_ids,
                        "<value of type const std::vector<int64_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->resource_ids)::BaseType>
      resource_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resource_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_resource_ids,
    resource_ids_fragment,
    &resource_ids_validate_params);

  params->resource_ids.Set(
      resource_ids_fragment.is_null() ? nullptr : resource_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resource_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resource_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetPurgingResourceIdsForTest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids);
};

bool ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.39
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<int64_t> p_resource_ids{};
  ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResourceIds(&p_resource_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 39, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_resource_ids));
  }
  return true;
}

void ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetPurgingResourceIdsForLiveVersionForTest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_ids"), in_resource_ids,
                        "<value of type const std::vector<int64_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForLiveVersionForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->resource_ids)::BaseType>
      resource_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resource_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_resource_ids,
    resource_ids_fragment,
    &resource_ids_validate_params);

  params->resource_ids.Set(
      resource_ids_fragment.is_null() ? nullptr : resource_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resource_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resource_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetPurgingResourceIdsForLiveVersionForTest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetPurgeableResourceIdsForTestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids);
};

bool ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.40
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<int64_t> p_resource_ids{};
  ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResourceIds(&p_resource_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 40, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_resource_ids));
  }
  return true;
}

void ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetPurgeableResourceIdsForTest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_ids"), in_resource_ids,
                        "<value of type const std::vector<int64_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetPurgeableResourceIdsForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->resource_ids)::BaseType>
      resource_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resource_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_resource_ids,
    resource_ids_fragment,
    &resource_ids_validate_params);

  params->resource_ids.Set(
      resource_ids_fragment.is_null() ? nullptr : resource_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resource_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resource_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetPurgeableResourceIdsForTest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::GetUncommittedResourceIdsForTestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids);
};

bool ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.41
  bool success = true;
  ::storage::mojom::ServiceWorkerDatabaseStatus p_status{};
  std::vector<int64_t> p_resource_ids{};
  ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResourceIds(&p_resource_ids))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 41, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_resource_ids));
  }
  return true;
}

void ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder::Run(
    ::storage::mojom::ServiceWorkerDatabaseStatus in_status, const std::vector<int64_t>& in_resource_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::GetUncommittedResourceIdsForTest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::storage::mojom::ServiceWorkerDatabaseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resource_ids"), in_resource_ids,
                        "<value of type const std::vector<int64_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kGetUncommittedResourceIdsForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::storage::mojom::ServiceWorkerDatabaseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->resource_ids)::BaseType>
      resource_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resource_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_resource_ids,
    resource_ids_fragment,
    &resource_ids_validate_params);

  params->resource_ids.Set(
      resource_ids_fragment.is_null() ? nullptr : resource_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resource_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resource_ids in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("GetUncommittedResourceIdsForTest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder> proxy(
        new ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ServiceWorkerStorageControl.42
  bool success = true;
  ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ServiceWorkerStorageControl::Name_, 42, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::ServiceWorkerStorageControl::SetPurgingCompleteCallbackForTest");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStorageControl::kSetPurgingCompleteCallbackForTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStorageControl::Name_);
  message.set_method_name("SetPurgingCompleteCallbackForTest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceWorkerStorageControlStubDispatch::Accept(
    ServiceWorkerStorageControl* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerStorageControl>(message->header()->name)) {
    case messages::ServiceWorkerStorageControl::kDisable: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kDelete: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kRecover: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetRegisteredStorageKeys: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kFindRegistrationForClientUrl: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kFindRegistrationForScope: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kFindRegistrationForId: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetRegistrationsForStorageKey: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetUsageForStorageKey: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetAllRegistrationsDeprecated: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetFakeRegistrationForClientUrl: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kStoreRegistration: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kDeleteRegistration: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kUpdateToActiveState: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kUpdateLastUpdateCheckTime: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadEnabled: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadHeader: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kUpdateFetchHandlerType: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kUpdateResourceSha256Checksums: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetNewRegistrationId: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetNewVersionId: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetNewResourceId: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kCreateResourceReader: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerStorageControl_CreateResourceReader_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerStorageControl_CreateResourceReader_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.22
      bool success = true;
      int64_t p_resource_id{};
      ::mojo::PendingReceiver<ServiceWorkerResourceReader> p_reader{};
      ServiceWorkerStorageControl_CreateResourceReader_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_resource_id = input_data_view.resource_id();
      if (success) {
        p_reader =
            input_data_view.TakeReader<decltype(p_reader)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateResourceReader(        
        std::move(p_resource_id), 
        std::move(p_reader));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kCreateResourceWriter: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerStorageControl_CreateResourceWriter_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerStorageControl_CreateResourceWriter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.23
      bool success = true;
      int64_t p_resource_id{};
      ::mojo::PendingReceiver<ServiceWorkerResourceWriter> p_writer{};
      ServiceWorkerStorageControl_CreateResourceWriter_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_resource_id = input_data_view.resource_id();
      if (success) {
        p_writer =
            input_data_view.TakeWriter<decltype(p_writer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateResourceWriter(        
        std::move(p_resource_id), 
        std::move(p_writer));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kCreateResourceMetadataWriter: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.24
      bool success = true;
      int64_t p_resource_id{};
      ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> p_writer{};
      ServiceWorkerStorageControl_CreateResourceMetadataWriter_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_resource_id = input_data_view.resource_id();
      if (success) {
        p_writer =
            input_data_view.TakeWriter<decltype(p_writer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateResourceMetadataWriter(        
        std::move(p_resource_id), 
        std::move(p_writer));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kStoreUncommittedResourceId: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kDoomUncommittedResources: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetUserData: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kStoreUserData: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kClearUserData: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetUserDataByKeyPrefix: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetUserKeysAndDataByKeyPrefix: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kClearUserDataByKeyPrefixes: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrations: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrationsByKeyPrefix: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kClearUserDataForAllRegistrationsByKeyPrefix: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kPerformStorageCleanup: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kApplyPolicyUpdates: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForTest: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForLiveVersionForTest: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetPurgeableResourceIdsForTest: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kGetUncommittedResourceIdsForTest: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kSetPurgingCompleteCallbackForTest: {
      break;
    }
  }
  return false;
}

// static
bool ServiceWorkerStorageControlStubDispatch::AcceptWithResponder(
    ServiceWorkerStorageControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerStorageControl>(message->header()->name)) {
    case messages::ServiceWorkerStorageControl::kDisable: {
      internal::ServiceWorkerStorageControl_Disable_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_Disable_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.0
      bool success = true;
      ServiceWorkerStorageControl_Disable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 0, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_Disable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Disable(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kDelete: {
      internal::ServiceWorkerStorageControl_Delete_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_Delete_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.1
      bool success = true;
      ServiceWorkerStorageControl_Delete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 1, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_Delete_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kRecover: {
      internal::ServiceWorkerStorageControl_Recover_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_Recover_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.2
      bool success = true;
      std::vector<ServiceWorkerLiveVersionInfoPtr> p_versions{};
      ServiceWorkerStorageControl_Recover_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVersions(&p_versions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 2, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_Recover_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Recover(        
        std::move(p_versions), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetRegisteredStorageKeys: {
      internal::ServiceWorkerStorageControl_GetRegisteredStorageKeys_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetRegisteredStorageKeys_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.3
      bool success = true;
      ServiceWorkerStorageControl_GetRegisteredStorageKeys_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 3, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetRegisteredStorageKeys_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegisteredStorageKeys(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kFindRegistrationForClientUrl: {
      internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.4
      bool success = true;
      ::GURL p_client_url{};
      ::blink::StorageKey p_key{};
      ServiceWorkerStorageControl_FindRegistrationForClientUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUrl(&p_client_url))
        success = false;
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 4, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_FindRegistrationForClientUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FindRegistrationForClientUrl(        
        std::move(p_client_url), 
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kFindRegistrationForScope: {
      internal::ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.5
      bool success = true;
      ::GURL p_scope{};
      ::blink::StorageKey p_key{};
      ServiceWorkerStorageControl_FindRegistrationForScope_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScope(&p_scope))
        success = false;
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 5, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_FindRegistrationForScope_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FindRegistrationForScope(        
        std::move(p_scope), 
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kFindRegistrationForId: {
      internal::ServiceWorkerStorageControl_FindRegistrationForId_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_FindRegistrationForId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.6
      bool success = true;
      int64_t p_registration_id{};
      std::optional<::blink::StorageKey> p_key{};
      ServiceWorkerStorageControl_FindRegistrationForId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 6, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_FindRegistrationForId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FindRegistrationForId(        
        std::move(p_registration_id), 
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetRegistrationsForStorageKey: {
      internal::ServiceWorkerStorageControl_GetRegistrationsForStorageKey_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetRegistrationsForStorageKey_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.7
      bool success = true;
      ::blink::StorageKey p_key{};
      ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 7, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRegistrationsForStorageKey(        
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetUsageForStorageKey: {
      internal::ServiceWorkerStorageControl_GetUsageForStorageKey_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUsageForStorageKey_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.8
      bool success = true;
      ::blink::StorageKey p_key{};
      ServiceWorkerStorageControl_GetUsageForStorageKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 8, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetUsageForStorageKey_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUsageForStorageKey(        
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetAllRegistrationsDeprecated: {
      internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.9
      bool success = true;
      ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 9, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllRegistrationsDeprecated(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetFakeRegistrationForClientUrl: {
      internal::ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.10
      bool success = true;
      ::GURL p_client_url{};
      ::blink::StorageKey p_key{};
      ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientUrl(&p_client_url))
        success = false;
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 10, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFakeRegistrationForClientUrl(        
        std::move(p_client_url), 
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kStoreRegistration: {
      internal::ServiceWorkerStorageControl_StoreRegistration_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_StoreRegistration_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.11
      bool success = true;
      ::storage::mojom::ServiceWorkerRegistrationDataPtr p_registration{};
      std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> p_resources{};
      ServiceWorkerStorageControl_StoreRegistration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegistration(&p_registration))
        success = false;
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 11, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_StoreRegistration_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StoreRegistration(        
        std::move(p_registration), 
        std::move(p_resources), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kDeleteRegistration: {
      internal::ServiceWorkerStorageControl_DeleteRegistration_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_DeleteRegistration_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.12
      bool success = true;
      int64_t p_registration_id{};
      ::blink::StorageKey p_key{};
      ServiceWorkerStorageControl_DeleteRegistration_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 12, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_DeleteRegistration_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteRegistration(        
        std::move(p_registration_id), 
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kUpdateToActiveState: {
      internal::ServiceWorkerStorageControl_UpdateToActiveState_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_UpdateToActiveState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.13
      bool success = true;
      int64_t p_registration_id{};
      ::blink::StorageKey p_key{};
      ServiceWorkerStorageControl_UpdateToActiveState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 13, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_UpdateToActiveState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateToActiveState(        
        std::move(p_registration_id), 
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kUpdateLastUpdateCheckTime: {
      internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.14
      bool success = true;
      int64_t p_registration_id{};
      ::blink::StorageKey p_key{};
      ::base::Time p_last_update_check_time{};
      ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadLastUpdateCheckTime(&p_last_update_check_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 14, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateLastUpdateCheckTime(        
        std::move(p_registration_id), 
        std::move(p_key), 
        std::move(p_last_update_check_time), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadEnabled: {
      internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.15
      bool success = true;
      int64_t p_registration_id{};
      ::blink::StorageKey p_key{};
      bool p_enable{};
      ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 15, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateNavigationPreloadEnabled(        
        std::move(p_registration_id), 
        std::move(p_key), 
        std::move(p_enable), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kUpdateNavigationPreloadHeader: {
      internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.16
      bool success = true;
      int64_t p_registration_id{};
      ::blink::StorageKey p_key{};
      std::string p_value{};
      ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 16, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateNavigationPreloadHeader(        
        std::move(p_registration_id), 
        std::move(p_key), 
        std::move(p_value), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kUpdateFetchHandlerType: {
      internal::ServiceWorkerStorageControl_UpdateFetchHandlerType_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_UpdateFetchHandlerType_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.17
      bool success = true;
      int64_t p_registration_id{};
      ::blink::StorageKey p_key{};
      ::blink::mojom::ServiceWorkerFetchHandlerType p_type{};
      ServiceWorkerStorageControl_UpdateFetchHandlerType_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 17, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_UpdateFetchHandlerType_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateFetchHandlerType(        
        std::move(p_registration_id), 
        std::move(p_key), 
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kUpdateResourceSha256Checksums: {
      internal::ServiceWorkerStorageControl_UpdateResourceSha256Checksums_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_UpdateResourceSha256Checksums_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.18
      bool success = true;
      int64_t p_registratation_id{};
      ::blink::StorageKey p_key{};
      base::flat_map<int64_t, std::string> p_updated_sha256_checksums{};
      ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registratation_id = input_data_view.registratation_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadUpdatedSha256Checksums(&p_updated_sha256_checksums))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 18, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateResourceSha256Checksums(        
        std::move(p_registratation_id), 
        std::move(p_key), 
        std::move(p_updated_sha256_checksums), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetNewRegistrationId: {
      internal::ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.19
      bool success = true;
      ServiceWorkerStorageControl_GetNewRegistrationId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 19, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetNewRegistrationId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNewRegistrationId(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetNewVersionId: {
      internal::ServiceWorkerStorageControl_GetNewVersionId_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetNewVersionId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.20
      bool success = true;
      ServiceWorkerStorageControl_GetNewVersionId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 20, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetNewVersionId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNewVersionId(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetNewResourceId: {
      internal::ServiceWorkerStorageControl_GetNewResourceId_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetNewResourceId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.21
      bool success = true;
      ServiceWorkerStorageControl_GetNewResourceId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 21, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetNewResourceId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNewResourceId(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kCreateResourceReader: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kCreateResourceWriter: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kCreateResourceMetadataWriter: {
      break;
    }
    case messages::ServiceWorkerStorageControl::kStoreUncommittedResourceId: {
      internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.25
      bool success = true;
      int64_t p_resource_id{};
      ServiceWorkerStorageControl_StoreUncommittedResourceId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_resource_id = input_data_view.resource_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 25, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_StoreUncommittedResourceId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StoreUncommittedResourceId(        
        std::move(p_resource_id), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kDoomUncommittedResources: {
      internal::ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.26
      bool success = true;
      std::vector<int64_t> p_resource_ids{};
      ServiceWorkerStorageControl_DoomUncommittedResources_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResourceIds(&p_resource_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 26, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_DoomUncommittedResources_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DoomUncommittedResources(        
        std::move(p_resource_ids), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetUserData: {
      internal::ServiceWorkerStorageControl_GetUserData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUserData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.27
      bool success = true;
      int64_t p_registration_id{};
      std::vector<std::string> p_keys{};
      ServiceWorkerStorageControl_GetUserData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKeys(&p_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 27, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetUserData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserData(        
        std::move(p_registration_id), 
        std::move(p_keys), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kStoreUserData: {
      internal::ServiceWorkerStorageControl_StoreUserData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_StoreUserData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.28
      bool success = true;
      int64_t p_registration_id{};
      ::blink::StorageKey p_key{};
      std::vector<ServiceWorkerUserDataPtr> p_user_data{};
      ServiceWorkerStorageControl_StoreUserData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadUserData(&p_user_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 28, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_StoreUserData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StoreUserData(        
        std::move(p_registration_id), 
        std::move(p_key), 
        std::move(p_user_data), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kClearUserData: {
      internal::ServiceWorkerStorageControl_ClearUserData_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_ClearUserData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.29
      bool success = true;
      int64_t p_registration_id{};
      std::vector<std::string> p_keys{};
      ServiceWorkerStorageControl_ClearUserData_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKeys(&p_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 29, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_ClearUserData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearUserData(        
        std::move(p_registration_id), 
        std::move(p_keys), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetUserDataByKeyPrefix: {
      internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.30
      bool success = true;
      int64_t p_registration_id{};
      std::string p_key_prefix{};
      ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKeyPrefix(&p_key_prefix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 30, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserDataByKeyPrefix(        
        std::move(p_registration_id), 
        std::move(p_key_prefix), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetUserKeysAndDataByKeyPrefix: {
      internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.31
      bool success = true;
      int64_t p_registration_id{};
      std::string p_key_prefix{};
      ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registration_id = input_data_view.registration_id();
      if (success && !input_data_view.ReadKeyPrefix(&p_key_prefix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 31, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserKeysAndDataByKeyPrefix(        
        std::move(p_registration_id), 
        std::move(p_key_prefix), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kClearUserDataByKeyPrefixes: {
      internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.32
      bool success = true;
      int64_t p_registratation_id{};
      std::vector<std::string> p_key_prefixes{};
      ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_registratation_id = input_data_view.registratation_id();
      if (success && !input_data_view.ReadKeyPrefixes(&p_key_prefixes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 32, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearUserDataByKeyPrefixes(        
        std::move(p_registratation_id), 
        std::move(p_key_prefixes), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrations: {
      internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.33
      bool success = true;
      std::string p_key{};
      ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 33, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserDataForAllRegistrations(        
        std::move(p_key), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetUserDataForAllRegistrationsByKeyPrefix: {
      internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.34
      bool success = true;
      std::string p_key_prefix{};
      ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyPrefix(&p_key_prefix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 34, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserDataForAllRegistrationsByKeyPrefix(        
        std::move(p_key_prefix), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kClearUserDataForAllRegistrationsByKeyPrefix: {
      internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.35
      bool success = true;
      std::string p_key_prefix{};
      ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyPrefix(&p_key_prefix))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 35, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearUserDataForAllRegistrationsByKeyPrefix(        
        std::move(p_key_prefix), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kPerformStorageCleanup: {
      internal::ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.36
      bool success = true;
      ServiceWorkerStorageControl_PerformStorageCleanup_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 36, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_PerformStorageCleanup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformStorageCleanup(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kApplyPolicyUpdates: {
      internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.37
      bool success = true;
      std::vector<::storage::mojom::StoragePolicyUpdatePtr> p_policy_updates{};
      ServiceWorkerStorageControl_ApplyPolicyUpdates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicyUpdates(&p_policy_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 37, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_ApplyPolicyUpdates_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyPolicyUpdates(        
        std::move(p_policy_updates), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForTest: {
      internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.38
      bool success = true;
      ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 38, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPurgingResourceIdsForTest(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetPurgingResourceIdsForLiveVersionForTest: {
      internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.39
      bool success = true;
      int64_t p_version_id{};
      ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_version_id = input_data_view.version_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 39, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPurgingResourceIdsForLiveVersionForTest(        
        std::move(p_version_id), std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetPurgeableResourceIdsForTest: {
      internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.40
      bool success = true;
      ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 40, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPurgeableResourceIdsForTest(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kGetUncommittedResourceIdsForTest: {
      internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.41
      bool success = true;
      ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 41, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUncommittedResourceIdsForTest(std::move(callback));
      return true;
    }
    case messages::ServiceWorkerStorageControl::kSetPurgingCompleteCallbackForTest: {
      internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data* params =
          reinterpret_cast<
              internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ServiceWorkerStorageControl.42
      bool success = true;
      ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStorageControl::Name_, 42, false);
        return false;
      }
      auto callback =
          ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPurgingCompleteCallbackForTest(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerStorageControlValidationInfo[] = {
    { &internal::ServiceWorkerStorageControl_Disable_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_Disable_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_Delete_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_Delete_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_Recover_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_Recover_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetRegisteredStorageKeys_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetRegisteredStorageKeys_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_FindRegistrationForClientUrl_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_FindRegistrationForScope_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_FindRegistrationForScope_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_FindRegistrationForId_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_FindRegistrationForId_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetRegistrationsForStorageKey_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetRegistrationsForStorageKey_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetUsageForStorageKey_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetUsageForStorageKey_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetAllRegistrationsDeprecated_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetFakeRegistrationForClientUrl_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_StoreRegistration_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_StoreRegistration_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_DeleteRegistration_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_DeleteRegistration_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_UpdateToActiveState_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_UpdateToActiveState_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_UpdateLastUpdateCheckTime_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_UpdateNavigationPreloadEnabled_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_UpdateNavigationPreloadHeader_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_UpdateFetchHandlerType_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_UpdateFetchHandlerType_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_UpdateResourceSha256Checksums_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_UpdateResourceSha256Checksums_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetNewRegistrationId_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetNewRegistrationId_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetNewVersionId_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetNewVersionId_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetNewResourceId_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetNewResourceId_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_CreateResourceReader_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerStorageControl_CreateResourceWriter_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerStorageControl_CreateResourceMetadataWriter_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_StoreUncommittedResourceId_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_DoomUncommittedResources_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_DoomUncommittedResources_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetUserData_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetUserData_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_StoreUserData_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_StoreUserData_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_ClearUserData_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_ClearUserData_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetUserDataByKeyPrefix_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetUserKeysAndDataByKeyPrefix_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_ClearUserDataByKeyPrefixes_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrations_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_ClearUserDataForAllRegistrationsByKeyPrefix_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_PerformStorageCleanup_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_PerformStorageCleanup_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_ApplyPolicyUpdates_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForTest_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetPurgingResourceIdsForLiveVersionForTest_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetPurgeableResourceIdsForTest_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_GetUncommittedResourceIdsForTest_ResponseParams_Data::Validate},
    { &internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_Params_Data::Validate,
     &internal::ServiceWorkerStorageControl_SetPurgingCompleteCallbackForTest_ResponseParams_Data::Validate},
};

bool ServiceWorkerStorageControlRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::storage::mojom::ServiceWorkerStorageControl::Name_,
    kServiceWorkerStorageControlValidationInfo);
}

bool ServiceWorkerStorageControlResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::storage::mojom::ServiceWorkerStorageControl::Name_,
    kServiceWorkerStorageControlValidationInfo);
}


}  // storage::mojom


namespace mojo {


// static
bool StructTraits<::storage::mojom::ServiceWorkerLiveVersionInfo::DataView, ::storage::mojom::ServiceWorkerLiveVersionInfoPtr>::Read(
    ::storage::mojom::ServiceWorkerLiveVersionInfo::DataView input,
    ::storage::mojom::ServiceWorkerLiveVersionInfoPtr* output) {
  bool success = true;
  ::storage::mojom::ServiceWorkerLiveVersionInfoPtr result(::storage::mojom::ServiceWorkerLiveVersionInfo::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadPurgeableResources(&result->purgeable_resources))
        success = false;
      if (success) {
        result->reference =
            input.TakeReference<decltype(result->reference)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::ServiceWorkerFindRegistrationResult::DataView, ::storage::mojom::ServiceWorkerFindRegistrationResultPtr>::Read(
    ::storage::mojom::ServiceWorkerFindRegistrationResult::DataView input,
    ::storage::mojom::ServiceWorkerFindRegistrationResultPtr* output) {
  bool success = true;
  ::storage::mojom::ServiceWorkerFindRegistrationResultPtr result(::storage::mojom::ServiceWorkerFindRegistrationResult::New());
  
      if (success) {
        result->version_reference =
            input.TakeVersionReference<decltype(result->version_reference)>();
      }
      if (success && !input.ReadRegistration(&result->registration))
        success = false;
      if (success && !input.ReadResources(&result->resources))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::ServiceWorkerUserData::DataView, ::storage::mojom::ServiceWorkerUserDataPtr>::Read(
    ::storage::mojom::ServiceWorkerUserData::DataView input,
    ::storage::mojom::ServiceWorkerUserDataPtr* output) {
  bool success = true;
  ::storage::mojom::ServiceWorkerUserDataPtr result(::storage::mojom::ServiceWorkerUserData::New());
  
      if (success)
        result->registration_id = input.registration_id();
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


ServiceWorkerLiveVersionRefAsyncWaiter::ServiceWorkerLiveVersionRefAsyncWaiter(
    ServiceWorkerLiveVersionRef* proxy) : proxy_(proxy) {}

ServiceWorkerLiveVersionRefAsyncWaiter::~ServiceWorkerLiveVersionRefAsyncWaiter() = default;





void ServiceWorkerResourceReaderInterceptorForTesting::ReadResponseHead(ReadResponseHeadCallback callback) {
  GetForwardingInterface()->ReadResponseHead(std::move(callback));
}
void ServiceWorkerResourceReaderInterceptorForTesting::PrepareReadData(int64_t size, PrepareReadDataCallback callback) {
  GetForwardingInterface()->PrepareReadData(
    std::move(size)
    , std::move(callback));
}
void ServiceWorkerResourceReaderInterceptorForTesting::ReadData(ReadDataCallback callback) {
  GetForwardingInterface()->ReadData(std::move(callback));
}
ServiceWorkerResourceReaderAsyncWaiter::ServiceWorkerResourceReaderAsyncWaiter(
    ServiceWorkerResourceReader* proxy) : proxy_(proxy) {}

ServiceWorkerResourceReaderAsyncWaiter::~ServiceWorkerResourceReaderAsyncWaiter() = default;


void ServiceWorkerResourceReaderAsyncWaiter::ReadResponseHead(
    int32_t* out_status, ::network::mojom::URLResponseHeadPtr* out_response_head, std::optional<::mojo_base::BigBuffer>* out_metadata) {
  base::RunLoop loop;
  proxy_->ReadResponseHead(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             ::network::mojom::URLResponseHeadPtr* out_response_head
,
             std::optional<::mojo_base::BigBuffer>* out_metadata
,
             int32_t status,
             ::network::mojom::URLResponseHeadPtr response_head,
             std::optional<::mojo_base::BigBuffer> metadata) {*out_status = std::move(status);*out_response_head = std::move(response_head);*out_metadata = std::move(metadata);
            loop->Quit();
          },
          &loop,
          out_status,
          out_response_head,
          out_metadata));
  loop.Run();
}



void ServiceWorkerResourceReaderAsyncWaiter::PrepareReadData(
    int64_t size, ::mojo::ScopedDataPipeConsumerHandle* out_pipe) {
  base::RunLoop loop;
  proxy_->PrepareReadData(
      std::move(size),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::ScopedDataPipeConsumerHandle* out_pipe
,
             ::mojo::ScopedDataPipeConsumerHandle pipe) {*out_pipe = std::move(pipe);
            loop->Quit();
          },
          &loop,
          out_pipe));
  loop.Run();
}

::mojo::ScopedDataPipeConsumerHandle ServiceWorkerResourceReaderAsyncWaiter::PrepareReadData(
    int64_t size) {
  ::mojo::ScopedDataPipeConsumerHandle async_wait_result;
  PrepareReadData(std::move(size),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerResourceReaderAsyncWaiter::ReadData(
    int32_t* out_status) {
  base::RunLoop loop;
  proxy_->ReadData(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             int32_t status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

int32_t ServiceWorkerResourceReaderAsyncWaiter::ReadData(
    ) {
  int32_t async_wait_result;
  ReadData(&async_wait_result);
  return async_wait_result;
}




void ServiceWorkerResourceWriterInterceptorForTesting::WriteResponseHead(::network::mojom::URLResponseHeadPtr response_head, WriteResponseHeadCallback callback) {
  GetForwardingInterface()->WriteResponseHead(
    std::move(response_head)
    , std::move(callback));
}
void ServiceWorkerResourceWriterInterceptorForTesting::WriteData(::mojo_base::BigBuffer data, WriteDataCallback callback) {
  GetForwardingInterface()->WriteData(
    std::move(data)
    , std::move(callback));
}
ServiceWorkerResourceWriterAsyncWaiter::ServiceWorkerResourceWriterAsyncWaiter(
    ServiceWorkerResourceWriter* proxy) : proxy_(proxy) {}

ServiceWorkerResourceWriterAsyncWaiter::~ServiceWorkerResourceWriterAsyncWaiter() = default;


void ServiceWorkerResourceWriterAsyncWaiter::WriteResponseHead(
    ::network::mojom::URLResponseHeadPtr response_head, int32_t* out_status) {
  base::RunLoop loop;
  proxy_->WriteResponseHead(
      std::move(response_head),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             int32_t status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

int32_t ServiceWorkerResourceWriterAsyncWaiter::WriteResponseHead(
    ::network::mojom::URLResponseHeadPtr response_head) {
  int32_t async_wait_result;
  WriteResponseHead(std::move(response_head),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerResourceWriterAsyncWaiter::WriteData(
    ::mojo_base::BigBuffer data, int32_t* out_status) {
  base::RunLoop loop;
  proxy_->WriteData(
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             int32_t status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

int32_t ServiceWorkerResourceWriterAsyncWaiter::WriteData(
    ::mojo_base::BigBuffer data) {
  int32_t async_wait_result;
  WriteData(std::move(data),&async_wait_result);
  return async_wait_result;
}




void ServiceWorkerResourceMetadataWriterInterceptorForTesting::WriteMetadata(::mojo_base::BigBuffer data, WriteMetadataCallback callback) {
  GetForwardingInterface()->WriteMetadata(
    std::move(data)
    , std::move(callback));
}
ServiceWorkerResourceMetadataWriterAsyncWaiter::ServiceWorkerResourceMetadataWriterAsyncWaiter(
    ServiceWorkerResourceMetadataWriter* proxy) : proxy_(proxy) {}

ServiceWorkerResourceMetadataWriterAsyncWaiter::~ServiceWorkerResourceMetadataWriterAsyncWaiter() = default;


void ServiceWorkerResourceMetadataWriterAsyncWaiter::WriteMetadata(
    ::mojo_base::BigBuffer data, int32_t* out_status) {
  base::RunLoop loop;
  proxy_->WriteMetadata(
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             int32_t status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

int32_t ServiceWorkerResourceMetadataWriterAsyncWaiter::WriteMetadata(
    ::mojo_base::BigBuffer data) {
  int32_t async_wait_result;
  WriteMetadata(std::move(data),&async_wait_result);
  return async_wait_result;
}




void ServiceWorkerStorageControlInterceptorForTesting::Disable(DisableCallback callback) {
  GetForwardingInterface()->Disable(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::Delete(DeleteCallback callback) {
  GetForwardingInterface()->Delete(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::Recover(std::vector<ServiceWorkerLiveVersionInfoPtr> versions, RecoverCallback callback) {
  GetForwardingInterface()->Recover(
    std::move(versions)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetRegisteredStorageKeys(GetRegisteredStorageKeysCallback callback) {
  GetForwardingInterface()->GetRegisteredStorageKeys(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::FindRegistrationForClientUrl(const ::GURL& client_url, const ::blink::StorageKey& key, FindRegistrationForClientUrlCallback callback) {
  GetForwardingInterface()->FindRegistrationForClientUrl(
    std::move(client_url)
    , 
    std::move(key)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::FindRegistrationForScope(const ::GURL& scope, const ::blink::StorageKey& key, FindRegistrationForScopeCallback callback) {
  GetForwardingInterface()->FindRegistrationForScope(
    std::move(scope)
    , 
    std::move(key)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::FindRegistrationForId(int64_t registration_id, const std::optional<::blink::StorageKey>& key, FindRegistrationForIdCallback callback) {
  GetForwardingInterface()->FindRegistrationForId(
    std::move(registration_id)
    , 
    std::move(key)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetRegistrationsForStorageKey(const ::blink::StorageKey& key, GetRegistrationsForStorageKeyCallback callback) {
  GetForwardingInterface()->GetRegistrationsForStorageKey(
    std::move(key)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUsageForStorageKey(const ::blink::StorageKey& key, GetUsageForStorageKeyCallback callback) {
  GetForwardingInterface()->GetUsageForStorageKey(
    std::move(key)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetAllRegistrationsDeprecated(GetAllRegistrationsDeprecatedCallback callback) {
  GetForwardingInterface()->GetAllRegistrationsDeprecated(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetFakeRegistrationForClientUrl(const ::GURL& client_url, const ::blink::StorageKey& key, GetFakeRegistrationForClientUrlCallback callback) {
  GetForwardingInterface()->GetFakeRegistrationForClientUrl(
    std::move(client_url)
    , 
    std::move(key)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::StoreRegistration(::storage::mojom::ServiceWorkerRegistrationDataPtr registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources, StoreRegistrationCallback callback) {
  GetForwardingInterface()->StoreRegistration(
    std::move(registration)
    , 
    std::move(resources)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::DeleteRegistration(int64_t registration_id, const ::blink::StorageKey& key, DeleteRegistrationCallback callback) {
  GetForwardingInterface()->DeleteRegistration(
    std::move(registration_id)
    , 
    std::move(key)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::UpdateToActiveState(int64_t registration_id, const ::blink::StorageKey& key, UpdateToActiveStateCallback callback) {
  GetForwardingInterface()->UpdateToActiveState(
    std::move(registration_id)
    , 
    std::move(key)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::UpdateLastUpdateCheckTime(int64_t registration_id, const ::blink::StorageKey& key, ::base::Time last_update_check_time, UpdateLastUpdateCheckTimeCallback callback) {
  GetForwardingInterface()->UpdateLastUpdateCheckTime(
    std::move(registration_id)
    , 
    std::move(key)
    , 
    std::move(last_update_check_time)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::UpdateNavigationPreloadEnabled(int64_t registration_id, const ::blink::StorageKey& key, bool enable, UpdateNavigationPreloadEnabledCallback callback) {
  GetForwardingInterface()->UpdateNavigationPreloadEnabled(
    std::move(registration_id)
    , 
    std::move(key)
    , 
    std::move(enable)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::UpdateNavigationPreloadHeader(int64_t registration_id, const ::blink::StorageKey& key, const std::string& value, UpdateNavigationPreloadHeaderCallback callback) {
  GetForwardingInterface()->UpdateNavigationPreloadHeader(
    std::move(registration_id)
    , 
    std::move(key)
    , 
    std::move(value)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::UpdateFetchHandlerType(int64_t registration_id, const ::blink::StorageKey& key, ::blink::mojom::ServiceWorkerFetchHandlerType type, UpdateFetchHandlerTypeCallback callback) {
  GetForwardingInterface()->UpdateFetchHandlerType(
    std::move(registration_id)
    , 
    std::move(key)
    , 
    std::move(type)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::UpdateResourceSha256Checksums(int64_t registratation_id, const ::blink::StorageKey& key, const base::flat_map<int64_t, std::string>& updated_sha256_checksums, UpdateResourceSha256ChecksumsCallback callback) {
  GetForwardingInterface()->UpdateResourceSha256Checksums(
    std::move(registratation_id)
    , 
    std::move(key)
    , 
    std::move(updated_sha256_checksums)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetNewRegistrationId(GetNewRegistrationIdCallback callback) {
  GetForwardingInterface()->GetNewRegistrationId(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetNewVersionId(GetNewVersionIdCallback callback) {
  GetForwardingInterface()->GetNewVersionId(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetNewResourceId(GetNewResourceIdCallback callback) {
  GetForwardingInterface()->GetNewResourceId(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::CreateResourceReader(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceReader> reader) {
  GetForwardingInterface()->CreateResourceReader(
    std::move(resource_id)
    , 
    std::move(reader)
    );
}
void ServiceWorkerStorageControlInterceptorForTesting::CreateResourceWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceWriter> writer) {
  GetForwardingInterface()->CreateResourceWriter(
    std::move(resource_id)
    , 
    std::move(writer)
    );
}
void ServiceWorkerStorageControlInterceptorForTesting::CreateResourceMetadataWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> writer) {
  GetForwardingInterface()->CreateResourceMetadataWriter(
    std::move(resource_id)
    , 
    std::move(writer)
    );
}
void ServiceWorkerStorageControlInterceptorForTesting::StoreUncommittedResourceId(int64_t resource_id, StoreUncommittedResourceIdCallback callback) {
  GetForwardingInterface()->StoreUncommittedResourceId(
    std::move(resource_id)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::DoomUncommittedResources(const std::vector<int64_t>& resource_ids, DoomUncommittedResourcesCallback callback) {
  GetForwardingInterface()->DoomUncommittedResources(
    std::move(resource_ids)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUserData(int64_t registration_id, const std::vector<std::string>& keys, GetUserDataCallback callback) {
  GetForwardingInterface()->GetUserData(
    std::move(registration_id)
    , 
    std::move(keys)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::StoreUserData(int64_t registration_id, const ::blink::StorageKey& key, std::vector<ServiceWorkerUserDataPtr> user_data, StoreUserDataCallback callback) {
  GetForwardingInterface()->StoreUserData(
    std::move(registration_id)
    , 
    std::move(key)
    , 
    std::move(user_data)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::ClearUserData(int64_t registration_id, const std::vector<std::string>& keys, ClearUserDataCallback callback) {
  GetForwardingInterface()->ClearUserData(
    std::move(registration_id)
    , 
    std::move(keys)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUserDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserDataByKeyPrefixCallback callback) {
  GetForwardingInterface()->GetUserDataByKeyPrefix(
    std::move(registration_id)
    , 
    std::move(key_prefix)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUserKeysAndDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserKeysAndDataByKeyPrefixCallback callback) {
  GetForwardingInterface()->GetUserKeysAndDataByKeyPrefix(
    std::move(registration_id)
    , 
    std::move(key_prefix)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::ClearUserDataByKeyPrefixes(int64_t registratation_id, const std::vector<std::string>& key_prefixes, ClearUserDataByKeyPrefixesCallback callback) {
  GetForwardingInterface()->ClearUserDataByKeyPrefixes(
    std::move(registratation_id)
    , 
    std::move(key_prefixes)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUserDataForAllRegistrations(const std::string& key, GetUserDataForAllRegistrationsCallback callback) {
  GetForwardingInterface()->GetUserDataForAllRegistrations(
    std::move(key)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, GetUserDataForAllRegistrationsByKeyPrefixCallback callback) {
  GetForwardingInterface()->GetUserDataForAllRegistrationsByKeyPrefix(
    std::move(key_prefix)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::ClearUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, ClearUserDataForAllRegistrationsByKeyPrefixCallback callback) {
  GetForwardingInterface()->ClearUserDataForAllRegistrationsByKeyPrefix(
    std::move(key_prefix)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::PerformStorageCleanup(PerformStorageCleanupCallback callback) {
  GetForwardingInterface()->PerformStorageCleanup(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates, ApplyPolicyUpdatesCallback callback) {
  GetForwardingInterface()->ApplyPolicyUpdates(
    std::move(policy_updates)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetPurgingResourceIdsForTest(GetPurgingResourceIdsForTestCallback callback) {
  GetForwardingInterface()->GetPurgingResourceIdsForTest(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetPurgingResourceIdsForLiveVersionForTest(int64_t version_id, GetPurgingResourceIdsForLiveVersionForTestCallback callback) {
  GetForwardingInterface()->GetPurgingResourceIdsForLiveVersionForTest(
    std::move(version_id)
    , std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetPurgeableResourceIdsForTest(GetPurgeableResourceIdsForTestCallback callback) {
  GetForwardingInterface()->GetPurgeableResourceIdsForTest(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::GetUncommittedResourceIdsForTest(GetUncommittedResourceIdsForTestCallback callback) {
  GetForwardingInterface()->GetUncommittedResourceIdsForTest(std::move(callback));
}
void ServiceWorkerStorageControlInterceptorForTesting::SetPurgingCompleteCallbackForTest(SetPurgingCompleteCallbackForTestCallback callback) {
  GetForwardingInterface()->SetPurgingCompleteCallbackForTest(std::move(callback));
}
ServiceWorkerStorageControlAsyncWaiter::ServiceWorkerStorageControlAsyncWaiter(
    ServiceWorkerStorageControl* proxy) : proxy_(proxy) {}

ServiceWorkerStorageControlAsyncWaiter::~ServiceWorkerStorageControlAsyncWaiter() = default;


void ServiceWorkerStorageControlAsyncWaiter::Disable(
    ) {
  base::RunLoop loop;
  proxy_->Disable(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::Delete(
    ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->Delete(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::Delete(
    ) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  Delete(&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::Recover(
    std::vector<ServiceWorkerLiveVersionInfoPtr> versions) {
  base::RunLoop loop;
  proxy_->Recover(
      std::move(versions),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetRegisteredStorageKeys(
    std::vector<::blink::StorageKey>* out_keys) {
  base::RunLoop loop;
  proxy_->GetRegisteredStorageKeys(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::blink::StorageKey>* out_keys
,
             const std::vector<::blink::StorageKey>& keys) {*out_keys = std::move(keys);
            loop->Quit();
          },
          &loop,
          out_keys));
  loop.Run();
}

std::vector<::blink::StorageKey> ServiceWorkerStorageControlAsyncWaiter::GetRegisteredStorageKeys(
    ) {
  std::vector<::blink::StorageKey> async_wait_result;
  GetRegisteredStorageKeys(&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::FindRegistrationForClientUrl(
    const ::GURL& client_url, const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result, std::optional<std::vector<::GURL>>* out_scopes) {
  base::RunLoop loop;
  proxy_->FindRegistrationForClientUrl(
      std::move(client_url),
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ServiceWorkerFindRegistrationResultPtr* out_result
,
             std::optional<std::vector<::GURL>>* out_scopes
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             ServiceWorkerFindRegistrationResultPtr result,
             const std::optional<std::vector<::GURL>>& scopes) {*out_status = std::move(status);*out_result = std::move(result);*out_scopes = std::move(scopes);
            loop->Quit();
          },
          &loop,
          out_status,
          out_result,
          out_scopes));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::FindRegistrationForScope(
    const ::GURL& scope, const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->FindRegistrationForScope(
      std::move(scope),
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ServiceWorkerFindRegistrationResultPtr* out_result
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             ServiceWorkerFindRegistrationResultPtr result) {*out_status = std::move(status);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_status,
          out_result));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::FindRegistrationForId(
    int64_t registration_id, const std::optional<::blink::StorageKey>& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->FindRegistrationForId(
      std::move(registration_id),
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ServiceWorkerFindRegistrationResultPtr* out_result
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             ServiceWorkerFindRegistrationResultPtr result) {*out_status = std::move(status);*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_status,
          out_result));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetRegistrationsForStorageKey(
    const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<ServiceWorkerFindRegistrationResultPtr>* out_registrations) {
  base::RunLoop loop;
  proxy_->GetRegistrationsForStorageKey(
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<ServiceWorkerFindRegistrationResultPtr>* out_registrations
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             std::vector<ServiceWorkerFindRegistrationResultPtr> registrations) {*out_status = std::move(status);*out_registrations = std::move(registrations);
            loop->Quit();
          },
          &loop,
          out_status,
          out_registrations));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetUsageForStorageKey(
    const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, int64_t* out_usage) {
  base::RunLoop loop;
  proxy_->GetUsageForStorageKey(
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             int64_t* out_usage
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             int64_t usage) {*out_status = std::move(status);*out_usage = std::move(usage);
            loop->Quit();
          },
          &loop,
          out_status,
          out_usage));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetAllRegistrationsDeprecated(
    ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr>* out_registrations) {
  base::RunLoop loop;
  proxy_->GetAllRegistrationsDeprecated(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr>* out_registrations
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr> registrations) {*out_status = std::move(status);*out_registrations = std::move(registrations);
            loop->Quit();
          },
          &loop,
          out_status,
          out_registrations));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetFakeRegistrationForClientUrl(
    const ::GURL& client_url, const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result, std::optional<std::vector<::GURL>>* out_scopes) {
  base::RunLoop loop;
  proxy_->GetFakeRegistrationForClientUrl(
      std::move(client_url),
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ServiceWorkerFindRegistrationResultPtr* out_result
,
             std::optional<std::vector<::GURL>>* out_scopes
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             ServiceWorkerFindRegistrationResultPtr result,
             const std::optional<std::vector<::GURL>>& scopes) {*out_status = std::move(status);*out_result = std::move(result);*out_scopes = std::move(scopes);
            loop->Quit();
          },
          &loop,
          out_status,
          out_result,
          out_scopes));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::StoreRegistration(
    ::storage::mojom::ServiceWorkerRegistrationDataPtr registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, uint64_t* out_deleted_resources_size) {
  base::RunLoop loop;
  proxy_->StoreRegistration(
      std::move(registration),
      std::move(resources),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             uint64_t* out_deleted_resources_size
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             uint64_t deleted_resources_size) {*out_status = std::move(status);*out_deleted_resources_size = std::move(deleted_resources_size);
            loop->Quit();
          },
          &loop,
          out_status,
          out_deleted_resources_size));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::DeleteRegistration(
    int64_t registration_id, const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, uint64_t* out_deleted_resources_size, ServiceWorkerStorageStorageKeyState* out_storage_key_state) {
  base::RunLoop loop;
  proxy_->DeleteRegistration(
      std::move(registration_id),
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             uint64_t* out_deleted_resources_size
,
             ServiceWorkerStorageStorageKeyState* out_storage_key_state
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             uint64_t deleted_resources_size,
             ServiceWorkerStorageStorageKeyState storage_key_state) {*out_status = std::move(status);*out_deleted_resources_size = std::move(deleted_resources_size);*out_storage_key_state = std::move(storage_key_state);
            loop->Quit();
          },
          &loop,
          out_status,
          out_deleted_resources_size,
          out_storage_key_state));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::UpdateToActiveState(
    int64_t registration_id, const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->UpdateToActiveState(
      std::move(registration_id),
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::UpdateToActiveState(
    int64_t registration_id, const ::blink::StorageKey& key) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  UpdateToActiveState(std::move(registration_id),std::move(key),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::UpdateLastUpdateCheckTime(
    int64_t registration_id, const ::blink::StorageKey& key, ::base::Time last_update_check_time, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->UpdateLastUpdateCheckTime(
      std::move(registration_id),
      std::move(key),
      std::move(last_update_check_time),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::UpdateLastUpdateCheckTime(
    int64_t registration_id, const ::blink::StorageKey& key, ::base::Time last_update_check_time) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  UpdateLastUpdateCheckTime(std::move(registration_id),std::move(key),std::move(last_update_check_time),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::UpdateNavigationPreloadEnabled(
    int64_t registration_id, const ::blink::StorageKey& key, bool enable, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->UpdateNavigationPreloadEnabled(
      std::move(registration_id),
      std::move(key),
      std::move(enable),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::UpdateNavigationPreloadEnabled(
    int64_t registration_id, const ::blink::StorageKey& key, bool enable) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  UpdateNavigationPreloadEnabled(std::move(registration_id),std::move(key),std::move(enable),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::UpdateNavigationPreloadHeader(
    int64_t registration_id, const ::blink::StorageKey& key, const std::string& value, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->UpdateNavigationPreloadHeader(
      std::move(registration_id),
      std::move(key),
      std::move(value),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::UpdateNavigationPreloadHeader(
    int64_t registration_id, const ::blink::StorageKey& key, const std::string& value) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  UpdateNavigationPreloadHeader(std::move(registration_id),std::move(key),std::move(value),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::UpdateFetchHandlerType(
    int64_t registration_id, const ::blink::StorageKey& key, ::blink::mojom::ServiceWorkerFetchHandlerType type, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->UpdateFetchHandlerType(
      std::move(registration_id),
      std::move(key),
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::UpdateFetchHandlerType(
    int64_t registration_id, const ::blink::StorageKey& key, ::blink::mojom::ServiceWorkerFetchHandlerType type) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  UpdateFetchHandlerType(std::move(registration_id),std::move(key),std::move(type),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::UpdateResourceSha256Checksums(
    int64_t registratation_id, const ::blink::StorageKey& key, const base::flat_map<int64_t, std::string>& updated_sha256_checksums, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->UpdateResourceSha256Checksums(
      std::move(registratation_id),
      std::move(key),
      std::move(updated_sha256_checksums),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::UpdateResourceSha256Checksums(
    int64_t registratation_id, const ::blink::StorageKey& key, const base::flat_map<int64_t, std::string>& updated_sha256_checksums) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  UpdateResourceSha256Checksums(std::move(registratation_id),std::move(key),std::move(updated_sha256_checksums),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::GetNewRegistrationId(
    int64_t* out_registration_id) {
  base::RunLoop loop;
  proxy_->GetNewRegistrationId(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_registration_id
,
             int64_t registration_id) {*out_registration_id = std::move(registration_id);
            loop->Quit();
          },
          &loop,
          out_registration_id));
  loop.Run();
}

int64_t ServiceWorkerStorageControlAsyncWaiter::GetNewRegistrationId(
    ) {
  int64_t async_wait_result;
  GetNewRegistrationId(&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::GetNewVersionId(
    int64_t* out_version_id, ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>* out_version_reference) {
  base::RunLoop loop;
  proxy_->GetNewVersionId(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_version_id
,
             ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>* out_version_reference
,
             int64_t version_id,
             ::mojo::PendingRemote<ServiceWorkerLiveVersionRef> version_reference) {*out_version_id = std::move(version_id);*out_version_reference = std::move(version_reference);
            loop->Quit();
          },
          &loop,
          out_version_id,
          out_version_reference));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetNewResourceId(
    int64_t* out_resource_id) {
  base::RunLoop loop;
  proxy_->GetNewResourceId(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_resource_id
,
             int64_t resource_id) {*out_resource_id = std::move(resource_id);
            loop->Quit();
          },
          &loop,
          out_resource_id));
  loop.Run();
}

int64_t ServiceWorkerStorageControlAsyncWaiter::GetNewResourceId(
    ) {
  int64_t async_wait_result;
  GetNewResourceId(&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::StoreUncommittedResourceId(
    int64_t resource_id, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->StoreUncommittedResourceId(
      std::move(resource_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::StoreUncommittedResourceId(
    int64_t resource_id) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  StoreUncommittedResourceId(std::move(resource_id),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::DoomUncommittedResources(
    const std::vector<int64_t>& resource_ids, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->DoomUncommittedResources(
      std::move(resource_ids),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::DoomUncommittedResources(
    const std::vector<int64_t>& resource_ids) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  DoomUncommittedResources(std::move(resource_ids),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::GetUserData(
    int64_t registration_id, const std::vector<std::string>& keys, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<std::string>* out_values) {
  base::RunLoop loop;
  proxy_->GetUserData(
      std::move(registration_id),
      std::move(keys),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<std::string>* out_values
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<std::string>& values) {*out_status = std::move(status);*out_values = std::move(values);
            loop->Quit();
          },
          &loop,
          out_status,
          out_values));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::StoreUserData(
    int64_t registration_id, const ::blink::StorageKey& key, std::vector<ServiceWorkerUserDataPtr> user_data, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->StoreUserData(
      std::move(registration_id),
      std::move(key),
      std::move(user_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::StoreUserData(
    int64_t registration_id, const ::blink::StorageKey& key, std::vector<ServiceWorkerUserDataPtr> user_data) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  StoreUserData(std::move(registration_id),std::move(key),std::move(user_data),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::ClearUserData(
    int64_t registration_id, const std::vector<std::string>& keys, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->ClearUserData(
      std::move(registration_id),
      std::move(keys),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::ClearUserData(
    int64_t registration_id, const std::vector<std::string>& keys) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  ClearUserData(std::move(registration_id),std::move(keys),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::GetUserDataByKeyPrefix(
    int64_t registration_id, const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<std::string>* out_values) {
  base::RunLoop loop;
  proxy_->GetUserDataByKeyPrefix(
      std::move(registration_id),
      std::move(key_prefix),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<std::string>* out_values
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<std::string>& values) {*out_status = std::move(status);*out_values = std::move(values);
            loop->Quit();
          },
          &loop,
          out_status,
          out_values));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetUserKeysAndDataByKeyPrefix(
    int64_t registration_id, const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, base::flat_map<std::string, std::string>* out_user_data) {
  base::RunLoop loop;
  proxy_->GetUserKeysAndDataByKeyPrefix(
      std::move(registration_id),
      std::move(key_prefix),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             base::flat_map<std::string, std::string>* out_user_data
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const base::flat_map<std::string, std::string>& user_data) {*out_status = std::move(status);*out_user_data = std::move(user_data);
            loop->Quit();
          },
          &loop,
          out_status,
          out_user_data));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::ClearUserDataByKeyPrefixes(
    int64_t registratation_id, const std::vector<std::string>& key_prefixes, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->ClearUserDataByKeyPrefixes(
      std::move(registratation_id),
      std::move(key_prefixes),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::ClearUserDataByKeyPrefixes(
    int64_t registratation_id, const std::vector<std::string>& key_prefixes) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  ClearUserDataByKeyPrefixes(std::move(registratation_id),std::move(key_prefixes),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::GetUserDataForAllRegistrations(
    const std::string& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<ServiceWorkerUserDataPtr>* out_values) {
  base::RunLoop loop;
  proxy_->GetUserDataForAllRegistrations(
      std::move(key),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<ServiceWorkerUserDataPtr>* out_values
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             std::vector<ServiceWorkerUserDataPtr> values) {*out_status = std::move(status);*out_values = std::move(values);
            loop->Quit();
          },
          &loop,
          out_status,
          out_values));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetUserDataForAllRegistrationsByKeyPrefix(
    const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<ServiceWorkerUserDataPtr>* out_values) {
  base::RunLoop loop;
  proxy_->GetUserDataForAllRegistrationsByKeyPrefix(
      std::move(key_prefix),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<ServiceWorkerUserDataPtr>* out_values
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             std::vector<ServiceWorkerUserDataPtr> values) {*out_status = std::move(status);*out_values = std::move(values);
            loop->Quit();
          },
          &loop,
          out_status,
          out_values));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::ClearUserDataForAllRegistrationsByKeyPrefix(
    const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->ClearUserDataForAllRegistrationsByKeyPrefix(
      std::move(key_prefix),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::ClearUserDataForAllRegistrationsByKeyPrefix(
    const std::string& key_prefix) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  ClearUserDataForAllRegistrationsByKeyPrefix(std::move(key_prefix),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::PerformStorageCleanup(
    ) {
  base::RunLoop loop;
  proxy_->PerformStorageCleanup(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status) {
  base::RunLoop loop;
  proxy_->ApplyPolicyUpdates(
      std::move(policy_updates),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::storage::mojom::ServiceWorkerDatabaseStatus ServiceWorkerStorageControlAsyncWaiter::ApplyPolicyUpdates(
    std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) {
  ::storage::mojom::ServiceWorkerDatabaseStatus async_wait_result;
  ApplyPolicyUpdates(std::move(policy_updates),&async_wait_result);
  return async_wait_result;
}

void ServiceWorkerStorageControlAsyncWaiter::GetPurgingResourceIdsForTest(
    ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids) {
  base::RunLoop loop;
  proxy_->GetPurgingResourceIdsForTest(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<int64_t>* out_resource_ids
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<int64_t>& resource_ids) {*out_status = std::move(status);*out_resource_ids = std::move(resource_ids);
            loop->Quit();
          },
          &loop,
          out_status,
          out_resource_ids));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetPurgingResourceIdsForLiveVersionForTest(
    int64_t version_id, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids) {
  base::RunLoop loop;
  proxy_->GetPurgingResourceIdsForLiveVersionForTest(
      std::move(version_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<int64_t>* out_resource_ids
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<int64_t>& resource_ids) {*out_status = std::move(status);*out_resource_ids = std::move(resource_ids);
            loop->Quit();
          },
          &loop,
          out_status,
          out_resource_ids));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetPurgeableResourceIdsForTest(
    ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids) {
  base::RunLoop loop;
  proxy_->GetPurgeableResourceIdsForTest(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<int64_t>* out_resource_ids
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<int64_t>& resource_ids) {*out_status = std::move(status);*out_resource_ids = std::move(resource_ids);
            loop->Quit();
          },
          &loop,
          out_status,
          out_resource_ids));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::GetUncommittedResourceIdsForTest(
    ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids) {
  base::RunLoop loop;
  proxy_->GetUncommittedResourceIdsForTest(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::storage::mojom::ServiceWorkerDatabaseStatus* out_status
,
             std::vector<int64_t>* out_resource_ids
,
             ::storage::mojom::ServiceWorkerDatabaseStatus status,
             const std::vector<int64_t>& resource_ids) {*out_status = std::move(status);*out_resource_ids = std::move(resource_ids);
            loop->Quit();
          },
          &loop,
          out_status,
          out_resource_ids));
  loop.Run();
}



void ServiceWorkerStorageControlAsyncWaiter::SetPurgingCompleteCallbackForTest(
    ) {
  base::RunLoop loop;
  proxy_->SetPurgingCompleteCallbackForTest(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif