// components/services/storage/public/mojom/service_worker_storage_control.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_TEST_UTILS_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_TEST_UTILS_H_

#include "components/services/storage/public/mojom/service_worker_storage_control.mojom.h"


namespace storage::mojom {


class  ServiceWorkerLiveVersionRefInterceptorForTesting : public ServiceWorkerLiveVersionRef {
  virtual ServiceWorkerLiveVersionRef* GetForwardingInterface() = 0;
};
class  ServiceWorkerLiveVersionRefAsyncWaiter {
 public:
  explicit ServiceWorkerLiveVersionRefAsyncWaiter(ServiceWorkerLiveVersionRef* proxy);

  ServiceWorkerLiveVersionRefAsyncWaiter(const ServiceWorkerLiveVersionRefAsyncWaiter&) = delete;
  ServiceWorkerLiveVersionRefAsyncWaiter& operator=(const ServiceWorkerLiveVersionRefAsyncWaiter&) = delete;

  ~ServiceWorkerLiveVersionRefAsyncWaiter();

 private:
  ServiceWorkerLiveVersionRef* const proxy_;
};


class  ServiceWorkerResourceReaderInterceptorForTesting : public ServiceWorkerResourceReader {
  virtual ServiceWorkerResourceReader* GetForwardingInterface() = 0;
  void ReadResponseHead(ReadResponseHeadCallback callback) override;
  void PrepareReadData(int64_t size, PrepareReadDataCallback callback) override;
  void ReadData(ReadDataCallback callback) override;
};
class  ServiceWorkerResourceReaderAsyncWaiter {
 public:
  explicit ServiceWorkerResourceReaderAsyncWaiter(ServiceWorkerResourceReader* proxy);

  ServiceWorkerResourceReaderAsyncWaiter(const ServiceWorkerResourceReaderAsyncWaiter&) = delete;
  ServiceWorkerResourceReaderAsyncWaiter& operator=(const ServiceWorkerResourceReaderAsyncWaiter&) = delete;

  ~ServiceWorkerResourceReaderAsyncWaiter();
  void ReadResponseHead(
      int32_t* out_status, ::network::mojom::URLResponseHeadPtr* out_response_head, std::optional<::mojo_base::BigBuffer>* out_metadata);
  
  void PrepareReadData(
      int64_t size, ::mojo::ScopedDataPipeConsumerHandle* out_pipe);
  ::mojo::ScopedDataPipeConsumerHandle PrepareReadData(int64_t size);
  void ReadData(
      int32_t* out_status);
  int32_t ReadData();

 private:
  ServiceWorkerResourceReader* const proxy_;
};


class  ServiceWorkerResourceWriterInterceptorForTesting : public ServiceWorkerResourceWriter {
  virtual ServiceWorkerResourceWriter* GetForwardingInterface() = 0;
  void WriteResponseHead(::network::mojom::URLResponseHeadPtr response_head, WriteResponseHeadCallback callback) override;
  void WriteData(::mojo_base::BigBuffer data, WriteDataCallback callback) override;
};
class  ServiceWorkerResourceWriterAsyncWaiter {
 public:
  explicit ServiceWorkerResourceWriterAsyncWaiter(ServiceWorkerResourceWriter* proxy);

  ServiceWorkerResourceWriterAsyncWaiter(const ServiceWorkerResourceWriterAsyncWaiter&) = delete;
  ServiceWorkerResourceWriterAsyncWaiter& operator=(const ServiceWorkerResourceWriterAsyncWaiter&) = delete;

  ~ServiceWorkerResourceWriterAsyncWaiter();
  void WriteResponseHead(
      ::network::mojom::URLResponseHeadPtr response_head, int32_t* out_status);
  int32_t WriteResponseHead(::network::mojom::URLResponseHeadPtr response_head);
  void WriteData(
      ::mojo_base::BigBuffer data, int32_t* out_status);
  int32_t WriteData(::mojo_base::BigBuffer data);

 private:
  ServiceWorkerResourceWriter* const proxy_;
};


class  ServiceWorkerResourceMetadataWriterInterceptorForTesting : public ServiceWorkerResourceMetadataWriter {
  virtual ServiceWorkerResourceMetadataWriter* GetForwardingInterface() = 0;
  void WriteMetadata(::mojo_base::BigBuffer data, WriteMetadataCallback callback) override;
};
class  ServiceWorkerResourceMetadataWriterAsyncWaiter {
 public:
  explicit ServiceWorkerResourceMetadataWriterAsyncWaiter(ServiceWorkerResourceMetadataWriter* proxy);

  ServiceWorkerResourceMetadataWriterAsyncWaiter(const ServiceWorkerResourceMetadataWriterAsyncWaiter&) = delete;
  ServiceWorkerResourceMetadataWriterAsyncWaiter& operator=(const ServiceWorkerResourceMetadataWriterAsyncWaiter&) = delete;

  ~ServiceWorkerResourceMetadataWriterAsyncWaiter();
  void WriteMetadata(
      ::mojo_base::BigBuffer data, int32_t* out_status);
  int32_t WriteMetadata(::mojo_base::BigBuffer data);

 private:
  ServiceWorkerResourceMetadataWriter* const proxy_;
};


class  ServiceWorkerStorageControlInterceptorForTesting : public ServiceWorkerStorageControl {
  virtual ServiceWorkerStorageControl* GetForwardingInterface() = 0;
  void Disable(DisableCallback callback) override;
  void Delete(DeleteCallback callback) override;
  void Recover(std::vector<ServiceWorkerLiveVersionInfoPtr> versions, RecoverCallback callback) override;
  void GetRegisteredStorageKeys(GetRegisteredStorageKeysCallback callback) override;
  void FindRegistrationForClientUrl(const ::GURL& client_url, const ::blink::StorageKey& key, FindRegistrationForClientUrlCallback callback) override;
  void FindRegistrationForScope(const ::GURL& scope, const ::blink::StorageKey& key, FindRegistrationForScopeCallback callback) override;
  void FindRegistrationForId(int64_t registration_id, const std::optional<::blink::StorageKey>& key, FindRegistrationForIdCallback callback) override;
  void GetRegistrationsForStorageKey(const ::blink::StorageKey& key, GetRegistrationsForStorageKeyCallback callback) override;
  void GetUsageForStorageKey(const ::blink::StorageKey& key, GetUsageForStorageKeyCallback callback) override;
  void GetAllRegistrationsDeprecated(GetAllRegistrationsDeprecatedCallback callback) override;
  void GetFakeRegistrationForClientUrl(const ::GURL& client_url, const ::blink::StorageKey& key, GetFakeRegistrationForClientUrlCallback callback) override;
  void StoreRegistration(::storage::mojom::ServiceWorkerRegistrationDataPtr registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources, StoreRegistrationCallback callback) override;
  void DeleteRegistration(int64_t registration_id, const ::blink::StorageKey& key, DeleteRegistrationCallback callback) override;
  void UpdateToActiveState(int64_t registration_id, const ::blink::StorageKey& key, UpdateToActiveStateCallback callback) override;
  void UpdateLastUpdateCheckTime(int64_t registration_id, const ::blink::StorageKey& key, ::base::Time last_update_check_time, UpdateLastUpdateCheckTimeCallback callback) override;
  void UpdateNavigationPreloadEnabled(int64_t registration_id, const ::blink::StorageKey& key, bool enable, UpdateNavigationPreloadEnabledCallback callback) override;
  void UpdateNavigationPreloadHeader(int64_t registration_id, const ::blink::StorageKey& key, const std::string& value, UpdateNavigationPreloadHeaderCallback callback) override;
  void UpdateFetchHandlerType(int64_t registration_id, const ::blink::StorageKey& key, ::blink::mojom::ServiceWorkerFetchHandlerType type, UpdateFetchHandlerTypeCallback callback) override;
  void UpdateResourceSha256Checksums(int64_t registratation_id, const ::blink::StorageKey& key, const base::flat_map<int64_t, std::string>& updated_sha256_checksums, UpdateResourceSha256ChecksumsCallback callback) override;
  void GetNewRegistrationId(GetNewRegistrationIdCallback callback) override;
  void GetNewVersionId(GetNewVersionIdCallback callback) override;
  void GetNewResourceId(GetNewResourceIdCallback callback) override;
  void CreateResourceReader(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceReader> reader) override;
  void CreateResourceWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceWriter> writer) override;
  void CreateResourceMetadataWriter(int64_t resource_id, ::mojo::PendingReceiver<ServiceWorkerResourceMetadataWriter> writer) override;
  void StoreUncommittedResourceId(int64_t resource_id, StoreUncommittedResourceIdCallback callback) override;
  void DoomUncommittedResources(const std::vector<int64_t>& resource_ids, DoomUncommittedResourcesCallback callback) override;
  void GetUserData(int64_t registration_id, const std::vector<std::string>& keys, GetUserDataCallback callback) override;
  void StoreUserData(int64_t registration_id, const ::blink::StorageKey& key, std::vector<ServiceWorkerUserDataPtr> user_data, StoreUserDataCallback callback) override;
  void ClearUserData(int64_t registration_id, const std::vector<std::string>& keys, ClearUserDataCallback callback) override;
  void GetUserDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserDataByKeyPrefixCallback callback) override;
  void GetUserKeysAndDataByKeyPrefix(int64_t registration_id, const std::string& key_prefix, GetUserKeysAndDataByKeyPrefixCallback callback) override;
  void ClearUserDataByKeyPrefixes(int64_t registratation_id, const std::vector<std::string>& key_prefixes, ClearUserDataByKeyPrefixesCallback callback) override;
  void GetUserDataForAllRegistrations(const std::string& key, GetUserDataForAllRegistrationsCallback callback) override;
  void GetUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, GetUserDataForAllRegistrationsByKeyPrefixCallback callback) override;
  void ClearUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix, ClearUserDataForAllRegistrationsByKeyPrefixCallback callback) override;
  void PerformStorageCleanup(PerformStorageCleanupCallback callback) override;
  void ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates, ApplyPolicyUpdatesCallback callback) override;
  void GetPurgingResourceIdsForTest(GetPurgingResourceIdsForTestCallback callback) override;
  void GetPurgingResourceIdsForLiveVersionForTest(int64_t version_id, GetPurgingResourceIdsForLiveVersionForTestCallback callback) override;
  void GetPurgeableResourceIdsForTest(GetPurgeableResourceIdsForTestCallback callback) override;
  void GetUncommittedResourceIdsForTest(GetUncommittedResourceIdsForTestCallback callback) override;
  void SetPurgingCompleteCallbackForTest(SetPurgingCompleteCallbackForTestCallback callback) override;
};
class  ServiceWorkerStorageControlAsyncWaiter {
 public:
  explicit ServiceWorkerStorageControlAsyncWaiter(ServiceWorkerStorageControl* proxy);

  ServiceWorkerStorageControlAsyncWaiter(const ServiceWorkerStorageControlAsyncWaiter&) = delete;
  ServiceWorkerStorageControlAsyncWaiter& operator=(const ServiceWorkerStorageControlAsyncWaiter&) = delete;

  ~ServiceWorkerStorageControlAsyncWaiter();
  void Disable(
      );
  
  void Delete(
      ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus Delete();
  void Recover(
      std::vector<ServiceWorkerLiveVersionInfoPtr> versions);
  
  void GetRegisteredStorageKeys(
      std::vector<::blink::StorageKey>* out_keys);
  std::vector<::blink::StorageKey> GetRegisteredStorageKeys();
  void FindRegistrationForClientUrl(
      const ::GURL& client_url, const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result, std::optional<std::vector<::GURL>>* out_scopes);
  
  void FindRegistrationForScope(
      const ::GURL& scope, const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result);
  
  void FindRegistrationForId(
      int64_t registration_id, const std::optional<::blink::StorageKey>& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result);
  
  void GetRegistrationsForStorageKey(
      const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<ServiceWorkerFindRegistrationResultPtr>* out_registrations);
  
  void GetUsageForStorageKey(
      const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, int64_t* out_usage);
  
  void GetAllRegistrationsDeprecated(
      ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<::storage::mojom::ServiceWorkerRegistrationDataPtr>* out_registrations);
  
  void GetFakeRegistrationForClientUrl(
      const ::GURL& client_url, const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, ServiceWorkerFindRegistrationResultPtr* out_result, std::optional<std::vector<::GURL>>* out_scopes);
  
  void StoreRegistration(
      ::storage::mojom::ServiceWorkerRegistrationDataPtr registration, std::vector<::storage::mojom::ServiceWorkerResourceRecordPtr> resources, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, uint64_t* out_deleted_resources_size);
  
  void DeleteRegistration(
      int64_t registration_id, const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, uint64_t* out_deleted_resources_size, ServiceWorkerStorageStorageKeyState* out_storage_key_state);
  
  void UpdateToActiveState(
      int64_t registration_id, const ::blink::StorageKey& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus UpdateToActiveState(int64_t registration_id, const ::blink::StorageKey& key);
  void UpdateLastUpdateCheckTime(
      int64_t registration_id, const ::blink::StorageKey& key, ::base::Time last_update_check_time, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus UpdateLastUpdateCheckTime(int64_t registration_id, const ::blink::StorageKey& key, ::base::Time last_update_check_time);
  void UpdateNavigationPreloadEnabled(
      int64_t registration_id, const ::blink::StorageKey& key, bool enable, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus UpdateNavigationPreloadEnabled(int64_t registration_id, const ::blink::StorageKey& key, bool enable);
  void UpdateNavigationPreloadHeader(
      int64_t registration_id, const ::blink::StorageKey& key, const std::string& value, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus UpdateNavigationPreloadHeader(int64_t registration_id, const ::blink::StorageKey& key, const std::string& value);
  void UpdateFetchHandlerType(
      int64_t registration_id, const ::blink::StorageKey& key, ::blink::mojom::ServiceWorkerFetchHandlerType type, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus UpdateFetchHandlerType(int64_t registration_id, const ::blink::StorageKey& key, ::blink::mojom::ServiceWorkerFetchHandlerType type);
  void UpdateResourceSha256Checksums(
      int64_t registratation_id, const ::blink::StorageKey& key, const base::flat_map<int64_t, std::string>& updated_sha256_checksums, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus UpdateResourceSha256Checksums(int64_t registratation_id, const ::blink::StorageKey& key, const base::flat_map<int64_t, std::string>& updated_sha256_checksums);
  void GetNewRegistrationId(
      int64_t* out_registration_id);
  int64_t GetNewRegistrationId();
  void GetNewVersionId(
      int64_t* out_version_id, ::mojo::PendingRemote<ServiceWorkerLiveVersionRef>* out_version_reference);
  
  void GetNewResourceId(
      int64_t* out_resource_id);
  int64_t GetNewResourceId();
  void StoreUncommittedResourceId(
      int64_t resource_id, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus StoreUncommittedResourceId(int64_t resource_id);
  void DoomUncommittedResources(
      const std::vector<int64_t>& resource_ids, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus DoomUncommittedResources(const std::vector<int64_t>& resource_ids);
  void GetUserData(
      int64_t registration_id, const std::vector<std::string>& keys, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<std::string>* out_values);
  
  void StoreUserData(
      int64_t registration_id, const ::blink::StorageKey& key, std::vector<ServiceWorkerUserDataPtr> user_data, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus StoreUserData(int64_t registration_id, const ::blink::StorageKey& key, std::vector<ServiceWorkerUserDataPtr> user_data);
  void ClearUserData(
      int64_t registration_id, const std::vector<std::string>& keys, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus ClearUserData(int64_t registration_id, const std::vector<std::string>& keys);
  void GetUserDataByKeyPrefix(
      int64_t registration_id, const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<std::string>* out_values);
  
  void GetUserKeysAndDataByKeyPrefix(
      int64_t registration_id, const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, base::flat_map<std::string, std::string>* out_user_data);
  
  void ClearUserDataByKeyPrefixes(
      int64_t registratation_id, const std::vector<std::string>& key_prefixes, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus ClearUserDataByKeyPrefixes(int64_t registratation_id, const std::vector<std::string>& key_prefixes);
  void GetUserDataForAllRegistrations(
      const std::string& key, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<ServiceWorkerUserDataPtr>* out_values);
  
  void GetUserDataForAllRegistrationsByKeyPrefix(
      const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<ServiceWorkerUserDataPtr>* out_values);
  
  void ClearUserDataForAllRegistrationsByKeyPrefix(
      const std::string& key_prefix, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus ClearUserDataForAllRegistrationsByKeyPrefix(const std::string& key_prefix);
  void PerformStorageCleanup(
      );
  
  void ApplyPolicyUpdates(
      std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status);
  ::storage::mojom::ServiceWorkerDatabaseStatus ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates);
  void GetPurgingResourceIdsForTest(
      ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids);
  
  void GetPurgingResourceIdsForLiveVersionForTest(
      int64_t version_id, ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids);
  
  void GetPurgeableResourceIdsForTest(
      ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids);
  
  void GetUncommittedResourceIdsForTest(
      ::storage::mojom::ServiceWorkerDatabaseStatus* out_status, std::vector<int64_t>* out_resource_ids);
  
  void SetPurgingCompleteCallbackForTest(
      );
  

 private:
  ServiceWorkerStorageControl* const proxy_;
};




}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_TEST_UTILS_H_