// components/services/storage/public/mojom/service_worker_database.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/service_worker_database.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/navigation_preload_state.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_ancestor_frame_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "components/services/storage/public/mojom/service_worker_database.mojom-data-view.h"




namespace std {

template <>
struct hash<::storage::mojom::ServiceWorkerDatabaseStatus>
    : public mojo::internal::EnumHashImpl<::storage::mojom::ServiceWorkerDatabaseStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerDatabaseStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::ServiceWorkerDatabaseStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::ServiceWorkerDatabaseStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerRegistrationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerRegistrationDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::ServiceWorkerRegistrationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->registration_id = Traits::registration_id(input);

    decltype(Traits::scope(input)) in_scope = Traits::scope(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope)::BaseType> scope_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_scope,
      scope_fragment);

    fragment->scope.Set(
        scope_fragment.is_null() ? nullptr : scope_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scope.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scope in ServiceWorkerRegistrationData struct");

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in ServiceWorkerRegistrationData struct");

    decltype(Traits::script(input)) in_script = Traits::script(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->script)::BaseType> script_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script,
      script_fragment);

    fragment->script.Set(
        script_fragment.is_null() ? nullptr : script_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->script.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script in ServiceWorkerRegistrationData struct");

    
    mojo::internal::Serialize<::blink::mojom::ScriptType>(
      Traits::script_type(input),
      &fragment->script_type);

    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
      Traits::update_via_cache(input),
      &fragment->update_via_cache);

    fragment->version_id = Traits::version_id(input);

    fragment->is_active = Traits::is_active(input);

    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchHandlerType>(
      Traits::fetch_handler_type(input),
      &fragment->fetch_handler_type);

    decltype(Traits::last_update_check(input)) in_last_update_check = Traits::last_update_check(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_update_check)::BaseType> last_update_check_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_update_check,
      last_update_check_fragment);

    fragment->last_update_check.Set(
        last_update_check_fragment.is_null() ? nullptr : last_update_check_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_update_check.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_update_check in ServiceWorkerRegistrationData struct");

    decltype(Traits::script_response_time(input)) in_script_response_time = Traits::script_response_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->script_response_time)::BaseType> script_response_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_script_response_time,
      script_response_time_fragment);

    fragment->script_response_time.Set(
        script_response_time_fragment.is_null() ? nullptr : script_response_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->script_response_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_response_time in ServiceWorkerRegistrationData struct");

    decltype(Traits::origin_trial_tokens(input)) in_origin_trial_tokens = Traits::origin_trial_tokens(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin_trial_tokens)::BaseType>
        origin_trial_tokens_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& origin_trial_tokens_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
      in_origin_trial_tokens,
      origin_trial_tokens_fragment,
      &origin_trial_tokens_validate_params);

    fragment->origin_trial_tokens.Set(
        origin_trial_tokens_fragment.is_null() ? nullptr : origin_trial_tokens_fragment.data());

    decltype(Traits::navigation_preload_state(input)) in_navigation_preload_state = Traits::navigation_preload_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_preload_state)::BaseType> navigation_preload_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::NavigationPreloadStateDataView>(
      in_navigation_preload_state,
      navigation_preload_state_fragment);

    fragment->navigation_preload_state.Set(
        navigation_preload_state_fragment.is_null() ? nullptr : navigation_preload_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->navigation_preload_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null navigation_preload_state in ServiceWorkerRegistrationData struct");

    decltype(Traits::used_features(input)) in_used_features = Traits::used_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->used_features)::BaseType>
        used_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& used_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebFeature_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
      in_used_features,
      used_features_fragment,
      &used_features_validate_params);

    fragment->used_features.Set(
        used_features_fragment.is_null() ? nullptr : used_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->used_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null used_features in ServiceWorkerRegistrationData struct");

    fragment->resources_total_size_bytes = Traits::resources_total_size_bytes(input);

    decltype(Traits::policy_container_policies(input)) in_policy_container_policies = Traits::policy_container_policies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_container_policies)::BaseType> policy_container_policies_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PolicyContainerPoliciesDataView>(
      in_policy_container_policies,
      policy_container_policies_fragment);

    fragment->policy_container_policies.Set(
        policy_container_policies_fragment.is_null() ? nullptr : policy_container_policies_fragment.data());

    
    mojo::internal::Serialize<::blink::mojom::AncestorFrameType>(
      Traits::ancestor_frame_type(input),
      &fragment->ancestor_frame_type);

    decltype(Traits::router_rules(input)) in_router_rules = Traits::router_rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->router_rules)::BaseType> router_rules_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterRulesDataView>(
      in_router_rules,
      router_rules_fragment);

    fragment->router_rules.Set(
        router_rules_fragment.is_null() ? nullptr : router_rules_fragment.data());

    fragment->has_hid_event_handlers = Traits::has_hid_event_handlers(input);

    fragment->has_usb_event_handlers = Traits::has_usb_event_handlers(input);
  }

  static bool Deserialize(::storage::mojom::internal::ServiceWorkerRegistrationData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::ServiceWorkerRegistrationDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerResourceRecordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerResourceRecordDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::ServiceWorkerResourceRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->resource_id = Traits::resource_id(input);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ServiceWorkerResourceRecord struct");

    fragment->size_bytes = Traits::size_bytes(input);

    decltype(Traits::sha256_checksum(input)) in_sha256_checksum = Traits::sha256_checksum(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sha256_checksum)::BaseType> sha256_checksum_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_sha256_checksum,
      sha256_checksum_fragment);

    fragment->sha256_checksum.Set(
        sha256_checksum_fragment.is_null() ? nullptr : sha256_checksum_fragment.data());
  }

  static bool Deserialize(::storage::mojom::internal::ServiceWorkerResourceRecord_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::ServiceWorkerResourceRecordDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void ServiceWorkerRegistrationDataDataView::GetScopeDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->scope.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ServiceWorkerRegistrationDataDataView::GetKeyDataView(
    ::blink::mojom::StorageKeyDataView* output) {
  auto pointer = data_->key.Get();
  *output = ::blink::mojom::StorageKeyDataView(pointer, message_);
}
inline void ServiceWorkerRegistrationDataDataView::GetScriptDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->script.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ServiceWorkerRegistrationDataDataView::GetLastUpdateCheckDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_update_check.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void ServiceWorkerRegistrationDataDataView::GetScriptResponseTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->script_response_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void ServiceWorkerRegistrationDataDataView::GetOriginTrialTokensDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>* output) {
  auto pointer = data_->origin_trial_tokens.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>(pointer, message_);
}
inline void ServiceWorkerRegistrationDataDataView::GetNavigationPreloadStateDataView(
    ::blink::mojom::NavigationPreloadStateDataView* output) {
  auto pointer = data_->navigation_preload_state.Get();
  *output = ::blink::mojom::NavigationPreloadStateDataView(pointer, message_);
}
inline void ServiceWorkerRegistrationDataDataView::GetUsedFeaturesDataView(
    mojo::ArrayDataView<::blink::mojom::WebFeature>* output) {
  auto pointer = data_->used_features.Get();
  *output = mojo::ArrayDataView<::blink::mojom::WebFeature>(pointer, message_);
}
inline void ServiceWorkerRegistrationDataDataView::GetPolicyContainerPoliciesDataView(
    ::blink::mojom::PolicyContainerPoliciesDataView* output) {
  auto pointer = data_->policy_container_policies.Get();
  *output = ::blink::mojom::PolicyContainerPoliciesDataView(pointer, message_);
}
inline void ServiceWorkerRegistrationDataDataView::GetRouterRulesDataView(
    ::blink::mojom::ServiceWorkerRouterRulesDataView* output) {
  auto pointer = data_->router_rules.Get();
  *output = ::blink::mojom::ServiceWorkerRouterRulesDataView(pointer, message_);
}


inline void ServiceWorkerResourceRecordDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ServiceWorkerResourceRecordDataView::GetSha256ChecksumDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sha256_checksum.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::storage::mojom::ServiceWorkerDatabaseStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::ServiceWorkerDatabaseStatus value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SHARED_H_