// components/services/storage/public/mojom/service_worker_database.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SEND_VALIDATION_H_

#include "components/services/storage/public/mojom/service_worker_database.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/navigation_preload_state.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_ancestor_frame_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_router_rule.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/services/storage/public/mojom/service_worker_database.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::storage::mojom::ServiceWorkerDatabaseStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::ServiceWorkerRegistrationDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerRegistrationDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::ServiceWorkerRegistrationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->registration_id = Traits::registration_id(input);

      decltype(Traits::scope(input)) in_scope = Traits::scope(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scope)::BaseType> scope_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_scope,
        scope_fragment);

      fragment->scope.Set(
          scope_fragment.is_null() ? nullptr : scope_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scope.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope in ServiceWorkerRegistrationData struct");

      decltype(Traits::key(input)) in_key = Traits::key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key)::BaseType> key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::StorageKeyDataView, send_validation>(
        in_key,
        key_fragment);

      fragment->key.Set(
          key_fragment.is_null() ? nullptr : key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in ServiceWorkerRegistrationData struct");

      decltype(Traits::script(input)) in_script = Traits::script(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->script)::BaseType> script_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_script,
        script_fragment);

      fragment->script.Set(
          script_fragment.is_null() ? nullptr : script_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->script.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script in ServiceWorkerRegistrationData struct");

      
      mojo::internal::Serialize<::blink::mojom::ScriptType>(
        Traits::script_type(input),
        &fragment->script_type);

      
      mojo::internal::Serialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
        Traits::update_via_cache(input),
        &fragment->update_via_cache);

      fragment->version_id = Traits::version_id(input);

      fragment->is_active = Traits::is_active(input);

      
      mojo::internal::Serialize<::blink::mojom::ServiceWorkerFetchHandlerType>(
        Traits::fetch_handler_type(input),
        &fragment->fetch_handler_type);

      decltype(Traits::last_update_check(input)) in_last_update_check = Traits::last_update_check(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_update_check)::BaseType> last_update_check_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_update_check,
        last_update_check_fragment);

      fragment->last_update_check.Set(
          last_update_check_fragment.is_null() ? nullptr : last_update_check_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_update_check.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_update_check in ServiceWorkerRegistrationData struct");

      decltype(Traits::script_response_time(input)) in_script_response_time = Traits::script_response_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->script_response_time)::BaseType> script_response_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_script_response_time,
        script_response_time_fragment);

      fragment->script_response_time.Set(
          script_response_time_fragment.is_null() ? nullptr : script_response_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->script_response_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script_response_time in ServiceWorkerRegistrationData struct");

      decltype(Traits::origin_trial_tokens(input)) in_origin_trial_tokens = Traits::origin_trial_tokens(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin_trial_tokens)::BaseType>
          origin_trial_tokens_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& origin_trial_tokens_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>, send_validation>(
        in_origin_trial_tokens,
        origin_trial_tokens_fragment,
        &origin_trial_tokens_validate_params);

      fragment->origin_trial_tokens.Set(
          origin_trial_tokens_fragment.is_null() ? nullptr : origin_trial_tokens_fragment.data());

      decltype(Traits::navigation_preload_state(input)) in_navigation_preload_state = Traits::navigation_preload_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->navigation_preload_state)::BaseType> navigation_preload_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::NavigationPreloadStateDataView, send_validation>(
        in_navigation_preload_state,
        navigation_preload_state_fragment);

      fragment->navigation_preload_state.Set(
          navigation_preload_state_fragment.is_null() ? nullptr : navigation_preload_state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->navigation_preload_state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_preload_state in ServiceWorkerRegistrationData struct");

      decltype(Traits::used_features(input)) in_used_features = Traits::used_features(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->used_features)::BaseType>
          used_features_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& used_features_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebFeature_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>, send_validation>(
        in_used_features,
        used_features_fragment,
        &used_features_validate_params);

      fragment->used_features.Set(
          used_features_fragment.is_null() ? nullptr : used_features_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->used_features.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null used_features in ServiceWorkerRegistrationData struct");

      fragment->resources_total_size_bytes = Traits::resources_total_size_bytes(input);

      decltype(Traits::policy_container_policies(input)) in_policy_container_policies = Traits::policy_container_policies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->policy_container_policies)::BaseType> policy_container_policies_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::PolicyContainerPoliciesDataView, send_validation>(
        in_policy_container_policies,
        policy_container_policies_fragment);

      fragment->policy_container_policies.Set(
          policy_container_policies_fragment.is_null() ? nullptr : policy_container_policies_fragment.data());

      
      mojo::internal::Serialize<::blink::mojom::AncestorFrameType>(
        Traits::ancestor_frame_type(input),
        &fragment->ancestor_frame_type);

      decltype(Traits::router_rules(input)) in_router_rules = Traits::router_rules(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->router_rules)::BaseType> router_rules_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ServiceWorkerRouterRulesDataView, send_validation>(
        in_router_rules,
        router_rules_fragment);

      fragment->router_rules.Set(
          router_rules_fragment.is_null() ? nullptr : router_rules_fragment.data());

      fragment->has_hid_event_handlers = Traits::has_hid_event_handlers(input);

      fragment->has_usb_event_handlers = Traits::has_usb_event_handlers(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::storage::mojom::ServiceWorkerResourceRecordDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerResourceRecordDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::ServiceWorkerResourceRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->resource_id = Traits::resource_id(input);

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ServiceWorkerResourceRecord struct");

      fragment->size_bytes = Traits::size_bytes(input);

      decltype(Traits::sha256_checksum(input)) in_sha256_checksum = Traits::sha256_checksum(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sha256_checksum)::BaseType> sha256_checksum_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_sha256_checksum,
        sha256_checksum_fragment);

      fragment->sha256_checksum.Set(
          sha256_checksum_fragment.is_null() ? nullptr : sha256_checksum_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SEND_VALIDATION_H_