// components/services/storage/public/mojom/filesystem/directory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/filesystem/directory.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/filesystem/directory.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_string.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_error.mojom.h"
#include "mojo/public/mojom/base/file_info.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/services/storage/public/cpp/filesystem/strict_relative_path_mojom_traits.h"
#include "base/component_export.h"




namespace storage::mojom {

class FileLockProxy;

template <typename ImplRefTraits>
class FileLockStub;

class FileLockRequestValidator;
class FileLockResponseValidator;


class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLock
    : public FileLockInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.FileLock";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileLockInterfaceBase;
  using Proxy_ = FileLockProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileLockStub<ImplRefTraits>;

  using RequestValidator_ = FileLockRequestValidator;
  using ResponseValidator_ = FileLockResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReleaseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Release_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileLock() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Release(::base::File::Error* out_error);
  using ReleaseCallback = base::OnceCallback<void(::base::File::Error)>;
  using ReleaseMojoCallback = base::OnceCallback<void(::base::File::Error)>;

  virtual void Release(ReleaseCallback callback) = 0;
};

class DirectoryProxy;

template <typename ImplRefTraits>
class DirectoryStub;

class DirectoryRequestValidator;
class DirectoryResponseValidator;


class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) Directory
    : public DirectoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.Directory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    1, 
    2, 
    3, 
    4, 
    5, 
    6, 
    7, 
    8, 
    9
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DirectoryInterfaceBase;
  using Proxy_ = DirectoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = DirectoryStub<ImplRefTraits>;

  using RequestValidator_ = DirectoryRequestValidator;
  using ResponseValidator_ = DirectoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCloneMinVersion = 0,
    kPathExistsMinVersion = 0,
    kGetEntriesMinVersion = 0,
    kOpenFileMinVersion = 0,
    kCreateDirectoryMinVersion = 0,
    kDeleteFileMinVersion = 0,
    kGetFileInfoMinVersion = 0,
    kGetPathAccessMinVersion = 0,
    kRenameFileMinVersion = 0,
    kLockFileMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PathExists_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateDirectory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFileInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPathAccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RenameFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LockFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Directory() = default;

  virtual void Clone(::mojo::PendingReceiver<Directory> receiver) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool PathExists(const ::base::FilePath& path, bool* out_exists);
  using PathExistsCallback = base::OnceCallback<void(bool)>;
  using PathExistsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void PathExists(const ::base::FilePath& path, PathExistsCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetEntries(const ::base::FilePath& path, GetEntriesMode mode, ::base::File::Error* out_error, std::vector<::base::FilePath>* out_entries);
  using GetEntriesCallback = base::OnceCallback<void(::base::File::Error, const std::vector<::base::FilePath>&)>;
  using GetEntriesMojoCallback = base::OnceCallback<void(::base::File::Error, const std::vector<::base::FilePath>&)>;

  virtual void GetEntries(const ::base::FilePath& path, GetEntriesMode mode, GetEntriesCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, ::base::File::Error* out_error, ::base::File* out_file);
  using OpenFileCallback = base::OnceCallback<void(::base::File::Error, ::base::File)>;
  using OpenFileMojoCallback = base::OnceCallback<void(::base::File::Error, ::base::File)>;

  virtual void OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, OpenFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateDirectory(const ::base::FilePath& path, ::base::File::Error* out_error);
  using CreateDirectoryCallback = base::OnceCallback<void(::base::File::Error)>;
  using CreateDirectoryMojoCallback = base::OnceCallback<void(::base::File::Error)>;

  virtual void CreateDirectory(const ::base::FilePath& path, CreateDirectoryCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DeleteFile(const ::base::FilePath& path, bool* out_success);
  using DeleteFileCallback = base::OnceCallback<void(bool)>;
  using DeleteFileMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DeleteFile(const ::base::FilePath& path, DeleteFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetFileInfo(const ::base::FilePath& path, std::optional<::base::File::Info>* out_info);
  using GetFileInfoCallback = base::OnceCallback<void(const std::optional<::base::File::Info>&)>;
  using GetFileInfoMojoCallback = base::OnceCallback<void(const std::optional<::base::File::Info>&)>;

  virtual void GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetPathAccess(const ::base::FilePath& path, PathAccessInfoPtr* out_info);
  using GetPathAccessCallback = base::OnceCallback<void(PathAccessInfoPtr)>;
  using GetPathAccessMojoCallback = base::OnceCallback<void(PathAccessInfoPtr)>;

  virtual void GetPathAccess(const ::base::FilePath& path, GetPathAccessCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, ::base::File::Error* out_error);
  using RenameFileCallback = base::OnceCallback<void(::base::File::Error)>;
  using RenameFileMojoCallback = base::OnceCallback<void(::base::File::Error)>;

  virtual void RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, RenameFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool LockFile(const ::base::FilePath& path, ::base::File::Error* out_error, ::mojo::PendingRemote<FileLock>* out_lock);
  using LockFileCallback = base::OnceCallback<void(::base::File::Error, ::mojo::PendingRemote<FileLock>)>;
  using LockFileMojoCallback = base::OnceCallback<void(::base::File::Error, ::mojo::PendingRemote<FileLock>)>;

  virtual void LockFile(const ::base::FilePath& path, LockFileCallback callback) = 0;
};



class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLockProxy
    : public FileLock {
 public:
  using InterfaceType = FileLock;

  explicit FileLockProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Release(::base::File::Error* out_error) final;
  
  void Release(ReleaseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) DirectoryProxy
    : public Directory {
 public:
  using InterfaceType = Directory;

  explicit DirectoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Clone(::mojo::PendingReceiver<Directory> receiver) final;
  
  bool PathExists(const ::base::FilePath& path, bool* out_exists) final;
  
  void PathExists(const ::base::FilePath& path, PathExistsCallback callback) final;
  
  bool GetEntries(const ::base::FilePath& path, GetEntriesMode mode, ::base::File::Error* out_error, std::vector<::base::FilePath>* out_entries) final;
  
  void GetEntries(const ::base::FilePath& path, GetEntriesMode mode, GetEntriesCallback callback) final;
  
  bool OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, ::base::File::Error* out_error, ::base::File* out_file) final;
  
  void OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, OpenFileCallback callback) final;
  
  bool CreateDirectory(const ::base::FilePath& path, ::base::File::Error* out_error) final;
  
  void CreateDirectory(const ::base::FilePath& path, CreateDirectoryCallback callback) final;
  
  bool DeleteFile(const ::base::FilePath& path, bool* out_success) final;
  
  void DeleteFile(const ::base::FilePath& path, DeleteFileCallback callback) final;
  
  bool GetFileInfo(const ::base::FilePath& path, std::optional<::base::File::Info>* out_info) final;
  
  void GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) final;
  
  bool GetPathAccess(const ::base::FilePath& path, PathAccessInfoPtr* out_info) final;
  
  void GetPathAccess(const ::base::FilePath& path, GetPathAccessCallback callback) final;
  
  bool RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, ::base::File::Error* out_error) final;
  
  void RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, RenameFileCallback callback) final;
  
  bool LockFile(const ::base::FilePath& path, ::base::File::Error* out_error, ::mojo::PendingRemote<FileLock>* out_lock) final;
  
  void LockFile(const ::base::FilePath& path, LockFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLockStubDispatch {
 public:
  static bool Accept(FileLock* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileLock* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileLock>>
class FileLockStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileLockStub() = default;
  ~FileLockStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileLockStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileLockStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) DirectoryStubDispatch {
 public:
  static bool Accept(Directory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Directory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Directory>>
class DirectoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DirectoryStub() = default;
  ~DirectoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DirectoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DirectoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLockRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) DirectoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLockResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) DirectoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) PathAccessInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PathAccessInfo, T>::value>;
  using DataView = PathAccessInfoDataView;
  using Data_ = internal::PathAccessInfo_Data;

  template <typename... Args>
  static PathAccessInfoPtr New(Args&&... args) {
    return PathAccessInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PathAccessInfoPtr From(const U& u) {
    return mojo::TypeConverter<PathAccessInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PathAccessInfo>::Convert(*this);
  }


  PathAccessInfo();

  PathAccessInfo(
      bool can_read,
      bool can_write);


  ~PathAccessInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PathAccessInfoPtr>
  PathAccessInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PathAccessInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PathAccessInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PathAccessInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PathAccessInfo_UnserializedMessageContext<
            UserType, PathAccessInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PathAccessInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PathAccessInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PathAccessInfo_UnserializedMessageContext<
            UserType, PathAccessInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PathAccessInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool can_read;
  
  bool can_write;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) StrictRelativePath {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StrictRelativePath, T>::value>;
  using DataView = StrictRelativePathDataView;
  using Data_ = internal::StrictRelativePath_Data;

  template <typename... Args>
  static StrictRelativePathPtr New(Args&&... args) {
    return StrictRelativePathPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StrictRelativePathPtr From(const U& u) {
    return mojo::TypeConverter<StrictRelativePathPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StrictRelativePath>::Convert(*this);
  }


  StrictRelativePath();

  explicit StrictRelativePath(
      const ::base::FilePath& path);


  ~StrictRelativePath();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StrictRelativePathPtr>
  StrictRelativePathPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StrictRelativePath::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StrictRelativePath::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StrictRelativePath::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StrictRelativePath_UnserializedMessageContext<
            UserType, StrictRelativePath::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StrictRelativePath::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StrictRelativePath::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StrictRelativePath_UnserializedMessageContext<
            UserType, StrictRelativePath::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StrictRelativePath::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::FilePath path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
StrictRelativePathPtr StrictRelativePath::Clone() const {
  return New(
      mojo::Clone(path)
  );
}

template <typename T, StrictRelativePath::EnableIfSame<T>*>
bool StrictRelativePath::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  return true;
}

template <typename T, StrictRelativePath::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  return false;
}
template <typename StructPtrType>
PathAccessInfoPtr PathAccessInfo::Clone() const {
  return New(
      mojo::Clone(can_read),
      mojo::Clone(can_write)
  );
}

template <typename T, PathAccessInfo::EnableIfSame<T>*>
bool PathAccessInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->can_read, other_struct.can_read))
    return false;
  if (!mojo::Equals(this->can_write, other_struct.can_write))
    return false;
  return true;
}

template <typename T, PathAccessInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.can_read < rhs.can_read)
    return true;
  if (rhs.can_read < lhs.can_read)
    return false;
  if (lhs.can_write < rhs.can_write)
    return true;
  if (rhs.can_write < lhs.can_write)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) StructTraits<::storage::mojom::StrictRelativePath::DataView,
                                         ::storage::mojom::StrictRelativePathPtr> {
  static bool IsNull(const ::storage::mojom::StrictRelativePathPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::StrictRelativePathPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::StrictRelativePath::path)& path(
      const ::storage::mojom::StrictRelativePathPtr& input) {
    return input->path;
  }

  static bool Read(::storage::mojom::StrictRelativePath::DataView input, ::storage::mojom::StrictRelativePathPtr* output);
};


template <>
struct COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) StructTraits<::storage::mojom::PathAccessInfo::DataView,
                                         ::storage::mojom::PathAccessInfoPtr> {
  static bool IsNull(const ::storage::mojom::PathAccessInfoPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::PathAccessInfoPtr* output) { output->reset(); }

  static decltype(::storage::mojom::PathAccessInfo::can_read) can_read(
      const ::storage::mojom::PathAccessInfoPtr& input) {
    return input->can_read;
  }

  static decltype(::storage::mojom::PathAccessInfo::can_write) can_write(
      const ::storage::mojom::PathAccessInfoPtr& input) {
    return input->can_write;
  }

  static bool Read(::storage::mojom::PathAccessInfo::DataView input, ::storage::mojom::PathAccessInfoPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_H_