// components/services/storage/public/mojom/filesystem/directory.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace storage::mojom {
namespace internal {
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) FileLock_Release_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<FileLock_Release_Params_Data>;

  FileLock_Release_Params_Data();
  ~FileLock_Release_Params_Data() = delete;
};
static_assert(sizeof(FileLock_Release_Params_Data) == 8,
              "Bad sizeof(FileLock_Release_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) FileLock_Release_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<FileLock_Release_ResponseParams_Data>;

  FileLock_Release_ResponseParams_Data();
  ~FileLock_Release_ResponseParams_Data() = delete;
};
static_assert(sizeof(FileLock_Release_ResponseParams_Data) == 16,
              "Bad sizeof(FileLock_Release_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_Clone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_Clone_Params_Data>;

  Directory_Clone_Params_Data();
  ~Directory_Clone_Params_Data() = delete;
};
static_assert(sizeof(Directory_Clone_Params_Data) == 16,
              "Bad sizeof(Directory_Clone_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_PathExists_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  friend class mojo::internal::MessageFragment<Directory_PathExists_Params_Data>;

  Directory_PathExists_Params_Data();
  ~Directory_PathExists_Params_Data() = delete;
};
static_assert(sizeof(Directory_PathExists_Params_Data) == 16,
              "Bad sizeof(Directory_PathExists_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_PathExists_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t exists : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Directory_PathExists_ResponseParams_Data>;

  Directory_PathExists_ResponseParams_Data();
  ~Directory_PathExists_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_PathExists_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_PathExists_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetEntries_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;
  int32_t mode;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_GetEntries_Params_Data>;

  Directory_GetEntries_Params_Data();
  ~Directory_GetEntries_Params_Data() = delete;
};
static_assert(sizeof(Directory_GetEntries_Params_Data) == 24,
              "Bad sizeof(Directory_GetEntries_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetEntries_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data>>> entries;

 private:
  friend class mojo::internal::MessageFragment<Directory_GetEntries_ResponseParams_Data>;

  Directory_GetEntries_ResponseParams_Data();
  ~Directory_GetEntries_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_GetEntries_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_GetEntries_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_OpenFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;
  int32_t mode;
  int32_t read_access;
  int32_t write_access;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_OpenFile_Params_Data>;

  Directory_OpenFile_Params_Data();
  ~Directory_OpenFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_OpenFile_Params_Data) == 32,
              "Bad sizeof(Directory_OpenFile_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_OpenFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> file;

 private:
  friend class mojo::internal::MessageFragment<Directory_OpenFile_ResponseParams_Data>;

  Directory_OpenFile_ResponseParams_Data();
  ~Directory_OpenFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_OpenFile_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_OpenFile_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_CreateDirectory_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  friend class mojo::internal::MessageFragment<Directory_CreateDirectory_Params_Data>;

  Directory_CreateDirectory_Params_Data();
  ~Directory_CreateDirectory_Params_Data() = delete;
};
static_assert(sizeof(Directory_CreateDirectory_Params_Data) == 16,
              "Bad sizeof(Directory_CreateDirectory_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_CreateDirectory_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_CreateDirectory_ResponseParams_Data>;

  Directory_CreateDirectory_ResponseParams_Data();
  ~Directory_CreateDirectory_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_CreateDirectory_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_CreateDirectory_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_DeleteFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  friend class mojo::internal::MessageFragment<Directory_DeleteFile_Params_Data>;

  Directory_DeleteFile_Params_Data();
  ~Directory_DeleteFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_DeleteFile_Params_Data) == 16,
              "Bad sizeof(Directory_DeleteFile_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_DeleteFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Directory_DeleteFile_ResponseParams_Data>;

  Directory_DeleteFile_ResponseParams_Data();
  ~Directory_DeleteFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_DeleteFile_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_DeleteFile_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetFileInfo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  friend class mojo::internal::MessageFragment<Directory_GetFileInfo_Params_Data>;

  Directory_GetFileInfo_Params_Data();
  ~Directory_GetFileInfo_Params_Data() = delete;
};
static_assert(sizeof(Directory_GetFileInfo_Params_Data) == 16,
              "Bad sizeof(Directory_GetFileInfo_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetFileInfo_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FileInfo_Data> info;

 private:
  friend class mojo::internal::MessageFragment<Directory_GetFileInfo_ResponseParams_Data>;

  Directory_GetFileInfo_ResponseParams_Data();
  ~Directory_GetFileInfo_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_GetFileInfo_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_GetFileInfo_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetPathAccess_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  friend class mojo::internal::MessageFragment<Directory_GetPathAccess_Params_Data>;

  Directory_GetPathAccess_Params_Data();
  ~Directory_GetPathAccess_Params_Data() = delete;
};
static_assert(sizeof(Directory_GetPathAccess_Params_Data) == 16,
              "Bad sizeof(Directory_GetPathAccess_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_GetPathAccess_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PathAccessInfo_Data> info;

 private:
  friend class mojo::internal::MessageFragment<Directory_GetPathAccess_ResponseParams_Data>;

  Directory_GetPathAccess_ResponseParams_Data();
  ~Directory_GetPathAccess_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_GetPathAccess_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_GetPathAccess_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_RenameFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> old_path;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> new_path;

 private:
  friend class mojo::internal::MessageFragment<Directory_RenameFile_Params_Data>;

  Directory_RenameFile_Params_Data();
  ~Directory_RenameFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_RenameFile_Params_Data) == 24,
              "Bad sizeof(Directory_RenameFile_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_RenameFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_RenameFile_ResponseParams_Data>;

  Directory_RenameFile_ResponseParams_Data();
  ~Directory_RenameFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_RenameFile_ResponseParams_Data) == 16,
              "Bad sizeof(Directory_RenameFile_ResponseParams_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_LockFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StrictRelativePath_Data> path;

 private:
  friend class mojo::internal::MessageFragment<Directory_LockFile_Params_Data>;

  Directory_LockFile_Params_Data();
  ~Directory_LockFile_Params_Data() = delete;
};
static_assert(sizeof(Directory_LockFile_Params_Data) == 16,
              "Bad sizeof(Directory_LockFile_Params_Data)");
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM_SHARED) Directory_LockFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error;
  mojo::internal::Interface_Data lock;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Directory_LockFile_ResponseParams_Data>;

  Directory_LockFile_ResponseParams_Data();
  ~Directory_LockFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Directory_LockFile_ResponseParams_Data) == 24,
              "Bad sizeof(Directory_LockFile_ResponseParams_Data)");

}  // namespace internal


class FileLock_Release_ParamsDataView {
 public:
  FileLock_Release_ParamsDataView() = default;

  FileLock_Release_ParamsDataView(
      internal::FileLock_Release_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::FileLock_Release_Params_Data* data_ = nullptr;
};


class FileLock_Release_ResponseParamsDataView {
 public:
  FileLock_Release_ResponseParamsDataView() = default;

  FileLock_Release_ResponseParamsDataView(
      internal::FileLock_Release_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
 private:
  internal::FileLock_Release_ResponseParams_Data* data_ = nullptr;
};


class Directory_Clone_ParamsDataView {
 public:
  Directory_Clone_ParamsDataView() = default;

  Directory_Clone_ParamsDataView(
      internal::Directory_Clone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::storage::mojom::DirectoryInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Directory_Clone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_PathExists_ParamsDataView {
 public:
  Directory_PathExists_ParamsDataView() = default;

  Directory_PathExists_ParamsDataView(
      internal::Directory_PathExists_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_PathExists_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_PathExists_ResponseParamsDataView {
 public:
  Directory_PathExists_ResponseParamsDataView() = default;

  Directory_PathExists_ResponseParamsDataView(
      internal::Directory_PathExists_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool exists() const {
    return data_->exists;
  }
 private:
  internal::Directory_PathExists_ResponseParams_Data* data_ = nullptr;
};


class Directory_GetEntries_ParamsDataView {
 public:
  Directory_GetEntries_ParamsDataView() = default;

  Directory_GetEntries_ParamsDataView(
      internal::Directory_GetEntries_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::storage::mojom::GetEntriesMode>(
        data_value, output);
  }
  GetEntriesMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::storage::mojom::GetEntriesMode>(data_->mode));
  }
 private:
  internal::Directory_GetEntries_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_GetEntries_ResponseParamsDataView {
 public:
  Directory_GetEntries_ResponseParamsDataView() = default;

  Directory_GetEntries_ResponseParamsDataView(
      internal::Directory_GetEntries_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
  inline void GetEntriesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntries(UserType* output) {
    
    auto* pointer = data_->entries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Directory_GetEntries_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_OpenFile_ParamsDataView {
 public:
  Directory_OpenFile_ParamsDataView() = default;

  Directory_OpenFile_ParamsDataView(
      internal::Directory_OpenFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::storage::mojom::FileOpenMode>(
        data_value, output);
  }
  FileOpenMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::storage::mojom::FileOpenMode>(data_->mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReadAccess(UserType* output) const {
    auto data_value = data_->read_access;
    return mojo::internal::Deserialize<::storage::mojom::FileReadAccess>(
        data_value, output);
  }
  FileReadAccess read_access() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::storage::mojom::FileReadAccess>(data_->read_access));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWriteAccess(UserType* output) const {
    auto data_value = data_->write_access;
    return mojo::internal::Deserialize<::storage::mojom::FileWriteAccess>(
        data_value, output);
  }
  FileWriteAccess write_access() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::storage::mojom::FileWriteAccess>(data_->write_access));
  }
 private:
  internal::Directory_OpenFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_OpenFile_ResponseParamsDataView {
 public:
  Directory_OpenFile_ResponseParamsDataView() = default;

  Directory_OpenFile_ResponseParamsDataView(
      internal::Directory_OpenFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileDataView, UserType>(),
    "Attempting to read the optional `file` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFile` instead "
    "of `ReadFile if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_OpenFile_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_CreateDirectory_ParamsDataView {
 public:
  Directory_CreateDirectory_ParamsDataView() = default;

  Directory_CreateDirectory_ParamsDataView(
      internal::Directory_CreateDirectory_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_CreateDirectory_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_CreateDirectory_ResponseParamsDataView {
 public:
  Directory_CreateDirectory_ResponseParamsDataView() = default;

  Directory_CreateDirectory_ResponseParamsDataView(
      internal::Directory_CreateDirectory_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
 private:
  internal::Directory_CreateDirectory_ResponseParams_Data* data_ = nullptr;
};


class Directory_DeleteFile_ParamsDataView {
 public:
  Directory_DeleteFile_ParamsDataView() = default;

  Directory_DeleteFile_ParamsDataView(
      internal::Directory_DeleteFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_DeleteFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_DeleteFile_ResponseParamsDataView {
 public:
  Directory_DeleteFile_ResponseParamsDataView() = default;

  Directory_DeleteFile_ResponseParamsDataView(
      internal::Directory_DeleteFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::Directory_DeleteFile_ResponseParams_Data* data_ = nullptr;
};


class Directory_GetFileInfo_ParamsDataView {
 public:
  Directory_GetFileInfo_ParamsDataView() = default;

  Directory_GetFileInfo_ParamsDataView(
      internal::Directory_GetFileInfo_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_GetFileInfo_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_GetFileInfo_ResponseParamsDataView {
 public:
  Directory_GetFileInfo_ResponseParamsDataView() = default;

  Directory_GetFileInfo_ResponseParamsDataView(
      internal::Directory_GetFileInfo_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      ::mojo_base::mojom::FileInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FileInfoDataView, UserType>(),
    "Attempting to read the optional `info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInfo` instead "
    "of `ReadInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_GetFileInfo_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_GetPathAccess_ParamsDataView {
 public:
  Directory_GetPathAccess_ParamsDataView() = default;

  Directory_GetPathAccess_ParamsDataView(
      internal::Directory_GetPathAccess_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_GetPathAccess_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_GetPathAccess_ResponseParamsDataView {
 public:
  Directory_GetPathAccess_ResponseParamsDataView() = default;

  Directory_GetPathAccess_ResponseParamsDataView(
      internal::Directory_GetPathAccess_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      PathAccessInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::storage::mojom::PathAccessInfoDataView, UserType>(),
    "Attempting to read the optional `info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInfo` instead "
    "of `ReadInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::storage::mojom::PathAccessInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_GetPathAccess_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_RenameFile_ParamsDataView {
 public:
  Directory_RenameFile_ParamsDataView() = default;

  Directory_RenameFile_ParamsDataView(
      internal::Directory_RenameFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOldPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOldPath(UserType* output) {
    
    auto* pointer = data_->old_path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, message_);
  }
  inline void GetNewPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNewPath(UserType* output) {
    
    auto* pointer = data_->new_path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_RenameFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_RenameFile_ResponseParamsDataView {
 public:
  Directory_RenameFile_ResponseParamsDataView() = default;

  Directory_RenameFile_ResponseParamsDataView(
      internal::Directory_RenameFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
 private:
  internal::Directory_RenameFile_ResponseParams_Data* data_ = nullptr;
};


class Directory_LockFile_ParamsDataView {
 public:
  Directory_LockFile_ParamsDataView() = default;

  Directory_LockFile_ParamsDataView(
      internal::Directory_LockFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      StrictRelativePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::storage::mojom::StrictRelativePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::Directory_LockFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Directory_LockFile_ResponseParamsDataView {
 public:
  Directory_LockFile_ResponseParamsDataView() = default;

  Directory_LockFile_ResponseParamsDataView(
      internal::Directory_LockFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::mojo_base::mojom::FileError>(
        data_value, output);
  }
  ::mojo_base::mojom::FileError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::FileError>(data_->error));
  }
  template <typename UserType>
  UserType TakeLock() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::storage::mojom::FileLockInterfaceBase>>(
            &data_->lock, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::Directory_LockFile_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};







inline void Directory_PathExists_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, message_);
}




inline void Directory_GetEntries_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, message_);
}


inline void Directory_GetEntries_ResponseParamsDataView::GetEntriesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output) {
  auto pointer = data_->entries.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>(pointer, message_);
}


inline void Directory_OpenFile_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, message_);
}


inline void Directory_OpenFile_ResponseParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}


inline void Directory_CreateDirectory_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, message_);
}




inline void Directory_DeleteFile_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, message_);
}




inline void Directory_GetFileInfo_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, message_);
}


inline void Directory_GetFileInfo_ResponseParamsDataView::GetInfoDataView(
    ::mojo_base::mojom::FileInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = ::mojo_base::mojom::FileInfoDataView(pointer, message_);
}


inline void Directory_GetPathAccess_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, message_);
}


inline void Directory_GetPathAccess_ResponseParamsDataView::GetInfoDataView(
    PathAccessInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = PathAccessInfoDataView(pointer, message_);
}


inline void Directory_RenameFile_ParamsDataView::GetOldPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->old_path.Get();
  *output = StrictRelativePathDataView(pointer, message_);
}
inline void Directory_RenameFile_ParamsDataView::GetNewPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->new_path.Get();
  *output = StrictRelativePathDataView(pointer, message_);
}




inline void Directory_LockFile_ParamsDataView::GetPathDataView(
    StrictRelativePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = StrictRelativePathDataView(pointer, message_);
}





}  // storage::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_PARAMS_DATA_H_