// components/services/storage/public/mojom/blob_storage_context.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/blob_storage_context.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/services/storage/public/mojom/blob_storage_context.mojom-data-view.h"




namespace std {

template <>
struct hash<::storage::mojom::BlobDataItemType>
    : public mojo::internal::EnumHashImpl<::storage::mojom::BlobDataItemType> {};

template <>
struct hash<::storage::mojom::WriteBlobToFileResult>
    : public mojo::internal::EnumHashImpl<::storage::mojom::WriteBlobToFileResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::BlobDataItemType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::BlobDataItemType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::BlobDataItemType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::WriteBlobToFileResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::WriteBlobToFileResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::WriteBlobToFileResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::BlobDataItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::BlobDataItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::BlobDataItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::storage::mojom::BlobDataItemType>(
      Traits::type(input),
      &fragment->type);

    fragment->size = Traits::size(input);

    fragment->side_data_size = Traits::side_data_size(input);

    decltype(Traits::content_type(input)) in_content_type = Traits::content_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_type)::BaseType> content_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_content_type,
      content_type_fragment);

    fragment->content_type.Set(
        content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_type in BlobDataItem struct");

    decltype(Traits::reader(input)) in_reader = Traits::reader(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::BlobDataItemReaderInterfaceBase>>(
      in_reader,
      &fragment->reader,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->reader)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid reader in BlobDataItem struct");
  }

  static bool Deserialize(::storage::mojom::internal::BlobDataItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::BlobDataItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void BlobDataItemDataView::GetContentTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::storage::mojom::BlobDataItemType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::BlobDataItemType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::storage::mojom::WriteBlobToFileResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::WriteBlobToFileResult value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_BLOB_STORAGE_CONTEXT_MOJOM_SHARED_H_