// components/services/storage/privileged/mojom/indexed_db_internals_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom.h"
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/schemeful_site.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>








namespace storage::mojom {










class  IdbTransactionMetadataStateHistory {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdbTransactionMetadataStateHistory, T>::value>;
  using DataView = IdbTransactionMetadataStateHistoryDataView;
  using Data_ = internal::IdbTransactionMetadataStateHistory_Data;

  template <typename... Args>
  static IdbTransactionMetadataStateHistoryPtr New(Args&&... args) {
    return IdbTransactionMetadataStateHistoryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdbTransactionMetadataStateHistoryPtr From(const U& u) {
    return mojo::TypeConverter<IdbTransactionMetadataStateHistoryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdbTransactionMetadataStateHistory>::Convert(*this);
  }


  IdbTransactionMetadataStateHistory();

  IdbTransactionMetadataStateHistory(
      IdbTransactionState state,
      double duration);


  ~IdbTransactionMetadataStateHistory();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdbTransactionMetadataStateHistoryPtr>
  IdbTransactionMetadataStateHistoryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdbTransactionMetadataStateHistory::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdbTransactionMetadataStateHistory::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdbTransactionMetadataStateHistory::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbTransactionMetadataStateHistory::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbTransactionMetadataStateHistory::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdbTransactionMetadataStateHistory::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdbTransactionMetadataStateHistory_UnserializedMessageContext<
            UserType, IdbTransactionMetadataStateHistory::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdbTransactionMetadataStateHistory::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdbTransactionMetadataStateHistory::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdbTransactionMetadataStateHistory_UnserializedMessageContext<
            UserType, IdbTransactionMetadataStateHistory::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdbTransactionMetadataStateHistory::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  IdbTransactionState state;
  
  double duration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdbTransactionMetadataStateHistory::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdbTransactionMetadataStateHistory::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdbTransactionMetadataStateHistory::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdbTransactionMetadataStateHistory::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  IdbOriginMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdbOriginMetadata, T>::value>;
  using DataView = IdbOriginMetadataDataView;
  using Data_ = internal::IdbOriginMetadata_Data;

  template <typename... Args>
  static IdbOriginMetadataPtr New(Args&&... args) {
    return IdbOriginMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdbOriginMetadataPtr From(const U& u) {
    return mojo::TypeConverter<IdbOriginMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdbOriginMetadata>::Convert(*this);
  }


  IdbOriginMetadata();

  IdbOriginMetadata(
      const ::url::Origin& origin,
      std::vector<IdbStorageKeyMetadataPtr> storage_keys);

IdbOriginMetadata(const IdbOriginMetadata&) = delete;
IdbOriginMetadata& operator=(const IdbOriginMetadata&) = delete;

  ~IdbOriginMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdbOriginMetadataPtr>
  IdbOriginMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdbOriginMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdbOriginMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdbOriginMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbOriginMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbOriginMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdbOriginMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdbOriginMetadata_UnserializedMessageContext<
            UserType, IdbOriginMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdbOriginMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdbOriginMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdbOriginMetadata_UnserializedMessageContext<
            UserType, IdbOriginMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdbOriginMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin origin;
  
  std::vector<IdbStorageKeyMetadataPtr> storage_keys;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdbOriginMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdbOriginMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdbOriginMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdbOriginMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  IdbStorageKeyMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdbStorageKeyMetadata, T>::value>;
  using DataView = IdbStorageKeyMetadataDataView;
  using Data_ = internal::IdbStorageKeyMetadata_Data;

  template <typename... Args>
  static IdbStorageKeyMetadataPtr New(Args&&... args) {
    return IdbStorageKeyMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdbStorageKeyMetadataPtr From(const U& u) {
    return mojo::TypeConverter<IdbStorageKeyMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdbStorageKeyMetadata>::Convert(*this);
  }


  IdbStorageKeyMetadata();

  IdbStorageKeyMetadata(
      const ::net::SchemefulSite& top_level_site,
      const std::string& serialized_storage_key,
      std::vector<IdbBucketMetadataPtr> buckets);

IdbStorageKeyMetadata(const IdbStorageKeyMetadata&) = delete;
IdbStorageKeyMetadata& operator=(const IdbStorageKeyMetadata&) = delete;

  ~IdbStorageKeyMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdbStorageKeyMetadataPtr>
  IdbStorageKeyMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdbStorageKeyMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdbStorageKeyMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdbStorageKeyMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbStorageKeyMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbStorageKeyMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdbStorageKeyMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdbStorageKeyMetadata_UnserializedMessageContext<
            UserType, IdbStorageKeyMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdbStorageKeyMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdbStorageKeyMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdbStorageKeyMetadata_UnserializedMessageContext<
            UserType, IdbStorageKeyMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdbStorageKeyMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::SchemefulSite top_level_site;
  
  std::string serialized_storage_key;
  
  std::vector<IdbBucketMetadataPtr> buckets;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdbStorageKeyMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdbStorageKeyMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdbStorageKeyMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdbStorageKeyMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  IdbBucketMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdbBucketMetadata, T>::value>;
  using DataView = IdbBucketMetadataDataView;
  using Data_ = internal::IdbBucketMetadata_Data;

  template <typename... Args>
  static IdbBucketMetadataPtr New(Args&&... args) {
    return IdbBucketMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdbBucketMetadataPtr From(const U& u) {
    return mojo::TypeConverter<IdbBucketMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdbBucketMetadata>::Convert(*this);
  }


  IdbBucketMetadata();

  IdbBucketMetadata(
      const ::storage::BucketLocator& bucket_locator,
      const std::string& name,
      uint64_t size,
      ::base::Time last_modified,
      std::vector<::base::FilePath> paths,
      uint64_t connection_count,
      std::vector<IdbDatabaseMetadataPtr> databases,
      std::vector<::storage::BucketClientInfo> clients,
      uint64_t delta_recording_start_ms);

IdbBucketMetadata(const IdbBucketMetadata&) = delete;
IdbBucketMetadata& operator=(const IdbBucketMetadata&) = delete;

  ~IdbBucketMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdbBucketMetadataPtr>
  IdbBucketMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdbBucketMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdbBucketMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdbBucketMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbBucketMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbBucketMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdbBucketMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdbBucketMetadata_UnserializedMessageContext<
            UserType, IdbBucketMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdbBucketMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdbBucketMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdbBucketMetadata_UnserializedMessageContext<
            UserType, IdbBucketMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdbBucketMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::storage::BucketLocator bucket_locator;
  
  std::string name;
  
  uint64_t size;
  
  ::base::Time last_modified;
  
  std::vector<::base::FilePath> paths;
  
  uint64_t connection_count;
  
  std::vector<IdbDatabaseMetadataPtr> databases;
  
  std::vector<::storage::BucketClientInfo> clients;
  
  uint64_t delta_recording_start_ms;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdbBucketMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdbBucketMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdbBucketMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdbBucketMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  IdbDatabaseMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdbDatabaseMetadata, T>::value>;
  using DataView = IdbDatabaseMetadataDataView;
  using Data_ = internal::IdbDatabaseMetadata_Data;

  template <typename... Args>
  static IdbDatabaseMetadataPtr New(Args&&... args) {
    return IdbDatabaseMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdbDatabaseMetadataPtr From(const U& u) {
    return mojo::TypeConverter<IdbDatabaseMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdbDatabaseMetadata>::Convert(*this);
  }


  IdbDatabaseMetadata();

  IdbDatabaseMetadata(
      const ::std::u16string& name,
      uint64_t connection_count,
      uint64_t active_open_delete,
      uint64_t pending_open_delete,
      std::vector<IdbTransactionMetadataPtr> transactions);

IdbDatabaseMetadata(const IdbDatabaseMetadata&) = delete;
IdbDatabaseMetadata& operator=(const IdbDatabaseMetadata&) = delete;

  ~IdbDatabaseMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdbDatabaseMetadataPtr>
  IdbDatabaseMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdbDatabaseMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdbDatabaseMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdbDatabaseMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbDatabaseMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbDatabaseMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdbDatabaseMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdbDatabaseMetadata_UnserializedMessageContext<
            UserType, IdbDatabaseMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdbDatabaseMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdbDatabaseMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdbDatabaseMetadata_UnserializedMessageContext<
            UserType, IdbDatabaseMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdbDatabaseMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string name;
  
  uint64_t connection_count;
  
  uint64_t active_open_delete;
  
  uint64_t pending_open_delete;
  
  std::vector<IdbTransactionMetadataPtr> transactions;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdbDatabaseMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdbDatabaseMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdbDatabaseMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdbDatabaseMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  IdbTransactionMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdbTransactionMetadata, T>::value>;
  using DataView = IdbTransactionMetadataDataView;
  using Data_ = internal::IdbTransactionMetadata_Data;

  template <typename... Args>
  static IdbTransactionMetadataPtr New(Args&&... args) {
    return IdbTransactionMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdbTransactionMetadataPtr From(const U& u) {
    return mojo::TypeConverter<IdbTransactionMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdbTransactionMetadata>::Convert(*this);
  }


  IdbTransactionMetadata();

  IdbTransactionMetadata(
      IdbTransactionMode mode,
      IdbTransactionState state,
      int64_t tid,
      int32_t connection_id,
      const std::string& client_token,
      double age,
      double runtime,
      double tasks_scheduled,
      double tasks_completed,
      std::vector<::std::u16string> scope,
      std::vector<IdbTransactionMetadataStateHistoryPtr> state_history);

IdbTransactionMetadata(const IdbTransactionMetadata&) = delete;
IdbTransactionMetadata& operator=(const IdbTransactionMetadata&) = delete;

  ~IdbTransactionMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdbTransactionMetadataPtr>
  IdbTransactionMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdbTransactionMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdbTransactionMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdbTransactionMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbTransactionMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdbTransactionMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdbTransactionMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdbTransactionMetadata_UnserializedMessageContext<
            UserType, IdbTransactionMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdbTransactionMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdbTransactionMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdbTransactionMetadata_UnserializedMessageContext<
            UserType, IdbTransactionMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdbTransactionMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  IdbTransactionMode mode;
  
  IdbTransactionState state;
  
  int64_t tid;
  
  int32_t connection_id;
  
  std::string client_token;
  
  double age;
  
  double runtime;
  
  double tasks_scheduled;
  
  double tasks_completed;
  
  std::vector<::std::u16string> scope;
  
  std::vector<IdbTransactionMetadataStateHistoryPtr> state_history;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdbTransactionMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdbTransactionMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdbTransactionMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdbTransactionMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
IdbOriginMetadataPtr IdbOriginMetadata::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(storage_keys)
  );
}

template <typename T, IdbOriginMetadata::EnableIfSame<T>*>
bool IdbOriginMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->storage_keys, other_struct.storage_keys))
    return false;
  return true;
}

template <typename T, IdbOriginMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.storage_keys < rhs.storage_keys)
    return true;
  if (rhs.storage_keys < lhs.storage_keys)
    return false;
  return false;
}
template <typename StructPtrType>
IdbStorageKeyMetadataPtr IdbStorageKeyMetadata::Clone() const {
  return New(
      mojo::Clone(top_level_site),
      mojo::Clone(serialized_storage_key),
      mojo::Clone(buckets)
  );
}

template <typename T, IdbStorageKeyMetadata::EnableIfSame<T>*>
bool IdbStorageKeyMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_level_site, other_struct.top_level_site))
    return false;
  if (!mojo::Equals(this->serialized_storage_key, other_struct.serialized_storage_key))
    return false;
  if (!mojo::Equals(this->buckets, other_struct.buckets))
    return false;
  return true;
}

template <typename T, IdbStorageKeyMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top_level_site < rhs.top_level_site)
    return true;
  if (rhs.top_level_site < lhs.top_level_site)
    return false;
  if (lhs.serialized_storage_key < rhs.serialized_storage_key)
    return true;
  if (rhs.serialized_storage_key < lhs.serialized_storage_key)
    return false;
  if (lhs.buckets < rhs.buckets)
    return true;
  if (rhs.buckets < lhs.buckets)
    return false;
  return false;
}
template <typename StructPtrType>
IdbBucketMetadataPtr IdbBucketMetadata::Clone() const {
  return New(
      mojo::Clone(bucket_locator),
      mojo::Clone(name),
      mojo::Clone(size),
      mojo::Clone(last_modified),
      mojo::Clone(paths),
      mojo::Clone(connection_count),
      mojo::Clone(databases),
      mojo::Clone(clients),
      mojo::Clone(delta_recording_start_ms)
  );
}

template <typename T, IdbBucketMetadata::EnableIfSame<T>*>
bool IdbBucketMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bucket_locator, other_struct.bucket_locator))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->last_modified, other_struct.last_modified))
    return false;
  if (!mojo::Equals(this->paths, other_struct.paths))
    return false;
  if (!mojo::Equals(this->connection_count, other_struct.connection_count))
    return false;
  if (!mojo::Equals(this->databases, other_struct.databases))
    return false;
  if (!mojo::Equals(this->clients, other_struct.clients))
    return false;
  if (!mojo::Equals(this->delta_recording_start_ms, other_struct.delta_recording_start_ms))
    return false;
  return true;
}

template <typename T, IdbBucketMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bucket_locator < rhs.bucket_locator)
    return true;
  if (rhs.bucket_locator < lhs.bucket_locator)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.last_modified < rhs.last_modified)
    return true;
  if (rhs.last_modified < lhs.last_modified)
    return false;
  if (lhs.paths < rhs.paths)
    return true;
  if (rhs.paths < lhs.paths)
    return false;
  if (lhs.connection_count < rhs.connection_count)
    return true;
  if (rhs.connection_count < lhs.connection_count)
    return false;
  if (lhs.databases < rhs.databases)
    return true;
  if (rhs.databases < lhs.databases)
    return false;
  if (lhs.clients < rhs.clients)
    return true;
  if (rhs.clients < lhs.clients)
    return false;
  if (lhs.delta_recording_start_ms < rhs.delta_recording_start_ms)
    return true;
  if (rhs.delta_recording_start_ms < lhs.delta_recording_start_ms)
    return false;
  return false;
}
template <typename StructPtrType>
IdbDatabaseMetadataPtr IdbDatabaseMetadata::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(connection_count),
      mojo::Clone(active_open_delete),
      mojo::Clone(pending_open_delete),
      mojo::Clone(transactions)
  );
}

template <typename T, IdbDatabaseMetadata::EnableIfSame<T>*>
bool IdbDatabaseMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->connection_count, other_struct.connection_count))
    return false;
  if (!mojo::Equals(this->active_open_delete, other_struct.active_open_delete))
    return false;
  if (!mojo::Equals(this->pending_open_delete, other_struct.pending_open_delete))
    return false;
  if (!mojo::Equals(this->transactions, other_struct.transactions))
    return false;
  return true;
}

template <typename T, IdbDatabaseMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.connection_count < rhs.connection_count)
    return true;
  if (rhs.connection_count < lhs.connection_count)
    return false;
  if (lhs.active_open_delete < rhs.active_open_delete)
    return true;
  if (rhs.active_open_delete < lhs.active_open_delete)
    return false;
  if (lhs.pending_open_delete < rhs.pending_open_delete)
    return true;
  if (rhs.pending_open_delete < lhs.pending_open_delete)
    return false;
  if (lhs.transactions < rhs.transactions)
    return true;
  if (rhs.transactions < lhs.transactions)
    return false;
  return false;
}
template <typename StructPtrType>
IdbTransactionMetadataPtr IdbTransactionMetadata::Clone() const {
  return New(
      mojo::Clone(mode),
      mojo::Clone(state),
      mojo::Clone(tid),
      mojo::Clone(connection_id),
      mojo::Clone(client_token),
      mojo::Clone(age),
      mojo::Clone(runtime),
      mojo::Clone(tasks_scheduled),
      mojo::Clone(tasks_completed),
      mojo::Clone(scope),
      mojo::Clone(state_history)
  );
}

template <typename T, IdbTransactionMetadata::EnableIfSame<T>*>
bool IdbTransactionMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->tid, other_struct.tid))
    return false;
  if (!mojo::Equals(this->connection_id, other_struct.connection_id))
    return false;
  if (!mojo::Equals(this->client_token, other_struct.client_token))
    return false;
  if (!mojo::Equals(this->age, other_struct.age))
    return false;
  if (!mojo::Equals(this->runtime, other_struct.runtime))
    return false;
  if (!mojo::Equals(this->tasks_scheduled, other_struct.tasks_scheduled))
    return false;
  if (!mojo::Equals(this->tasks_completed, other_struct.tasks_completed))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->state_history, other_struct.state_history))
    return false;
  return true;
}

template <typename T, IdbTransactionMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.tid < rhs.tid)
    return true;
  if (rhs.tid < lhs.tid)
    return false;
  if (lhs.connection_id < rhs.connection_id)
    return true;
  if (rhs.connection_id < lhs.connection_id)
    return false;
  if (lhs.client_token < rhs.client_token)
    return true;
  if (rhs.client_token < lhs.client_token)
    return false;
  if (lhs.age < rhs.age)
    return true;
  if (rhs.age < lhs.age)
    return false;
  if (lhs.runtime < rhs.runtime)
    return true;
  if (rhs.runtime < lhs.runtime)
    return false;
  if (lhs.tasks_scheduled < rhs.tasks_scheduled)
    return true;
  if (rhs.tasks_scheduled < lhs.tasks_scheduled)
    return false;
  if (lhs.tasks_completed < rhs.tasks_completed)
    return true;
  if (rhs.tasks_completed < lhs.tasks_completed)
    return false;
  if (lhs.scope < rhs.scope)
    return true;
  if (rhs.scope < lhs.scope)
    return false;
  if (lhs.state_history < rhs.state_history)
    return true;
  if (rhs.state_history < lhs.state_history)
    return false;
  return false;
}
template <typename StructPtrType>
IdbTransactionMetadataStateHistoryPtr IdbTransactionMetadataStateHistory::Clone() const {
  return New(
      mojo::Clone(state),
      mojo::Clone(duration)
  );
}

template <typename T, IdbTransactionMetadataStateHistory::EnableIfSame<T>*>
bool IdbTransactionMetadataStateHistory::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  return true;
}

template <typename T, IdbTransactionMetadataStateHistory::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::IdbOriginMetadata::DataView,
                                         ::storage::mojom::IdbOriginMetadataPtr> {
  static bool IsNull(const ::storage::mojom::IdbOriginMetadataPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::IdbOriginMetadataPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::IdbOriginMetadata::origin)& origin(
      const ::storage::mojom::IdbOriginMetadataPtr& input) {
    return input->origin;
  }

  static const decltype(::storage::mojom::IdbOriginMetadata::storage_keys)& storage_keys(
      const ::storage::mojom::IdbOriginMetadataPtr& input) {
    return input->storage_keys;
  }

  static bool Read(::storage::mojom::IdbOriginMetadata::DataView input, ::storage::mojom::IdbOriginMetadataPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::IdbStorageKeyMetadata::DataView,
                                         ::storage::mojom::IdbStorageKeyMetadataPtr> {
  static bool IsNull(const ::storage::mojom::IdbStorageKeyMetadataPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::IdbStorageKeyMetadataPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::IdbStorageKeyMetadata::top_level_site)& top_level_site(
      const ::storage::mojom::IdbStorageKeyMetadataPtr& input) {
    return input->top_level_site;
  }

  static const decltype(::storage::mojom::IdbStorageKeyMetadata::serialized_storage_key)& serialized_storage_key(
      const ::storage::mojom::IdbStorageKeyMetadataPtr& input) {
    return input->serialized_storage_key;
  }

  static const decltype(::storage::mojom::IdbStorageKeyMetadata::buckets)& buckets(
      const ::storage::mojom::IdbStorageKeyMetadataPtr& input) {
    return input->buckets;
  }

  static bool Read(::storage::mojom::IdbStorageKeyMetadata::DataView input, ::storage::mojom::IdbStorageKeyMetadataPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::IdbBucketMetadata::DataView,
                                         ::storage::mojom::IdbBucketMetadataPtr> {
  static bool IsNull(const ::storage::mojom::IdbBucketMetadataPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::IdbBucketMetadataPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::IdbBucketMetadata::bucket_locator)& bucket_locator(
      const ::storage::mojom::IdbBucketMetadataPtr& input) {
    return input->bucket_locator;
  }

  static const decltype(::storage::mojom::IdbBucketMetadata::name)& name(
      const ::storage::mojom::IdbBucketMetadataPtr& input) {
    return input->name;
  }

  static decltype(::storage::mojom::IdbBucketMetadata::size) size(
      const ::storage::mojom::IdbBucketMetadataPtr& input) {
    return input->size;
  }

  static const decltype(::storage::mojom::IdbBucketMetadata::last_modified)& last_modified(
      const ::storage::mojom::IdbBucketMetadataPtr& input) {
    return input->last_modified;
  }

  static const decltype(::storage::mojom::IdbBucketMetadata::paths)& paths(
      const ::storage::mojom::IdbBucketMetadataPtr& input) {
    return input->paths;
  }

  static decltype(::storage::mojom::IdbBucketMetadata::connection_count) connection_count(
      const ::storage::mojom::IdbBucketMetadataPtr& input) {
    return input->connection_count;
  }

  static const decltype(::storage::mojom::IdbBucketMetadata::databases)& databases(
      const ::storage::mojom::IdbBucketMetadataPtr& input) {
    return input->databases;
  }

  static const decltype(::storage::mojom::IdbBucketMetadata::clients)& clients(
      const ::storage::mojom::IdbBucketMetadataPtr& input) {
    return input->clients;
  }

  static decltype(::storage::mojom::IdbBucketMetadata::delta_recording_start_ms) delta_recording_start_ms(
      const ::storage::mojom::IdbBucketMetadataPtr& input) {
    return input->delta_recording_start_ms;
  }

  static bool Read(::storage::mojom::IdbBucketMetadata::DataView input, ::storage::mojom::IdbBucketMetadataPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::IdbDatabaseMetadata::DataView,
                                         ::storage::mojom::IdbDatabaseMetadataPtr> {
  static bool IsNull(const ::storage::mojom::IdbDatabaseMetadataPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::IdbDatabaseMetadataPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::IdbDatabaseMetadata::name)& name(
      const ::storage::mojom::IdbDatabaseMetadataPtr& input) {
    return input->name;
  }

  static decltype(::storage::mojom::IdbDatabaseMetadata::connection_count) connection_count(
      const ::storage::mojom::IdbDatabaseMetadataPtr& input) {
    return input->connection_count;
  }

  static decltype(::storage::mojom::IdbDatabaseMetadata::active_open_delete) active_open_delete(
      const ::storage::mojom::IdbDatabaseMetadataPtr& input) {
    return input->active_open_delete;
  }

  static decltype(::storage::mojom::IdbDatabaseMetadata::pending_open_delete) pending_open_delete(
      const ::storage::mojom::IdbDatabaseMetadataPtr& input) {
    return input->pending_open_delete;
  }

  static const decltype(::storage::mojom::IdbDatabaseMetadata::transactions)& transactions(
      const ::storage::mojom::IdbDatabaseMetadataPtr& input) {
    return input->transactions;
  }

  static bool Read(::storage::mojom::IdbDatabaseMetadata::DataView input, ::storage::mojom::IdbDatabaseMetadataPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::IdbTransactionMetadata::DataView,
                                         ::storage::mojom::IdbTransactionMetadataPtr> {
  static bool IsNull(const ::storage::mojom::IdbTransactionMetadataPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::IdbTransactionMetadataPtr* output) { output->reset(); }

  static decltype(::storage::mojom::IdbTransactionMetadata::mode) mode(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->mode;
  }

  static decltype(::storage::mojom::IdbTransactionMetadata::state) state(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->state;
  }

  static decltype(::storage::mojom::IdbTransactionMetadata::tid) tid(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->tid;
  }

  static decltype(::storage::mojom::IdbTransactionMetadata::connection_id) connection_id(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->connection_id;
  }

  static const decltype(::storage::mojom::IdbTransactionMetadata::client_token)& client_token(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->client_token;
  }

  static decltype(::storage::mojom::IdbTransactionMetadata::age) age(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->age;
  }

  static decltype(::storage::mojom::IdbTransactionMetadata::runtime) runtime(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->runtime;
  }

  static decltype(::storage::mojom::IdbTransactionMetadata::tasks_scheduled) tasks_scheduled(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->tasks_scheduled;
  }

  static decltype(::storage::mojom::IdbTransactionMetadata::tasks_completed) tasks_completed(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->tasks_completed;
  }

  static const decltype(::storage::mojom::IdbTransactionMetadata::scope)& scope(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->scope;
  }

  static const decltype(::storage::mojom::IdbTransactionMetadata::state_history)& state_history(
      const ::storage::mojom::IdbTransactionMetadataPtr& input) {
    return input->state_history;
  }

  static bool Read(::storage::mojom::IdbTransactionMetadata::DataView input, ::storage::mojom::IdbTransactionMetadataPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::IdbTransactionMetadataStateHistory::DataView,
                                         ::storage::mojom::IdbTransactionMetadataStateHistoryPtr> {
  static bool IsNull(const ::storage::mojom::IdbTransactionMetadataStateHistoryPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::IdbTransactionMetadataStateHistoryPtr* output) { output->reset(); }

  static decltype(::storage::mojom::IdbTransactionMetadataStateHistory::state) state(
      const ::storage::mojom::IdbTransactionMetadataStateHistoryPtr& input) {
    return input->state;
  }

  static decltype(::storage::mojom::IdbTransactionMetadataStateHistory::duration) duration(
      const ::storage::mojom::IdbTransactionMetadataStateHistoryPtr& input) {
    return input->duration;
  }

  static bool Read(::storage::mojom::IdbTransactionMetadataStateHistory::DataView input, ::storage::mojom::IdbTransactionMetadataStateHistoryPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_H_