// components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared-internal.h"
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-shared.h"
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"




#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-data-view.h"




namespace std {

template <>
struct hash<::storage::mojom::IdbTransactionMode>
    : public mojo::internal::EnumHashImpl<::storage::mojom::IdbTransactionMode> {};

template <>
struct hash<::storage::mojom::IdbTransactionState>
    : public mojo::internal::EnumHashImpl<::storage::mojom::IdbTransactionState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IdbTransactionMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::IdbTransactionMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::IdbTransactionMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IdbTransactionState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::IdbTransactionState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::storage::mojom::IdbTransactionState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IdbOriginMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbOriginMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbOriginMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in IdbOriginMetadata struct");

    decltype(Traits::storage_keys(input)) in_storage_keys = Traits::storage_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->storage_keys)::BaseType>
        storage_keys_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& storage_keys_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbStorageKeyMetadataDataView>>(
      in_storage_keys,
      storage_keys_fragment,
      &storage_keys_validate_params);

    fragment->storage_keys.Set(
        storage_keys_fragment.is_null() ? nullptr : storage_keys_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->storage_keys.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_keys in IdbOriginMetadata struct");
  }

  static bool Deserialize(::storage::mojom::internal::IdbOriginMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::IdbOriginMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IdbStorageKeyMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbStorageKeyMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbStorageKeyMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::top_level_site(input)) in_top_level_site = Traits::top_level_site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_level_site)::BaseType> top_level_site_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
      in_top_level_site,
      top_level_site_fragment);

    fragment->top_level_site.Set(
        top_level_site_fragment.is_null() ? nullptr : top_level_site_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->top_level_site.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_level_site in IdbStorageKeyMetadata struct");

    decltype(Traits::serialized_storage_key(input)) in_serialized_storage_key = Traits::serialized_storage_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serialized_storage_key)::BaseType> serialized_storage_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_serialized_storage_key,
      serialized_storage_key_fragment);

    fragment->serialized_storage_key.Set(
        serialized_storage_key_fragment.is_null() ? nullptr : serialized_storage_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->serialized_storage_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serialized_storage_key in IdbStorageKeyMetadata struct");

    decltype(Traits::buckets(input)) in_buckets = Traits::buckets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buckets)::BaseType>
        buckets_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& buckets_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbBucketMetadataDataView>>(
      in_buckets,
      buckets_fragment,
      &buckets_validate_params);

    fragment->buckets.Set(
        buckets_fragment.is_null() ? nullptr : buckets_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->buckets.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buckets in IdbStorageKeyMetadata struct");
  }

  static bool Deserialize(::storage::mojom::internal::IdbStorageKeyMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::IdbStorageKeyMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IdbBucketMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbBucketMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbBucketMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bucket_locator(input)) in_bucket_locator = Traits::bucket_locator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bucket_locator)::BaseType> bucket_locator_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
      in_bucket_locator,
      bucket_locator_fragment);

    fragment->bucket_locator.Set(
        bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bucket_locator.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket_locator in IdbBucketMetadata struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IdbBucketMetadata struct");

    fragment->size = Traits::size(input);

    decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_modified,
      last_modified_fragment);

    fragment->last_modified.Set(
        last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_modified.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_modified in IdbBucketMetadata struct");

    decltype(Traits::paths(input)) in_paths = Traits::paths(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->paths)::BaseType>
        paths_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& paths_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
      in_paths,
      paths_fragment,
      &paths_validate_params);

    fragment->paths.Set(
        paths_fragment.is_null() ? nullptr : paths_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->paths.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null paths in IdbBucketMetadata struct");

    fragment->connection_count = Traits::connection_count(input);

    decltype(Traits::databases(input)) in_databases = Traits::databases(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->databases)::BaseType>
        databases_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& databases_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbDatabaseMetadataDataView>>(
      in_databases,
      databases_fragment,
      &databases_validate_params);

    fragment->databases.Set(
        databases_fragment.is_null() ? nullptr : databases_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->databases.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null databases in IdbBucketMetadata struct");

    decltype(Traits::clients(input)) in_clients = Traits::clients(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->clients)::BaseType>
        clients_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& clients_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::BucketClientInfoDataView>>(
      in_clients,
      clients_fragment,
      &clients_validate_params);

    fragment->clients.Set(
        clients_fragment.is_null() ? nullptr : clients_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->clients.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null clients in IdbBucketMetadata struct");

    fragment->delta_recording_start_ms = Traits::delta_recording_start_ms(input);
  }

  static bool Deserialize(::storage::mojom::internal::IdbBucketMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::IdbBucketMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IdbDatabaseMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbDatabaseMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbDatabaseMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IdbDatabaseMetadata struct");

    fragment->connection_count = Traits::connection_count(input);

    fragment->active_open_delete = Traits::active_open_delete(input);

    fragment->pending_open_delete = Traits::pending_open_delete(input);

    decltype(Traits::transactions(input)) in_transactions = Traits::transactions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transactions)::BaseType>
        transactions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& transactions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbTransactionMetadataDataView>>(
      in_transactions,
      transactions_fragment,
      &transactions_validate_params);

    fragment->transactions.Set(
        transactions_fragment.is_null() ? nullptr : transactions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transactions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transactions in IdbDatabaseMetadata struct");
  }

  static bool Deserialize(::storage::mojom::internal::IdbDatabaseMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::IdbDatabaseMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IdbTransactionMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbTransactionMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbTransactionMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::storage::mojom::IdbTransactionMode>(
      Traits::mode(input),
      &fragment->mode);

    
    mojo::internal::Serialize<::storage::mojom::IdbTransactionState>(
      Traits::state(input),
      &fragment->state);

    fragment->tid = Traits::tid(input);

    fragment->connection_id = Traits::connection_id(input);

    decltype(Traits::client_token(input)) in_client_token = Traits::client_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_token)::BaseType> client_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_client_token,
      client_token_fragment);

    fragment->client_token.Set(
        client_token_fragment.is_null() ? nullptr : client_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_token in IdbTransactionMetadata struct");

    fragment->age = Traits::age(input);

    fragment->runtime = Traits::runtime(input);

    fragment->tasks_scheduled = Traits::tasks_scheduled(input);

    fragment->tasks_completed = Traits::tasks_completed(input);

    decltype(Traits::scope(input)) in_scope = Traits::scope(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scope)::BaseType>
        scope_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& scope_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_scope,
      scope_fragment,
      &scope_validate_params);

    fragment->scope.Set(
        scope_fragment.is_null() ? nullptr : scope_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scope.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scope in IdbTransactionMetadata struct");

    decltype(Traits::state_history(input)) in_state_history = Traits::state_history(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->state_history)::BaseType>
        state_history_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& state_history_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbTransactionMetadataStateHistoryDataView>>(
      in_state_history,
      state_history_fragment,
      &state_history_validate_params);

    fragment->state_history.Set(
        state_history_fragment.is_null() ? nullptr : state_history_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->state_history.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state_history in IdbTransactionMetadata struct");
  }

  static bool Deserialize(::storage::mojom::internal::IdbTransactionMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::IdbTransactionMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::IdbTransactionMetadataStateHistoryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::IdbTransactionMetadataStateHistoryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::storage::mojom::internal::IdbTransactionMetadataStateHistory_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::storage::mojom::IdbTransactionState>(
      Traits::state(input),
      &fragment->state);

    fragment->duration = Traits::duration(input);
  }

  static bool Deserialize(::storage::mojom::internal::IdbTransactionMetadataStateHistory_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::IdbTransactionMetadataStateHistoryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage::mojom {

inline void IdbOriginMetadataDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void IdbOriginMetadataDataView::GetStorageKeysDataView(
    mojo::ArrayDataView<IdbStorageKeyMetadataDataView>* output) {
  auto pointer = data_->storage_keys.Get();
  *output = mojo::ArrayDataView<IdbStorageKeyMetadataDataView>(pointer, message_);
}


inline void IdbStorageKeyMetadataDataView::GetTopLevelSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->top_level_site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}
inline void IdbStorageKeyMetadataDataView::GetSerializedStorageKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->serialized_storage_key.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdbStorageKeyMetadataDataView::GetBucketsDataView(
    mojo::ArrayDataView<IdbBucketMetadataDataView>* output) {
  auto pointer = data_->buckets.Get();
  *output = mojo::ArrayDataView<IdbBucketMetadataDataView>(pointer, message_);
}


inline void IdbBucketMetadataDataView::GetBucketLocatorDataView(
    ::storage::mojom::BucketLocatorDataView* output) {
  auto pointer = data_->bucket_locator.Get();
  *output = ::storage::mojom::BucketLocatorDataView(pointer, message_);
}
inline void IdbBucketMetadataDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdbBucketMetadataDataView::GetLastModifiedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_modified.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void IdbBucketMetadataDataView::GetPathsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output) {
  auto pointer = data_->paths.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>(pointer, message_);
}
inline void IdbBucketMetadataDataView::GetDatabasesDataView(
    mojo::ArrayDataView<IdbDatabaseMetadataDataView>* output) {
  auto pointer = data_->databases.Get();
  *output = mojo::ArrayDataView<IdbDatabaseMetadataDataView>(pointer, message_);
}
inline void IdbBucketMetadataDataView::GetClientsDataView(
    mojo::ArrayDataView<::storage::mojom::BucketClientInfoDataView>* output) {
  auto pointer = data_->clients.Get();
  *output = mojo::ArrayDataView<::storage::mojom::BucketClientInfoDataView>(pointer, message_);
}


inline void IdbDatabaseMetadataDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void IdbDatabaseMetadataDataView::GetTransactionsDataView(
    mojo::ArrayDataView<IdbTransactionMetadataDataView>* output) {
  auto pointer = data_->transactions.Get();
  *output = mojo::ArrayDataView<IdbTransactionMetadataDataView>(pointer, message_);
}


inline void IdbTransactionMetadataDataView::GetClientTokenDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->client_token.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IdbTransactionMetadataDataView::GetScopeDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->scope.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void IdbTransactionMetadataDataView::GetStateHistoryDataView(
    mojo::ArrayDataView<IdbTransactionMetadataStateHistoryDataView>* output) {
  auto pointer = data_->state_history.Get();
  *output = mojo::ArrayDataView<IdbTransactionMetadataStateHistoryDataView>(pointer, message_);
}





}  // storage::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::storage::mojom::IdbTransactionMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::IdbTransactionMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::storage::mojom::IdbTransactionState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::storage::mojom::IdbTransactionState value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_SHARED_H_