// components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared-internal.h"
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-shared.h"
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"


namespace storage::mojom {
class IdbOriginMetadataDataView;

class IdbStorageKeyMetadataDataView;

class IdbBucketMetadataDataView;

class IdbDatabaseMetadataDataView;

class IdbTransactionMetadataDataView;

class IdbTransactionMetadataStateHistoryDataView;



}  // storage::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::IdbOriginMetadataDataView> {
  using Data = ::storage::mojom::internal::IdbOriginMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::IdbStorageKeyMetadataDataView> {
  using Data = ::storage::mojom::internal::IdbStorageKeyMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::IdbBucketMetadataDataView> {
  using Data = ::storage::mojom::internal::IdbBucketMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::IdbDatabaseMetadataDataView> {
  using Data = ::storage::mojom::internal::IdbDatabaseMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::IdbTransactionMetadataDataView> {
  using Data = ::storage::mojom::internal::IdbTransactionMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::IdbTransactionMetadataStateHistoryDataView> {
  using Data = ::storage::mojom::internal::IdbTransactionMetadataStateHistory_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage::mojom {


enum class IdbTransactionMode : int32_t {
  
  kReadOnly = 0,
  
  kReadWrite = 1,
  
  kVersionChange = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, IdbTransactionMode value);
inline bool IsKnownEnumValue(IdbTransactionMode value) {
  return internal::IdbTransactionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IdbTransactionState : int32_t {
  
  kBlocked = 0,
  
  kRunning = 1,
  
  kStarted = 2,
  
  kCommitting = 3,
  
  kFinished = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, IdbTransactionState value);
inline bool IsKnownEnumValue(IdbTransactionState value) {
  return internal::IdbTransactionState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class IdbOriginMetadataDataView {
 public:
  IdbOriginMetadataDataView() = default;

  IdbOriginMetadataDataView(
      internal::IdbOriginMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetStorageKeysDataView(
      mojo::ArrayDataView<IdbStorageKeyMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStorageKeys(UserType* output) {
    
    auto* pointer = data_->storage_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::storage::mojom::IdbStorageKeyMetadataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::IdbOriginMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IdbStorageKeyMetadataDataView {
 public:
  IdbStorageKeyMetadataDataView() = default;

  IdbStorageKeyMetadataDataView(
      internal::IdbStorageKeyMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTopLevelSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelSite(UserType* output) {
    
    auto* pointer = data_->top_level_site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  inline void GetSerializedStorageKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerializedStorageKey(UserType* output) {
    
    auto* pointer = data_->serialized_storage_key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBucketsDataView(
      mojo::ArrayDataView<IdbBucketMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBuckets(UserType* output) {
    
    auto* pointer = data_->buckets.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::storage::mojom::IdbBucketMetadataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::IdbStorageKeyMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IdbBucketMetadataDataView {
 public:
  IdbBucketMetadataDataView() = default;

  IdbBucketMetadataDataView(
      internal::IdbBucketMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBucketLocatorDataView(
      ::storage::mojom::BucketLocatorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBucketLocator(UserType* output) {
    
    auto* pointer = data_->bucket_locator.Get();
    return mojo::internal::Deserialize<::storage::mojom::BucketLocatorDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint64_t size() const {
    return data_->size;
  }
  inline void GetLastModifiedDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastModified(UserType* output) {
    
    auto* pointer = data_->last_modified.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetPathsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaths(UserType* output) {
    
    auto* pointer = data_->paths.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
        pointer, output, message_);
  }
  uint64_t connection_count() const {
    return data_->connection_count;
  }
  inline void GetDatabasesDataView(
      mojo::ArrayDataView<IdbDatabaseMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDatabases(UserType* output) {
    
    auto* pointer = data_->databases.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::storage::mojom::IdbDatabaseMetadataDataView>>(
        pointer, output, message_);
  }
  inline void GetClientsDataView(
      mojo::ArrayDataView<::storage::mojom::BucketClientInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClients(UserType* output) {
    
    auto* pointer = data_->clients.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::storage::mojom::BucketClientInfoDataView>>(
        pointer, output, message_);
  }
  uint64_t delta_recording_start_ms() const {
    return data_->delta_recording_start_ms;
  }
 private:
  internal::IdbBucketMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IdbDatabaseMetadataDataView {
 public:
  IdbDatabaseMetadataDataView() = default;

  IdbDatabaseMetadataDataView(
      internal::IdbDatabaseMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  uint64_t connection_count() const {
    return data_->connection_count;
  }
  uint64_t active_open_delete() const {
    return data_->active_open_delete;
  }
  uint64_t pending_open_delete() const {
    return data_->pending_open_delete;
  }
  inline void GetTransactionsDataView(
      mojo::ArrayDataView<IdbTransactionMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransactions(UserType* output) {
    
    auto* pointer = data_->transactions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::storage::mojom::IdbTransactionMetadataDataView>>(
        pointer, output, message_);
  }
 private:
  internal::IdbDatabaseMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IdbTransactionMetadataDataView {
 public:
  IdbTransactionMetadataDataView() = default;

  IdbTransactionMetadataDataView(
      internal::IdbTransactionMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::storage::mojom::IdbTransactionMode>(
        data_value, output);
  }
  IdbTransactionMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::storage::mojom::IdbTransactionMode>(data_->mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::storage::mojom::IdbTransactionState>(
        data_value, output);
  }
  IdbTransactionState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::storage::mojom::IdbTransactionState>(data_->state));
  }
  int64_t tid() const {
    return data_->tid;
  }
  int32_t connection_id() const {
    return data_->connection_id;
  }
  inline void GetClientTokenDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientToken(UserType* output) {
    
    auto* pointer = data_->client_token.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double age() const {
    return data_->age;
  }
  double runtime() const {
    return data_->runtime;
  }
  double tasks_scheduled() const {
    return data_->tasks_scheduled;
  }
  double tasks_completed() const {
    return data_->tasks_completed;
  }
  inline void GetScopeDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScope(UserType* output) {
    
    auto* pointer = data_->scope.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetStateHistoryDataView(
      mojo::ArrayDataView<IdbTransactionMetadataStateHistoryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStateHistory(UserType* output) {
    
    auto* pointer = data_->state_history.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::storage::mojom::IdbTransactionMetadataStateHistoryDataView>>(
        pointer, output, message_);
  }
 private:
  internal::IdbTransactionMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class IdbTransactionMetadataStateHistoryDataView {
 public:
  IdbTransactionMetadataStateHistoryDataView() = default;

  IdbTransactionMetadataStateHistoryDataView(
      internal::IdbTransactionMetadataStateHistory_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::storage::mojom::IdbTransactionState>(
        data_value, output);
  }
  IdbTransactionState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::storage::mojom::IdbTransactionState>(data_->state));
  }
  double duration() const {
    return data_->duration;
  }
 private:
  internal::IdbTransactionMetadataStateHistory_Data* data_ = nullptr;
};


}  // storage::mojom

#endif  // COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_INDEXED_DB_INTERNALS_TYPES_MOJOM_DATA_VIEW_H_