// components/services/storage/privileged/mojom/bucket_client_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_BUCKET_CLIENT_INFO_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_BUCKET_CLIENT_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/privileged/mojom/bucket_client_info.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>




#include "components/services/storage/privileged/mojom/bucket_client_info_mojom_traits.h"




namespace storage::mojom {








class  BucketClientInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BucketClientInfo, T>::value>;
  using DataView = BucketClientInfoDataView;
  using Data_ = internal::BucketClientInfo_Data;

  template <typename... Args>
  static BucketClientInfoPtr New(Args&&... args) {
    return BucketClientInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BucketClientInfoPtr From(const U& u) {
    return mojo::TypeConverter<BucketClientInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BucketClientInfo>::Convert(*this);
  }


  BucketClientInfo();

  BucketClientInfo(
      int32_t process_id,
      const ::blink::ExecutionContextToken& context_token,
      const std::optional<::blink::DocumentToken>& document_token);


  ~BucketClientInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BucketClientInfoPtr>
  BucketClientInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BucketClientInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BucketClientInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BucketClientInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BucketClientInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BucketClientInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BucketClientInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BucketClientInfo_UnserializedMessageContext<
            UserType, BucketClientInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BucketClientInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BucketClientInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BucketClientInfo_UnserializedMessageContext<
            UserType, BucketClientInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BucketClientInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t process_id;
  
  ::blink::ExecutionContextToken context_token;
  
  std::optional<::blink::DocumentToken> document_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BucketClientInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BucketClientInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BucketClientInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BucketClientInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BucketClientInfoPtr BucketClientInfo::Clone() const {
  return New(
      mojo::Clone(process_id),
      mojo::Clone(context_token),
      mojo::Clone(document_token)
  );
}

template <typename T, BucketClientInfo::EnableIfSame<T>*>
bool BucketClientInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->process_id, other_struct.process_id))
    return false;
  if (!mojo::Equals(this->context_token, other_struct.context_token))
    return false;
  if (!mojo::Equals(this->document_token, other_struct.document_token))
    return false;
  return true;
}

template <typename T, BucketClientInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.process_id < rhs.process_id)
    return true;
  if (rhs.process_id < lhs.process_id)
    return false;
  if (lhs.context_token < rhs.context_token)
    return true;
  if (rhs.context_token < lhs.context_token)
    return false;
  if (lhs.document_token < rhs.document_token)
    return true;
  if (rhs.document_token < lhs.document_token)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::BucketClientInfo::DataView,
                                         ::storage::mojom::BucketClientInfoPtr> {
  static bool IsNull(const ::storage::mojom::BucketClientInfoPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::BucketClientInfoPtr* output) { output->reset(); }

  static decltype(::storage::mojom::BucketClientInfo::process_id) process_id(
      const ::storage::mojom::BucketClientInfoPtr& input) {
    return input->process_id;
  }

  static const decltype(::storage::mojom::BucketClientInfo::context_token)& context_token(
      const ::storage::mojom::BucketClientInfoPtr& input) {
    return input->context_token;
  }

  static const decltype(::storage::mojom::BucketClientInfo::document_token)& document_token(
      const ::storage::mojom::BucketClientInfoPtr& input) {
    return input->document_token;
  }

  static bool Read(::storage::mojom::BucketClientInfo::DataView input, ::storage::mojom::BucketClientInfoPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PRIVILEGED_MOJOM_BUCKET_CLIENT_INFO_MOJOM_H_