// components/services/quarantine/public/mojom/quarantine.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace quarantine::mojom {
namespace internal {
class  Quarantine_QuarantineFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> full_path;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> source_url;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> referrer_url;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> request_initiator;
  mojo::internal::Pointer<mojo::internal::String_Data> client_guid;

 private:
  friend class mojo::internal::MessageFragment<Quarantine_QuarantineFile_Params_Data>;

  Quarantine_QuarantineFile_Params_Data();
  ~Quarantine_QuarantineFile_Params_Data() = delete;
};
static_assert(sizeof(Quarantine_QuarantineFile_Params_Data) == 48,
              "Bad sizeof(Quarantine_QuarantineFile_Params_Data)");
class  Quarantine_QuarantineFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<Quarantine_QuarantineFile_ResponseParams_Data>;

  Quarantine_QuarantineFile_ResponseParams_Data();
  ~Quarantine_QuarantineFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(Quarantine_QuarantineFile_ResponseParams_Data) == 16,
              "Bad sizeof(Quarantine_QuarantineFile_ResponseParams_Data)");

}  // namespace internal


class Quarantine_QuarantineFile_ParamsDataView {
 public:
  Quarantine_QuarantineFile_ParamsDataView() = default;

  Quarantine_QuarantineFile_ParamsDataView(
      internal::Quarantine_QuarantineFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFullPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFullPath(UserType* output) {
    
    auto* pointer = data_->full_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetSourceUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceUrl(UserType* output) {
    
    auto* pointer = data_->source_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrerUrl(UserType* output) {
    
    auto* pointer = data_->referrer_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetRequestInitiatorDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestInitiator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `request_initiator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestInitiator` instead "
    "of `ReadRequestInitiator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_initiator.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetClientGuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientGuid(UserType* output) {
    
    auto* pointer = data_->client_guid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Quarantine_QuarantineFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Quarantine_QuarantineFile_ResponseParamsDataView {
 public:
  Quarantine_QuarantineFile_ResponseParamsDataView() = default;

  Quarantine_QuarantineFile_ResponseParamsDataView(
      internal::Quarantine_QuarantineFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::quarantine::mojom::QuarantineFileResult>(
        data_value, output);
  }
  QuarantineFileResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::quarantine::mojom::QuarantineFileResult>(data_->result));
  }
 private:
  internal::Quarantine_QuarantineFile_ResponseParams_Data* data_ = nullptr;
};

inline void Quarantine_QuarantineFile_ParamsDataView::GetFullPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->full_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void Quarantine_QuarantineFile_ParamsDataView::GetSourceUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->source_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void Quarantine_QuarantineFile_ParamsDataView::GetReferrerUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->referrer_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void Quarantine_QuarantineFile_ParamsDataView::GetRequestInitiatorDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->request_initiator.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void Quarantine_QuarantineFile_ParamsDataView::GetClientGuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->client_guid.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // quarantine::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_PARAMS_DATA_H_