// components/services/print_compositor/public/mojom/print_compositor.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/print_compositor/public/mojom/print_compositor.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/print_compositor/public/mojom/print_compositor.mojom-params-data.h"
namespace printing {
namespace mojom {

NOINLINE static const char* PrintCompositor_StatusToStringHelper(PrintCompositor_Status value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PrintCompositor_Status::kSuccess:
      return "kSuccess";
    case PrintCompositor_Status::kHandleMapError:
      return "kHandleMapError";
    case PrintCompositor_Status::kContentFormatError:
      return "kContentFormatError";
    case PrintCompositor_Status::kCompositingFailure:
      return "kCompositingFailure";
    default:
      return nullptr;
  }
}

std::string PrintCompositor_StatusToString(PrintCompositor_Status value) {
  const char *str = PrintCompositor_StatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PrintCompositor_Status value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PrintCompositor_Status value) {
  return os << PrintCompositor_StatusToString(value);
}

NOINLINE static const char* PrintCompositor_DocumentTypeToStringHelper(PrintCompositor_DocumentType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PrintCompositor_DocumentType::kPDF:
      return "kPDF";
    case PrintCompositor_DocumentType::kXPS:
      return "kXPS";
    default:
      return nullptr;
  }
}

std::string PrintCompositor_DocumentTypeToString(PrintCompositor_DocumentType value) {
  const char *str = PrintCompositor_DocumentTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PrintCompositor_DocumentType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PrintCompositor_DocumentType value) {
  return os << PrintCompositor_DocumentTypeToString(value);
}

namespace internal {


// static
bool PrintCompositor_NotifyUnavailableSubframe_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_NotifyUnavailableSubframe_Params_Data* object =
      static_cast<const PrintCompositor_NotifyUnavailableSubframe_Params_Data*>(data);

  return true;
}

PrintCompositor_NotifyUnavailableSubframe_Params_Data::PrintCompositor_NotifyUnavailableSubframe_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_AddSubframeContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_AddSubframeContent_Params_Data* object =
      static_cast<const PrintCompositor_AddSubframeContent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_content, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->serialized_content, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframe_content_info, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subframe_content_info_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->subframe_content_info, validation_context,
                                         &subframe_content_info_validate_params)) {
    return false;
  }

  return true;
}

PrintCompositor_AddSubframeContent_Params_Data::PrintCompositor_AddSubframeContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_SetAccessibilityTree_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_SetAccessibilityTree_Params_Data* object =
      static_cast<const PrintCompositor_SetAccessibilityTree_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accessibility_tree, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->accessibility_tree, validation_context))
    return false;

  return true;
}

PrintCompositor_SetAccessibilityTree_Params_Data::PrintCompositor_SetAccessibilityTree_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_CompositePage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_CompositePage_Params_Data* object =
      static_cast<const PrintCompositor_CompositePage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sk_region, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sk_region, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframe_content_info, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subframe_content_info_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->subframe_content_info, validation_context,
                                         &subframe_content_info_validate_params)) {
    return false;
  }

  return true;
}

PrintCompositor_CompositePage_Params_Data::PrintCompositor_CompositePage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_CompositePage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_CompositePage_ResponseParams_Data* object =
      static_cast<const PrintCompositor_CompositePage_ResponseParams_Data*>(data);


  if (!::printing::mojom::internal::PrintCompositor_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->document_region, validation_context))
    return false;

  return true;
}

PrintCompositor_CompositePage_ResponseParams_Data::PrintCompositor_CompositePage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_CompositeDocument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_CompositeDocument_Params_Data* object =
      static_cast<const PrintCompositor_CompositeDocument_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sk_region, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sk_region, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframe_content_info, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subframe_content_info_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->subframe_content_info, validation_context,
                                         &subframe_content_info_validate_params)) {
    return false;
  }


  if (!::printing::mojom::internal::PrintCompositor_DocumentType_Data
        ::Validate(object->document_type, validation_context))
    return false;

  return true;
}

PrintCompositor_CompositeDocument_Params_Data::PrintCompositor_CompositeDocument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_CompositeDocument_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_CompositeDocument_ResponseParams_Data* object =
      static_cast<const PrintCompositor_CompositeDocument_ResponseParams_Data*>(data);


  if (!::printing::mojom::internal::PrintCompositor_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->document_region, validation_context))
    return false;

  return true;
}

PrintCompositor_CompositeDocument_ResponseParams_Data::PrintCompositor_CompositeDocument_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_PrepareToCompositeDocument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_PrepareToCompositeDocument_Params_Data* object =
      static_cast<const PrintCompositor_PrepareToCompositeDocument_Params_Data*>(data);


  if (!::printing::mojom::internal::PrintCompositor_DocumentType_Data
        ::Validate(object->document_type, validation_context))
    return false;

  return true;
}

PrintCompositor_PrepareToCompositeDocument_Params_Data::PrintCompositor_PrepareToCompositeDocument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_PrepareToCompositeDocument_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_PrepareToCompositeDocument_ResponseParams_Data* object =
      static_cast<const PrintCompositor_PrepareToCompositeDocument_ResponseParams_Data*>(data);


  if (!::printing::mojom::internal::PrintCompositor_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

PrintCompositor_PrepareToCompositeDocument_ResponseParams_Data::PrintCompositor_PrepareToCompositeDocument_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_FinishDocumentComposition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_FinishDocumentComposition_Params_Data* object =
      static_cast<const PrintCompositor_FinishDocumentComposition_Params_Data*>(data);

  return true;
}

PrintCompositor_FinishDocumentComposition_Params_Data::PrintCompositor_FinishDocumentComposition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_FinishDocumentComposition_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_FinishDocumentComposition_ResponseParams_Data* object =
      static_cast<const PrintCompositor_FinishDocumentComposition_ResponseParams_Data*>(data);


  if (!::printing::mojom::internal::PrintCompositor_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->document_region, validation_context))
    return false;

  return true;
}

PrintCompositor_FinishDocumentComposition_ResponseParams_Data::PrintCompositor_FinishDocumentComposition_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_SetWebContentsURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_SetWebContentsURL_Params_Data* object =
      static_cast<const PrintCompositor_SetWebContentsURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PrintCompositor_SetWebContentsURL_Params_Data::PrintCompositor_SetWebContentsURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_SetUserAgent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_SetUserAgent_Params_Data* object =
      static_cast<const PrintCompositor_SetUserAgent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_agent, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_agent_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_agent, validation_context,
                                         &user_agent_validate_params)) {
    return false;
  }

  return true;
}

PrintCompositor_SetUserAgent_Params_Data::PrintCompositor_SetUserAgent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_SetGenerateDocumentOutline_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_SetGenerateDocumentOutline_Params_Data* object =
      static_cast<const PrintCompositor_SetGenerateDocumentOutline_Params_Data*>(data);


  if (!::printing::mojom::internal::GenerateDocumentOutline_Data
        ::Validate(object->generate_document_outline, validation_context))
    return false;

  return true;
}

PrintCompositor_SetGenerateDocumentOutline_Params_Data::PrintCompositor_SetGenerateDocumentOutline_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_SetTitle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_SetTitle_Params_Data* object =
      static_cast<const PrintCompositor_SetTitle_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  return true;
}

PrintCompositor_SetTitle_Params_Data::PrintCompositor_SetTitle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PrintCompositor_SetWatermarkBlock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PrintCompositor_SetWatermarkBlock_Params_Data* object =
      static_cast<const PrintCompositor_SetWatermarkBlock_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->watermark_block, validation_context))
    return false;

  return true;
}

PrintCompositor_SetWatermarkBlock_Params_Data::PrintCompositor_SetWatermarkBlock_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace printing

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PrintCompositor_Status>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::PrintCompositor_Status value) {
  return std::move(context).WriteString(::printing::mojom::PrintCompositor_StatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PrintCompositor_DocumentType>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::PrintCompositor_DocumentType value) {
  return std::move(context).WriteString(::printing::mojom::PrintCompositor_DocumentTypeToString(value));
}

} // namespace perfetto