// components/services/on_device_translation/public/mojom/on_device_translation_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_H_
#define COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-features.h"  // IWYU pragma: export
#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-shared.h"  // IWYU pragma: export
#include "components/services/on_device_translation/public/mojom/on_device_translation_service.mojom-forward.h"  // IWYU pragma: export
#include "components/services/on_device_translation/public/mojom/translator.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"





constexpr ::sandbox::mojom::Sandbox kOnDeviceTranslationSandbox = ::sandbox::mojom::Sandbox::kOnDeviceTranslation;


namespace on_device_translation::mojom {

class FileOperationProxyProxy;

template <typename ImplRefTraits>
class FileOperationProxyStub;

class FileOperationProxyRequestValidator;
class FileOperationProxyResponseValidator;


class FileOperationProxy
    : public FileOperationProxyInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_translation.mojom.FileOperationProxy";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileOperationProxyInterfaceBase;
  using Proxy_ = FileOperationProxyProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileOperationProxyStub<ImplRefTraits>;

  using RequestValidator_ = FileOperationProxyRequestValidator;
  using ResponseValidator_ = FileOperationProxyResponseValidator;
  enum MethodMinVersions : uint32_t {
    kFileExistsMinVersion = 0,
    kOpenMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FileExists_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Open_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileOperationProxy() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool FileExists(uint32_t package_index, const ::base::FilePath& relative_path, bool* out_exists, bool* out_is_directory);
  using FileExistsCallback = base::OnceCallback<void(bool, bool)>;
  using FileExistsMojoCallback = base::OnceCallback<void(bool, bool)>;

  virtual void FileExists(uint32_t package_index, const ::base::FilePath& relative_path, FileExistsCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Open(uint32_t package_index, const ::base::FilePath& relative_path, ::base::File* out_file);
  using OpenCallback = base::OnceCallback<void(::base::File)>;
  using OpenMojoCallback = base::OnceCallback<void(::base::File)>;

  virtual void Open(uint32_t package_index, const ::base::FilePath& relative_path, OpenCallback callback) = 0;
};

class OnDeviceTranslationServiceProxy;

template <typename ImplRefTraits>
class OnDeviceTranslationServiceStub;

class OnDeviceTranslationServiceRequestValidator;
class OnDeviceTranslationServiceResponseValidator;


class OnDeviceTranslationService
    : public OnDeviceTranslationServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_translation.mojom.OnDeviceTranslationService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kOnDeviceTranslation;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OnDeviceTranslationServiceInterfaceBase;
  using Proxy_ = OnDeviceTranslationServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = OnDeviceTranslationServiceStub<ImplRefTraits>;

  using RequestValidator_ = OnDeviceTranslationServiceRequestValidator;
  using ResponseValidator_ = OnDeviceTranslationServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetServiceConfigMinVersion = 0,
    kCreateTranslatorMinVersion = 0,
    kCanTranslateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetServiceConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTranslator_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CanTranslate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OnDeviceTranslationService() = default;

  virtual void SetServiceConfig(OnDeviceTranslationServiceConfigPtr config) = 0;

  using CreateTranslatorCallback = base::OnceCallback<void(CreateTranslatorResult)>;
  using CreateTranslatorMojoCallback = base::OnceCallback<void(CreateTranslatorResult)>;

  virtual void CreateTranslator(const std::string& source_lang, const std::string& target_lang, ::mojo::PendingReceiver<::on_device_translation::mojom::Translator> receiver, CreateTranslatorCallback callback) = 0;

  using CanTranslateCallback = base::OnceCallback<void(bool)>;
  using CanTranslateMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CanTranslate(const std::string& source_lang, const std::string& target_lang, CanTranslateCallback callback) = 0;
};



class  FileOperationProxyProxy
    : public FileOperationProxy {
 public:
  using InterfaceType = FileOperationProxy;

  explicit FileOperationProxyProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool FileExists(uint32_t package_index, const ::base::FilePath& relative_path, bool* out_exists, bool* out_is_directory) final;
  
  void FileExists(uint32_t package_index, const ::base::FilePath& relative_path, FileExistsCallback callback) final;
  
  bool Open(uint32_t package_index, const ::base::FilePath& relative_path, ::base::File* out_file) final;
  
  void Open(uint32_t package_index, const ::base::FilePath& relative_path, OpenCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  OnDeviceTranslationServiceProxy
    : public OnDeviceTranslationService {
 public:
  using InterfaceType = OnDeviceTranslationService;

  explicit OnDeviceTranslationServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetServiceConfig(OnDeviceTranslationServiceConfigPtr config) final;
  
  void CreateTranslator(const std::string& source_lang, const std::string& target_lang, ::mojo::PendingReceiver<::on_device_translation::mojom::Translator> receiver, CreateTranslatorCallback callback) final;
  
  void CanTranslate(const std::string& source_lang, const std::string& target_lang, CanTranslateCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FileOperationProxyStubDispatch {
 public:
  static bool Accept(FileOperationProxy* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileOperationProxy* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileOperationProxy>>
class FileOperationProxyStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileOperationProxyStub() = default;
  ~FileOperationProxyStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileOperationProxyStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileOperationProxyStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  OnDeviceTranslationServiceStubDispatch {
 public:
  static bool Accept(OnDeviceTranslationService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OnDeviceTranslationService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OnDeviceTranslationService>>
class OnDeviceTranslationServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OnDeviceTranslationServiceStub() = default;
  ~OnDeviceTranslationServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OnDeviceTranslationServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OnDeviceTranslationServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FileOperationProxyRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OnDeviceTranslationServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FileOperationProxyResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OnDeviceTranslationServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  OnDeviceTranslationLanguagePackage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OnDeviceTranslationLanguagePackage, T>::value>;
  using DataView = OnDeviceTranslationLanguagePackageDataView;
  using Data_ = internal::OnDeviceTranslationLanguagePackage_Data;

  template <typename... Args>
  static OnDeviceTranslationLanguagePackagePtr New(Args&&... args) {
    return OnDeviceTranslationLanguagePackagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OnDeviceTranslationLanguagePackagePtr From(const U& u) {
    return mojo::TypeConverter<OnDeviceTranslationLanguagePackagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OnDeviceTranslationLanguagePackage>::Convert(*this);
  }


  OnDeviceTranslationLanguagePackage();

  OnDeviceTranslationLanguagePackage(
      const std::string& language1,
      const std::string& language2);


  ~OnDeviceTranslationLanguagePackage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OnDeviceTranslationLanguagePackagePtr>
  OnDeviceTranslationLanguagePackagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OnDeviceTranslationLanguagePackage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OnDeviceTranslationLanguagePackage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OnDeviceTranslationLanguagePackage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnDeviceTranslationLanguagePackage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnDeviceTranslationLanguagePackage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OnDeviceTranslationLanguagePackage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OnDeviceTranslationLanguagePackage_UnserializedMessageContext<
            UserType, OnDeviceTranslationLanguagePackage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OnDeviceTranslationLanguagePackage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OnDeviceTranslationLanguagePackage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OnDeviceTranslationLanguagePackage_UnserializedMessageContext<
            UserType, OnDeviceTranslationLanguagePackage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OnDeviceTranslationLanguagePackage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string language1;
  
  std::string language2;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OnDeviceTranslationLanguagePackage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OnDeviceTranslationLanguagePackage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OnDeviceTranslationLanguagePackage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OnDeviceTranslationLanguagePackage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  OnDeviceTranslationServiceConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OnDeviceTranslationServiceConfig, T>::value>;
  using DataView = OnDeviceTranslationServiceConfigDataView;
  using Data_ = internal::OnDeviceTranslationServiceConfig_Data;

  template <typename... Args>
  static OnDeviceTranslationServiceConfigPtr New(Args&&... args) {
    return OnDeviceTranslationServiceConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OnDeviceTranslationServiceConfigPtr From(const U& u) {
    return mojo::TypeConverter<OnDeviceTranslationServiceConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OnDeviceTranslationServiceConfig>::Convert(*this);
  }


  OnDeviceTranslationServiceConfig();

  OnDeviceTranslationServiceConfig(
      std::vector<OnDeviceTranslationLanguagePackagePtr> packages,
      ::mojo::PendingRemote<FileOperationProxy> file_operation_proxy);

OnDeviceTranslationServiceConfig(const OnDeviceTranslationServiceConfig&) = delete;
OnDeviceTranslationServiceConfig& operator=(const OnDeviceTranslationServiceConfig&) = delete;

  ~OnDeviceTranslationServiceConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OnDeviceTranslationServiceConfigPtr>
  OnDeviceTranslationServiceConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OnDeviceTranslationServiceConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OnDeviceTranslationServiceConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OnDeviceTranslationServiceConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OnDeviceTranslationServiceConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OnDeviceTranslationServiceConfig_UnserializedMessageContext<
            UserType, OnDeviceTranslationServiceConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OnDeviceTranslationServiceConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OnDeviceTranslationServiceConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OnDeviceTranslationServiceConfig_UnserializedMessageContext<
            UserType, OnDeviceTranslationServiceConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OnDeviceTranslationServiceConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<OnDeviceTranslationLanguagePackagePtr> packages;
  
  ::mojo::PendingRemote<FileOperationProxy> file_operation_proxy;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OnDeviceTranslationServiceConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OnDeviceTranslationServiceConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OnDeviceTranslationServiceConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OnDeviceTranslationServiceConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
OnDeviceTranslationLanguagePackagePtr OnDeviceTranslationLanguagePackage::Clone() const {
  return New(
      mojo::Clone(language1),
      mojo::Clone(language2)
  );
}

template <typename T, OnDeviceTranslationLanguagePackage::EnableIfSame<T>*>
bool OnDeviceTranslationLanguagePackage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->language1, other_struct.language1))
    return false;
  if (!mojo::Equals(this->language2, other_struct.language2))
    return false;
  return true;
}

template <typename T, OnDeviceTranslationLanguagePackage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.language1 < rhs.language1)
    return true;
  if (rhs.language1 < lhs.language1)
    return false;
  if (lhs.language2 < rhs.language2)
    return true;
  if (rhs.language2 < lhs.language2)
    return false;
  return false;
}
template <typename StructPtrType>
OnDeviceTranslationServiceConfigPtr OnDeviceTranslationServiceConfig::Clone() const {
  return New(
      mojo::Clone(packages),
      mojo::Clone(file_operation_proxy)
  );
}

template <typename T, OnDeviceTranslationServiceConfig::EnableIfSame<T>*>
bool OnDeviceTranslationServiceConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->packages, other_struct.packages))
    return false;
  if (!mojo::Equals(this->file_operation_proxy, other_struct.file_operation_proxy))
    return false;
  return true;
}

template <typename T, OnDeviceTranslationServiceConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.packages < rhs.packages)
    return true;
  if (rhs.packages < lhs.packages)
    return false;
  if (lhs.file_operation_proxy < rhs.file_operation_proxy)
    return true;
  if (rhs.file_operation_proxy < lhs.file_operation_proxy)
    return false;
  return false;
}


}  // on_device_translation::mojom

namespace mojo {


template <>
struct  StructTraits<::on_device_translation::mojom::OnDeviceTranslationLanguagePackage::DataView,
                                         ::on_device_translation::mojom::OnDeviceTranslationLanguagePackagePtr> {
  static bool IsNull(const ::on_device_translation::mojom::OnDeviceTranslationLanguagePackagePtr& input) { return !input; }
  static void SetToNull(::on_device_translation::mojom::OnDeviceTranslationLanguagePackagePtr* output) { output->reset(); }

  static const decltype(::on_device_translation::mojom::OnDeviceTranslationLanguagePackage::language1)& language1(
      const ::on_device_translation::mojom::OnDeviceTranslationLanguagePackagePtr& input) {
    return input->language1;
  }

  static const decltype(::on_device_translation::mojom::OnDeviceTranslationLanguagePackage::language2)& language2(
      const ::on_device_translation::mojom::OnDeviceTranslationLanguagePackagePtr& input) {
    return input->language2;
  }

  static bool Read(::on_device_translation::mojom::OnDeviceTranslationLanguagePackage::DataView input, ::on_device_translation::mojom::OnDeviceTranslationLanguagePackagePtr* output);
};


template <>
struct  StructTraits<::on_device_translation::mojom::OnDeviceTranslationServiceConfig::DataView,
                                         ::on_device_translation::mojom::OnDeviceTranslationServiceConfigPtr> {
  static bool IsNull(const ::on_device_translation::mojom::OnDeviceTranslationServiceConfigPtr& input) { return !input; }
  static void SetToNull(::on_device_translation::mojom::OnDeviceTranslationServiceConfigPtr* output) { output->reset(); }

  static const decltype(::on_device_translation::mojom::OnDeviceTranslationServiceConfig::packages)& packages(
      const ::on_device_translation::mojom::OnDeviceTranslationServiceConfigPtr& input) {
    return input->packages;
  }

  static  decltype(::on_device_translation::mojom::OnDeviceTranslationServiceConfig::file_operation_proxy)& file_operation_proxy(
       ::on_device_translation::mojom::OnDeviceTranslationServiceConfigPtr& input) {
    return input->file_operation_proxy;
  }

  static bool Read(::on_device_translation::mojom::OnDeviceTranslationServiceConfig::DataView input, ::on_device_translation::mojom::OnDeviceTranslationServiceConfigPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_ON_DEVICE_TRANSLATION_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_SERVICE_MOJOM_H_