// components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-params-data.h"
namespace heap_profiling {
namespace mojom {

NOINLINE static const char* ProcessTypeToStringHelper(ProcessType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ProcessType::OTHER:
      return "OTHER";
    case ProcessType::BROWSER:
      return "BROWSER";
    case ProcessType::RENDERER:
      return "RENDERER";
    case ProcessType::GPU:
      return "{GPU, LAST}";
    default:
      return nullptr;
  }
}

std::string ProcessTypeToString(ProcessType value) {
  const char *str = ProcessTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ProcessType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ProcessType value) {
  return os << ProcessTypeToString(value);
}

namespace internal {


// static
bool ProfilingService_AddProfilingClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfilingService_AddProfilingClient_Params_Data* object =
      static_cast<const ProfilingService_AddProfilingClient_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pid, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }


  if (!::heap_profiling::mojom::internal::ProcessType_Data
        ::Validate(object->process_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

ProfilingService_AddProfilingClient_Params_Data::ProfilingService_AddProfilingClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfilingService_AddProfilingClient_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfilingService_AddProfilingClient_ResponseParams_Data* object =
      static_cast<const ProfilingService_AddProfilingClient_ResponseParams_Data*>(data);

  return true;
}

ProfilingService_AddProfilingClient_ResponseParams_Data::ProfilingService_AddProfilingClient_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfilingService_GetProfiledPids_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfilingService_GetProfiledPids_Params_Data* object =
      static_cast<const ProfilingService_GetProfiledPids_Params_Data*>(data);

  return true;
}

ProfilingService_GetProfiledPids_Params_Data::ProfilingService_GetProfiledPids_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProfilingService_GetProfiledPids_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfilingService_GetProfiledPids_ResponseParams_Data* object =
      static_cast<const ProfilingService_GetProfiledPids_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pids, validation_context,
                                         &pids_validate_params)) {
    return false;
  }

  return true;
}

ProfilingService_GetProfiledPids_ResponseParams_Data::ProfilingService_GetProfiledPids_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace heap_profiling

namespace perfetto {

// static
void TraceFormatTraits<::heap_profiling::mojom::ProcessType>::WriteIntoTrace(
   perfetto::TracedValue context, ::heap_profiling::mojom::ProcessType value) {
  return std::move(context).WriteString(::heap_profiling::mojom::ProcessTypeToString(value));
}

} // namespace perfetto