// components/services/heap_profiling/public/mojom/heap_profiling_service.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_SERVICE_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_SERVICE_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace heap_profiling::mojom {
namespace internal {
class  ProfilingService_AddProfilingClient_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ProcessId_Data> pid;
  mojo::internal::Interface_Data client;
  int32_t process_type;
  uint8_t pad2_[4];
  mojo::internal::Pointer<::heap_profiling::mojom::internal::ProfilingParams_Data> params;

 private:
  friend class mojo::internal::MessageFragment<ProfilingService_AddProfilingClient_Params_Data>;

  ProfilingService_AddProfilingClient_Params_Data();
  ~ProfilingService_AddProfilingClient_Params_Data() = delete;
};
static_assert(sizeof(ProfilingService_AddProfilingClient_Params_Data) == 40,
              "Bad sizeof(ProfilingService_AddProfilingClient_Params_Data)");
class  ProfilingService_AddProfilingClient_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<ProfilingService_AddProfilingClient_ResponseParams_Data>;

  ProfilingService_AddProfilingClient_ResponseParams_Data();
  ~ProfilingService_AddProfilingClient_ResponseParams_Data() = delete;
};
static_assert(sizeof(ProfilingService_AddProfilingClient_ResponseParams_Data) == 16,
              "Bad sizeof(ProfilingService_AddProfilingClient_ResponseParams_Data)");
class  ProfilingService_GetProfiledPids_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<ProfilingService_GetProfiledPids_Params_Data>;

  ProfilingService_GetProfiledPids_Params_Data();
  ~ProfilingService_GetProfiledPids_Params_Data() = delete;
};
static_assert(sizeof(ProfilingService_GetProfiledPids_Params_Data) == 8,
              "Bad sizeof(ProfilingService_GetProfiledPids_Params_Data)");
class  ProfilingService_GetProfiledPids_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::ProcessId_Data>>> pids;

 private:
  friend class mojo::internal::MessageFragment<ProfilingService_GetProfiledPids_ResponseParams_Data>;

  ProfilingService_GetProfiledPids_ResponseParams_Data();
  ~ProfilingService_GetProfiledPids_ResponseParams_Data() = delete;
};
static_assert(sizeof(ProfilingService_GetProfiledPids_ResponseParams_Data) == 16,
              "Bad sizeof(ProfilingService_GetProfiledPids_ResponseParams_Data)");

}  // namespace internal


class ProfilingService_AddProfilingClient_ParamsDataView {
 public:
  ProfilingService_AddProfilingClient_ParamsDataView() = default;

  ProfilingService_AddProfilingClient_ParamsDataView(
      internal::ProfilingService_AddProfilingClient_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPidDataView(
      ::mojo_base::mojom::ProcessIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPid(UserType* output) {
    
    auto* pointer = data_->pid.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProcessIdDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::heap_profiling::mojom::ProfilingClientInterfaceBase>>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProcessType(UserType* output) const {
    auto data_value = data_->process_type;
    return mojo::internal::Deserialize<::heap_profiling::mojom::ProcessType>(
        data_value, output);
  }
  ProcessType process_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::heap_profiling::mojom::ProcessType>(data_->process_type));
  }
  inline void GetParamsDataView(
      ::heap_profiling::mojom::ProfilingParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::heap_profiling::mojom::ProfilingParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProfilingService_AddProfilingClient_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProfilingService_AddProfilingClient_ResponseParamsDataView {
 public:
  ProfilingService_AddProfilingClient_ResponseParamsDataView() = default;

  ProfilingService_AddProfilingClient_ResponseParamsDataView(
      internal::ProfilingService_AddProfilingClient_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::ProfilingService_AddProfilingClient_ResponseParams_Data* data_ = nullptr;
};


class ProfilingService_GetProfiledPids_ParamsDataView {
 public:
  ProfilingService_GetProfiledPids_ParamsDataView() = default;

  ProfilingService_GetProfiledPids_ParamsDataView(
      internal::ProfilingService_GetProfiledPids_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ProfilingService_GetProfiledPids_Params_Data* data_ = nullptr;
};


class ProfilingService_GetProfiledPids_ResponseParamsDataView {
 public:
  ProfilingService_GetProfiledPids_ResponseParamsDataView() = default;

  ProfilingService_GetProfiledPids_ResponseParamsDataView(
      internal::ProfilingService_GetProfiledPids_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPidsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::ProcessIdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPids(UserType* output) {
    
    auto* pointer = data_->pids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::ProcessIdDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ProfilingService_GetProfiledPids_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void ProfilingService_AddProfilingClient_ParamsDataView::GetPidDataView(
    ::mojo_base::mojom::ProcessIdDataView* output) {
  auto pointer = data_->pid.Get();
  *output = ::mojo_base::mojom::ProcessIdDataView(pointer, message_);
}
inline void ProfilingService_AddProfilingClient_ParamsDataView::GetParamsDataView(
    ::heap_profiling::mojom::ProfilingParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::heap_profiling::mojom::ProfilingParamsDataView(pointer, message_);
}






inline void ProfilingService_GetProfiledPids_ResponseParamsDataView::GetPidsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::ProcessIdDataView>* output) {
  auto pointer = data_->pids.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::ProcessIdDataView>(pointer, message_);
}



}  // heap_profiling::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_SERVICE_MOJOM_PARAMS_DATA_H_