// components/services/heap_profiling/public/mojom/heap_profiling_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-params-data.h"
#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-shared-message-ids.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-import-headers.h"
#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-test-utils.h"


namespace heap_profiling::mojom {
ProfilingParams::ProfilingParams()
    : stack_mode(),
      sampling_rate() {}

ProfilingParams::ProfilingParams(
    StackMode stack_mode_in,
    uint32_t sampling_rate_in)
    : stack_mode(std::move(stack_mode_in)),
      sampling_rate(std::move(sampling_rate_in)) {}

ProfilingParams::~ProfilingParams() = default;
size_t ProfilingParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->stack_mode);
  seed = mojo::internal::Hash(seed, this->sampling_rate);
  return seed;
}

void ProfilingParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stack_mode"), this->stack_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type StackMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sampling_rate"), this->sampling_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProfilingParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HeapProfileSample::HeapProfileSample()
    : allocator(),
      size(),
      total(),
      context_id(),
      stack() {}

HeapProfileSample::HeapProfileSample(
    AllocatorType allocator_in,
    uint64_t size_in,
    uint64_t total_in,
    uint64_t context_id_in,
    std::vector<uint64_t> stack_in)
    : allocator(std::move(allocator_in)),
      size(std::move(size_in)),
      total(std::move(total_in)),
      context_id(std::move(context_id_in)),
      stack(std::move(stack_in)) {}

HeapProfileSample::~HeapProfileSample() = default;

void HeapProfileSample::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allocator"), this->allocator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AllocatorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_id"), this->context_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stack"), this->stack,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HeapProfileSample::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HeapProfile::HeapProfile()
    : samples(),
      strings() {}

HeapProfile::HeapProfile(
    std::vector<HeapProfileSamplePtr> samples_in,
    const base::flat_map<uint64_t, std::string>& strings_in)
    : samples(std::move(samples_in)),
      strings(std::move(strings_in)) {}

HeapProfile::~HeapProfile() = default;

void HeapProfile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "samples"), this->samples,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<HeapProfileSamplePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strings"), this->strings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<uint64_t, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HeapProfile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ProfilingClient::IPCStableHashFunction ProfilingClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProfilingClient>(message.name())) {
    case messages::ProfilingClient::kStartProfiling: {
      return &ProfilingClient::StartProfiling_Sym::IPCStableHash;
    }
    case messages::ProfilingClient::kRetrieveHeapProfile: {
      return &ProfilingClient::RetrieveHeapProfile_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProfilingClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProfilingClient>(message.name())) {
      case messages::ProfilingClient::kStartProfiling:
            return "Receive heap_profiling::mojom::ProfilingClient::StartProfiling";
      case messages::ProfilingClient::kRetrieveHeapProfile:
            return "Receive heap_profiling::mojom::ProfilingClient::RetrieveHeapProfile";
    }
  } else {
    switch (static_cast<messages::ProfilingClient>(message.name())) {
      case messages::ProfilingClient::kStartProfiling:
            return "Receive reply heap_profiling::mojom::ProfilingClient::StartProfiling";
      case messages::ProfilingClient::kRetrieveHeapProfile:
            return "Receive reply heap_profiling::mojom::ProfilingClient::RetrieveHeapProfile";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProfilingClient::StartProfiling_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e9047ab;  // IPCStableHash for heap_profiling::mojom::ProfilingClient::StartProfiling
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProfilingClient::RetrieveHeapProfile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd6e1fd4;  // IPCStableHash for heap_profiling::mojom::ProfilingClient::RetrieveHeapProfile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ProfilingClient_StartProfiling_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProfilingClient_StartProfiling_ForwardToCallback(
      ProfilingClient::StartProfilingCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProfilingClient_StartProfiling_ForwardToCallback(const ProfilingClient_StartProfiling_ForwardToCallback&) = delete;
  ProfilingClient_StartProfiling_ForwardToCallback& operator=(const ProfilingClient_StartProfiling_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProfilingClient::StartProfilingCallback callback_;
};

class ProfilingClient_RetrieveHeapProfile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProfilingClient_RetrieveHeapProfile_ForwardToCallback(
      ProfilingClient::RetrieveHeapProfileCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProfilingClient_RetrieveHeapProfile_ForwardToCallback(const ProfilingClient_RetrieveHeapProfile_ForwardToCallback&) = delete;
  ProfilingClient_RetrieveHeapProfile_ForwardToCallback& operator=(const ProfilingClient_RetrieveHeapProfile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProfilingClient::RetrieveHeapProfileCallback callback_;
};

ProfilingClientProxy::ProfilingClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProfilingClientProxy::StartProfiling(
    ProfilingParamsPtr in_params, StartProfilingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send heap_profiling::mojom::ProfilingClient::StartProfiling", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ProfilingParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfilingClient::kStartProfiling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::heap_profiling::mojom::internal::ProfilingClient_StartProfiling_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::heap_profiling::mojom::ProfilingParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in ProfilingClient.StartProfiling request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfilingClient::Name_);
  message.set_method_name("StartProfiling");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProfilingClient_StartProfiling_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProfilingClientProxy::RetrieveHeapProfile(
    RetrieveHeapProfileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send heap_profiling::mojom::ProfilingClient::RetrieveHeapProfile");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfilingClient::kRetrieveHeapProfile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::heap_profiling::mojom::internal::ProfilingClient_RetrieveHeapProfile_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfilingClient::Name_);
  message.set_method_name("RetrieveHeapProfile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProfilingClient_RetrieveHeapProfile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ProfilingClient_StartProfiling_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProfilingClient::StartProfilingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProfilingClient_StartProfiling_ProxyToResponder> proxy(
        new ProfilingClient_StartProfiling_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProfilingClient_StartProfiling_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProfilingClient_StartProfiling_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProfilingClient_StartProfiling_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProfilingClient::StartProfilingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ProfilingClient_StartProfiling_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProfilingClient_StartProfiling_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProfilingClient_StartProfiling_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProfilingClient.0
  bool success = true;
  ProfilingClient_StartProfiling_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProfilingClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ProfilingClient_StartProfiling_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply heap_profiling::mojom::ProfilingClient::StartProfiling");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfilingClient::kStartProfiling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::heap_profiling::mojom::internal::ProfilingClient_StartProfiling_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfilingClient::Name_);
  message.set_method_name("StartProfiling");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ProfilingClient_RetrieveHeapProfile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProfilingClient::RetrieveHeapProfileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProfilingClient_RetrieveHeapProfile_ProxyToResponder> proxy(
        new ProfilingClient_RetrieveHeapProfile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProfilingClient_RetrieveHeapProfile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProfilingClient_RetrieveHeapProfile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProfilingClient_RetrieveHeapProfile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProfilingClient::RetrieveHeapProfileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      HeapProfilePtr in_profile);
};

bool ProfilingClient_RetrieveHeapProfile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProfilingClient_RetrieveHeapProfile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProfilingClient_RetrieveHeapProfile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProfilingClient.1
  bool success = true;
  HeapProfilePtr p_profile{};
  ProfilingClient_RetrieveHeapProfile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProfile(&p_profile))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProfilingClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_profile));
  }
  return true;
}

void ProfilingClient_RetrieveHeapProfile_ProxyToResponder::Run(
    HeapProfilePtr in_profile) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply heap_profiling::mojom::ProfilingClient::RetrieveHeapProfile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile"), in_profile,
                        "<value of type HeapProfilePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProfilingClient::kRetrieveHeapProfile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::heap_profiling::mojom::internal::ProfilingClient_RetrieveHeapProfile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile)::BaseType> profile_fragment(
          params.message());
  
  mojo::internal::Serialize<::heap_profiling::mojom::HeapProfileDataView>(
    in_profile,
    profile_fragment);

  params->profile.Set(
      profile_fragment.is_null() ? nullptr : profile_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->profile.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null profile in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProfilingClient::Name_);
  message.set_method_name("RetrieveHeapProfile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProfilingClientStubDispatch::Accept(
    ProfilingClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProfilingClient>(message->header()->name)) {
    case messages::ProfilingClient::kStartProfiling: {
      break;
    }
    case messages::ProfilingClient::kRetrieveHeapProfile: {
      break;
    }
  }
  return false;
}

// static
bool ProfilingClientStubDispatch::AcceptWithResponder(
    ProfilingClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProfilingClient>(message->header()->name)) {
    case messages::ProfilingClient::kStartProfiling: {
      internal::ProfilingClient_StartProfiling_Params_Data* params =
          reinterpret_cast<
              internal::ProfilingClient_StartProfiling_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProfilingClient.0
      bool success = true;
      ProfilingParamsPtr p_params{};
      ProfilingClient_StartProfiling_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfilingClient::Name_, 0, false);
        return false;
      }
      auto callback =
          ProfilingClient_StartProfiling_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartProfiling(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::ProfilingClient::kRetrieveHeapProfile: {
      internal::ProfilingClient_RetrieveHeapProfile_Params_Data* params =
          reinterpret_cast<
              internal::ProfilingClient_RetrieveHeapProfile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProfilingClient.1
      bool success = true;
      ProfilingClient_RetrieveHeapProfile_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProfilingClient::Name_, 1, false);
        return false;
      }
      auto callback =
          ProfilingClient_RetrieveHeapProfile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RetrieveHeapProfile(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProfilingClientValidationInfo[] = {
    { &internal::ProfilingClient_StartProfiling_Params_Data::Validate,
     &internal::ProfilingClient_StartProfiling_ResponseParams_Data::Validate},
    { &internal::ProfilingClient_RetrieveHeapProfile_Params_Data::Validate,
     &internal::ProfilingClient_RetrieveHeapProfile_ResponseParams_Data::Validate},
};

bool ProfilingClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::heap_profiling::mojom::ProfilingClient::Name_,
    kProfilingClientValidationInfo);
}

bool ProfilingClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::heap_profiling::mojom::ProfilingClient::Name_,
    kProfilingClientValidationInfo);
}


}  // heap_profiling::mojom


namespace mojo {


// static
bool StructTraits<::heap_profiling::mojom::ProfilingParams::DataView, ::heap_profiling::mojom::ProfilingParamsPtr>::Read(
    ::heap_profiling::mojom::ProfilingParams::DataView input,
    ::heap_profiling::mojom::ProfilingParamsPtr* output) {
  bool success = true;
  ::heap_profiling::mojom::ProfilingParamsPtr result(::heap_profiling::mojom::ProfilingParams::New());
  
      if (success && !input.ReadStackMode(&result->stack_mode))
        success = false;
      if (success)
        result->sampling_rate = input.sampling_rate();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::heap_profiling::mojom::HeapProfileSample::DataView, ::heap_profiling::mojom::HeapProfileSamplePtr>::Read(
    ::heap_profiling::mojom::HeapProfileSample::DataView input,
    ::heap_profiling::mojom::HeapProfileSamplePtr* output) {
  bool success = true;
  ::heap_profiling::mojom::HeapProfileSamplePtr result(::heap_profiling::mojom::HeapProfileSample::New());
  
      if (success && !input.ReadAllocator(&result->allocator))
        success = false;
      if (success)
        result->size = input.size();
      if (success)
        result->total = input.total();
      if (success)
        result->context_id = input.context_id();
      if (success && !input.ReadStack(&result->stack))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::heap_profiling::mojom::HeapProfile::DataView, ::heap_profiling::mojom::HeapProfilePtr>::Read(
    ::heap_profiling::mojom::HeapProfile::DataView input,
    ::heap_profiling::mojom::HeapProfilePtr* output) {
  bool success = true;
  ::heap_profiling::mojom::HeapProfilePtr result(::heap_profiling::mojom::HeapProfile::New());
  
      if (success && !input.ReadSamples(&result->samples))
        success = false;
      if (success && !input.ReadStrings(&result->strings))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace heap_profiling::mojom {


void ProfilingClientInterceptorForTesting::StartProfiling(ProfilingParamsPtr params, StartProfilingCallback callback) {
  GetForwardingInterface()->StartProfiling(
    std::move(params)
    , std::move(callback));
}
void ProfilingClientInterceptorForTesting::RetrieveHeapProfile(RetrieveHeapProfileCallback callback) {
  GetForwardingInterface()->RetrieveHeapProfile(std::move(callback));
}
ProfilingClientAsyncWaiter::ProfilingClientAsyncWaiter(
    ProfilingClient* proxy) : proxy_(proxy) {}

ProfilingClientAsyncWaiter::~ProfilingClientAsyncWaiter() = default;


void ProfilingClientAsyncWaiter::StartProfiling(
    ProfilingParamsPtr params) {
  base::RunLoop loop;
  proxy_->StartProfiling(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void ProfilingClientAsyncWaiter::RetrieveHeapProfile(
    HeapProfilePtr* out_profile) {
  base::RunLoop loop;
  proxy_->RetrieveHeapProfile(
      base::BindOnce(
          [](base::RunLoop* loop,
             HeapProfilePtr* out_profile
,
             HeapProfilePtr profile) {*out_profile = std::move(profile);
            loop->Quit();
          },
          &loop,
          out_profile));
  loop.Run();
}

HeapProfilePtr ProfilingClientAsyncWaiter::RetrieveHeapProfile(
    ) {
  HeapProfilePtr async_wait_result;
  RetrieveHeapProfile(&async_wait_result);
  return async_wait_result;
}






}  // heap_profiling::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif