// components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-data-view.h"




namespace std {

template <>
struct hash<::heap_profiling::mojom::StackMode>
    : public mojo::internal::EnumHashImpl<::heap_profiling::mojom::StackMode> {};

template <>
struct hash<::heap_profiling::mojom::AllocatorType>
    : public mojo::internal::EnumHashImpl<::heap_profiling::mojom::AllocatorType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::heap_profiling::mojom::StackMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::heap_profiling::mojom::StackMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::heap_profiling::mojom::StackMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::heap_profiling::mojom::AllocatorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::heap_profiling::mojom::AllocatorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::heap_profiling::mojom::AllocatorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::heap_profiling::mojom::ProfilingParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::heap_profiling::mojom::ProfilingParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::heap_profiling::mojom::internal::ProfilingParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::heap_profiling::mojom::StackMode>(
      Traits::stack_mode(input),
      &fragment->stack_mode);

    fragment->sampling_rate = Traits::sampling_rate(input);
  }

  static bool Deserialize(::heap_profiling::mojom::internal::ProfilingParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::heap_profiling::mojom::ProfilingParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::heap_profiling::mojom::HeapProfileSampleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::heap_profiling::mojom::HeapProfileSampleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::heap_profiling::mojom::internal::HeapProfileSample_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::heap_profiling::mojom::AllocatorType>(
      Traits::allocator(input),
      &fragment->allocator);

    fragment->size = Traits::size(input);

    fragment->total = Traits::total(input);

    fragment->context_id = Traits::context_id(input);

    decltype(Traits::stack(input)) in_stack = Traits::stack(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stack)::BaseType>
        stack_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& stack_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
      in_stack,
      stack_fragment,
      &stack_validate_params);

    fragment->stack.Set(
        stack_fragment.is_null() ? nullptr : stack_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stack.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stack in HeapProfileSample struct");
  }

  static bool Deserialize(::heap_profiling::mojom::internal::HeapProfileSample_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::heap_profiling::mojom::HeapProfileSampleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::heap_profiling::mojom::HeapProfileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::heap_profiling::mojom::HeapProfileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::heap_profiling::mojom::internal::HeapProfile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::samples(input)) in_samples = Traits::samples(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->samples)::BaseType>
        samples_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& samples_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::heap_profiling::mojom::HeapProfileSampleDataView>>(
      in_samples,
      samples_fragment,
      &samples_validate_params);

    fragment->samples.Set(
        samples_fragment.is_null() ? nullptr : samples_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->samples.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null samples in HeapProfile struct");

    decltype(Traits::strings(input)) in_strings = Traits::strings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->strings)::BaseType>
        strings_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& strings_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint64_t, mojo::StringDataView>>(
      in_strings,
      strings_fragment,
      &strings_validate_params);

    fragment->strings.Set(
        strings_fragment.is_null() ? nullptr : strings_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->strings.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null strings in HeapProfile struct");
  }

  static bool Deserialize(::heap_profiling::mojom::internal::HeapProfile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::heap_profiling::mojom::HeapProfileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace heap_profiling::mojom {



inline void HeapProfileSampleDataView::GetStackDataView(
    mojo::ArrayDataView<uint64_t>* output) {
  auto pointer = data_->stack.Get();
  *output = mojo::ArrayDataView<uint64_t>(pointer, message_);
}


inline void HeapProfileDataView::GetSamplesDataView(
    mojo::ArrayDataView<HeapProfileSampleDataView>* output) {
  auto pointer = data_->samples.Get();
  *output = mojo::ArrayDataView<HeapProfileSampleDataView>(pointer, message_);
}
inline void HeapProfileDataView::GetStringsDataView(
    mojo::MapDataView<uint64_t, mojo::StringDataView>* output) {
  auto pointer = data_->strings.Get();
  *output = mojo::MapDataView<uint64_t, mojo::StringDataView>(pointer, message_);
}



}  // heap_profiling::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::heap_profiling::mojom::StackMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::heap_profiling::mojom::StackMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::heap_profiling::mojom::AllocatorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::heap_profiling::mojom::AllocatorType value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_SHARED_H_