// components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_SEND_VALIDATION_H_

#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-shared-internal.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::heap_profiling::mojom::StackMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::heap_profiling::mojom::AllocatorType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::heap_profiling::mojom::ProfilingParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::heap_profiling::mojom::ProfilingParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::heap_profiling::mojom::internal::ProfilingParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::heap_profiling::mojom::StackMode>(
        Traits::stack_mode(input),
        &fragment->stack_mode);

      fragment->sampling_rate = Traits::sampling_rate(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::heap_profiling::mojom::HeapProfileSampleDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::heap_profiling::mojom::HeapProfileSampleDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::heap_profiling::mojom::internal::HeapProfileSample_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::heap_profiling::mojom::AllocatorType>(
        Traits::allocator(input),
        &fragment->allocator);

      fragment->size = Traits::size(input);

      fragment->total = Traits::total(input);

      fragment->context_id = Traits::context_id(input);

      decltype(Traits::stack(input)) in_stack = Traits::stack(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->stack)::BaseType>
          stack_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& stack_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>, send_validation>(
        in_stack,
        stack_fragment,
        &stack_validate_params);

      fragment->stack.Set(
          stack_fragment.is_null() ? nullptr : stack_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->stack.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stack in HeapProfileSample struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::heap_profiling::mojom::HeapProfileDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::heap_profiling::mojom::HeapProfileDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::heap_profiling::mojom::internal::HeapProfile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::samples(input)) in_samples = Traits::samples(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->samples)::BaseType>
          samples_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& samples_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::heap_profiling::mojom::HeapProfileSampleDataView>, send_validation>(
        in_samples,
        samples_fragment,
        &samples_validate_params);

      fragment->samples.Set(
          samples_fragment.is_null() ? nullptr : samples_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->samples.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null samples in HeapProfile struct");

      decltype(Traits::strings(input)) in_strings = Traits::strings(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->strings)::BaseType>
          strings_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& strings_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<uint64_t, mojo::StringDataView>, send_validation>(
        in_strings,
        strings_fragment,
        &strings_validate_params);

      fragment->strings.Set(
          strings_fragment.is_null() ? nullptr : strings_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->strings.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null strings in HeapProfile struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_SEND_VALIDATION_H_