// components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/services/heap_profiling/public/mojom/heap_profiling_client.mojom-shared-internal.h"


namespace heap_profiling::mojom {
class ProfilingParamsDataView;

class HeapProfileSampleDataView;

class HeapProfileDataView;



}  // heap_profiling::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::heap_profiling::mojom::ProfilingParamsDataView> {
  using Data = ::heap_profiling::mojom::internal::ProfilingParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::heap_profiling::mojom::HeapProfileSampleDataView> {
  using Data = ::heap_profiling::mojom::internal::HeapProfileSample_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::heap_profiling::mojom::HeapProfileDataView> {
  using Data = ::heap_profiling::mojom::internal::HeapProfile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace heap_profiling::mojom {


enum class StackMode : int32_t {
  
  NATIVE_WITH_THREAD_NAMES = 0,
  
  NATIVE_WITHOUT_THREAD_NAMES = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, StackMode value);
inline bool IsKnownEnumValue(StackMode value) {
  return internal::StackMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AllocatorType : int32_t {
  
  kMalloc = 0,
  
  kPartitionAlloc = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, AllocatorType value);
inline bool IsKnownEnumValue(AllocatorType value) {
  return internal::AllocatorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ProfilingClientInterfaceBase {};

using ProfilingClientPtrDataView =
    mojo::InterfacePtrDataView<ProfilingClientInterfaceBase>;
using ProfilingClientRequestDataView =
    mojo::InterfaceRequestDataView<ProfilingClientInterfaceBase>;
using ProfilingClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProfilingClientInterfaceBase>;
using ProfilingClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProfilingClientInterfaceBase>;


class ProfilingParamsDataView {
 public:
  ProfilingParamsDataView() = default;

  ProfilingParamsDataView(
      internal::ProfilingParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStackMode(UserType* output) const {
    auto data_value = data_->stack_mode;
    return mojo::internal::Deserialize<::heap_profiling::mojom::StackMode>(
        data_value, output);
  }
  StackMode stack_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::heap_profiling::mojom::StackMode>(data_->stack_mode));
  }
  uint32_t sampling_rate() const {
    return data_->sampling_rate;
  }
 private:
  internal::ProfilingParams_Data* data_ = nullptr;
};


class HeapProfileSampleDataView {
 public:
  HeapProfileSampleDataView() = default;

  HeapProfileSampleDataView(
      internal::HeapProfileSample_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAllocator(UserType* output) const {
    auto data_value = data_->allocator;
    return mojo::internal::Deserialize<::heap_profiling::mojom::AllocatorType>(
        data_value, output);
  }
  AllocatorType allocator() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::heap_profiling::mojom::AllocatorType>(data_->allocator));
  }
  uint64_t size() const {
    return data_->size;
  }
  uint64_t total() const {
    return data_->total;
  }
  uint64_t context_id() const {
    return data_->context_id;
  }
  inline void GetStackDataView(
      mojo::ArrayDataView<uint64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStack(UserType* output) {
    
    auto* pointer = data_->stack.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint64_t>>(
        pointer, output, message_);
  }
 private:
  internal::HeapProfileSample_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HeapProfileDataView {
 public:
  HeapProfileDataView() = default;

  HeapProfileDataView(
      internal::HeapProfile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSamplesDataView(
      mojo::ArrayDataView<HeapProfileSampleDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSamples(UserType* output) {
    
    auto* pointer = data_->samples.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::heap_profiling::mojom::HeapProfileSampleDataView>>(
        pointer, output, message_);
  }
  inline void GetStringsDataView(
      mojo::MapDataView<uint64_t, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStrings(UserType* output) {
    
    auto* pointer = data_->strings.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint64_t, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::HeapProfile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // heap_profiling::mojom

#endif  // COMPONENTS_SERVICES_HEAP_PROFILING_PUBLIC_MOJOM_HEAP_PROFILING_CLIENT_MOJOM_DATA_VIEW_H_