// components/services/font_data/public/mojom/font_data_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FONT_DATA_PUBLIC_MOJOM_FONT_DATA_SERVICE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_FONT_DATA_PUBLIC_MOJOM_FONT_DATA_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "components/services/font_data/public/mojom/font_data_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"


namespace font_data_service::mojom {
class TypefaceStyleDataView;

class CoordinateDataView;

class VariationPositionDataView;

class TypefaceFileDataView;

class MatchFamilyNameResultDataView;

class TypefaceDataDataView;


}  // font_data_service::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::font_data_service::mojom::TypefaceStyleDataView> {
  using Data = ::font_data_service::mojom::internal::TypefaceStyle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::font_data_service::mojom::CoordinateDataView> {
  using Data = ::font_data_service::mojom::internal::Coordinate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::font_data_service::mojom::VariationPositionDataView> {
  using Data = ::font_data_service::mojom::internal::VariationPosition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::font_data_service::mojom::TypefaceFileDataView> {
  using Data = ::font_data_service::mojom::internal::TypefaceFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::font_data_service::mojom::MatchFamilyNameResultDataView> {
  using Data = ::font_data_service::mojom::internal::MatchFamilyNameResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::font_data_service::mojom::TypefaceDataDataView> {
  using Data = ::font_data_service::mojom::internal::TypefaceData_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace font_data_service::mojom {


enum class TypefaceSlant : int32_t {
  
  kRoman = 0,
  
  kItalic = 1,
  
  kOblique = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TypefaceSlant value);
inline bool IsKnownEnumValue(TypefaceSlant value) {
  return internal::TypefaceSlant_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FontDataServiceInterfaceBase {};

using FontDataServicePtrDataView =
    mojo::InterfacePtrDataView<FontDataServiceInterfaceBase>;
using FontDataServiceRequestDataView =
    mojo::InterfaceRequestDataView<FontDataServiceInterfaceBase>;
using FontDataServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FontDataServiceInterfaceBase>;
using FontDataServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FontDataServiceInterfaceBase>;


class TypefaceStyleDataView {
 public:
  TypefaceStyleDataView() = default;

  TypefaceStyleDataView(
      internal::TypefaceStyle_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t weight() const {
    return data_->weight;
  }
  uint8_t width() const {
    return data_->width;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSlant(UserType* output) const {
    auto data_value = data_->slant;
    return mojo::internal::Deserialize<::font_data_service::mojom::TypefaceSlant>(
        data_value, output);
  }
  TypefaceSlant slant() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_data_service::mojom::TypefaceSlant>(data_->slant));
  }
 private:
  internal::TypefaceStyle_Data* data_ = nullptr;
};


class CoordinateDataView {
 public:
  CoordinateDataView() = default;

  CoordinateDataView(
      internal::Coordinate_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t axis() const {
    return data_->axis;
  }
  float value() const {
    return data_->value;
  }
 private:
  internal::Coordinate_Data* data_ = nullptr;
};


class VariationPositionDataView {
 public:
  VariationPositionDataView() = default;

  VariationPositionDataView(
      internal::VariationPosition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCoordinatesDataView(
      mojo::ArrayDataView<CoordinateDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCoordinates(UserType* output) {
    
    auto* pointer = data_->coordinates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::font_data_service::mojom::CoordinateDataView>>(
        pointer, output, message_);
  }
  uint16_t coordinateCount() const {
    return data_->coordinateCount;
  }
 private:
  internal::VariationPosition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TypefaceFileDataView {
 public:
  TypefaceFileDataView() = default;

  TypefaceFileDataView(
      internal::TypefaceFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFileHandleDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileHandle(UserType* output) {
    
    auto* pointer = data_->file_handle.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  uint64_t id() const {
    return data_->id;
  }
 private:
  internal::TypefaceFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MatchFamilyNameResultDataView {
 public:
  MatchFamilyNameResultDataView() = default;

  MatchFamilyNameResultDataView(
      internal::MatchFamilyNameResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTypefaceDataDataView(
      TypefaceDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTypefaceData(UserType* output) {
    
    auto* pointer = !data_->typeface_data.is_null() ? &data_->typeface_data : nullptr;
    return mojo::internal::Deserialize<::font_data_service::mojom::TypefaceDataDataView>(
        pointer, output, message_);
  }
  int32_t ttc_index() const {
    return data_->ttc_index;
  }
  inline void GetVariationPositionDataView(
      VariationPositionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVariationPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::font_data_service::mojom::VariationPositionDataView, UserType>(),
    "Attempting to read the optional `variation_position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVariationPosition` instead "
    "of `ReadVariationPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->variation_position.Get();
    return mojo::internal::Deserialize<::font_data_service::mojom::VariationPositionDataView>(
        pointer, output, message_);
  }
 private:
  internal::MatchFamilyNameResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TypefaceDataDataView {
 public:
  using Tag = internal::TypefaceData_Data::TypefaceData_Tag;

  TypefaceDataDataView() = default;

  TypefaceDataDataView(
      internal::TypefaceData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_region() const { return data_->tag == Tag::kRegion; }
  inline void GetRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRegion(UserType* output) const {
    
    CHECK(is_region());
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        data_->data.f_region.Get(), output, message_);
  }
  bool is_font_file() const { return data_->tag == Tag::kFontFile; }
  inline void GetFontFileDataView(
      TypefaceFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFontFile(UserType* output) const {
    
    CHECK(is_font_file());
    return mojo::internal::Deserialize<::font_data_service::mojom::TypefaceFileDataView>(
        data_->data.f_font_file.Get(), output, message_);
  }

 private:
  internal::TypefaceData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // font_data_service::mojom

#endif  // COMPONENTS_SERVICES_FONT_DATA_PUBLIC_MOJOM_FONT_DATA_SERVICE_MOJOM_DATA_VIEW_H_