// components/services/filesystem/public/mojom/types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/filesystem/public/mojom/types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/safe_base_name.mojom-shared.h"




#include "components/services/filesystem/public/mojom/types.mojom-data-view.h"




namespace std {

template <>
struct hash<::filesystem::mojom::Whence>
    : public mojo::internal::EnumHashImpl<::filesystem::mojom::Whence> {};

template <>
struct hash<::filesystem::mojom::FsFileType>
    : public mojo::internal::EnumHashImpl<::filesystem::mojom::FsFileType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::filesystem::mojom::Whence, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::filesystem::mojom::Whence, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::filesystem::mojom::Whence>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::filesystem::mojom::FsFileType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::filesystem::mojom::FsFileType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::filesystem::mojom::FsFileType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::filesystem::mojom::TimespecOrNowDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::filesystem::mojom::TimespecOrNowDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::filesystem::mojom::internal::TimespecOrNow_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->now = Traits::now(input);

    fragment->seconds = Traits::seconds(input);
  }

  static bool Deserialize(::filesystem::mojom::internal::TimespecOrNow_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::filesystem::mojom::TimespecOrNowDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::filesystem::mojom::FileInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::filesystem::mojom::FileInformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::filesystem::mojom::internal::FileInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::filesystem::mojom::FsFileType>(
      Traits::type(input),
      &fragment->type);

    fragment->size = Traits::size(input);

    fragment->atime = Traits::atime(input);

    fragment->mtime = Traits::mtime(input);

    fragment->ctime = Traits::ctime(input);
  }

  static bool Deserialize(::filesystem::mojom::internal::FileInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::filesystem::mojom::FileInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::filesystem::mojom::DirectoryEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::filesystem::mojom::DirectoryEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::filesystem::mojom::internal::DirectoryEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::SafeBaseNameDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in DirectoryEntry struct");

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in DirectoryEntry struct");

    
    mojo::internal::Serialize<::filesystem::mojom::FsFileType>(
      Traits::type(input),
      &fragment->type);
  }

  static bool Deserialize(::filesystem::mojom::internal::DirectoryEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::filesystem::mojom::DirectoryEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace filesystem::mojom {





inline void DirectoryEntryDataView::GetNameDataView(
    ::mojo_base::mojom::SafeBaseNameDataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::SafeBaseNameDataView(pointer, message_);
}
inline void DirectoryEntryDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // filesystem::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::filesystem::mojom::Whence> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::filesystem::mojom::Whence value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::filesystem::mojom::FsFileType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::filesystem::mojom::FsFileType value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_SHARED_H_