// components/services/filesystem/public/mojom/types.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_SEND_VALIDATION_H_

#include "components/services/filesystem/public/mojom/types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/safe_base_name.mojom-shared.h"

#include "components/services/filesystem/public/mojom/types.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::filesystem::mojom::Whence, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::filesystem::mojom::FsFileType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::filesystem::mojom::TimespecOrNowDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::filesystem::mojom::TimespecOrNowDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::filesystem::mojom::internal::TimespecOrNow_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->now = Traits::now(input);

      fragment->seconds = Traits::seconds(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::filesystem::mojom::FileInformationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::filesystem::mojom::FileInformationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::filesystem::mojom::internal::FileInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::filesystem::mojom::FsFileType>(
        Traits::type(input),
        &fragment->type);

      fragment->size = Traits::size(input);

      fragment->atime = Traits::atime(input);

      fragment->mtime = Traits::mtime(input);

      fragment->ctime = Traits::ctime(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::filesystem::mojom::DirectoryEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::filesystem::mojom::DirectoryEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::filesystem::mojom::internal::DirectoryEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::SafeBaseNameDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in DirectoryEntry struct");

      decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_name)::BaseType> display_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_name,
        display_name_fragment);

      fragment->display_name.Set(
          display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_name in DirectoryEntry struct");

      
      mojo::internal::Serialize<::filesystem::mojom::FsFileType>(
        Traits::type(input),
        &fragment->type);
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_SEND_VALIDATION_H_