// components/services/filesystem/public/mojom/types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/services/filesystem/public/mojom/types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/safe_base_name.mojom-shared.h"


namespace filesystem::mojom {
class TimespecOrNowDataView;

class FileInformationDataView;

class DirectoryEntryDataView;



}  // filesystem::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::filesystem::mojom::TimespecOrNowDataView> {
  using Data = ::filesystem::mojom::internal::TimespecOrNow_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::filesystem::mojom::FileInformationDataView> {
  using Data = ::filesystem::mojom::internal::FileInformation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::filesystem::mojom::DirectoryEntryDataView> {
  using Data = ::filesystem::mojom::internal::DirectoryEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace filesystem::mojom {


enum class Whence : int32_t {
  
  FROM_BEGIN = 0,
  
  FROM_CURRENT = 1,
  
  FROM_END = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, Whence value);
inline bool IsKnownEnumValue(Whence value) {
  return internal::Whence_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FsFileType : int32_t {
  
  UNKNOWN = 0,
  
  REGULAR_FILE = 1,
  
  DIRECTORY = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FsFileType value);
inline bool IsKnownEnumValue(FsFileType value) {
  return internal::FsFileType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class TimespecOrNowDataView {
 public:
  TimespecOrNowDataView() = default;

  TimespecOrNowDataView(
      internal::TimespecOrNow_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool now() const {
    return data_->now;
  }
  double seconds() const {
    return data_->seconds;
  }
 private:
  internal::TimespecOrNow_Data* data_ = nullptr;
};


class FileInformationDataView {
 public:
  FileInformationDataView() = default;

  FileInformationDataView(
      internal::FileInformation_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::filesystem::mojom::FsFileType>(
        data_value, output);
  }
  FsFileType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::filesystem::mojom::FsFileType>(data_->type));
  }
  int64_t size() const {
    return data_->size;
  }
  double atime() const {
    return data_->atime;
  }
  double mtime() const {
    return data_->mtime;
  }
  double ctime() const {
    return data_->ctime;
  }
 private:
  internal::FileInformation_Data* data_ = nullptr;
};


class DirectoryEntryDataView {
 public:
  DirectoryEntryDataView() = default;

  DirectoryEntryDataView(
      internal::DirectoryEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::SafeBaseNameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::SafeBaseNameDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::filesystem::mojom::FsFileType>(
        data_value, output);
  }
  FsFileType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::filesystem::mojom::FsFileType>(data_->type));
  }
 private:
  internal::DirectoryEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // filesystem::mojom

#endif  // COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_TYPES_MOJOM_DATA_VIEW_H_