// components/services/filesystem/public/mojom/directory.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('filesystem.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
filesystem.mojom.DirectoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        filesystem.mojom.Directory.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { filesystem.mojom.DirectoryInterface }
 */
filesystem.mojom.DirectoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!filesystem.mojom.DirectoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          filesystem.mojom.DirectoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!filesystem.mojom.DirectoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
        directoryContents: ?Array<!filesystem.mojom.DirectoryEntry>,
   *  }>}
   */

  read() {
    return this.proxy.sendMessage(
        0,
        filesystem.mojom.Directory_Read_ParamsSpec.$,
        filesystem.mojom.Directory_Read_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { !number } openFlags
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
        fileHandle: ?mojoBase.mojom.File,
   *  }>}
   */

  openFileHandle(
      path,
      openFlags) {
    return this.proxy.sendMessage(
        1,
        filesystem.mojom.Directory_OpenFileHandle_ParamsSpec.$,
        filesystem.mojom.Directory_OpenFileHandle_ResponseParamsSpec.$,
        [
          path,
          openFlags
        ],
        false);
  }

  
  /**
   * @param { !Array<!filesystem.mojom.FileOpenDetails> } files
   * @return {!Promise<{
        results: !Array<!filesystem.mojom.FileOpenResult>,
   *  }>}
   */

  openFileHandles(
      files) {
    return this.proxy.sendMessage(
        2,
        filesystem.mojom.Directory_OpenFileHandles_ParamsSpec.$,
        filesystem.mojom.Directory_OpenFileHandles_ResponseParamsSpec.$,
        [
          files
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { ?filesystem.mojom.DirectoryPendingReceiver } directory
   * @param { !number } openFlags
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  openDirectory(
      path,
      directory,
      openFlags) {
    return this.proxy.sendMessage(
        3,
        filesystem.mojom.Directory_OpenDirectory_ParamsSpec.$,
        filesystem.mojom.Directory_OpenDirectory_ResponseParamsSpec.$,
        [
          path,
          directory,
          openFlags
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { !string } newPath
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  rename(
      path,
      newPath) {
    return this.proxy.sendMessage(
        4,
        filesystem.mojom.Directory_Rename_ParamsSpec.$,
        filesystem.mojom.Directory_Rename_ResponseParamsSpec.$,
        [
          path,
          newPath
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { !string } newPath
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  replace(
      path,
      newPath) {
    return this.proxy.sendMessage(
        5,
        filesystem.mojom.Directory_Replace_ParamsSpec.$,
        filesystem.mojom.Directory_Replace_ResponseParamsSpec.$,
        [
          path,
          newPath
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { !number } deleteFlags
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  delete(
      path,
      deleteFlags) {
    return this.proxy.sendMessage(
        6,
        filesystem.mojom.Directory_Delete_ParamsSpec.$,
        filesystem.mojom.Directory_Delete_ResponseParamsSpec.$,
        [
          path,
          deleteFlags
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
        exists: !boolean,
   *  }>}
   */

  exists(
      path) {
    return this.proxy.sendMessage(
        7,
        filesystem.mojom.Directory_Exists_ParamsSpec.$,
        filesystem.mojom.Directory_Exists_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
        isWritable: !boolean,
   *  }>}
   */

  isWritable(
      path) {
    return this.proxy.sendMessage(
        8,
        filesystem.mojom.Directory_IsWritable_ParamsSpec.$,
        filesystem.mojom.Directory_IsWritable_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  flush() {
    return this.proxy.sendMessage(
        9,
        filesystem.mojom.Directory_Flush_ParamsSpec.$,
        filesystem.mojom.Directory_Flush_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
        fileInformation: ?filesystem.mojom.FileInformation,
   *  }>}
   */

  statFile(
      path) {
    return this.proxy.sendMessage(
        10,
        filesystem.mojom.Directory_StatFile_ParamsSpec.$,
        filesystem.mojom.Directory_StatFile_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !filesystem.mojom.DirectoryPendingReceiver } directory
   */

  clone(
      directory) {
    this.proxy.sendMessage(
        11,
        filesystem.mojom.Directory_Clone_ParamsSpec.$,
        null,
        [
          directory
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
        data: !Array<!number>,
   *  }>}
   */

  readEntireFile(
      path) {
    return this.proxy.sendMessage(
        12,
        filesystem.mojom.Directory_ReadEntireFile_ParamsSpec.$,
        filesystem.mojom.Directory_ReadEntireFile_ResponseParamsSpec.$,
        [
          path
        ],
        false);
  }

  
  /**
   * @param { !string } path
   * @param { !Array<!number> } data
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  writeFile(
      path,
      data) {
    return this.proxy.sendMessage(
        13,
        filesystem.mojom.Directory_WriteFile_ParamsSpec.$,
        filesystem.mojom.Directory_WriteFile_ResponseParamsSpec.$,
        [
          path,
          data
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Directory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
filesystem.mojom.DirectoryReceiver = class {
  /**
   * @param {!filesystem.mojom.DirectoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!filesystem.mojom.DirectoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        filesystem.mojom.DirectoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!filesystem.mojom.DirectoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        filesystem.mojom.Directory_Read_ParamsSpec.$,
        filesystem.mojom.Directory_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        filesystem.mojom.Directory_OpenFileHandle_ParamsSpec.$,
        filesystem.mojom.Directory_OpenFileHandle_ResponseParamsSpec.$,
        impl.openFileHandle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        filesystem.mojom.Directory_OpenFileHandles_ParamsSpec.$,
        filesystem.mojom.Directory_OpenFileHandles_ResponseParamsSpec.$,
        impl.openFileHandles.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        filesystem.mojom.Directory_OpenDirectory_ParamsSpec.$,
        filesystem.mojom.Directory_OpenDirectory_ResponseParamsSpec.$,
        impl.openDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        filesystem.mojom.Directory_Rename_ParamsSpec.$,
        filesystem.mojom.Directory_Rename_ResponseParamsSpec.$,
        impl.rename.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        filesystem.mojom.Directory_Replace_ParamsSpec.$,
        filesystem.mojom.Directory_Replace_ResponseParamsSpec.$,
        impl.replace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        filesystem.mojom.Directory_Delete_ParamsSpec.$,
        filesystem.mojom.Directory_Delete_ResponseParamsSpec.$,
        impl.delete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        filesystem.mojom.Directory_Exists_ParamsSpec.$,
        filesystem.mojom.Directory_Exists_ResponseParamsSpec.$,
        impl.exists.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        filesystem.mojom.Directory_IsWritable_ParamsSpec.$,
        filesystem.mojom.Directory_IsWritable_ResponseParamsSpec.$,
        impl.isWritable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        filesystem.mojom.Directory_Flush_ParamsSpec.$,
        filesystem.mojom.Directory_Flush_ResponseParamsSpec.$,
        impl.flush.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        filesystem.mojom.Directory_StatFile_ParamsSpec.$,
        filesystem.mojom.Directory_StatFile_ResponseParamsSpec.$,
        impl.statFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        filesystem.mojom.Directory_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        filesystem.mojom.Directory_ReadEntireFile_ParamsSpec.$,
        filesystem.mojom.Directory_ReadEntireFile_ResponseParamsSpec.$,
        impl.readEntireFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        filesystem.mojom.Directory_WriteFile_ParamsSpec.$,
        filesystem.mojom.Directory_WriteFile_ResponseParamsSpec.$,
        impl.writeFile.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
filesystem.mojom.Directory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "filesystem.mojom.Directory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!filesystem.mojom.DirectoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new filesystem.mojom.DirectoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Directory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
filesystem.mojom.DirectoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      filesystem.mojom.DirectoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!filesystem.mojom.DirectoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        filesystem.mojom.Directory_Read_ParamsSpec.$,
        filesystem.mojom.Directory_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFileHandle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        filesystem.mojom.Directory_OpenFileHandle_ParamsSpec.$,
        filesystem.mojom.Directory_OpenFileHandle_ResponseParamsSpec.$,
        this.openFileHandle.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFileHandles =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        filesystem.mojom.Directory_OpenFileHandles_ParamsSpec.$,
        filesystem.mojom.Directory_OpenFileHandles_ResponseParamsSpec.$,
        this.openFileHandles.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        filesystem.mojom.Directory_OpenDirectory_ParamsSpec.$,
        filesystem.mojom.Directory_OpenDirectory_ResponseParamsSpec.$,
        this.openDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rename =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        filesystem.mojom.Directory_Rename_ParamsSpec.$,
        filesystem.mojom.Directory_Rename_ResponseParamsSpec.$,
        this.rename.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        filesystem.mojom.Directory_Replace_ParamsSpec.$,
        filesystem.mojom.Directory_Replace_ResponseParamsSpec.$,
        this.replace.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.delete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        filesystem.mojom.Directory_Delete_ParamsSpec.$,
        filesystem.mojom.Directory_Delete_ResponseParamsSpec.$,
        this.delete.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exists =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        filesystem.mojom.Directory_Exists_ParamsSpec.$,
        filesystem.mojom.Directory_Exists_ResponseParamsSpec.$,
        this.exists.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isWritable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        filesystem.mojom.Directory_IsWritable_ParamsSpec.$,
        filesystem.mojom.Directory_IsWritable_ResponseParamsSpec.$,
        this.isWritable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        filesystem.mojom.Directory_Flush_ParamsSpec.$,
        filesystem.mojom.Directory_Flush_ResponseParamsSpec.$,
        this.flush.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.statFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        filesystem.mojom.Directory_StatFile_ParamsSpec.$,
        filesystem.mojom.Directory_StatFile_ResponseParamsSpec.$,
        this.statFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        filesystem.mojom.Directory_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.readEntireFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        filesystem.mojom.Directory_ReadEntireFile_ParamsSpec.$,
        filesystem.mojom.Directory_ReadEntireFile_ResponseParamsSpec.$,
        this.readEntireFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.writeFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        filesystem.mojom.Directory_WriteFile_ParamsSpec.$,
        filesystem.mojom.Directory_WriteFile_ResponseParamsSpec.$,
        this.writeFile.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.FileOpenDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.FileOpenResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_OpenFileHandle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_OpenFileHandle_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_OpenFileHandles_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_OpenFileHandles_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_OpenDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_OpenDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Rename_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Rename_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Replace_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Replace_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Delete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Delete_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Exists_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Exists_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_IsWritable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_IsWritable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Flush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Flush_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_StatFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_StatFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_ReadEntireFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_ReadEntireFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_WriteFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
filesystem.mojom.Directory_WriteFile_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    filesystem.mojom.FileOpenDetailsSpec.$,
    'FileOpenDetails',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'openFlags', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.FileOpenDetails = class {
  constructor() {
    /** @export { !string } */
    this.path;
    /** @export { !number } */
    this.openFlags;
  }
};



mojo.internal.Struct(
    filesystem.mojom.FileOpenResultSpec.$,
    'FileOpenResult',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileHandle', 16,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
filesystem.mojom.FileOpenResult = class {
  constructor() {
    /** @export { !string } */
    this.path;
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
    /** @export { (mojoBase.mojom.File|undefined) } */
    this.fileHandle;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Read_ParamsSpec.$,
    'Directory_Read_Params',
    [
    ],
    [[0, 8],]);





/** @record */
filesystem.mojom.Directory_Read_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Read_ResponseParamsSpec.$,
    'Directory_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directoryContents', 8,
        0,
        mojo.internal.Array(filesystem.mojom.DirectoryEntrySpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.Directory_Read_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
    /** @export { (Array<!filesystem.mojom.DirectoryEntry>|undefined) } */
    this.directoryContents;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_OpenFileHandle_ParamsSpec.$,
    'Directory_OpenFileHandle_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'openFlags', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.Directory_OpenFileHandle_Params = class {
  constructor() {
    /** @export { !string } */
    this.path;
    /** @export { !number } */
    this.openFlags;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_OpenFileHandle_ResponseParamsSpec.$,
    'Directory_OpenFileHandle_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileHandle', 8,
        0,
        mojoBase.mojom.FileSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.Directory_OpenFileHandle_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
    /** @export { (mojoBase.mojom.File|undefined) } */
    this.fileHandle;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_OpenFileHandles_ParamsSpec.$,
    'Directory_OpenFileHandles_Params',
    [
      mojo.internal.StructField(
        'files', 0,
        0,
        mojo.internal.Array(filesystem.mojom.FileOpenDetailsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_OpenFileHandles_Params = class {
  constructor() {
    /** @export { !Array<!filesystem.mojom.FileOpenDetails> } */
    this.files;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_OpenFileHandles_ResponseParamsSpec.$,
    'Directory_OpenFileHandles_ResponseParams',
    [
      mojo.internal.StructField(
        'results', 0,
        0,
        mojo.internal.Array(filesystem.mojom.FileOpenResultSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_OpenFileHandles_ResponseParams = class {
  constructor() {
    /** @export { !Array<!filesystem.mojom.FileOpenResult> } */
    this.results;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_OpenDirectory_ParamsSpec.$,
    'Directory_OpenDirectory_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceRequest(filesystem.mojom.DirectoryPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'openFlags', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.Directory_OpenDirectory_Params = class {
  constructor() {
    /** @export { !string } */
    this.path;
    /** @export { (filesystem.mojom.DirectoryPendingReceiver|undefined) } */
    this.directory;
    /** @export { !number } */
    this.openFlags;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_OpenDirectory_ResponseParamsSpec.$,
    'Directory_OpenDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_OpenDirectory_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Rename_ParamsSpec.$,
    'Directory_Rename_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newPath', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.Directory_Rename_Params = class {
  constructor() {
    /** @export { !string } */
    this.path;
    /** @export { !string } */
    this.newPath;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Rename_ResponseParamsSpec.$,
    'Directory_Rename_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_Rename_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Replace_ParamsSpec.$,
    'Directory_Replace_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newPath', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.Directory_Replace_Params = class {
  constructor() {
    /** @export { !string } */
    this.path;
    /** @export { !string } */
    this.newPath;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Replace_ResponseParamsSpec.$,
    'Directory_Replace_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_Replace_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Delete_ParamsSpec.$,
    'Directory_Delete_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deleteFlags', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.Directory_Delete_Params = class {
  constructor() {
    /** @export { !string } */
    this.path;
    /** @export { !number } */
    this.deleteFlags;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Delete_ResponseParamsSpec.$,
    'Directory_Delete_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_Delete_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Exists_ParamsSpec.$,
    'Directory_Exists_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_Exists_Params = class {
  constructor() {
    /** @export { !string } */
    this.path;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Exists_ResponseParamsSpec.$,
    'Directory_Exists_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exists', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_Exists_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
    /** @export { !boolean } */
    this.exists;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_IsWritable_ParamsSpec.$,
    'Directory_IsWritable_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_IsWritable_Params = class {
  constructor() {
    /** @export { !string } */
    this.path;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_IsWritable_ResponseParamsSpec.$,
    'Directory_IsWritable_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isWritable', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_IsWritable_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
    /** @export { !boolean } */
    this.isWritable;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Flush_ParamsSpec.$,
    'Directory_Flush_Params',
    [
    ],
    [[0, 8],]);





/** @record */
filesystem.mojom.Directory_Flush_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Flush_ResponseParamsSpec.$,
    'Directory_Flush_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_Flush_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_StatFile_ParamsSpec.$,
    'Directory_StatFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_StatFile_Params = class {
  constructor() {
    /** @export { !string } */
    this.path;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_StatFile_ResponseParamsSpec.$,
    'Directory_StatFile_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileInformation', 8,
        0,
        filesystem.mojom.FileInformationSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.Directory_StatFile_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
    /** @export { (filesystem.mojom.FileInformation|undefined) } */
    this.fileInformation;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_Clone_ParamsSpec.$,
    'Directory_Clone_Params',
    [
      mojo.internal.StructField(
        'directory', 0,
        0,
        mojo.internal.InterfaceRequest(filesystem.mojom.DirectoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_Clone_Params = class {
  constructor() {
    /** @export { !filesystem.mojom.DirectoryPendingReceiver } */
    this.directory;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_ReadEntireFile_ParamsSpec.$,
    'Directory_ReadEntireFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_ReadEntireFile_Params = class {
  constructor() {
    /** @export { !string } */
    this.path;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_ReadEntireFile_ResponseParamsSpec.$,
    'Directory_ReadEntireFile_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.Directory_ReadEntireFile_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_WriteFile_ParamsSpec.$,
    'Directory_WriteFile_Params',
    [
      mojo.internal.StructField(
        'path', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
filesystem.mojom.Directory_WriteFile_Params = class {
  constructor() {
    /** @export { !string } */
    this.path;
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    filesystem.mojom.Directory_WriteFile_ResponseParamsSpec.$,
    'Directory_WriteFile_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
filesystem.mojom.Directory_WriteFile_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
  }
};

