// components/schema_org/common/metadata.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/schema_org/common/metadata.mojom-shared-internal.h"


namespace schema_org::mojom {
class PropertyDataView;

class EntityDataView;

class ValuesDataView;


}  // schema_org::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::schema_org::mojom::PropertyDataView> {
  using Data = ::schema_org::mojom::internal::Property_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::schema_org::mojom::EntityDataView> {
  using Data = ::schema_org::mojom::internal::Entity_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::schema_org::mojom::ValuesDataView> {
  using Data = ::schema_org::mojom::internal::Values_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace schema_org::mojom {


class PropertyDataView {
 public:
  PropertyDataView() = default;

  PropertyDataView(
      internal::Property_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValuesDataView(
      ValuesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValues(UserType* output) {
    
    auto* pointer = !data_->values.is_null() ? &data_->values : nullptr;
    return mojo::internal::Deserialize<::schema_org::mojom::ValuesDataView>(
        pointer, output, message_);
  }
 private:
  internal::Property_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EntityDataView {
 public:
  EntityDataView() = default;

  EntityDataView(
      internal::Entity_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPropertiesDataView(
      mojo::ArrayDataView<PropertyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProperties(UserType* output) {
    
    auto* pointer = data_->properties.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::schema_org::mojom::PropertyDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Entity_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ValuesDataView {
 public:
  using Tag = internal::Values_Data::Values_Tag;

  ValuesDataView() = default;

  ValuesDataView(
      internal::Values_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_bool_values() const { return data_->tag == Tag::kBoolValues; }
  inline void GetBoolValuesDataView(
      mojo::ArrayDataView<bool>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBoolValues(UserType* output) const {
    
    CHECK(is_bool_values());
    return mojo::internal::Deserialize<mojo::ArrayDataView<bool>>(
        data_->data.f_bool_values.Get(), output, message_);
  }
  bool is_long_values() const { return data_->tag == Tag::kLongValues; }
  inline void GetLongValuesDataView(
      mojo::ArrayDataView<int64_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLongValues(UserType* output) const {
    
    CHECK(is_long_values());
    return mojo::internal::Deserialize<mojo::ArrayDataView<int64_t>>(
        data_->data.f_long_values.Get(), output, message_);
  }
  bool is_string_values() const { return data_->tag == Tag::kStringValues; }
  inline void GetStringValuesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadStringValues(UserType* output) const {
    
    CHECK(is_string_values());
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        data_->data.f_string_values.Get(), output, message_);
  }
  bool is_entity_values() const { return data_->tag == Tag::kEntityValues; }
  inline void GetEntityValuesDataView(
      mojo::ArrayDataView<EntityDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEntityValues(UserType* output) const {
    
    CHECK(is_entity_values());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::schema_org::mojom::EntityDataView>>(
        data_->data.f_entity_values.Get(), output, message_);
  }

 private:
  internal::Values_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // schema_org::mojom

#endif  // COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_DATA_VIEW_H_