// components/safe_browsing/content/common/safe_browsing.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_H_
#define COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/safe_browsing/content/common/safe_browsing.mojom-features.h"  // IWYU pragma: export
#include "components/safe_browsing/content/common/safe_browsing.mojom-shared.h"  // IWYU pragma: export
#include "components/safe_browsing/content/common/safe_browsing.mojom-forward.h"  // IWYU pragma: export
#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom.h"
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "services/network/public/mojom/http_request_headers.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace safe_browsing::mojom {

class SafeBrowsingProxy;

template <typename ImplRefTraits>
class SafeBrowsingStub;

class SafeBrowsingRequestValidator;
class SafeBrowsingResponseValidator;


class SafeBrowsing
    : public SafeBrowsingInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "safe_browsing.mojom.SafeBrowsing";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SafeBrowsingInterfaceBase;
  using Proxy_ = SafeBrowsingProxy;

  template <typename ImplRefTraits>
  using Stub_ = SafeBrowsingStub<ImplRefTraits>;

  using RequestValidator_ = SafeBrowsingRequestValidator;
  using ResponseValidator_ = SafeBrowsingResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateCheckerAndCheckMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateCheckerAndCheck_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SafeBrowsing() = default;

  using CreateCheckerAndCheckCallback = base::OnceCallback<void(bool, bool)>;
  using CreateCheckerAndCheckMojoCallback = base::OnceCallback<void(bool, bool)>;

  virtual void CreateCheckerAndCheck(const std::optional<::blink::LocalFrameToken>& frame_token, ::mojo::PendingReceiver<::safe_browsing::mojom::SafeBrowsingUrlChecker> receiver, const ::GURL& url, const std::string& method, const ::net::HttpRequestHeaders& headers, int32_t load_flags, bool has_user_gesture, bool originated_from_service_worker, CreateCheckerAndCheckCallback callback) = 0;

  virtual void Clone(::mojo::PendingReceiver<SafeBrowsing> receiver) = 0;
};

class ThreatReporterProxy;

template <typename ImplRefTraits>
class ThreatReporterStub;

class ThreatReporterRequestValidator;
class ThreatReporterResponseValidator;


class ThreatReporter
    : public ThreatReporterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "safe_browsing.mojom.ThreatReporter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ThreatReporterInterfaceBase;
  using Proxy_ = ThreatReporterProxy;

  template <typename ImplRefTraits>
  using Stub_ = ThreatReporterStub<ImplRefTraits>;

  using RequestValidator_ = ThreatReporterRequestValidator;
  using ResponseValidator_ = ThreatReporterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetThreatDOMDetailsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetThreatDOMDetails_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ThreatReporter() = default;

  using GetThreatDOMDetailsCallback = base::OnceCallback<void(std::vector<ThreatDOMDetailsNodePtr>)>;
  using GetThreatDOMDetailsMojoCallback = base::OnceCallback<void(std::vector<ThreatDOMDetailsNodePtr>)>;

  virtual void GetThreatDOMDetails(GetThreatDOMDetailsCallback callback) = 0;
};

class PhishingDetectorProxy;

template <typename ImplRefTraits>
class PhishingDetectorStub;

class PhishingDetectorRequestValidator;
class PhishingDetectorResponseValidator;


class PhishingDetector
    : public PhishingDetectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "safe_browsing.mojom.PhishingDetector";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PhishingDetectorInterfaceBase;
  using Proxy_ = PhishingDetectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = PhishingDetectorStub<ImplRefTraits>;

  using RequestValidator_ = PhishingDetectorRequestValidator;
  using ResponseValidator_ = PhishingDetectorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartPhishingDetectionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartPhishingDetection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PhishingDetector() = default;

  using StartPhishingDetectionCallback = base::OnceCallback<void(PhishingDetectorResult, std::optional<::mojo_base::ProtoWrapper>)>;
  using StartPhishingDetectionMojoCallback = base::OnceCallback<void(PhishingDetectorResult, std::optional<::mojo_base::ProtoWrapper>)>;

  virtual void StartPhishingDetection(const ::GURL& url, ClientSideDetectionType request_type, StartPhishingDetectionCallback callback) = 0;
};

class PhishingModelSetterProxy;

template <typename ImplRefTraits>
class PhishingModelSetterStub;

class PhishingModelSetterRequestValidator;
class PhishingModelSetterResponseValidator;


class PhishingModelSetter
    : public PhishingModelSetterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "safe_browsing.mojom.PhishingModelSetter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PhishingModelSetterInterfaceBase;
  using Proxy_ = PhishingModelSetterProxy;

  template <typename ImplRefTraits>
  using Stub_ = PhishingModelSetterStub<ImplRefTraits>;

  using RequestValidator_ = PhishingModelSetterRequestValidator;
  using ResponseValidator_ = PhishingModelSetterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetImageEmbeddingAndPhishingFlatBufferModelMinVersion = 0,
    kAttachImageEmbeddingModelMinVersion = 0,
    kSetPhishingFlatBufferModelMinVersion = 0,
    kClearScorerMinVersion = 0,
    kSetTestObserverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetImageEmbeddingAndPhishingFlatBufferModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AttachImageEmbeddingModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPhishingFlatBufferModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearScorer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTestObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PhishingModelSetter() = default;

  virtual void SetImageEmbeddingAndPhishingFlatBufferModel(::base::ReadOnlySharedMemoryRegion region, ::base::File tflite_model, ::base::File image_embedding_model) = 0;

  virtual void AttachImageEmbeddingModel(::base::File image_embedding_model) = 0;

  virtual void SetPhishingFlatBufferModel(::base::ReadOnlySharedMemoryRegion region, ::base::File tflite_model) = 0;

  virtual void ClearScorer() = 0;

  using SetTestObserverCallback = base::OnceCallback<void()>;
  using SetTestObserverMojoCallback = base::OnceCallback<void()>;

  virtual void SetTestObserver(::mojo::PendingRemote<PhishingModelSetterTestObserver> observer, SetTestObserverCallback callback) = 0;
};

class PhishingModelSetterTestObserverProxy;

template <typename ImplRefTraits>
class PhishingModelSetterTestObserverStub;

class PhishingModelSetterTestObserverRequestValidator;


class PhishingModelSetterTestObserver
    : public PhishingModelSetterTestObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "safe_browsing.mojom.PhishingModelSetterTestObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PhishingModelSetterTestObserverInterfaceBase;
  using Proxy_ = PhishingModelSetterTestObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = PhishingModelSetterTestObserverStub<ImplRefTraits>;

  using RequestValidator_ = PhishingModelSetterTestObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPhishingModelUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PhishingModelUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PhishingModelSetterTestObserver() = default;

  virtual void PhishingModelUpdated() = 0;
};

class PhishingImageEmbedderDetectorProxy;

template <typename ImplRefTraits>
class PhishingImageEmbedderDetectorStub;

class PhishingImageEmbedderDetectorRequestValidator;
class PhishingImageEmbedderDetectorResponseValidator;


class PhishingImageEmbedderDetector
    : public PhishingImageEmbedderDetectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "safe_browsing.mojom.PhishingImageEmbedderDetector";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PhishingImageEmbedderDetectorInterfaceBase;
  using Proxy_ = PhishingImageEmbedderDetectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = PhishingImageEmbedderDetectorStub<ImplRefTraits>;

  using RequestValidator_ = PhishingImageEmbedderDetectorRequestValidator;
  using ResponseValidator_ = PhishingImageEmbedderDetectorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartImageEmbeddingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartImageEmbedding_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PhishingImageEmbedderDetector() = default;

  using StartImageEmbeddingCallback = base::OnceCallback<void(PhishingImageEmbeddingResult, std::optional<::mojo_base::ProtoWrapper>)>;
  using StartImageEmbeddingMojoCallback = base::OnceCallback<void(PhishingImageEmbeddingResult, std::optional<::mojo_base::ProtoWrapper>)>;

  virtual void StartImageEmbedding(const ::GURL& url, StartImageEmbeddingCallback callback) = 0;
};

class ExtensionWebRequestReporterProxy;

template <typename ImplRefTraits>
class ExtensionWebRequestReporterStub;

class ExtensionWebRequestReporterRequestValidator;


class ExtensionWebRequestReporter
    : public ExtensionWebRequestReporterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "safe_browsing.mojom.ExtensionWebRequestReporter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ExtensionWebRequestReporterInterfaceBase;
  using Proxy_ = ExtensionWebRequestReporterProxy;

  template <typename ImplRefTraits>
  using Stub_ = ExtensionWebRequestReporterStub<ImplRefTraits>;

  using RequestValidator_ = ExtensionWebRequestReporterRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendWebRequestDataMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendWebRequestData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ExtensionWebRequestReporter() = default;

  virtual void SendWebRequestData(const std::string& origin_extension_id, const ::GURL& telemetry_url, WebRequestProtocolType protocol_type, WebRequestContactInitiatorType contact_initiator_type) = 0;

  virtual void Clone(::mojo::PendingReceiver<ExtensionWebRequestReporter> receiver) = 0;
};



class  SafeBrowsingProxy
    : public SafeBrowsing {
 public:
  using InterfaceType = SafeBrowsing;

  explicit SafeBrowsingProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateCheckerAndCheck(const std::optional<::blink::LocalFrameToken>& frame_token, ::mojo::PendingReceiver<::safe_browsing::mojom::SafeBrowsingUrlChecker> receiver, const ::GURL& url, const std::string& method, const ::net::HttpRequestHeaders& headers, int32_t load_flags, bool has_user_gesture, bool originated_from_service_worker, CreateCheckerAndCheckCallback callback) final;
  
  void Clone(::mojo::PendingReceiver<SafeBrowsing> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ThreatReporterProxy
    : public ThreatReporter {
 public:
  using InterfaceType = ThreatReporter;

  explicit ThreatReporterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetThreatDOMDetails(GetThreatDOMDetailsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PhishingDetectorProxy
    : public PhishingDetector {
 public:
  using InterfaceType = PhishingDetector;

  explicit PhishingDetectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartPhishingDetection(const ::GURL& url, ClientSideDetectionType request_type, StartPhishingDetectionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PhishingModelSetterProxy
    : public PhishingModelSetter {
 public:
  using InterfaceType = PhishingModelSetter;

  explicit PhishingModelSetterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetImageEmbeddingAndPhishingFlatBufferModel(::base::ReadOnlySharedMemoryRegion region, ::base::File tflite_model, ::base::File image_embedding_model) final;
  
  void AttachImageEmbeddingModel(::base::File image_embedding_model) final;
  
  void SetPhishingFlatBufferModel(::base::ReadOnlySharedMemoryRegion region, ::base::File tflite_model) final;
  
  void ClearScorer() final;
  
  void SetTestObserver(::mojo::PendingRemote<PhishingModelSetterTestObserver> observer, SetTestObserverCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PhishingModelSetterTestObserverProxy
    : public PhishingModelSetterTestObserver {
 public:
  using InterfaceType = PhishingModelSetterTestObserver;

  explicit PhishingModelSetterTestObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PhishingModelUpdated() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PhishingImageEmbedderDetectorProxy
    : public PhishingImageEmbedderDetector {
 public:
  using InterfaceType = PhishingImageEmbedderDetector;

  explicit PhishingImageEmbedderDetectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartImageEmbedding(const ::GURL& url, StartImageEmbeddingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ExtensionWebRequestReporterProxy
    : public ExtensionWebRequestReporter {
 public:
  using InterfaceType = ExtensionWebRequestReporter;

  explicit ExtensionWebRequestReporterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendWebRequestData(const std::string& origin_extension_id, const ::GURL& telemetry_url, WebRequestProtocolType protocol_type, WebRequestContactInitiatorType contact_initiator_type) final;
  
  void Clone(::mojo::PendingReceiver<ExtensionWebRequestReporter> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SafeBrowsingStubDispatch {
 public:
  static bool Accept(SafeBrowsing* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SafeBrowsing* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SafeBrowsing>>
class SafeBrowsingStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SafeBrowsingStub() = default;
  ~SafeBrowsingStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SafeBrowsingStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SafeBrowsingStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ThreatReporterStubDispatch {
 public:
  static bool Accept(ThreatReporter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ThreatReporter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ThreatReporter>>
class ThreatReporterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ThreatReporterStub() = default;
  ~ThreatReporterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ThreatReporterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ThreatReporterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PhishingDetectorStubDispatch {
 public:
  static bool Accept(PhishingDetector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PhishingDetector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PhishingDetector>>
class PhishingDetectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PhishingDetectorStub() = default;
  ~PhishingDetectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PhishingDetectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PhishingDetectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PhishingModelSetterStubDispatch {
 public:
  static bool Accept(PhishingModelSetter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PhishingModelSetter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PhishingModelSetter>>
class PhishingModelSetterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PhishingModelSetterStub() = default;
  ~PhishingModelSetterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PhishingModelSetterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PhishingModelSetterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PhishingModelSetterTestObserverStubDispatch {
 public:
  static bool Accept(PhishingModelSetterTestObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PhishingModelSetterTestObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PhishingModelSetterTestObserver>>
class PhishingModelSetterTestObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PhishingModelSetterTestObserverStub() = default;
  ~PhishingModelSetterTestObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PhishingModelSetterTestObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PhishingModelSetterTestObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PhishingImageEmbedderDetectorStubDispatch {
 public:
  static bool Accept(PhishingImageEmbedderDetector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PhishingImageEmbedderDetector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PhishingImageEmbedderDetector>>
class PhishingImageEmbedderDetectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PhishingImageEmbedderDetectorStub() = default;
  ~PhishingImageEmbedderDetectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PhishingImageEmbedderDetectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PhishingImageEmbedderDetectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ExtensionWebRequestReporterStubDispatch {
 public:
  static bool Accept(ExtensionWebRequestReporter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ExtensionWebRequestReporter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ExtensionWebRequestReporter>>
class ExtensionWebRequestReporterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ExtensionWebRequestReporterStub() = default;
  ~ExtensionWebRequestReporterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ExtensionWebRequestReporterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ExtensionWebRequestReporterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SafeBrowsingRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ThreatReporterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PhishingDetectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PhishingModelSetterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PhishingModelSetterTestObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PhishingImageEmbedderDetectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ExtensionWebRequestReporterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SafeBrowsingResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ThreatReporterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PhishingDetectorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PhishingModelSetterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PhishingImageEmbedderDetectorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  AttributeNameValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AttributeNameValue, T>::value>;
  using DataView = AttributeNameValueDataView;
  using Data_ = internal::AttributeNameValue_Data;

  template <typename... Args>
  static AttributeNameValuePtr New(Args&&... args) {
    return AttributeNameValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AttributeNameValuePtr From(const U& u) {
    return mojo::TypeConverter<AttributeNameValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AttributeNameValue>::Convert(*this);
  }


  AttributeNameValue();

  AttributeNameValue(
      const std::string& name,
      const std::string& value);


  ~AttributeNameValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AttributeNameValuePtr>
  AttributeNameValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AttributeNameValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AttributeNameValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AttributeNameValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributeNameValue::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributeNameValue::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AttributeNameValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AttributeNameValue_UnserializedMessageContext<
            UserType, AttributeNameValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AttributeNameValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AttributeNameValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AttributeNameValue_UnserializedMessageContext<
            UserType, AttributeNameValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AttributeNameValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AttributeNameValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AttributeNameValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AttributeNameValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AttributeNameValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  ThreatDOMDetailsNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ThreatDOMDetailsNode, T>::value>;
  using DataView = ThreatDOMDetailsNodeDataView;
  using Data_ = internal::ThreatDOMDetailsNode_Data;

  template <typename... Args>
  static ThreatDOMDetailsNodePtr New(Args&&... args) {
    return ThreatDOMDetailsNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ThreatDOMDetailsNodePtr From(const U& u) {
    return mojo::TypeConverter<ThreatDOMDetailsNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ThreatDOMDetailsNode>::Convert(*this);
  }


  ThreatDOMDetailsNode();

  ThreatDOMDetailsNode(
      int32_t node_id,
      const ::GURL& url,
      const std::string& tag_name,
      const ::GURL& parent,
      int32_t parent_node_id,
      std::vector<::GURL> children,
      std::vector<int32_t> child_node_ids,
      std::vector<AttributeNameValuePtr> attributes,
      const std::optional<::blink::FrameToken>& child_frame_token,
      const std::string& inner_html);

ThreatDOMDetailsNode(const ThreatDOMDetailsNode&) = delete;
ThreatDOMDetailsNode& operator=(const ThreatDOMDetailsNode&) = delete;

  ~ThreatDOMDetailsNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ThreatDOMDetailsNodePtr>
  ThreatDOMDetailsNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ThreatDOMDetailsNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ThreatDOMDetailsNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ThreatDOMDetailsNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ThreatDOMDetailsNode::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ThreatDOMDetailsNode::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ThreatDOMDetailsNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ThreatDOMDetailsNode_UnserializedMessageContext<
            UserType, ThreatDOMDetailsNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ThreatDOMDetailsNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ThreatDOMDetailsNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ThreatDOMDetailsNode_UnserializedMessageContext<
            UserType, ThreatDOMDetailsNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ThreatDOMDetailsNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t node_id;
  
  ::GURL url;
  
  std::string tag_name;
  
  ::GURL parent;
  
  int32_t parent_node_id;
  
  std::vector<::GURL> children;
  
  std::vector<int32_t> child_node_ids;
  
  std::vector<AttributeNameValuePtr> attributes;
  
  std::optional<::blink::FrameToken> child_frame_token;
  
  std::string inner_html;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ThreatDOMDetailsNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ThreatDOMDetailsNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ThreatDOMDetailsNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ThreatDOMDetailsNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AttributeNameValuePtr AttributeNameValue::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value)
  );
}

template <typename T, AttributeNameValue::EnableIfSame<T>*>
bool AttributeNameValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, AttributeNameValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
ThreatDOMDetailsNodePtr ThreatDOMDetailsNode::Clone() const {
  return New(
      mojo::Clone(node_id),
      mojo::Clone(url),
      mojo::Clone(tag_name),
      mojo::Clone(parent),
      mojo::Clone(parent_node_id),
      mojo::Clone(children),
      mojo::Clone(child_node_ids),
      mojo::Clone(attributes),
      mojo::Clone(child_frame_token),
      mojo::Clone(inner_html)
  );
}

template <typename T, ThreatDOMDetailsNode::EnableIfSame<T>*>
bool ThreatDOMDetailsNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->node_id, other_struct.node_id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->tag_name, other_struct.tag_name))
    return false;
  if (!mojo::Equals(this->parent, other_struct.parent))
    return false;
  if (!mojo::Equals(this->parent_node_id, other_struct.parent_node_id))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  if (!mojo::Equals(this->child_node_ids, other_struct.child_node_ids))
    return false;
  if (!mojo::Equals(this->attributes, other_struct.attributes))
    return false;
  if (!mojo::Equals(this->child_frame_token, other_struct.child_frame_token))
    return false;
  if (!mojo::Equals(this->inner_html, other_struct.inner_html))
    return false;
  return true;
}

template <typename T, ThreatDOMDetailsNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.node_id < rhs.node_id)
    return true;
  if (rhs.node_id < lhs.node_id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.tag_name < rhs.tag_name)
    return true;
  if (rhs.tag_name < lhs.tag_name)
    return false;
  if (lhs.parent < rhs.parent)
    return true;
  if (rhs.parent < lhs.parent)
    return false;
  if (lhs.parent_node_id < rhs.parent_node_id)
    return true;
  if (rhs.parent_node_id < lhs.parent_node_id)
    return false;
  if (lhs.children < rhs.children)
    return true;
  if (rhs.children < lhs.children)
    return false;
  if (lhs.child_node_ids < rhs.child_node_ids)
    return true;
  if (rhs.child_node_ids < lhs.child_node_ids)
    return false;
  if (lhs.attributes < rhs.attributes)
    return true;
  if (rhs.attributes < lhs.attributes)
    return false;
  if (lhs.child_frame_token < rhs.child_frame_token)
    return true;
  if (rhs.child_frame_token < lhs.child_frame_token)
    return false;
  if (lhs.inner_html < rhs.inner_html)
    return true;
  if (rhs.inner_html < lhs.inner_html)
    return false;
  return false;
}


}  // safe_browsing::mojom

namespace mojo {


template <>
struct  StructTraits<::safe_browsing::mojom::AttributeNameValue::DataView,
                                         ::safe_browsing::mojom::AttributeNameValuePtr> {
  static bool IsNull(const ::safe_browsing::mojom::AttributeNameValuePtr& input) { return !input; }
  static void SetToNull(::safe_browsing::mojom::AttributeNameValuePtr* output) { output->reset(); }

  static const decltype(::safe_browsing::mojom::AttributeNameValue::name)& name(
      const ::safe_browsing::mojom::AttributeNameValuePtr& input) {
    return input->name;
  }

  static const decltype(::safe_browsing::mojom::AttributeNameValue::value)& value(
      const ::safe_browsing::mojom::AttributeNameValuePtr& input) {
    return input->value;
  }

  static bool Read(::safe_browsing::mojom::AttributeNameValue::DataView input, ::safe_browsing::mojom::AttributeNameValuePtr* output);
};


template <>
struct  StructTraits<::safe_browsing::mojom::ThreatDOMDetailsNode::DataView,
                                         ::safe_browsing::mojom::ThreatDOMDetailsNodePtr> {
  static bool IsNull(const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) { return !input; }
  static void SetToNull(::safe_browsing::mojom::ThreatDOMDetailsNodePtr* output) { output->reset(); }

  static decltype(::safe_browsing::mojom::ThreatDOMDetailsNode::node_id) node_id(
      const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) {
    return input->node_id;
  }

  static const decltype(::safe_browsing::mojom::ThreatDOMDetailsNode::url)& url(
      const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) {
    return input->url;
  }

  static const decltype(::safe_browsing::mojom::ThreatDOMDetailsNode::tag_name)& tag_name(
      const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) {
    return input->tag_name;
  }

  static const decltype(::safe_browsing::mojom::ThreatDOMDetailsNode::parent)& parent(
      const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) {
    return input->parent;
  }

  static decltype(::safe_browsing::mojom::ThreatDOMDetailsNode::parent_node_id) parent_node_id(
      const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) {
    return input->parent_node_id;
  }

  static const decltype(::safe_browsing::mojom::ThreatDOMDetailsNode::children)& children(
      const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) {
    return input->children;
  }

  static const decltype(::safe_browsing::mojom::ThreatDOMDetailsNode::child_node_ids)& child_node_ids(
      const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) {
    return input->child_node_ids;
  }

  static const decltype(::safe_browsing::mojom::ThreatDOMDetailsNode::attributes)& attributes(
      const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) {
    return input->attributes;
  }

  static const decltype(::safe_browsing::mojom::ThreatDOMDetailsNode::child_frame_token)& child_frame_token(
      const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) {
    return input->child_frame_token;
  }

  static const decltype(::safe_browsing::mojom::ThreatDOMDetailsNode::inner_html)& inner_html(
      const ::safe_browsing::mojom::ThreatDOMDetailsNodePtr& input) {
    return input->inner_html;
  }

  static bool Read(::safe_browsing::mojom::ThreatDOMDetailsNode::DataView input, ::safe_browsing::mojom::ThreatDOMDetailsNodePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_H_