// components/safe_browsing/content/common/safe_browsing.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/safe_browsing/content/common/safe_browsing.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/safe_browsing/content/common/safe_browsing.mojom-params-data.h"
#include "components/safe_browsing/content/common/safe_browsing.mojom-shared-message-ids.h"

#include "components/safe_browsing/content/common/safe_browsing.mojom-import-headers.h"
#include "components/safe_browsing/content/common/safe_browsing.mojom-test-utils.h"


namespace safe_browsing::mojom {
AttributeNameValue::AttributeNameValue()
    : name(),
      value() {}

AttributeNameValue::AttributeNameValue(
    const std::string& name_in,
    const std::string& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

AttributeNameValue::~AttributeNameValue() = default;
size_t AttributeNameValue::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void AttributeNameValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AttributeNameValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ThreatDOMDetailsNode::ThreatDOMDetailsNode()
    : node_id(),
      url(),
      tag_name(),
      parent(),
      parent_node_id(),
      children(),
      child_node_ids(),
      attributes(),
      child_frame_token(),
      inner_html() {}

ThreatDOMDetailsNode::ThreatDOMDetailsNode(
    int32_t node_id_in,
    const ::GURL& url_in,
    const std::string& tag_name_in,
    const ::GURL& parent_in,
    int32_t parent_node_id_in,
    std::vector<::GURL> children_in,
    std::vector<int32_t> child_node_ids_in,
    std::vector<AttributeNameValuePtr> attributes_in,
    const std::optional<::blink::FrameToken>& child_frame_token_in,
    const std::string& inner_html_in)
    : node_id(std::move(node_id_in)),
      url(std::move(url_in)),
      tag_name(std::move(tag_name_in)),
      parent(std::move(parent_in)),
      parent_node_id(std::move(parent_node_id_in)),
      children(std::move(children_in)),
      child_node_ids(std::move(child_node_ids_in)),
      attributes(std::move(attributes_in)),
      child_frame_token(std::move(child_frame_token_in)),
      inner_html(std::move(inner_html_in)) {}

ThreatDOMDetailsNode::~ThreatDOMDetailsNode() = default;

void ThreatDOMDetailsNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_id"), this->node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tag_name"), this->tag_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent"), this->parent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_node_id"), this->parent_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children"), this->children,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "child_node_ids"), this->child_node_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attributes"), this->attributes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AttributeNameValuePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "child_frame_token"), this->child_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::FrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inner_html"), this->inner_html,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ThreatDOMDetailsNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SafeBrowsing::IPCStableHashFunction SafeBrowsing::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SafeBrowsing>(message.name())) {
    case messages::SafeBrowsing::kCreateCheckerAndCheck: {
      return &SafeBrowsing::CreateCheckerAndCheck_Sym::IPCStableHash;
    }
    case messages::SafeBrowsing::kClone: {
      return &SafeBrowsing::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SafeBrowsing::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SafeBrowsing>(message.name())) {
      case messages::SafeBrowsing::kCreateCheckerAndCheck:
            return "Receive safe_browsing::mojom::SafeBrowsing::CreateCheckerAndCheck";
      case messages::SafeBrowsing::kClone:
            return "Receive safe_browsing::mojom::SafeBrowsing::Clone";
    }
  } else {
    switch (static_cast<messages::SafeBrowsing>(message.name())) {
      case messages::SafeBrowsing::kCreateCheckerAndCheck:
            return "Receive reply safe_browsing::mojom::SafeBrowsing::CreateCheckerAndCheck";
      case messages::SafeBrowsing::kClone:
            return "Receive reply safe_browsing::mojom::SafeBrowsing::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SafeBrowsing::CreateCheckerAndCheck_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x203d6081;  // IPCStableHash for safe_browsing::mojom::SafeBrowsing::CreateCheckerAndCheck
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SafeBrowsing::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x825540ce;  // IPCStableHash for safe_browsing::mojom::SafeBrowsing::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SafeBrowsing_CreateCheckerAndCheck_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SafeBrowsing_CreateCheckerAndCheck_ForwardToCallback(
      SafeBrowsing::CreateCheckerAndCheckCallback callback
      ) : callback_(std::move(callback)) {
  }

  SafeBrowsing_CreateCheckerAndCheck_ForwardToCallback(const SafeBrowsing_CreateCheckerAndCheck_ForwardToCallback&) = delete;
  SafeBrowsing_CreateCheckerAndCheck_ForwardToCallback& operator=(const SafeBrowsing_CreateCheckerAndCheck_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SafeBrowsing::CreateCheckerAndCheckCallback callback_;
};

SafeBrowsingProxy::SafeBrowsingProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SafeBrowsingProxy::CreateCheckerAndCheck(
    const std::optional<::blink::LocalFrameToken>& in_frame_token, ::mojo::PendingReceiver<::safe_browsing::mojom::SafeBrowsingUrlChecker> in_receiver, const ::GURL& in_url, const std::string& in_method, const ::net::HttpRequestHeaders& in_headers, int32_t in_load_flags, bool in_has_user_gesture, bool in_originated_from_service_worker, CreateCheckerAndCheckCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::SafeBrowsing::CreateCheckerAndCheck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_token"), in_frame_token,
                        "<value of type const std::optional<::blink::LocalFrameToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::safe_browsing::mojom::SafeBrowsingUrlChecker>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method"), in_method,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type const ::net::HttpRequestHeaders&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("load_flags"), in_load_flags,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_user_gesture"), in_has_user_gesture,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("originated_from_service_worker"), in_originated_from_service_worker,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeBrowsing::kCreateCheckerAndCheck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::SafeBrowsing_CreateCheckerAndCheck_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_token)::BaseType> frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_frame_token,
    frame_token_fragment);

  params->frame_token.Set(
      frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::safe_browsing::mojom::SafeBrowsingUrlCheckerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in SafeBrowsing.CreateCheckerAndCheck request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in SafeBrowsing.CreateCheckerAndCheck request");
  mojo::internal::MessageFragment<
      typename decltype(params->method)::BaseType> method_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_method,
    method_fragment);

  params->method.Set(
      method_fragment.is_null() ? nullptr : method_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->method.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null method in SafeBrowsing.CreateCheckerAndCheck request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
    in_headers,
    headers_fragment);

  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null headers in SafeBrowsing.CreateCheckerAndCheck request");

  params->load_flags = in_load_flags;

  params->has_user_gesture = in_has_user_gesture;

  params->originated_from_service_worker = in_originated_from_service_worker;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeBrowsing::Name_);
  message.set_method_name("CreateCheckerAndCheck");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SafeBrowsing_CreateCheckerAndCheck_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SafeBrowsingProxy::Clone(
    ::mojo::PendingReceiver<SafeBrowsing> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::SafeBrowsing::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<SafeBrowsing>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeBrowsing::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::SafeBrowsing_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::safe_browsing::mojom::SafeBrowsingInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in SafeBrowsing.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeBrowsing::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class SafeBrowsing_CreateCheckerAndCheck_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SafeBrowsing::CreateCheckerAndCheckCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SafeBrowsing_CreateCheckerAndCheck_ProxyToResponder> proxy(
        new SafeBrowsing_CreateCheckerAndCheck_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SafeBrowsing_CreateCheckerAndCheck_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SafeBrowsing_CreateCheckerAndCheck_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SafeBrowsing_CreateCheckerAndCheck_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SafeBrowsing::CreateCheckerAndCheckCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_proceed, bool in_showed_interstitial);
};

bool SafeBrowsing_CreateCheckerAndCheck_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SafeBrowsing.0
  bool success = true;
  bool p_proceed{};
  bool p_showed_interstitial{};
  SafeBrowsing_CreateCheckerAndCheck_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_proceed = input_data_view.proceed();
  if (success)
    p_showed_interstitial = input_data_view.showed_interstitial();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SafeBrowsing::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_proceed), 
std::move(p_showed_interstitial));
  }
  return true;
}

void SafeBrowsing_CreateCheckerAndCheck_ProxyToResponder::Run(
    bool in_proceed, bool in_showed_interstitial) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply safe_browsing::mojom::SafeBrowsing::CreateCheckerAndCheck", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proceed"), in_proceed,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("showed_interstitial"), in_showed_interstitial,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SafeBrowsing::kCreateCheckerAndCheck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->proceed = in_proceed;

  params->showed_interstitial = in_showed_interstitial;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SafeBrowsing::Name_);
  message.set_method_name("CreateCheckerAndCheck");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SafeBrowsingStubDispatch::Accept(
    SafeBrowsing* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SafeBrowsing>(message->header()->name)) {
    case messages::SafeBrowsing::kCreateCheckerAndCheck: {
      break;
    }
    case messages::SafeBrowsing::kClone: {
      DCHECK(message->is_serialized());
      internal::SafeBrowsing_Clone_Params_Data* params =
          reinterpret_cast<internal::SafeBrowsing_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SafeBrowsing.1
      bool success = true;
      ::mojo::PendingReceiver<SafeBrowsing> p_receiver{};
      SafeBrowsing_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeBrowsing::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool SafeBrowsingStubDispatch::AcceptWithResponder(
    SafeBrowsing* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SafeBrowsing>(message->header()->name)) {
    case messages::SafeBrowsing::kCreateCheckerAndCheck: {
      internal::SafeBrowsing_CreateCheckerAndCheck_Params_Data* params =
          reinterpret_cast<
              internal::SafeBrowsing_CreateCheckerAndCheck_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SafeBrowsing.0
      bool success = true;
      std::optional<::blink::LocalFrameToken> p_frame_token{};
      ::mojo::PendingReceiver<::safe_browsing::mojom::SafeBrowsingUrlChecker> p_receiver{};
      ::GURL p_url{};
      std::string p_method{};
      ::net::HttpRequestHeaders p_headers{};
      int32_t p_load_flags{};
      bool p_has_user_gesture{};
      bool p_originated_from_service_worker{};
      SafeBrowsing_CreateCheckerAndCheck_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameToken(&p_frame_token))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadMethod(&p_method))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success)
        p_load_flags = input_data_view.load_flags();
      if (success)
        p_has_user_gesture = input_data_view.has_user_gesture();
      if (success)
        p_originated_from_service_worker = input_data_view.originated_from_service_worker();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SafeBrowsing::Name_, 0, false);
        return false;
      }
      auto callback =
          SafeBrowsing_CreateCheckerAndCheck_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCheckerAndCheck(        
        std::move(p_frame_token), 
        std::move(p_receiver), 
        std::move(p_url), 
        std::move(p_method), 
        std::move(p_headers), 
        std::move(p_load_flags), 
        std::move(p_has_user_gesture), 
        std::move(p_originated_from_service_worker), std::move(callback));
      return true;
    }
    case messages::SafeBrowsing::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSafeBrowsingValidationInfo[] = {
    { &internal::SafeBrowsing_CreateCheckerAndCheck_Params_Data::Validate,
     &internal::SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data::Validate},
    { &internal::SafeBrowsing_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool SafeBrowsingRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::safe_browsing::mojom::SafeBrowsing::Name_,
    kSafeBrowsingValidationInfo);
}

bool SafeBrowsingResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::safe_browsing::mojom::SafeBrowsing::Name_,
    kSafeBrowsingValidationInfo);
}
// The declaration includes the definition on other builds.

ThreatReporter::IPCStableHashFunction ThreatReporter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ThreatReporter>(message.name())) {
    case messages::ThreatReporter::kGetThreatDOMDetails: {
      return &ThreatReporter::GetThreatDOMDetails_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ThreatReporter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ThreatReporter>(message.name())) {
      case messages::ThreatReporter::kGetThreatDOMDetails:
            return "Receive safe_browsing::mojom::ThreatReporter::GetThreatDOMDetails";
    }
  } else {
    switch (static_cast<messages::ThreatReporter>(message.name())) {
      case messages::ThreatReporter::kGetThreatDOMDetails:
            return "Receive reply safe_browsing::mojom::ThreatReporter::GetThreatDOMDetails";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ThreatReporter::GetThreatDOMDetails_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe92e0daa;  // IPCStableHash for safe_browsing::mojom::ThreatReporter::GetThreatDOMDetails
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ThreatReporter_GetThreatDOMDetails_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ThreatReporter_GetThreatDOMDetails_ForwardToCallback(
      ThreatReporter::GetThreatDOMDetailsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ThreatReporter_GetThreatDOMDetails_ForwardToCallback(const ThreatReporter_GetThreatDOMDetails_ForwardToCallback&) = delete;
  ThreatReporter_GetThreatDOMDetails_ForwardToCallback& operator=(const ThreatReporter_GetThreatDOMDetails_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ThreatReporter::GetThreatDOMDetailsCallback callback_;
};

ThreatReporterProxy::ThreatReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ThreatReporterProxy::GetThreatDOMDetails(
    GetThreatDOMDetailsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send safe_browsing::mojom::ThreatReporter::GetThreatDOMDetails");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThreatReporter::kGetThreatDOMDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::ThreatReporter_GetThreatDOMDetails_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThreatReporter::Name_);
  message.set_method_name("GetThreatDOMDetails");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ThreatReporter_GetThreatDOMDetails_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ThreatReporter_GetThreatDOMDetails_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ThreatReporter::GetThreatDOMDetailsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ThreatReporter_GetThreatDOMDetails_ProxyToResponder> proxy(
        new ThreatReporter_GetThreatDOMDetails_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ThreatReporter_GetThreatDOMDetails_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ThreatReporter_GetThreatDOMDetails_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ThreatReporter_GetThreatDOMDetails_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ThreatReporter::GetThreatDOMDetailsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ThreatDOMDetailsNodePtr> in_nodes);
};

bool ThreatReporter_GetThreatDOMDetails_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ThreatReporter_GetThreatDOMDetails_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ThreatReporter_GetThreatDOMDetails_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ThreatReporter.0
  bool success = true;
  std::vector<ThreatDOMDetailsNodePtr> p_nodes{};
  ThreatReporter_GetThreatDOMDetails_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadNodes(&p_nodes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ThreatReporter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_nodes));
  }
  return true;
}

void ThreatReporter_GetThreatDOMDetails_ProxyToResponder::Run(
    std::vector<ThreatDOMDetailsNodePtr> in_nodes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply safe_browsing::mojom::ThreatReporter::GetThreatDOMDetails", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("nodes"), in_nodes,
                        "<value of type std::vector<ThreatDOMDetailsNodePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThreatReporter::kGetThreatDOMDetails), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::ThreatReporter_GetThreatDOMDetails_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->nodes)::BaseType>
      nodes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::safe_browsing::mojom::ThreatDOMDetailsNodeDataView>>(
    in_nodes,
    nodes_fragment,
    &nodes_validate_params);

  params->nodes.Set(
      nodes_fragment.is_null() ? nullptr : nodes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->nodes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null nodes in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThreatReporter::Name_);
  message.set_method_name("GetThreatDOMDetails");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ThreatReporterStubDispatch::Accept(
    ThreatReporter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ThreatReporter>(message->header()->name)) {
    case messages::ThreatReporter::kGetThreatDOMDetails: {
      break;
    }
  }
  return false;
}

// static
bool ThreatReporterStubDispatch::AcceptWithResponder(
    ThreatReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ThreatReporter>(message->header()->name)) {
    case messages::ThreatReporter::kGetThreatDOMDetails: {
      internal::ThreatReporter_GetThreatDOMDetails_Params_Data* params =
          reinterpret_cast<
              internal::ThreatReporter_GetThreatDOMDetails_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ThreatReporter.0
      bool success = true;
      ThreatReporter_GetThreatDOMDetails_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThreatReporter::Name_, 0, false);
        return false;
      }
      auto callback =
          ThreatReporter_GetThreatDOMDetails_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetThreatDOMDetails(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kThreatReporterValidationInfo[] = {
    { &internal::ThreatReporter_GetThreatDOMDetails_Params_Data::Validate,
     &internal::ThreatReporter_GetThreatDOMDetails_ResponseParams_Data::Validate},
};

bool ThreatReporterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::safe_browsing::mojom::ThreatReporter::Name_,
    kThreatReporterValidationInfo);
}

bool ThreatReporterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::safe_browsing::mojom::ThreatReporter::Name_,
    kThreatReporterValidationInfo);
}
// The declaration includes the definition on other builds.

PhishingDetector::IPCStableHashFunction PhishingDetector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PhishingDetector>(message.name())) {
    case messages::PhishingDetector::kStartPhishingDetection: {
      return &PhishingDetector::StartPhishingDetection_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PhishingDetector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PhishingDetector>(message.name())) {
      case messages::PhishingDetector::kStartPhishingDetection:
            return "Receive safe_browsing::mojom::PhishingDetector::StartPhishingDetection";
    }
  } else {
    switch (static_cast<messages::PhishingDetector>(message.name())) {
      case messages::PhishingDetector::kStartPhishingDetection:
            return "Receive reply safe_browsing::mojom::PhishingDetector::StartPhishingDetection";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PhishingDetector::StartPhishingDetection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe046b320;  // IPCStableHash for safe_browsing::mojom::PhishingDetector::StartPhishingDetection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PhishingDetector_StartPhishingDetection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PhishingDetector_StartPhishingDetection_ForwardToCallback(
      PhishingDetector::StartPhishingDetectionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PhishingDetector_StartPhishingDetection_ForwardToCallback(const PhishingDetector_StartPhishingDetection_ForwardToCallback&) = delete;
  PhishingDetector_StartPhishingDetection_ForwardToCallback& operator=(const PhishingDetector_StartPhishingDetection_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PhishingDetector::StartPhishingDetectionCallback callback_;
};

PhishingDetectorProxy::PhishingDetectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PhishingDetectorProxy::StartPhishingDetection(
    const ::GURL& in_url, ClientSideDetectionType in_request_type, StartPhishingDetectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::PhishingDetector::StartPhishingDetection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_type"), in_request_type,
                        "<value of type ClientSideDetectionType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingDetector::kStartPhishingDetection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingDetector_StartPhishingDetection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PhishingDetector.StartPhishingDetection request");

  
  mojo::internal::Serialize<::safe_browsing::mojom::ClientSideDetectionType>(
    in_request_type,
    &params->request_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingDetector::Name_);
  message.set_method_name("StartPhishingDetection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PhishingDetector_StartPhishingDetection_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PhishingDetector_StartPhishingDetection_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PhishingDetector::StartPhishingDetectionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PhishingDetector_StartPhishingDetection_ProxyToResponder> proxy(
        new PhishingDetector_StartPhishingDetection_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PhishingDetector_StartPhishingDetection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PhishingDetector_StartPhishingDetection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PhishingDetector_StartPhishingDetection_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PhishingDetector::StartPhishingDetectionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PhishingDetectorResult in_result, std::optional<::mojo_base::ProtoWrapper> in_request);
};

bool PhishingDetector_StartPhishingDetection_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PhishingDetector_StartPhishingDetection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PhishingDetector_StartPhishingDetection_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PhishingDetector.0
  bool success = true;
  PhishingDetectorResult p_result{};
  std::optional<::mojo_base::ProtoWrapper> p_request{};
  PhishingDetector_StartPhishingDetection_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadRequest(&p_request))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PhishingDetector::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_request));
  }
  return true;
}

void PhishingDetector_StartPhishingDetection_ProxyToResponder::Run(
    PhishingDetectorResult in_result, std::optional<::mojo_base::ProtoWrapper> in_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply safe_browsing::mojom::PhishingDetector::StartPhishingDetection", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PhishingDetectorResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type std::optional<::mojo_base::ProtoWrapper>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingDetector::kStartPhishingDetection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingDetector_StartPhishingDetection_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::safe_browsing::mojom::PhishingDetectorResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingDetector::Name_);
  message.set_method_name("StartPhishingDetection");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PhishingDetectorStubDispatch::Accept(
    PhishingDetector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PhishingDetector>(message->header()->name)) {
    case messages::PhishingDetector::kStartPhishingDetection: {
      break;
    }
  }
  return false;
}

// static
bool PhishingDetectorStubDispatch::AcceptWithResponder(
    PhishingDetector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PhishingDetector>(message->header()->name)) {
    case messages::PhishingDetector::kStartPhishingDetection: {
      internal::PhishingDetector_StartPhishingDetection_Params_Data* params =
          reinterpret_cast<
              internal::PhishingDetector_StartPhishingDetection_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PhishingDetector.0
      bool success = true;
      ::GURL p_url{};
      ClientSideDetectionType p_request_type{};
      PhishingDetector_StartPhishingDetection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadRequestType(&p_request_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PhishingDetector::Name_, 0, false);
        return false;
      }
      auto callback =
          PhishingDetector_StartPhishingDetection_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartPhishingDetection(        
        std::move(p_url), 
        std::move(p_request_type), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPhishingDetectorValidationInfo[] = {
    { &internal::PhishingDetector_StartPhishingDetection_Params_Data::Validate,
     &internal::PhishingDetector_StartPhishingDetection_ResponseParams_Data::Validate},
};

bool PhishingDetectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::safe_browsing::mojom::PhishingDetector::Name_,
    kPhishingDetectorValidationInfo);
}

bool PhishingDetectorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::safe_browsing::mojom::PhishingDetector::Name_,
    kPhishingDetectorValidationInfo);
}
// The declaration includes the definition on other builds.

PhishingModelSetter::IPCStableHashFunction PhishingModelSetter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PhishingModelSetter>(message.name())) {
    case messages::PhishingModelSetter::kSetImageEmbeddingAndPhishingFlatBufferModel: {
      return &PhishingModelSetter::SetImageEmbeddingAndPhishingFlatBufferModel_Sym::IPCStableHash;
    }
    case messages::PhishingModelSetter::kAttachImageEmbeddingModel: {
      return &PhishingModelSetter::AttachImageEmbeddingModel_Sym::IPCStableHash;
    }
    case messages::PhishingModelSetter::kSetPhishingFlatBufferModel: {
      return &PhishingModelSetter::SetPhishingFlatBufferModel_Sym::IPCStableHash;
    }
    case messages::PhishingModelSetter::kClearScorer: {
      return &PhishingModelSetter::ClearScorer_Sym::IPCStableHash;
    }
    case messages::PhishingModelSetter::kSetTestObserver: {
      return &PhishingModelSetter::SetTestObserver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PhishingModelSetter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PhishingModelSetter>(message.name())) {
      case messages::PhishingModelSetter::kSetImageEmbeddingAndPhishingFlatBufferModel:
            return "Receive safe_browsing::mojom::PhishingModelSetter::SetImageEmbeddingAndPhishingFlatBufferModel";
      case messages::PhishingModelSetter::kAttachImageEmbeddingModel:
            return "Receive safe_browsing::mojom::PhishingModelSetter::AttachImageEmbeddingModel";
      case messages::PhishingModelSetter::kSetPhishingFlatBufferModel:
            return "Receive safe_browsing::mojom::PhishingModelSetter::SetPhishingFlatBufferModel";
      case messages::PhishingModelSetter::kClearScorer:
            return "Receive safe_browsing::mojom::PhishingModelSetter::ClearScorer";
      case messages::PhishingModelSetter::kSetTestObserver:
            return "Receive safe_browsing::mojom::PhishingModelSetter::SetTestObserver";
    }
  } else {
    switch (static_cast<messages::PhishingModelSetter>(message.name())) {
      case messages::PhishingModelSetter::kSetImageEmbeddingAndPhishingFlatBufferModel:
            return "Receive reply safe_browsing::mojom::PhishingModelSetter::SetImageEmbeddingAndPhishingFlatBufferModel";
      case messages::PhishingModelSetter::kAttachImageEmbeddingModel:
            return "Receive reply safe_browsing::mojom::PhishingModelSetter::AttachImageEmbeddingModel";
      case messages::PhishingModelSetter::kSetPhishingFlatBufferModel:
            return "Receive reply safe_browsing::mojom::PhishingModelSetter::SetPhishingFlatBufferModel";
      case messages::PhishingModelSetter::kClearScorer:
            return "Receive reply safe_browsing::mojom::PhishingModelSetter::ClearScorer";
      case messages::PhishingModelSetter::kSetTestObserver:
            return "Receive reply safe_browsing::mojom::PhishingModelSetter::SetTestObserver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PhishingModelSetter::SetImageEmbeddingAndPhishingFlatBufferModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b1d4cd1;  // IPCStableHash for safe_browsing::mojom::PhishingModelSetter::SetImageEmbeddingAndPhishingFlatBufferModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PhishingModelSetter::AttachImageEmbeddingModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xda687603;  // IPCStableHash for safe_browsing::mojom::PhishingModelSetter::AttachImageEmbeddingModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PhishingModelSetter::SetPhishingFlatBufferModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x53a2a86c;  // IPCStableHash for safe_browsing::mojom::PhishingModelSetter::SetPhishingFlatBufferModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PhishingModelSetter::ClearScorer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x66e32447;  // IPCStableHash for safe_browsing::mojom::PhishingModelSetter::ClearScorer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PhishingModelSetter::SetTestObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x763e8eda;  // IPCStableHash for safe_browsing::mojom::PhishingModelSetter::SetTestObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PhishingModelSetter_SetTestObserver_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PhishingModelSetter_SetTestObserver_ForwardToCallback(
      PhishingModelSetter::SetTestObserverCallback callback
      ) : callback_(std::move(callback)) {
  }

  PhishingModelSetter_SetTestObserver_ForwardToCallback(const PhishingModelSetter_SetTestObserver_ForwardToCallback&) = delete;
  PhishingModelSetter_SetTestObserver_ForwardToCallback& operator=(const PhishingModelSetter_SetTestObserver_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PhishingModelSetter::SetTestObserverCallback callback_;
};

PhishingModelSetterProxy::PhishingModelSetterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PhishingModelSetterProxy::SetImageEmbeddingAndPhishingFlatBufferModel(
    ::base::ReadOnlySharedMemoryRegion in_region, ::base::File in_tflite_model, ::base::File in_image_embedding_model) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::PhishingModelSetter::SetImageEmbeddingAndPhishingFlatBufferModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tflite_model"), in_tflite_model,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_embedding_model"), in_image_embedding_model,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingModelSetter::kSetImageEmbeddingAndPhishingFlatBufferModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_region,
    region_fragment);

  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null region in PhishingModelSetter.SetImageEmbeddingAndPhishingFlatBufferModel request");
  mojo::internal::MessageFragment<
      typename decltype(params->tflite_model)::BaseType> tflite_model_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_tflite_model,
    tflite_model_fragment);

  params->tflite_model.Set(
      tflite_model_fragment.is_null() ? nullptr : tflite_model_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->image_embedding_model)::BaseType> image_embedding_model_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_image_embedding_model,
    image_embedding_model_fragment);

  params->image_embedding_model.Set(
      image_embedding_model_fragment.is_null() ? nullptr : image_embedding_model_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingModelSetter::Name_);
  message.set_method_name("SetImageEmbeddingAndPhishingFlatBufferModel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PhishingModelSetterProxy::AttachImageEmbeddingModel(
    ::base::File in_image_embedding_model) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::PhishingModelSetter::AttachImageEmbeddingModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_embedding_model"), in_image_embedding_model,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingModelSetter::kAttachImageEmbeddingModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingModelSetter_AttachImageEmbeddingModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image_embedding_model)::BaseType> image_embedding_model_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_image_embedding_model,
    image_embedding_model_fragment);

  params->image_embedding_model.Set(
      image_embedding_model_fragment.is_null() ? nullptr : image_embedding_model_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingModelSetter::Name_);
  message.set_method_name("AttachImageEmbeddingModel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PhishingModelSetterProxy::SetPhishingFlatBufferModel(
    ::base::ReadOnlySharedMemoryRegion in_region, ::base::File in_tflite_model) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::PhishingModelSetter::SetPhishingFlatBufferModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("region"), in_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tflite_model"), in_tflite_model,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingModelSetter::kSetPhishingFlatBufferModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->region)::BaseType> region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_region,
    region_fragment);

  params->region.Set(
      region_fragment.is_null() ? nullptr : region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null region in PhishingModelSetter.SetPhishingFlatBufferModel request");
  mojo::internal::MessageFragment<
      typename decltype(params->tflite_model)::BaseType> tflite_model_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_tflite_model,
    tflite_model_fragment);

  params->tflite_model.Set(
      tflite_model_fragment.is_null() ? nullptr : tflite_model_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingModelSetter::Name_);
  message.set_method_name("SetPhishingFlatBufferModel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PhishingModelSetterProxy::ClearScorer(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send safe_browsing::mojom::PhishingModelSetter::ClearScorer");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingModelSetter::kClearScorer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingModelSetter_ClearScorer_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingModelSetter::Name_);
  message.set_method_name("ClearScorer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PhishingModelSetterProxy::SetTestObserver(
    ::mojo::PendingRemote<PhishingModelSetterTestObserver> in_observer, SetTestObserverCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::PhishingModelSetter::SetTestObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<PhishingModelSetterTestObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingModelSetter::kSetTestObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingModelSetter_SetTestObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::safe_browsing::mojom::PhishingModelSetterTestObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingModelSetter::Name_);
  message.set_method_name("SetTestObserver");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PhishingModelSetter_SetTestObserver_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PhishingModelSetter_SetTestObserver_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PhishingModelSetter::SetTestObserverCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PhishingModelSetter_SetTestObserver_ProxyToResponder> proxy(
        new PhishingModelSetter_SetTestObserver_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PhishingModelSetter_SetTestObserver_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PhishingModelSetter_SetTestObserver_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PhishingModelSetter_SetTestObserver_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PhishingModelSetter::SetTestObserverCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PhishingModelSetter_SetTestObserver_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PhishingModelSetter_SetTestObserver_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PhishingModelSetter_SetTestObserver_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PhishingModelSetter.4
  bool success = true;
  PhishingModelSetter_SetTestObserver_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PhishingModelSetter::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PhishingModelSetter_SetTestObserver_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply safe_browsing::mojom::PhishingModelSetter::SetTestObserver");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingModelSetter::kSetTestObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingModelSetter_SetTestObserver_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingModelSetter::Name_);
  message.set_method_name("SetTestObserver");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PhishingModelSetterStubDispatch::Accept(
    PhishingModelSetter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PhishingModelSetter>(message->header()->name)) {
    case messages::PhishingModelSetter::kSetImageEmbeddingAndPhishingFlatBufferModel: {
      DCHECK(message->is_serialized());
      internal::PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data* params =
          reinterpret_cast<internal::PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PhishingModelSetter.0
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_region{};
      ::base::File p_tflite_model{};
      ::base::File p_image_embedding_model{};
      PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (success && !input_data_view.ReadTfliteModel(&p_tflite_model))
        success = false;
      if (success && !input_data_view.ReadImageEmbeddingModel(&p_image_embedding_model))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PhishingModelSetter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetImageEmbeddingAndPhishingFlatBufferModel(        
        std::move(p_region), 
        std::move(p_tflite_model), 
        std::move(p_image_embedding_model));
      return true;
    }
    case messages::PhishingModelSetter::kAttachImageEmbeddingModel: {
      DCHECK(message->is_serialized());
      internal::PhishingModelSetter_AttachImageEmbeddingModel_Params_Data* params =
          reinterpret_cast<internal::PhishingModelSetter_AttachImageEmbeddingModel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PhishingModelSetter.1
      bool success = true;
      ::base::File p_image_embedding_model{};
      PhishingModelSetter_AttachImageEmbeddingModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImageEmbeddingModel(&p_image_embedding_model))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PhishingModelSetter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AttachImageEmbeddingModel(        
        std::move(p_image_embedding_model));
      return true;
    }
    case messages::PhishingModelSetter::kSetPhishingFlatBufferModel: {
      DCHECK(message->is_serialized());
      internal::PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data* params =
          reinterpret_cast<internal::PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PhishingModelSetter.2
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_region{};
      ::base::File p_tflite_model{};
      PhishingModelSetter_SetPhishingFlatBufferModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (success && !input_data_view.ReadTfliteModel(&p_tflite_model))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PhishingModelSetter::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPhishingFlatBufferModel(        
        std::move(p_region), 
        std::move(p_tflite_model));
      return true;
    }
    case messages::PhishingModelSetter::kClearScorer: {
      DCHECK(message->is_serialized());
      internal::PhishingModelSetter_ClearScorer_Params_Data* params =
          reinterpret_cast<internal::PhishingModelSetter_ClearScorer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PhishingModelSetter.3
      bool success = true;
      PhishingModelSetter_ClearScorer_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PhishingModelSetter::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearScorer(        );
      return true;
    }
    case messages::PhishingModelSetter::kSetTestObserver: {
      break;
    }
  }
  return false;
}

// static
bool PhishingModelSetterStubDispatch::AcceptWithResponder(
    PhishingModelSetter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PhishingModelSetter>(message->header()->name)) {
    case messages::PhishingModelSetter::kSetImageEmbeddingAndPhishingFlatBufferModel: {
      break;
    }
    case messages::PhishingModelSetter::kAttachImageEmbeddingModel: {
      break;
    }
    case messages::PhishingModelSetter::kSetPhishingFlatBufferModel: {
      break;
    }
    case messages::PhishingModelSetter::kClearScorer: {
      break;
    }
    case messages::PhishingModelSetter::kSetTestObserver: {
      internal::PhishingModelSetter_SetTestObserver_Params_Data* params =
          reinterpret_cast<
              internal::PhishingModelSetter_SetTestObserver_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PhishingModelSetter.4
      bool success = true;
      ::mojo::PendingRemote<PhishingModelSetterTestObserver> p_observer{};
      PhishingModelSetter_SetTestObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PhishingModelSetter::Name_, 4, false);
        return false;
      }
      auto callback =
          PhishingModelSetter_SetTestObserver_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTestObserver(        
        std::move(p_observer), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPhishingModelSetterValidationInfo[] = {
    { &internal::PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PhishingModelSetter_AttachImageEmbeddingModel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PhishingModelSetter_ClearScorer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PhishingModelSetter_SetTestObserver_Params_Data::Validate,
     &internal::PhishingModelSetter_SetTestObserver_ResponseParams_Data::Validate},
};

bool PhishingModelSetterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::safe_browsing::mojom::PhishingModelSetter::Name_,
    kPhishingModelSetterValidationInfo);
}

bool PhishingModelSetterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::safe_browsing::mojom::PhishingModelSetter::Name_,
    kPhishingModelSetterValidationInfo);
}
// The declaration includes the definition on other builds.

PhishingModelSetterTestObserver::IPCStableHashFunction PhishingModelSetterTestObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PhishingModelSetterTestObserver>(message.name())) {
    case messages::PhishingModelSetterTestObserver::kPhishingModelUpdated: {
      return &PhishingModelSetterTestObserver::PhishingModelUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PhishingModelSetterTestObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PhishingModelSetterTestObserver>(message.name())) {
      case messages::PhishingModelSetterTestObserver::kPhishingModelUpdated:
            return "Receive safe_browsing::mojom::PhishingModelSetterTestObserver::PhishingModelUpdated";
    }
  } else {
    switch (static_cast<messages::PhishingModelSetterTestObserver>(message.name())) {
      case messages::PhishingModelSetterTestObserver::kPhishingModelUpdated:
            return "Receive reply safe_browsing::mojom::PhishingModelSetterTestObserver::PhishingModelUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PhishingModelSetterTestObserver::PhishingModelUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcf3a2d57;  // IPCStableHash for safe_browsing::mojom::PhishingModelSetterTestObserver::PhishingModelUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PhishingModelSetterTestObserverProxy::PhishingModelSetterTestObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PhishingModelSetterTestObserverProxy::PhishingModelUpdated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send safe_browsing::mojom::PhishingModelSetterTestObserver::PhishingModelUpdated");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingModelSetterTestObserver::kPhishingModelUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingModelSetterTestObserver::Name_);
  message.set_method_name("PhishingModelUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PhishingModelSetterTestObserverStubDispatch::Accept(
    PhishingModelSetterTestObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PhishingModelSetterTestObserver>(message->header()->name)) {
    case messages::PhishingModelSetterTestObserver::kPhishingModelUpdated: {
      DCHECK(message->is_serialized());
      internal::PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data* params =
          reinterpret_cast<internal::PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PhishingModelSetterTestObserver.0
      bool success = true;
      PhishingModelSetterTestObserver_PhishingModelUpdated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PhishingModelSetterTestObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PhishingModelUpdated(        );
      return true;
    }
  }
  return false;
}

// static
bool PhishingModelSetterTestObserverStubDispatch::AcceptWithResponder(
    PhishingModelSetterTestObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PhishingModelSetterTestObserver>(message->header()->name)) {
    case messages::PhishingModelSetterTestObserver::kPhishingModelUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPhishingModelSetterTestObserverValidationInfo[] = {
    { &internal::PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool PhishingModelSetterTestObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::safe_browsing::mojom::PhishingModelSetterTestObserver::Name_,
    kPhishingModelSetterTestObserverValidationInfo);
}

// The declaration includes the definition on other builds.

PhishingImageEmbedderDetector::IPCStableHashFunction PhishingImageEmbedderDetector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PhishingImageEmbedderDetector>(message.name())) {
    case messages::PhishingImageEmbedderDetector::kStartImageEmbedding: {
      return &PhishingImageEmbedderDetector::StartImageEmbedding_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PhishingImageEmbedderDetector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PhishingImageEmbedderDetector>(message.name())) {
      case messages::PhishingImageEmbedderDetector::kStartImageEmbedding:
            return "Receive safe_browsing::mojom::PhishingImageEmbedderDetector::StartImageEmbedding";
    }
  } else {
    switch (static_cast<messages::PhishingImageEmbedderDetector>(message.name())) {
      case messages::PhishingImageEmbedderDetector::kStartImageEmbedding:
            return "Receive reply safe_browsing::mojom::PhishingImageEmbedderDetector::StartImageEmbedding";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PhishingImageEmbedderDetector::StartImageEmbedding_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa26f746a;  // IPCStableHash for safe_browsing::mojom::PhishingImageEmbedderDetector::StartImageEmbedding
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PhishingImageEmbedderDetector_StartImageEmbedding_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PhishingImageEmbedderDetector_StartImageEmbedding_ForwardToCallback(
      PhishingImageEmbedderDetector::StartImageEmbeddingCallback callback
      ) : callback_(std::move(callback)) {
  }

  PhishingImageEmbedderDetector_StartImageEmbedding_ForwardToCallback(const PhishingImageEmbedderDetector_StartImageEmbedding_ForwardToCallback&) = delete;
  PhishingImageEmbedderDetector_StartImageEmbedding_ForwardToCallback& operator=(const PhishingImageEmbedderDetector_StartImageEmbedding_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PhishingImageEmbedderDetector::StartImageEmbeddingCallback callback_;
};

PhishingImageEmbedderDetectorProxy::PhishingImageEmbedderDetectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PhishingImageEmbedderDetectorProxy::StartImageEmbedding(
    const ::GURL& in_url, StartImageEmbeddingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::PhishingImageEmbedderDetector::StartImageEmbedding", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingImageEmbedderDetector::kStartImageEmbedding), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PhishingImageEmbedderDetector.StartImageEmbedding request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingImageEmbedderDetector::Name_);
  message.set_method_name("StartImageEmbedding");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PhishingImageEmbedderDetector_StartImageEmbedding_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PhishingImageEmbedderDetector_StartImageEmbedding_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PhishingImageEmbedderDetector::StartImageEmbeddingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PhishingImageEmbedderDetector_StartImageEmbedding_ProxyToResponder> proxy(
        new PhishingImageEmbedderDetector_StartImageEmbedding_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PhishingImageEmbedderDetector_StartImageEmbedding_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PhishingImageEmbedderDetector_StartImageEmbedding_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PhishingImageEmbedderDetector_StartImageEmbedding_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PhishingImageEmbedderDetector::StartImageEmbeddingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PhishingImageEmbeddingResult in_result, std::optional<::mojo_base::ProtoWrapper> in_image_embedding_request);
};

bool PhishingImageEmbedderDetector_StartImageEmbedding_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PhishingImageEmbedderDetector.0
  bool success = true;
  PhishingImageEmbeddingResult p_result{};
  std::optional<::mojo_base::ProtoWrapper> p_image_embedding_request{};
  PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadImageEmbeddingRequest(&p_image_embedding_request))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PhishingImageEmbedderDetector::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_image_embedding_request));
  }
  return true;
}

void PhishingImageEmbedderDetector_StartImageEmbedding_ProxyToResponder::Run(
    PhishingImageEmbeddingResult in_result, std::optional<::mojo_base::ProtoWrapper> in_image_embedding_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply safe_browsing::mojom::PhishingImageEmbedderDetector::StartImageEmbedding", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PhishingImageEmbeddingResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_embedding_request"), in_image_embedding_request,
                        "<value of type std::optional<::mojo_base::ProtoWrapper>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PhishingImageEmbedderDetector::kStartImageEmbedding), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::safe_browsing::mojom::PhishingImageEmbeddingResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->image_embedding_request)::BaseType> image_embedding_request_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView>(
    in_image_embedding_request,
    image_embedding_request_fragment);

  params->image_embedding_request.Set(
      image_embedding_request_fragment.is_null() ? nullptr : image_embedding_request_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PhishingImageEmbedderDetector::Name_);
  message.set_method_name("StartImageEmbedding");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PhishingImageEmbedderDetectorStubDispatch::Accept(
    PhishingImageEmbedderDetector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PhishingImageEmbedderDetector>(message->header()->name)) {
    case messages::PhishingImageEmbedderDetector::kStartImageEmbedding: {
      break;
    }
  }
  return false;
}

// static
bool PhishingImageEmbedderDetectorStubDispatch::AcceptWithResponder(
    PhishingImageEmbedderDetector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PhishingImageEmbedderDetector>(message->header()->name)) {
    case messages::PhishingImageEmbedderDetector::kStartImageEmbedding: {
      internal::PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data* params =
          reinterpret_cast<
              internal::PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PhishingImageEmbedderDetector.0
      bool success = true;
      ::GURL p_url{};
      PhishingImageEmbedderDetector_StartImageEmbedding_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PhishingImageEmbedderDetector::Name_, 0, false);
        return false;
      }
      auto callback =
          PhishingImageEmbedderDetector_StartImageEmbedding_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartImageEmbedding(        
        std::move(p_url), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPhishingImageEmbedderDetectorValidationInfo[] = {
    { &internal::PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data::Validate,
     &internal::PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data::Validate},
};

bool PhishingImageEmbedderDetectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::safe_browsing::mojom::PhishingImageEmbedderDetector::Name_,
    kPhishingImageEmbedderDetectorValidationInfo);
}

bool PhishingImageEmbedderDetectorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::safe_browsing::mojom::PhishingImageEmbedderDetector::Name_,
    kPhishingImageEmbedderDetectorValidationInfo);
}
// The declaration includes the definition on other builds.

ExtensionWebRequestReporter::IPCStableHashFunction ExtensionWebRequestReporter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ExtensionWebRequestReporter>(message.name())) {
    case messages::ExtensionWebRequestReporter::kSendWebRequestData: {
      return &ExtensionWebRequestReporter::SendWebRequestData_Sym::IPCStableHash;
    }
    case messages::ExtensionWebRequestReporter::kClone: {
      return &ExtensionWebRequestReporter::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ExtensionWebRequestReporter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ExtensionWebRequestReporter>(message.name())) {
      case messages::ExtensionWebRequestReporter::kSendWebRequestData:
            return "Receive safe_browsing::mojom::ExtensionWebRequestReporter::SendWebRequestData";
      case messages::ExtensionWebRequestReporter::kClone:
            return "Receive safe_browsing::mojom::ExtensionWebRequestReporter::Clone";
    }
  } else {
    switch (static_cast<messages::ExtensionWebRequestReporter>(message.name())) {
      case messages::ExtensionWebRequestReporter::kSendWebRequestData:
            return "Receive reply safe_browsing::mojom::ExtensionWebRequestReporter::SendWebRequestData";
      case messages::ExtensionWebRequestReporter::kClone:
            return "Receive reply safe_browsing::mojom::ExtensionWebRequestReporter::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ExtensionWebRequestReporter::SendWebRequestData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe564ca09;  // IPCStableHash for safe_browsing::mojom::ExtensionWebRequestReporter::SendWebRequestData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ExtensionWebRequestReporter::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcad3e293;  // IPCStableHash for safe_browsing::mojom::ExtensionWebRequestReporter::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ExtensionWebRequestReporterProxy::ExtensionWebRequestReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ExtensionWebRequestReporterProxy::SendWebRequestData(
    const std::string& in_origin_extension_id, const ::GURL& in_telemetry_url, WebRequestProtocolType in_protocol_type, WebRequestContactInitiatorType in_contact_initiator_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::ExtensionWebRequestReporter::SendWebRequestData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin_extension_id"), in_origin_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("telemetry_url"), in_telemetry_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("protocol_type"), in_protocol_type,
                        "<value of type WebRequestProtocolType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("contact_initiator_type"), in_contact_initiator_type,
                        "<value of type WebRequestContactInitiatorType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionWebRequestReporter::kSendWebRequestData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::ExtensionWebRequestReporter_SendWebRequestData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin_extension_id)::BaseType> origin_extension_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_origin_extension_id,
    origin_extension_id_fragment);

  params->origin_extension_id.Set(
      origin_extension_id_fragment.is_null() ? nullptr : origin_extension_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin_extension_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin_extension_id in ExtensionWebRequestReporter.SendWebRequestData request");
  mojo::internal::MessageFragment<
      typename decltype(params->telemetry_url)::BaseType> telemetry_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_telemetry_url,
    telemetry_url_fragment);

  params->telemetry_url.Set(
      telemetry_url_fragment.is_null() ? nullptr : telemetry_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->telemetry_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null telemetry_url in ExtensionWebRequestReporter.SendWebRequestData request");

  
  mojo::internal::Serialize<::safe_browsing::mojom::WebRequestProtocolType>(
    in_protocol_type,
    &params->protocol_type);

  
  mojo::internal::Serialize<::safe_browsing::mojom::WebRequestContactInitiatorType>(
    in_contact_initiator_type,
    &params->contact_initiator_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionWebRequestReporter::Name_);
  message.set_method_name("SendWebRequestData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ExtensionWebRequestReporterProxy::Clone(
    ::mojo::PendingReceiver<ExtensionWebRequestReporter> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send safe_browsing::mojom::ExtensionWebRequestReporter::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<ExtensionWebRequestReporter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ExtensionWebRequestReporter::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::safe_browsing::mojom::internal::ExtensionWebRequestReporter_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::safe_browsing::mojom::ExtensionWebRequestReporterInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in ExtensionWebRequestReporter.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ExtensionWebRequestReporter::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ExtensionWebRequestReporterStubDispatch::Accept(
    ExtensionWebRequestReporter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ExtensionWebRequestReporter>(message->header()->name)) {
    case messages::ExtensionWebRequestReporter::kSendWebRequestData: {
      DCHECK(message->is_serialized());
      internal::ExtensionWebRequestReporter_SendWebRequestData_Params_Data* params =
          reinterpret_cast<internal::ExtensionWebRequestReporter_SendWebRequestData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionWebRequestReporter.0
      bool success = true;
      std::string p_origin_extension_id{};
      ::GURL p_telemetry_url{};
      WebRequestProtocolType p_protocol_type{};
      WebRequestContactInitiatorType p_contact_initiator_type{};
      ExtensionWebRequestReporter_SendWebRequestData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOriginExtensionId(&p_origin_extension_id))
        success = false;
      if (success && !input_data_view.ReadTelemetryUrl(&p_telemetry_url))
        success = false;
      if (success && !input_data_view.ReadProtocolType(&p_protocol_type))
        success = false;
      if (success && !input_data_view.ReadContactInitiatorType(&p_contact_initiator_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionWebRequestReporter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendWebRequestData(        
        std::move(p_origin_extension_id), 
        std::move(p_telemetry_url), 
        std::move(p_protocol_type), 
        std::move(p_contact_initiator_type));
      return true;
    }
    case messages::ExtensionWebRequestReporter::kClone: {
      DCHECK(message->is_serialized());
      internal::ExtensionWebRequestReporter_Clone_Params_Data* params =
          reinterpret_cast<internal::ExtensionWebRequestReporter_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ExtensionWebRequestReporter.1
      bool success = true;
      ::mojo::PendingReceiver<ExtensionWebRequestReporter> p_receiver{};
      ExtensionWebRequestReporter_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ExtensionWebRequestReporter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ExtensionWebRequestReporterStubDispatch::AcceptWithResponder(
    ExtensionWebRequestReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ExtensionWebRequestReporter>(message->header()->name)) {
    case messages::ExtensionWebRequestReporter::kSendWebRequestData: {
      break;
    }
    case messages::ExtensionWebRequestReporter::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kExtensionWebRequestReporterValidationInfo[] = {
    { &internal::ExtensionWebRequestReporter_SendWebRequestData_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ExtensionWebRequestReporter_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool ExtensionWebRequestReporterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::safe_browsing::mojom::ExtensionWebRequestReporter::Name_,
    kExtensionWebRequestReporterValidationInfo);
}



}  // safe_browsing::mojom


namespace mojo {


// static
bool StructTraits<::safe_browsing::mojom::AttributeNameValue::DataView, ::safe_browsing::mojom::AttributeNameValuePtr>::Read(
    ::safe_browsing::mojom::AttributeNameValue::DataView input,
    ::safe_browsing::mojom::AttributeNameValuePtr* output) {
  bool success = true;
  ::safe_browsing::mojom::AttributeNameValuePtr result(::safe_browsing::mojom::AttributeNameValue::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::safe_browsing::mojom::ThreatDOMDetailsNode::DataView, ::safe_browsing::mojom::ThreatDOMDetailsNodePtr>::Read(
    ::safe_browsing::mojom::ThreatDOMDetailsNode::DataView input,
    ::safe_browsing::mojom::ThreatDOMDetailsNodePtr* output) {
  bool success = true;
  ::safe_browsing::mojom::ThreatDOMDetailsNodePtr result(::safe_browsing::mojom::ThreatDOMDetailsNode::New());
  
      if (success)
        result->node_id = input.node_id();
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTagName(&result->tag_name))
        success = false;
      if (success && !input.ReadParent(&result->parent))
        success = false;
      if (success)
        result->parent_node_id = input.parent_node_id();
      if (success && !input.ReadChildren(&result->children))
        success = false;
      if (success && !input.ReadChildNodeIds(&result->child_node_ids))
        success = false;
      if (success && !input.ReadAttributes(&result->attributes))
        success = false;
      if (success && !input.ReadChildFrameToken(&result->child_frame_token))
        success = false;
      if (success && !input.ReadInnerHtml(&result->inner_html))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace safe_browsing::mojom {


void SafeBrowsingInterceptorForTesting::CreateCheckerAndCheck(const std::optional<::blink::LocalFrameToken>& frame_token, ::mojo::PendingReceiver<::safe_browsing::mojom::SafeBrowsingUrlChecker> receiver, const ::GURL& url, const std::string& method, const ::net::HttpRequestHeaders& headers, int32_t load_flags, bool has_user_gesture, bool originated_from_service_worker, CreateCheckerAndCheckCallback callback) {
  GetForwardingInterface()->CreateCheckerAndCheck(
    std::move(frame_token)
    , 
    std::move(receiver)
    , 
    std::move(url)
    , 
    std::move(method)
    , 
    std::move(headers)
    , 
    std::move(load_flags)
    , 
    std::move(has_user_gesture)
    , 
    std::move(originated_from_service_worker)
    , std::move(callback));
}
void SafeBrowsingInterceptorForTesting::Clone(::mojo::PendingReceiver<SafeBrowsing> receiver) {
  GetForwardingInterface()->Clone(
    std::move(receiver)
    );
}
SafeBrowsingAsyncWaiter::SafeBrowsingAsyncWaiter(
    SafeBrowsing* proxy) : proxy_(proxy) {}

SafeBrowsingAsyncWaiter::~SafeBrowsingAsyncWaiter() = default;


void SafeBrowsingAsyncWaiter::CreateCheckerAndCheck(
    const std::optional<::blink::LocalFrameToken>& frame_token, ::mojo::PendingReceiver<::safe_browsing::mojom::SafeBrowsingUrlChecker> receiver, const ::GURL& url, const std::string& method, const ::net::HttpRequestHeaders& headers, int32_t load_flags, bool has_user_gesture, bool originated_from_service_worker, bool* out_proceed, bool* out_showed_interstitial) {
  base::RunLoop loop;
  proxy_->CreateCheckerAndCheck(
      std::move(frame_token),
      std::move(receiver),
      std::move(url),
      std::move(method),
      std::move(headers),
      std::move(load_flags),
      std::move(has_user_gesture),
      std::move(originated_from_service_worker),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_proceed
,
             bool* out_showed_interstitial
,
             bool proceed,
             bool showed_interstitial) {*out_proceed = std::move(proceed);*out_showed_interstitial = std::move(showed_interstitial);
            loop->Quit();
          },
          &loop,
          out_proceed,
          out_showed_interstitial));
  loop.Run();
}






void ThreatReporterInterceptorForTesting::GetThreatDOMDetails(GetThreatDOMDetailsCallback callback) {
  GetForwardingInterface()->GetThreatDOMDetails(std::move(callback));
}
ThreatReporterAsyncWaiter::ThreatReporterAsyncWaiter(
    ThreatReporter* proxy) : proxy_(proxy) {}

ThreatReporterAsyncWaiter::~ThreatReporterAsyncWaiter() = default;


void ThreatReporterAsyncWaiter::GetThreatDOMDetails(
    std::vector<ThreatDOMDetailsNodePtr>* out_nodes) {
  base::RunLoop loop;
  proxy_->GetThreatDOMDetails(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ThreatDOMDetailsNodePtr>* out_nodes
,
             std::vector<ThreatDOMDetailsNodePtr> nodes) {*out_nodes = std::move(nodes);
            loop->Quit();
          },
          &loop,
          out_nodes));
  loop.Run();
}

std::vector<ThreatDOMDetailsNodePtr> ThreatReporterAsyncWaiter::GetThreatDOMDetails(
    ) {
  std::vector<ThreatDOMDetailsNodePtr> async_wait_result;
  GetThreatDOMDetails(&async_wait_result);
  return async_wait_result;
}




void PhishingDetectorInterceptorForTesting::StartPhishingDetection(const ::GURL& url, ClientSideDetectionType request_type, StartPhishingDetectionCallback callback) {
  GetForwardingInterface()->StartPhishingDetection(
    std::move(url)
    , 
    std::move(request_type)
    , std::move(callback));
}
PhishingDetectorAsyncWaiter::PhishingDetectorAsyncWaiter(
    PhishingDetector* proxy) : proxy_(proxy) {}

PhishingDetectorAsyncWaiter::~PhishingDetectorAsyncWaiter() = default;


void PhishingDetectorAsyncWaiter::StartPhishingDetection(
    const ::GURL& url, ClientSideDetectionType request_type, PhishingDetectorResult* out_result, std::optional<::mojo_base::ProtoWrapper>* out_request) {
  base::RunLoop loop;
  proxy_->StartPhishingDetection(
      std::move(url),
      std::move(request_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             PhishingDetectorResult* out_result
,
             std::optional<::mojo_base::ProtoWrapper>* out_request
,
             PhishingDetectorResult result,
             std::optional<::mojo_base::ProtoWrapper> request) {*out_result = std::move(result);*out_request = std::move(request);
            loop->Quit();
          },
          &loop,
          out_result,
          out_request));
  loop.Run();
}






void PhishingModelSetterInterceptorForTesting::SetImageEmbeddingAndPhishingFlatBufferModel(::base::ReadOnlySharedMemoryRegion region, ::base::File tflite_model, ::base::File image_embedding_model) {
  GetForwardingInterface()->SetImageEmbeddingAndPhishingFlatBufferModel(
    std::move(region)
    , 
    std::move(tflite_model)
    , 
    std::move(image_embedding_model)
    );
}
void PhishingModelSetterInterceptorForTesting::AttachImageEmbeddingModel(::base::File image_embedding_model) {
  GetForwardingInterface()->AttachImageEmbeddingModel(
    std::move(image_embedding_model)
    );
}
void PhishingModelSetterInterceptorForTesting::SetPhishingFlatBufferModel(::base::ReadOnlySharedMemoryRegion region, ::base::File tflite_model) {
  GetForwardingInterface()->SetPhishingFlatBufferModel(
    std::move(region)
    , 
    std::move(tflite_model)
    );
}
void PhishingModelSetterInterceptorForTesting::ClearScorer() {
  GetForwardingInterface()->ClearScorer();
}
void PhishingModelSetterInterceptorForTesting::SetTestObserver(::mojo::PendingRemote<PhishingModelSetterTestObserver> observer, SetTestObserverCallback callback) {
  GetForwardingInterface()->SetTestObserver(
    std::move(observer)
    , std::move(callback));
}
PhishingModelSetterAsyncWaiter::PhishingModelSetterAsyncWaiter(
    PhishingModelSetter* proxy) : proxy_(proxy) {}

PhishingModelSetterAsyncWaiter::~PhishingModelSetterAsyncWaiter() = default;


void PhishingModelSetterAsyncWaiter::SetTestObserver(
    ::mojo::PendingRemote<PhishingModelSetterTestObserver> observer) {
  base::RunLoop loop;
  proxy_->SetTestObserver(
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void PhishingModelSetterTestObserverInterceptorForTesting::PhishingModelUpdated() {
  GetForwardingInterface()->PhishingModelUpdated();
}
PhishingModelSetterTestObserverAsyncWaiter::PhishingModelSetterTestObserverAsyncWaiter(
    PhishingModelSetterTestObserver* proxy) : proxy_(proxy) {}

PhishingModelSetterTestObserverAsyncWaiter::~PhishingModelSetterTestObserverAsyncWaiter() = default;





void PhishingImageEmbedderDetectorInterceptorForTesting::StartImageEmbedding(const ::GURL& url, StartImageEmbeddingCallback callback) {
  GetForwardingInterface()->StartImageEmbedding(
    std::move(url)
    , std::move(callback));
}
PhishingImageEmbedderDetectorAsyncWaiter::PhishingImageEmbedderDetectorAsyncWaiter(
    PhishingImageEmbedderDetector* proxy) : proxy_(proxy) {}

PhishingImageEmbedderDetectorAsyncWaiter::~PhishingImageEmbedderDetectorAsyncWaiter() = default;


void PhishingImageEmbedderDetectorAsyncWaiter::StartImageEmbedding(
    const ::GURL& url, PhishingImageEmbeddingResult* out_result, std::optional<::mojo_base::ProtoWrapper>* out_image_embedding_request) {
  base::RunLoop loop;
  proxy_->StartImageEmbedding(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             PhishingImageEmbeddingResult* out_result
,
             std::optional<::mojo_base::ProtoWrapper>* out_image_embedding_request
,
             PhishingImageEmbeddingResult result,
             std::optional<::mojo_base::ProtoWrapper> image_embedding_request) {*out_result = std::move(result);*out_image_embedding_request = std::move(image_embedding_request);
            loop->Quit();
          },
          &loop,
          out_result,
          out_image_embedding_request));
  loop.Run();
}






void ExtensionWebRequestReporterInterceptorForTesting::SendWebRequestData(const std::string& origin_extension_id, const ::GURL& telemetry_url, WebRequestProtocolType protocol_type, WebRequestContactInitiatorType contact_initiator_type) {
  GetForwardingInterface()->SendWebRequestData(
    std::move(origin_extension_id)
    , 
    std::move(telemetry_url)
    , 
    std::move(protocol_type)
    , 
    std::move(contact_initiator_type)
    );
}
void ExtensionWebRequestReporterInterceptorForTesting::Clone(::mojo::PendingReceiver<ExtensionWebRequestReporter> receiver) {
  GetForwardingInterface()->Clone(
    std::move(receiver)
    );
}
ExtensionWebRequestReporterAsyncWaiter::ExtensionWebRequestReporterAsyncWaiter(
    ExtensionWebRequestReporter* proxy) : proxy_(proxy) {}

ExtensionWebRequestReporterAsyncWaiter::~ExtensionWebRequestReporterAsyncWaiter() = default;







}  // safe_browsing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif