// components/safe_browsing/content/common/safe_browsing.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_TEST_UTILS_H_
#define COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_TEST_UTILS_H_

#include "components/safe_browsing/content/common/safe_browsing.mojom.h"


namespace safe_browsing::mojom {


class  SafeBrowsingInterceptorForTesting : public SafeBrowsing {
  virtual SafeBrowsing* GetForwardingInterface() = 0;
  void CreateCheckerAndCheck(const std::optional<::blink::LocalFrameToken>& frame_token, ::mojo::PendingReceiver<::safe_browsing::mojom::SafeBrowsingUrlChecker> receiver, const ::GURL& url, const std::string& method, const ::net::HttpRequestHeaders& headers, int32_t load_flags, bool has_user_gesture, bool originated_from_service_worker, CreateCheckerAndCheckCallback callback) override;
  void Clone(::mojo::PendingReceiver<SafeBrowsing> receiver) override;
};
class  SafeBrowsingAsyncWaiter {
 public:
  explicit SafeBrowsingAsyncWaiter(SafeBrowsing* proxy);

  SafeBrowsingAsyncWaiter(const SafeBrowsingAsyncWaiter&) = delete;
  SafeBrowsingAsyncWaiter& operator=(const SafeBrowsingAsyncWaiter&) = delete;

  ~SafeBrowsingAsyncWaiter();
  void CreateCheckerAndCheck(
      const std::optional<::blink::LocalFrameToken>& frame_token, ::mojo::PendingReceiver<::safe_browsing::mojom::SafeBrowsingUrlChecker> receiver, const ::GURL& url, const std::string& method, const ::net::HttpRequestHeaders& headers, int32_t load_flags, bool has_user_gesture, bool originated_from_service_worker, bool* out_proceed, bool* out_showed_interstitial);
  

 private:
  SafeBrowsing* const proxy_;
};


class  ThreatReporterInterceptorForTesting : public ThreatReporter {
  virtual ThreatReporter* GetForwardingInterface() = 0;
  void GetThreatDOMDetails(GetThreatDOMDetailsCallback callback) override;
};
class  ThreatReporterAsyncWaiter {
 public:
  explicit ThreatReporterAsyncWaiter(ThreatReporter* proxy);

  ThreatReporterAsyncWaiter(const ThreatReporterAsyncWaiter&) = delete;
  ThreatReporterAsyncWaiter& operator=(const ThreatReporterAsyncWaiter&) = delete;

  ~ThreatReporterAsyncWaiter();
  void GetThreatDOMDetails(
      std::vector<ThreatDOMDetailsNodePtr>* out_nodes);
  std::vector<ThreatDOMDetailsNodePtr> GetThreatDOMDetails();

 private:
  ThreatReporter* const proxy_;
};


class  PhishingDetectorInterceptorForTesting : public PhishingDetector {
  virtual PhishingDetector* GetForwardingInterface() = 0;
  void StartPhishingDetection(const ::GURL& url, ClientSideDetectionType request_type, StartPhishingDetectionCallback callback) override;
};
class  PhishingDetectorAsyncWaiter {
 public:
  explicit PhishingDetectorAsyncWaiter(PhishingDetector* proxy);

  PhishingDetectorAsyncWaiter(const PhishingDetectorAsyncWaiter&) = delete;
  PhishingDetectorAsyncWaiter& operator=(const PhishingDetectorAsyncWaiter&) = delete;

  ~PhishingDetectorAsyncWaiter();
  void StartPhishingDetection(
      const ::GURL& url, ClientSideDetectionType request_type, PhishingDetectorResult* out_result, std::optional<::mojo_base::ProtoWrapper>* out_request);
  

 private:
  PhishingDetector* const proxy_;
};


class  PhishingModelSetterInterceptorForTesting : public PhishingModelSetter {
  virtual PhishingModelSetter* GetForwardingInterface() = 0;
  void SetImageEmbeddingAndPhishingFlatBufferModel(::base::ReadOnlySharedMemoryRegion region, ::base::File tflite_model, ::base::File image_embedding_model) override;
  void AttachImageEmbeddingModel(::base::File image_embedding_model) override;
  void SetPhishingFlatBufferModel(::base::ReadOnlySharedMemoryRegion region, ::base::File tflite_model) override;
  void ClearScorer() override;
  void SetTestObserver(::mojo::PendingRemote<PhishingModelSetterTestObserver> observer, SetTestObserverCallback callback) override;
};
class  PhishingModelSetterAsyncWaiter {
 public:
  explicit PhishingModelSetterAsyncWaiter(PhishingModelSetter* proxy);

  PhishingModelSetterAsyncWaiter(const PhishingModelSetterAsyncWaiter&) = delete;
  PhishingModelSetterAsyncWaiter& operator=(const PhishingModelSetterAsyncWaiter&) = delete;

  ~PhishingModelSetterAsyncWaiter();
  void SetTestObserver(
      ::mojo::PendingRemote<PhishingModelSetterTestObserver> observer);
  

 private:
  PhishingModelSetter* const proxy_;
};


class  PhishingModelSetterTestObserverInterceptorForTesting : public PhishingModelSetterTestObserver {
  virtual PhishingModelSetterTestObserver* GetForwardingInterface() = 0;
  void PhishingModelUpdated() override;
};
class  PhishingModelSetterTestObserverAsyncWaiter {
 public:
  explicit PhishingModelSetterTestObserverAsyncWaiter(PhishingModelSetterTestObserver* proxy);

  PhishingModelSetterTestObserverAsyncWaiter(const PhishingModelSetterTestObserverAsyncWaiter&) = delete;
  PhishingModelSetterTestObserverAsyncWaiter& operator=(const PhishingModelSetterTestObserverAsyncWaiter&) = delete;

  ~PhishingModelSetterTestObserverAsyncWaiter();

 private:
  PhishingModelSetterTestObserver* const proxy_;
};


class  PhishingImageEmbedderDetectorInterceptorForTesting : public PhishingImageEmbedderDetector {
  virtual PhishingImageEmbedderDetector* GetForwardingInterface() = 0;
  void StartImageEmbedding(const ::GURL& url, StartImageEmbeddingCallback callback) override;
};
class  PhishingImageEmbedderDetectorAsyncWaiter {
 public:
  explicit PhishingImageEmbedderDetectorAsyncWaiter(PhishingImageEmbedderDetector* proxy);

  PhishingImageEmbedderDetectorAsyncWaiter(const PhishingImageEmbedderDetectorAsyncWaiter&) = delete;
  PhishingImageEmbedderDetectorAsyncWaiter& operator=(const PhishingImageEmbedderDetectorAsyncWaiter&) = delete;

  ~PhishingImageEmbedderDetectorAsyncWaiter();
  void StartImageEmbedding(
      const ::GURL& url, PhishingImageEmbeddingResult* out_result, std::optional<::mojo_base::ProtoWrapper>* out_image_embedding_request);
  

 private:
  PhishingImageEmbedderDetector* const proxy_;
};


class  ExtensionWebRequestReporterInterceptorForTesting : public ExtensionWebRequestReporter {
  virtual ExtensionWebRequestReporter* GetForwardingInterface() = 0;
  void SendWebRequestData(const std::string& origin_extension_id, const ::GURL& telemetry_url, WebRequestProtocolType protocol_type, WebRequestContactInitiatorType contact_initiator_type) override;
  void Clone(::mojo::PendingReceiver<ExtensionWebRequestReporter> receiver) override;
};
class  ExtensionWebRequestReporterAsyncWaiter {
 public:
  explicit ExtensionWebRequestReporterAsyncWaiter(ExtensionWebRequestReporter* proxy);

  ExtensionWebRequestReporterAsyncWaiter(const ExtensionWebRequestReporterAsyncWaiter&) = delete;
  ExtensionWebRequestReporterAsyncWaiter& operator=(const ExtensionWebRequestReporterAsyncWaiter&) = delete;

  ~ExtensionWebRequestReporterAsyncWaiter();

 private:
  ExtensionWebRequestReporter* const proxy_;
};




}  // safe_browsing::mojom

#endif  // COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_TEST_UTILS_H_