// components/safe_browsing/content/common/safe_browsing.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_SHARED_H_
#define COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/safe_browsing/content/common/safe_browsing.mojom-shared-internal.h"
#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/safe_browsing/content/common/safe_browsing.mojom-data-view.h"




namespace std {

template <>
struct hash<::safe_browsing::mojom::PhishingDetectorResult>
    : public mojo::internal::EnumHashImpl<::safe_browsing::mojom::PhishingDetectorResult> {};

template <>
struct hash<::safe_browsing::mojom::ClientSideDetectionType>
    : public mojo::internal::EnumHashImpl<::safe_browsing::mojom::ClientSideDetectionType> {};

template <>
struct hash<::safe_browsing::mojom::PhishingImageEmbeddingResult>
    : public mojo::internal::EnumHashImpl<::safe_browsing::mojom::PhishingImageEmbeddingResult> {};

template <>
struct hash<::safe_browsing::mojom::WebRequestProtocolType>
    : public mojo::internal::EnumHashImpl<::safe_browsing::mojom::WebRequestProtocolType> {};

template <>
struct hash<::safe_browsing::mojom::WebRequestContactInitiatorType>
    : public mojo::internal::EnumHashImpl<::safe_browsing::mojom::WebRequestContactInitiatorType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::safe_browsing::mojom::PhishingDetectorResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::safe_browsing::mojom::PhishingDetectorResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::safe_browsing::mojom::PhishingDetectorResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::safe_browsing::mojom::ClientSideDetectionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::safe_browsing::mojom::ClientSideDetectionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::safe_browsing::mojom::ClientSideDetectionType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::safe_browsing::mojom::PhishingImageEmbeddingResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::safe_browsing::mojom::PhishingImageEmbeddingResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::safe_browsing::mojom::PhishingImageEmbeddingResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::safe_browsing::mojom::WebRequestProtocolType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::safe_browsing::mojom::WebRequestProtocolType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::safe_browsing::mojom::WebRequestProtocolType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::safe_browsing::mojom::WebRequestContactInitiatorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::safe_browsing::mojom::WebRequestContactInitiatorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::safe_browsing::mojom::WebRequestContactInitiatorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::safe_browsing::mojom::AttributeNameValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::safe_browsing::mojom::AttributeNameValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::safe_browsing::mojom::internal::AttributeNameValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in AttributeNameValue struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in AttributeNameValue struct");
  }

  static bool Deserialize(::safe_browsing::mojom::internal::AttributeNameValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::safe_browsing::mojom::AttributeNameValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::safe_browsing::mojom::ThreatDOMDetailsNodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::safe_browsing::mojom::ThreatDOMDetailsNodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::safe_browsing::mojom::internal::ThreatDOMDetailsNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->node_id = Traits::node_id(input);

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ThreatDOMDetailsNode struct");

    decltype(Traits::tag_name(input)) in_tag_name = Traits::tag_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tag_name)::BaseType> tag_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_tag_name,
      tag_name_fragment);

    fragment->tag_name.Set(
        tag_name_fragment.is_null() ? nullptr : tag_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tag_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tag_name in ThreatDOMDetailsNode struct");

    decltype(Traits::parent(input)) in_parent = Traits::parent(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parent)::BaseType> parent_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_parent,
      parent_fragment);

    fragment->parent.Set(
        parent_fragment.is_null() ? nullptr : parent_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->parent.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parent in ThreatDOMDetailsNode struct");

    fragment->parent_node_id = Traits::parent_node_id(input);

    decltype(Traits::children(input)) in_children = Traits::children(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->children)::BaseType>
        children_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_children,
      children_fragment,
      &children_validate_params);

    fragment->children.Set(
        children_fragment.is_null() ? nullptr : children_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->children.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null children in ThreatDOMDetailsNode struct");

    decltype(Traits::child_node_ids(input)) in_child_node_ids = Traits::child_node_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->child_node_ids)::BaseType>
        child_node_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& child_node_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_child_node_ids,
      child_node_ids_fragment,
      &child_node_ids_validate_params);

    fragment->child_node_ids.Set(
        child_node_ids_fragment.is_null() ? nullptr : child_node_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->child_node_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_node_ids in ThreatDOMDetailsNode struct");

    decltype(Traits::attributes(input)) in_attributes = Traits::attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attributes)::BaseType>
        attributes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& attributes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::safe_browsing::mojom::AttributeNameValueDataView>>(
      in_attributes,
      attributes_fragment,
      &attributes_validate_params);

    fragment->attributes.Set(
        attributes_fragment.is_null() ? nullptr : attributes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->attributes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null attributes in ThreatDOMDetailsNode struct");

    decltype(Traits::child_frame_token(input)) in_child_frame_token = Traits::child_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->child_frame_token)>
        child_frame_token_fragment(fragment.message());
    child_frame_token_fragment.Claim(&fragment->child_frame_token);
    
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
      in_child_frame_token,
      child_frame_token_fragment,
      true);

    decltype(Traits::inner_html(input)) in_inner_html = Traits::inner_html(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->inner_html)::BaseType> inner_html_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_inner_html,
      inner_html_fragment);

    fragment->inner_html.Set(
        inner_html_fragment.is_null() ? nullptr : inner_html_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->inner_html.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null inner_html in ThreatDOMDetailsNode struct");
  }

  static bool Deserialize(::safe_browsing::mojom::internal::ThreatDOMDetailsNode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::safe_browsing::mojom::ThreatDOMDetailsNodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace safe_browsing::mojom {

inline void AttributeNameValueDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AttributeNameValueDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ThreatDOMDetailsNodeDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ThreatDOMDetailsNodeDataView::GetTagNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tag_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ThreatDOMDetailsNodeDataView::GetParentDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->parent.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ThreatDOMDetailsNodeDataView::GetChildrenDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->children.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void ThreatDOMDetailsNodeDataView::GetChildNodeIdsDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->child_node_ids.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void ThreatDOMDetailsNodeDataView::GetAttributesDataView(
    mojo::ArrayDataView<AttributeNameValueDataView>* output) {
  auto pointer = data_->attributes.Get();
  *output = mojo::ArrayDataView<AttributeNameValueDataView>(pointer, message_);
}
inline void ThreatDOMDetailsNodeDataView::GetChildFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->child_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void ThreatDOMDetailsNodeDataView::GetInnerHtmlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->inner_html.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // safe_browsing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::safe_browsing::mojom::PhishingDetectorResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::safe_browsing::mojom::PhishingDetectorResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::safe_browsing::mojom::ClientSideDetectionType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::safe_browsing::mojom::ClientSideDetectionType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::safe_browsing::mojom::PhishingImageEmbeddingResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::safe_browsing::mojom::PhishingImageEmbeddingResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::safe_browsing::mojom::WebRequestProtocolType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::safe_browsing::mojom::WebRequestProtocolType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::safe_browsing::mojom::WebRequestContactInitiatorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::safe_browsing::mojom::WebRequestContactInitiatorType value);
};

} // namespace perfetto

#endif  // COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_SHARED_H_