// components/safe_browsing/content/common/safe_browsing.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_SEND_VALIDATION_H_

#include "components/safe_browsing/content/common/safe_browsing.mojom-shared-internal.h"
#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/safe_browsing/content/common/safe_browsing.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::safe_browsing::mojom::PhishingDetectorResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::safe_browsing::mojom::ClientSideDetectionType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::safe_browsing::mojom::PhishingImageEmbeddingResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::safe_browsing::mojom::WebRequestProtocolType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::safe_browsing::mojom::WebRequestContactInitiatorType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::safe_browsing::mojom::AttributeNameValueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::safe_browsing::mojom::AttributeNameValueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::safe_browsing::mojom::internal::AttributeNameValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in AttributeNameValue struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in AttributeNameValue struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::safe_browsing::mojom::ThreatDOMDetailsNodeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::safe_browsing::mojom::ThreatDOMDetailsNodeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::safe_browsing::mojom::internal::ThreatDOMDetailsNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->node_id = Traits::node_id(input);

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ThreatDOMDetailsNode struct");

      decltype(Traits::tag_name(input)) in_tag_name = Traits::tag_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tag_name)::BaseType> tag_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_tag_name,
        tag_name_fragment);

      fragment->tag_name.Set(
          tag_name_fragment.is_null() ? nullptr : tag_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tag_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tag_name in ThreatDOMDetailsNode struct");

      decltype(Traits::parent(input)) in_parent = Traits::parent(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parent)::BaseType> parent_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_parent,
        parent_fragment);

      fragment->parent.Set(
          parent_fragment.is_null() ? nullptr : parent_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->parent.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parent in ThreatDOMDetailsNode struct");

      fragment->parent_node_id = Traits::parent_node_id(input);

      decltype(Traits::children(input)) in_children = Traits::children(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->children)::BaseType>
          children_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>, send_validation>(
        in_children,
        children_fragment,
        &children_validate_params);

      fragment->children.Set(
          children_fragment.is_null() ? nullptr : children_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->children.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null children in ThreatDOMDetailsNode struct");

      decltype(Traits::child_node_ids(input)) in_child_node_ids = Traits::child_node_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->child_node_ids)::BaseType>
          child_node_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& child_node_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<int32_t>, send_validation>(
        in_child_node_ids,
        child_node_ids_fragment,
        &child_node_ids_validate_params);

      fragment->child_node_ids.Set(
          child_node_ids_fragment.is_null() ? nullptr : child_node_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->child_node_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null child_node_ids in ThreatDOMDetailsNode struct");

      decltype(Traits::attributes(input)) in_attributes = Traits::attributes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attributes)::BaseType>
          attributes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& attributes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::safe_browsing::mojom::AttributeNameValueDataView>, send_validation>(
        in_attributes,
        attributes_fragment,
        &attributes_validate_params);

      fragment->attributes.Set(
          attributes_fragment.is_null() ? nullptr : attributes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attributes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attributes in ThreatDOMDetailsNode struct");

      decltype(Traits::child_frame_token(input)) in_child_frame_token = Traits::child_frame_token(input);
      mojo::internal::MessageFragment<decltype(fragment->child_frame_token)>
          child_frame_token_fragment(fragment.message());
      child_frame_token_fragment.Claim(&fragment->child_frame_token);
      
      mojo::internal::Serialize<::blink::mojom::FrameTokenDataView, send_validation>(
        in_child_frame_token,
        child_frame_token_fragment,
        true);

      decltype(Traits::inner_html(input)) in_inner_html = Traits::inner_html(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->inner_html)::BaseType> inner_html_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_inner_html,
        inner_html_fragment);

      fragment->inner_html.Set(
          inner_html_fragment.is_null() ? nullptr : inner_html_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->inner_html.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null inner_html in ThreatDOMDetailsNode struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_SEND_VALIDATION_H_