// components/safe_browsing/content/common/safe_browsing.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace safe_browsing::mojom {
namespace internal {
class  SafeBrowsing_CreateCheckerAndCheck_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::LocalFrameToken_Data> frame_token;
  mojo::internal::Handle_Data receiver;
  int32_t load_flags;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<mojo::internal::String_Data> method;
  mojo::internal::Pointer<::network::mojom::internal::HttpRequestHeaders_Data> headers;
  uint8_t has_user_gesture : 1;
  uint8_t originated_from_service_worker : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<SafeBrowsing_CreateCheckerAndCheck_Params_Data>;

  SafeBrowsing_CreateCheckerAndCheck_Params_Data();
  ~SafeBrowsing_CreateCheckerAndCheck_Params_Data() = delete;
};
static_assert(sizeof(SafeBrowsing_CreateCheckerAndCheck_Params_Data) == 56,
              "Bad sizeof(SafeBrowsing_CreateCheckerAndCheck_Params_Data)");
class  SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t proceed : 1;
  uint8_t showed_interstitial : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data>;

  SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data();
  ~SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data() = delete;
};
static_assert(sizeof(SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data) == 16,
              "Bad sizeof(SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data)");
class  SafeBrowsing_Clone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<SafeBrowsing_Clone_Params_Data>;

  SafeBrowsing_Clone_Params_Data();
  ~SafeBrowsing_Clone_Params_Data() = delete;
};
static_assert(sizeof(SafeBrowsing_Clone_Params_Data) == 16,
              "Bad sizeof(SafeBrowsing_Clone_Params_Data)");
class  ThreatReporter_GetThreatDOMDetails_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<ThreatReporter_GetThreatDOMDetails_Params_Data>;

  ThreatReporter_GetThreatDOMDetails_Params_Data();
  ~ThreatReporter_GetThreatDOMDetails_Params_Data() = delete;
};
static_assert(sizeof(ThreatReporter_GetThreatDOMDetails_Params_Data) == 8,
              "Bad sizeof(ThreatReporter_GetThreatDOMDetails_Params_Data)");
class  ThreatReporter_GetThreatDOMDetails_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ThreatDOMDetailsNode_Data>>> nodes;

 private:
  friend class mojo::internal::MessageFragment<ThreatReporter_GetThreatDOMDetails_ResponseParams_Data>;

  ThreatReporter_GetThreatDOMDetails_ResponseParams_Data();
  ~ThreatReporter_GetThreatDOMDetails_ResponseParams_Data() = delete;
};
static_assert(sizeof(ThreatReporter_GetThreatDOMDetails_ResponseParams_Data) == 16,
              "Bad sizeof(ThreatReporter_GetThreatDOMDetails_ResponseParams_Data)");
class  PhishingDetector_StartPhishingDetection_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  int32_t request_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PhishingDetector_StartPhishingDetection_Params_Data>;

  PhishingDetector_StartPhishingDetection_Params_Data();
  ~PhishingDetector_StartPhishingDetection_Params_Data() = delete;
};
static_assert(sizeof(PhishingDetector_StartPhishingDetection_Params_Data) == 24,
              "Bad sizeof(PhishingDetector_StartPhishingDetection_Params_Data)");
class  PhishingDetector_StartPhishingDetection_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ProtoWrapper_Data> request;

 private:
  friend class mojo::internal::MessageFragment<PhishingDetector_StartPhishingDetection_ResponseParams_Data>;

  PhishingDetector_StartPhishingDetection_ResponseParams_Data();
  ~PhishingDetector_StartPhishingDetection_ResponseParams_Data() = delete;
};
static_assert(sizeof(PhishingDetector_StartPhishingDetection_ResponseParams_Data) == 24,
              "Bad sizeof(PhishingDetector_StartPhishingDetection_ResponseParams_Data)");
class  PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> region;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyFile_Data> tflite_model;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyFile_Data> image_embedding_model;

 private:
  friend class mojo::internal::MessageFragment<PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data>;

  PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data();
  ~PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data() = delete;
};
static_assert(sizeof(PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data) == 32,
              "Bad sizeof(PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data)");
class  PhishingModelSetter_AttachImageEmbeddingModel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyFile_Data> image_embedding_model;

 private:
  friend class mojo::internal::MessageFragment<PhishingModelSetter_AttachImageEmbeddingModel_Params_Data>;

  PhishingModelSetter_AttachImageEmbeddingModel_Params_Data();
  ~PhishingModelSetter_AttachImageEmbeddingModel_Params_Data() = delete;
};
static_assert(sizeof(PhishingModelSetter_AttachImageEmbeddingModel_Params_Data) == 16,
              "Bad sizeof(PhishingModelSetter_AttachImageEmbeddingModel_Params_Data)");
class  PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlySharedMemoryRegion_Data> region;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyFile_Data> tflite_model;

 private:
  friend class mojo::internal::MessageFragment<PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data>;

  PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data();
  ~PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data() = delete;
};
static_assert(sizeof(PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data) == 24,
              "Bad sizeof(PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data)");
class  PhishingModelSetter_ClearScorer_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PhishingModelSetter_ClearScorer_Params_Data>;

  PhishingModelSetter_ClearScorer_Params_Data();
  ~PhishingModelSetter_ClearScorer_Params_Data() = delete;
};
static_assert(sizeof(PhishingModelSetter_ClearScorer_Params_Data) == 8,
              "Bad sizeof(PhishingModelSetter_ClearScorer_Params_Data)");
class  PhishingModelSetter_SetTestObserver_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data observer;

 private:
  friend class mojo::internal::MessageFragment<PhishingModelSetter_SetTestObserver_Params_Data>;

  PhishingModelSetter_SetTestObserver_Params_Data();
  ~PhishingModelSetter_SetTestObserver_Params_Data() = delete;
};
static_assert(sizeof(PhishingModelSetter_SetTestObserver_Params_Data) == 16,
              "Bad sizeof(PhishingModelSetter_SetTestObserver_Params_Data)");
class  PhishingModelSetter_SetTestObserver_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PhishingModelSetter_SetTestObserver_ResponseParams_Data>;

  PhishingModelSetter_SetTestObserver_ResponseParams_Data();
  ~PhishingModelSetter_SetTestObserver_ResponseParams_Data() = delete;
};
static_assert(sizeof(PhishingModelSetter_SetTestObserver_ResponseParams_Data) == 8,
              "Bad sizeof(PhishingModelSetter_SetTestObserver_ResponseParams_Data)");
class  PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data>;

  PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data();
  ~PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data() = delete;
};
static_assert(sizeof(PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data) == 8,
              "Bad sizeof(PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data)");
class  PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data>;

  PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data();
  ~PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data() = delete;
};
static_assert(sizeof(PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data) == 16,
              "Bad sizeof(PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data)");
class  PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ProtoWrapper_Data> image_embedding_request;

 private:
  friend class mojo::internal::MessageFragment<PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data>;

  PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data();
  ~PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data() = delete;
};
static_assert(sizeof(PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data) == 24,
              "Bad sizeof(PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data)");
class  ExtensionWebRequestReporter_SendWebRequestData_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> origin_extension_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> telemetry_url;
  int32_t protocol_type;
  int32_t contact_initiator_type;

 private:
  friend class mojo::internal::MessageFragment<ExtensionWebRequestReporter_SendWebRequestData_Params_Data>;

  ExtensionWebRequestReporter_SendWebRequestData_Params_Data();
  ~ExtensionWebRequestReporter_SendWebRequestData_Params_Data() = delete;
};
static_assert(sizeof(ExtensionWebRequestReporter_SendWebRequestData_Params_Data) == 32,
              "Bad sizeof(ExtensionWebRequestReporter_SendWebRequestData_Params_Data)");
class  ExtensionWebRequestReporter_Clone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ExtensionWebRequestReporter_Clone_Params_Data>;

  ExtensionWebRequestReporter_Clone_Params_Data();
  ~ExtensionWebRequestReporter_Clone_Params_Data() = delete;
};
static_assert(sizeof(ExtensionWebRequestReporter_Clone_Params_Data) == 16,
              "Bad sizeof(ExtensionWebRequestReporter_Clone_Params_Data)");

}  // namespace internal


class SafeBrowsing_CreateCheckerAndCheck_ParamsDataView {
 public:
  SafeBrowsing_CreateCheckerAndCheck_ParamsDataView() = default;

  SafeBrowsing_CreateCheckerAndCheck_ParamsDataView(
      internal::SafeBrowsing_CreateCheckerAndCheck_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::LocalFrameTokenDataView, UserType>(),
    "Attempting to read the optional `frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameToken` instead "
    "of `ReadFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::safe_browsing::mojom::SafeBrowsingUrlCheckerInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      ::network::mojom::HttpRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRequestHeadersDataView>(
        pointer, output, message_);
  }
  int32_t load_flags() const {
    return data_->load_flags;
  }
  bool has_user_gesture() const {
    return data_->has_user_gesture;
  }
  bool originated_from_service_worker() const {
    return data_->originated_from_service_worker;
  }
 private:
  internal::SafeBrowsing_CreateCheckerAndCheck_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SafeBrowsing_CreateCheckerAndCheck_ResponseParamsDataView {
 public:
  SafeBrowsing_CreateCheckerAndCheck_ResponseParamsDataView() = default;

  SafeBrowsing_CreateCheckerAndCheck_ResponseParamsDataView(
      internal::SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool proceed() const {
    return data_->proceed;
  }
  bool showed_interstitial() const {
    return data_->showed_interstitial;
  }
 private:
  internal::SafeBrowsing_CreateCheckerAndCheck_ResponseParams_Data* data_ = nullptr;
};


class SafeBrowsing_Clone_ParamsDataView {
 public:
  SafeBrowsing_Clone_ParamsDataView() = default;

  SafeBrowsing_Clone_ParamsDataView(
      internal::SafeBrowsing_Clone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::safe_browsing::mojom::SafeBrowsingInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::SafeBrowsing_Clone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ThreatReporter_GetThreatDOMDetails_ParamsDataView {
 public:
  ThreatReporter_GetThreatDOMDetails_ParamsDataView() = default;

  ThreatReporter_GetThreatDOMDetails_ParamsDataView(
      internal::ThreatReporter_GetThreatDOMDetails_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::ThreatReporter_GetThreatDOMDetails_Params_Data* data_ = nullptr;
};


class ThreatReporter_GetThreatDOMDetails_ResponseParamsDataView {
 public:
  ThreatReporter_GetThreatDOMDetails_ResponseParamsDataView() = default;

  ThreatReporter_GetThreatDOMDetails_ResponseParamsDataView(
      internal::ThreatReporter_GetThreatDOMDetails_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNodesDataView(
      mojo::ArrayDataView<ThreatDOMDetailsNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNodes(UserType* output) {
    
    auto* pointer = data_->nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::safe_browsing::mojom::ThreatDOMDetailsNodeDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ThreatReporter_GetThreatDOMDetails_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PhishingDetector_StartPhishingDetection_ParamsDataView {
 public:
  PhishingDetector_StartPhishingDetection_ParamsDataView() = default;

  PhishingDetector_StartPhishingDetection_ParamsDataView(
      internal::PhishingDetector_StartPhishingDetection_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestType(UserType* output) const {
    auto data_value = data_->request_type;
    return mojo::internal::Deserialize<::safe_browsing::mojom::ClientSideDetectionType>(
        data_value, output);
  }
  ClientSideDetectionType request_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::safe_browsing::mojom::ClientSideDetectionType>(data_->request_type));
  }
 private:
  internal::PhishingDetector_StartPhishingDetection_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PhishingDetector_StartPhishingDetection_ResponseParamsDataView {
 public:
  PhishingDetector_StartPhishingDetection_ResponseParamsDataView() = default;

  PhishingDetector_StartPhishingDetection_ResponseParamsDataView(
      internal::PhishingDetector_StartPhishingDetection_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::safe_browsing::mojom::PhishingDetectorResult>(
        data_value, output);
  }
  PhishingDetectorResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::safe_browsing::mojom::PhishingDetectorResult>(data_->result));
  }
  inline void GetRequestDataView(
      ::mojo_base::mojom::ProtoWrapperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ProtoWrapperDataView, UserType>(),
    "Attempting to read the optional `request` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequest` instead "
    "of `ReadRequest if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProtoWrapperDataView>(
        pointer, output, message_);
  }
 private:
  internal::PhishingDetector_StartPhishingDetection_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_ParamsDataView {
 public:
  PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_ParamsDataView() = default;

  PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_ParamsDataView(
      internal::PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegion(UserType* output) {
    
    auto* pointer = data_->region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  inline void GetTfliteModelDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTfliteModel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlyFileDataView, UserType>(),
    "Attempting to read the optional `tflite_model` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTfliteModel` instead "
    "of `ReadTfliteModel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tflite_model.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  inline void GetImageEmbeddingModelDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageEmbeddingModel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlyFileDataView, UserType>(),
    "Attempting to read the optional `image_embedding_model` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImageEmbeddingModel` instead "
    "of `ReadImageEmbeddingModel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image_embedding_model.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
 private:
  internal::PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PhishingModelSetter_AttachImageEmbeddingModel_ParamsDataView {
 public:
  PhishingModelSetter_AttachImageEmbeddingModel_ParamsDataView() = default;

  PhishingModelSetter_AttachImageEmbeddingModel_ParamsDataView(
      internal::PhishingModelSetter_AttachImageEmbeddingModel_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageEmbeddingModelDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageEmbeddingModel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlyFileDataView, UserType>(),
    "Attempting to read the optional `image_embedding_model` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImageEmbeddingModel` instead "
    "of `ReadImageEmbeddingModel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image_embedding_model.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
 private:
  internal::PhishingModelSetter_AttachImageEmbeddingModel_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PhishingModelSetter_SetPhishingFlatBufferModel_ParamsDataView {
 public:
  PhishingModelSetter_SetPhishingFlatBufferModel_ParamsDataView() = default;

  PhishingModelSetter_SetPhishingFlatBufferModel_ParamsDataView(
      internal::PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegion(UserType* output) {
    
    auto* pointer = data_->region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, message_);
  }
  inline void GetTfliteModelDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTfliteModel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlyFileDataView, UserType>(),
    "Attempting to read the optional `tflite_model` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTfliteModel` instead "
    "of `ReadTfliteModel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tflite_model.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
 private:
  internal::PhishingModelSetter_SetPhishingFlatBufferModel_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PhishingModelSetter_ClearScorer_ParamsDataView {
 public:
  PhishingModelSetter_ClearScorer_ParamsDataView() = default;

  PhishingModelSetter_ClearScorer_ParamsDataView(
      internal::PhishingModelSetter_ClearScorer_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PhishingModelSetter_ClearScorer_Params_Data* data_ = nullptr;
};


class PhishingModelSetter_SetTestObserver_ParamsDataView {
 public:
  PhishingModelSetter_SetTestObserver_ParamsDataView() = default;

  PhishingModelSetter_SetTestObserver_ParamsDataView(
      internal::PhishingModelSetter_SetTestObserver_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::safe_browsing::mojom::PhishingModelSetterTestObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PhishingModelSetter_SetTestObserver_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PhishingModelSetter_SetTestObserver_ResponseParamsDataView {
 public:
  PhishingModelSetter_SetTestObserver_ResponseParamsDataView() = default;

  PhishingModelSetter_SetTestObserver_ResponseParamsDataView(
      internal::PhishingModelSetter_SetTestObserver_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PhishingModelSetter_SetTestObserver_ResponseParams_Data* data_ = nullptr;
};


class PhishingModelSetterTestObserver_PhishingModelUpdated_ParamsDataView {
 public:
  PhishingModelSetterTestObserver_PhishingModelUpdated_ParamsDataView() = default;

  PhishingModelSetterTestObserver_PhishingModelUpdated_ParamsDataView(
      internal::PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PhishingModelSetterTestObserver_PhishingModelUpdated_Params_Data* data_ = nullptr;
};


class PhishingImageEmbedderDetector_StartImageEmbedding_ParamsDataView {
 public:
  PhishingImageEmbedderDetector_StartImageEmbedding_ParamsDataView() = default;

  PhishingImageEmbedderDetector_StartImageEmbedding_ParamsDataView(
      internal::PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::PhishingImageEmbedderDetector_StartImageEmbedding_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParamsDataView {
 public:
  PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParamsDataView() = default;

  PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParamsDataView(
      internal::PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::safe_browsing::mojom::PhishingImageEmbeddingResult>(
        data_value, output);
  }
  PhishingImageEmbeddingResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::safe_browsing::mojom::PhishingImageEmbeddingResult>(data_->result));
  }
  inline void GetImageEmbeddingRequestDataView(
      ::mojo_base::mojom::ProtoWrapperDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageEmbeddingRequest(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ProtoWrapperDataView, UserType>(),
    "Attempting to read the optional `image_embedding_request` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImageEmbeddingRequest` instead "
    "of `ReadImageEmbeddingRequest if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image_embedding_request.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ProtoWrapperDataView>(
        pointer, output, message_);
  }
 private:
  internal::PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ExtensionWebRequestReporter_SendWebRequestData_ParamsDataView {
 public:
  ExtensionWebRequestReporter_SendWebRequestData_ParamsDataView() = default;

  ExtensionWebRequestReporter_SendWebRequestData_ParamsDataView(
      internal::ExtensionWebRequestReporter_SendWebRequestData_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginExtensionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginExtensionId(UserType* output) {
    
    auto* pointer = data_->origin_extension_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTelemetryUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTelemetryUrl(UserType* output) {
    
    auto* pointer = data_->telemetry_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProtocolType(UserType* output) const {
    auto data_value = data_->protocol_type;
    return mojo::internal::Deserialize<::safe_browsing::mojom::WebRequestProtocolType>(
        data_value, output);
  }
  WebRequestProtocolType protocol_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::safe_browsing::mojom::WebRequestProtocolType>(data_->protocol_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContactInitiatorType(UserType* output) const {
    auto data_value = data_->contact_initiator_type;
    return mojo::internal::Deserialize<::safe_browsing::mojom::WebRequestContactInitiatorType>(
        data_value, output);
  }
  WebRequestContactInitiatorType contact_initiator_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::safe_browsing::mojom::WebRequestContactInitiatorType>(data_->contact_initiator_type));
  }
 private:
  internal::ExtensionWebRequestReporter_SendWebRequestData_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ExtensionWebRequestReporter_Clone_ParamsDataView {
 public:
  ExtensionWebRequestReporter_Clone_ParamsDataView() = default;

  ExtensionWebRequestReporter_Clone_ParamsDataView(
      internal::ExtensionWebRequestReporter_Clone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::safe_browsing::mojom::ExtensionWebRequestReporterInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ExtensionWebRequestReporter_Clone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void SafeBrowsing_CreateCheckerAndCheck_ParamsDataView::GetFrameTokenDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->frame_token.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void SafeBrowsing_CreateCheckerAndCheck_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SafeBrowsing_CreateCheckerAndCheck_ParamsDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SafeBrowsing_CreateCheckerAndCheck_ParamsDataView::GetHeadersDataView(
    ::network::mojom::HttpRequestHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = ::network::mojom::HttpRequestHeadersDataView(pointer, message_);
}








inline void ThreatReporter_GetThreatDOMDetails_ResponseParamsDataView::GetNodesDataView(
    mojo::ArrayDataView<ThreatDOMDetailsNodeDataView>* output) {
  auto pointer = data_->nodes.Get();
  *output = mojo::ArrayDataView<ThreatDOMDetailsNodeDataView>(pointer, message_);
}


inline void PhishingDetector_StartPhishingDetection_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void PhishingDetector_StartPhishingDetection_ResponseParamsDataView::GetRequestDataView(
    ::mojo_base::mojom::ProtoWrapperDataView* output) {
  auto pointer = data_->request.Get();
  *output = ::mojo_base::mojom::ProtoWrapperDataView(pointer, message_);
}


inline void PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_ParamsDataView::GetRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}
inline void PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_ParamsDataView::GetTfliteModelDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->tflite_model.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}
inline void PhishingModelSetter_SetImageEmbeddingAndPhishingFlatBufferModel_ParamsDataView::GetImageEmbeddingModelDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->image_embedding_model.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}


inline void PhishingModelSetter_AttachImageEmbeddingModel_ParamsDataView::GetImageEmbeddingModelDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->image_embedding_model.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}


inline void PhishingModelSetter_SetPhishingFlatBufferModel_ParamsDataView::GetRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}
inline void PhishingModelSetter_SetPhishingFlatBufferModel_ParamsDataView::GetTfliteModelDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->tflite_model.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}










inline void PhishingImageEmbedderDetector_StartImageEmbedding_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void PhishingImageEmbedderDetector_StartImageEmbedding_ResponseParamsDataView::GetImageEmbeddingRequestDataView(
    ::mojo_base::mojom::ProtoWrapperDataView* output) {
  auto pointer = data_->image_embedding_request.Get();
  *output = ::mojo_base::mojom::ProtoWrapperDataView(pointer, message_);
}


inline void ExtensionWebRequestReporter_SendWebRequestData_ParamsDataView::GetOriginExtensionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->origin_extension_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExtensionWebRequestReporter_SendWebRequestData_ParamsDataView::GetTelemetryUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->telemetry_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}





}  // safe_browsing::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_PARAMS_DATA_H_