// components/safe_browsing/content/common/safe_browsing.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_DATA_VIEW_H_
#define COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/safe_browsing/content/common/safe_browsing.mojom-shared-internal.h"
#include "components/safe_browsing/core/common/safe_browsing_url_checker.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace safe_browsing::mojom {
class AttributeNameValueDataView;

class ThreatDOMDetailsNodeDataView;



}  // safe_browsing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::safe_browsing::mojom::AttributeNameValueDataView> {
  using Data = ::safe_browsing::mojom::internal::AttributeNameValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::safe_browsing::mojom::ThreatDOMDetailsNodeDataView> {
  using Data = ::safe_browsing::mojom::internal::ThreatDOMDetailsNode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace safe_browsing::mojom {


enum class PhishingDetectorResult : int32_t {
  
  SUCCESS = 0,
  
  CLASSIFIER_NOT_READY = 1,
  
  CANCELLED = 2,
  
  FORWARD_BACK_TRANSITION = 3,
  
  INVALID_SCORE = 4,
  
  INVALID_URL_FORMAT_REQUEST = 5,
  
  INVALID_DOCUMENT_LOADER = 6,
  
  URL_FEATURE_EXTRACTION_FAILED = 7,
  
  DOM_EXTRACTION_FAILED = 8,
  
  TERM_EXTRACTION_FAILED = 9,
  
  VISUAL_EXTRACTION_FAILED = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

 std::ostream& operator<<(std::ostream& os, PhishingDetectorResult value);
inline bool IsKnownEnumValue(PhishingDetectorResult value) {
  return internal::PhishingDetectorResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ClientSideDetectionType : int32_t {
  
  kForceRequest = 0,
  
  kTriggerModels = 1,
  
  kNotificationPermissionPrompt = 2,
  
  kKeyboardLock = 3,
  
  kPointerLock = 4,
  
  kVibrationApi = 5,
  
  kFullscreen = 6,
  
  kPasswordProtection = 7,
  
  kClipboardCopyApi = 8,
  
  kCreditCardForm = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

 std::ostream& operator<<(std::ostream& os, ClientSideDetectionType value);
inline bool IsKnownEnumValue(ClientSideDetectionType value) {
  return internal::ClientSideDetectionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PhishingImageEmbeddingResult : int32_t {
  
  kSuccess = 0,
  
  kImageEmbedderNotReady = 1,
  
  kCancelled = 2,
  
  kForwardBackTransition = 3,
  
  kFailed = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, PhishingImageEmbeddingResult value);
inline bool IsKnownEnumValue(PhishingImageEmbeddingResult value) {
  return internal::PhishingImageEmbeddingResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebRequestProtocolType : int32_t {
  
  kHttpHttps = 0,
  
  kWebSocket = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, WebRequestProtocolType value);
inline bool IsKnownEnumValue(WebRequestProtocolType value) {
  return internal::WebRequestProtocolType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebRequestContactInitiatorType : int32_t {
  
  kExtension = 0,
  
  kContentScript = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, WebRequestContactInitiatorType value);
inline bool IsKnownEnumValue(WebRequestContactInitiatorType value) {
  return internal::WebRequestContactInitiatorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SafeBrowsingInterfaceBase {};

using SafeBrowsingPtrDataView =
    mojo::InterfacePtrDataView<SafeBrowsingInterfaceBase>;
using SafeBrowsingRequestDataView =
    mojo::InterfaceRequestDataView<SafeBrowsingInterfaceBase>;
using SafeBrowsingAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SafeBrowsingInterfaceBase>;
using SafeBrowsingAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SafeBrowsingInterfaceBase>;
class ThreatReporterInterfaceBase {};

using ThreatReporterPtrDataView =
    mojo::InterfacePtrDataView<ThreatReporterInterfaceBase>;
using ThreatReporterRequestDataView =
    mojo::InterfaceRequestDataView<ThreatReporterInterfaceBase>;
using ThreatReporterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ThreatReporterInterfaceBase>;
using ThreatReporterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ThreatReporterInterfaceBase>;
class PhishingDetectorInterfaceBase {};

using PhishingDetectorPtrDataView =
    mojo::InterfacePtrDataView<PhishingDetectorInterfaceBase>;
using PhishingDetectorRequestDataView =
    mojo::InterfaceRequestDataView<PhishingDetectorInterfaceBase>;
using PhishingDetectorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PhishingDetectorInterfaceBase>;
using PhishingDetectorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PhishingDetectorInterfaceBase>;
class PhishingModelSetterInterfaceBase {};

using PhishingModelSetterPtrDataView =
    mojo::InterfacePtrDataView<PhishingModelSetterInterfaceBase>;
using PhishingModelSetterRequestDataView =
    mojo::InterfaceRequestDataView<PhishingModelSetterInterfaceBase>;
using PhishingModelSetterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PhishingModelSetterInterfaceBase>;
using PhishingModelSetterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PhishingModelSetterInterfaceBase>;
class PhishingModelSetterTestObserverInterfaceBase {};

using PhishingModelSetterTestObserverPtrDataView =
    mojo::InterfacePtrDataView<PhishingModelSetterTestObserverInterfaceBase>;
using PhishingModelSetterTestObserverRequestDataView =
    mojo::InterfaceRequestDataView<PhishingModelSetterTestObserverInterfaceBase>;
using PhishingModelSetterTestObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PhishingModelSetterTestObserverInterfaceBase>;
using PhishingModelSetterTestObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PhishingModelSetterTestObserverInterfaceBase>;
class PhishingImageEmbedderDetectorInterfaceBase {};

using PhishingImageEmbedderDetectorPtrDataView =
    mojo::InterfacePtrDataView<PhishingImageEmbedderDetectorInterfaceBase>;
using PhishingImageEmbedderDetectorRequestDataView =
    mojo::InterfaceRequestDataView<PhishingImageEmbedderDetectorInterfaceBase>;
using PhishingImageEmbedderDetectorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PhishingImageEmbedderDetectorInterfaceBase>;
using PhishingImageEmbedderDetectorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PhishingImageEmbedderDetectorInterfaceBase>;
class ExtensionWebRequestReporterInterfaceBase {};

using ExtensionWebRequestReporterPtrDataView =
    mojo::InterfacePtrDataView<ExtensionWebRequestReporterInterfaceBase>;
using ExtensionWebRequestReporterRequestDataView =
    mojo::InterfaceRequestDataView<ExtensionWebRequestReporterInterfaceBase>;
using ExtensionWebRequestReporterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ExtensionWebRequestReporterInterfaceBase>;
using ExtensionWebRequestReporterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ExtensionWebRequestReporterInterfaceBase>;


class AttributeNameValueDataView {
 public:
  AttributeNameValueDataView() = default;

  AttributeNameValueDataView(
      internal::AttributeNameValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AttributeNameValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ThreatDOMDetailsNodeDataView {
 public:
  ThreatDOMDetailsNodeDataView() = default;

  ThreatDOMDetailsNodeDataView(
      internal::ThreatDOMDetailsNode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t node_id() const {
    return data_->node_id;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTagNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTagName(UserType* output) {
    
    auto* pointer = data_->tag_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParentDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParent(UserType* output) {
    
    auto* pointer = data_->parent.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int32_t parent_node_id() const {
    return data_->parent_node_id;
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetChildNodeIdsDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildNodeIds(UserType* output) {
    
    auto* pointer = data_->child_node_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetAttributesDataView(
      mojo::ArrayDataView<AttributeNameValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributes(UserType* output) {
    
    auto* pointer = data_->attributes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::safe_browsing::mojom::AttributeNameValueDataView>>(
        pointer, output, message_);
  }
  inline void GetChildFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `child_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadChildFrameToken` instead "
    "of `ReadChildFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->child_frame_token.is_null() ? &data_->child_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetInnerHtmlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInnerHtml(UserType* output) {
    
    auto* pointer = data_->inner_html.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ThreatDOMDetailsNode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // safe_browsing::mojom

#endif  // COMPONENTS_SAFE_BROWSING_CONTENT_COMMON_SAFE_BROWSING_MOJOM_DATA_VIEW_H_