// components/remote_cocoa/common/select_file_dialog.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_SELECT_FILE_DIALOG_MOJOM_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_SELECT_FILE_DIALOG_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/remote_cocoa/common/select_file_dialog.mojom-features.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/select_file_dialog.mojom-shared.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/select_file_dialog.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace remote_cocoa::mojom {

class SelectFileDialogProxy;

template <typename ImplRefTraits>
class SelectFileDialogStub;

class SelectFileDialogRequestValidator;
class SelectFileDialogResponseValidator;


class SelectFileDialog
    : public SelectFileDialogInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.SelectFileDialog";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SelectFileDialogInterfaceBase;
  using Proxy_ = SelectFileDialogProxy;

  template <typename ImplRefTraits>
  using Stub_ = SelectFileDialogStub<ImplRefTraits>;

  using RequestValidator_ = SelectFileDialogRequestValidator;
  using ResponseValidator_ = SelectFileDialogResponseValidator;
  enum MethodMinVersions : uint32_t {
    kShowMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Show_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SelectFileDialog() = default;

  using ShowCallback = base::OnceCallback<void(bool, const std::vector<::base::FilePath>&, int32_t, const std::vector<std::string>&)>;
  using ShowMojoCallback = base::OnceCallback<void(bool, const std::vector<::base::FilePath>&, int32_t, const std::vector<std::string>&)>;

  virtual void Show(SelectFileDialogType type, const ::std::u16string& title, const ::base::FilePath& file_path, SelectFileTypeInfoPtr file_types, int32_t file_type_index, const std::string& default_extension, ShowCallback callback) = 0;
};



class  SelectFileDialogProxy
    : public SelectFileDialog {
 public:
  using InterfaceType = SelectFileDialog;

  explicit SelectFileDialogProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Show(SelectFileDialogType type, const ::std::u16string& title, const ::base::FilePath& file_path, SelectFileTypeInfoPtr file_types, int32_t file_type_index, const std::string& default_extension, ShowCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SelectFileDialogStubDispatch {
 public:
  static bool Accept(SelectFileDialog* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SelectFileDialog* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SelectFileDialog>>
class SelectFileDialogStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SelectFileDialogStub() = default;
  ~SelectFileDialogStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SelectFileDialogStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SelectFileDialogStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SelectFileDialogRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SelectFileDialogResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  SelectFileTypeInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectFileTypeInfo, T>::value>;
  using DataView = SelectFileTypeInfoDataView;
  using Data_ = internal::SelectFileTypeInfo_Data;

  template <typename... Args>
  static SelectFileTypeInfoPtr New(Args&&... args) {
    return SelectFileTypeInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectFileTypeInfoPtr From(const U& u) {
    return mojo::TypeConverter<SelectFileTypeInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectFileTypeInfo>::Convert(*this);
  }


  SelectFileTypeInfo();

  SelectFileTypeInfo(
      std::vector<std::vector<std::string>> extensions,
      std::vector<::std::u16string> extension_description_overrides,
      bool include_all_files,
      bool keep_extension_visible);


  ~SelectFileTypeInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectFileTypeInfoPtr>
  SelectFileTypeInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectFileTypeInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectFileTypeInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectFileTypeInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectFileTypeInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectFileTypeInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectFileTypeInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectFileTypeInfo_UnserializedMessageContext<
            UserType, SelectFileTypeInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectFileTypeInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectFileTypeInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectFileTypeInfo_UnserializedMessageContext<
            UserType, SelectFileTypeInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectFileTypeInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::vector<std::string>> extensions;
  
  std::vector<::std::u16string> extension_description_overrides;
  
  bool include_all_files;
  
  bool keep_extension_visible;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectFileTypeInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectFileTypeInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectFileTypeInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectFileTypeInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SelectFileTypeInfoPtr SelectFileTypeInfo::Clone() const {
  return New(
      mojo::Clone(extensions),
      mojo::Clone(extension_description_overrides),
      mojo::Clone(include_all_files),
      mojo::Clone(keep_extension_visible)
  );
}

template <typename T, SelectFileTypeInfo::EnableIfSame<T>*>
bool SelectFileTypeInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->extensions, other_struct.extensions))
    return false;
  if (!mojo::Equals(this->extension_description_overrides, other_struct.extension_description_overrides))
    return false;
  if (!mojo::Equals(this->include_all_files, other_struct.include_all_files))
    return false;
  if (!mojo::Equals(this->keep_extension_visible, other_struct.keep_extension_visible))
    return false;
  return true;
}

template <typename T, SelectFileTypeInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.extensions < rhs.extensions)
    return true;
  if (rhs.extensions < lhs.extensions)
    return false;
  if (lhs.extension_description_overrides < rhs.extension_description_overrides)
    return true;
  if (rhs.extension_description_overrides < lhs.extension_description_overrides)
    return false;
  if (lhs.include_all_files < rhs.include_all_files)
    return true;
  if (rhs.include_all_files < lhs.include_all_files)
    return false;
  if (lhs.keep_extension_visible < rhs.keep_extension_visible)
    return true;
  if (rhs.keep_extension_visible < lhs.keep_extension_visible)
    return false;
  return false;
}


}  // remote_cocoa::mojom

namespace mojo {


template <>
struct  StructTraits<::remote_cocoa::mojom::SelectFileTypeInfo::DataView,
                                         ::remote_cocoa::mojom::SelectFileTypeInfoPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::SelectFileTypeInfoPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::SelectFileTypeInfoPtr* output) { output->reset(); }

  static const decltype(::remote_cocoa::mojom::SelectFileTypeInfo::extensions)& extensions(
      const ::remote_cocoa::mojom::SelectFileTypeInfoPtr& input) {
    return input->extensions;
  }

  static const decltype(::remote_cocoa::mojom::SelectFileTypeInfo::extension_description_overrides)& extension_description_overrides(
      const ::remote_cocoa::mojom::SelectFileTypeInfoPtr& input) {
    return input->extension_description_overrides;
  }

  static decltype(::remote_cocoa::mojom::SelectFileTypeInfo::include_all_files) include_all_files(
      const ::remote_cocoa::mojom::SelectFileTypeInfoPtr& input) {
    return input->include_all_files;
  }

  static decltype(::remote_cocoa::mojom::SelectFileTypeInfo::keep_extension_visible) keep_extension_visible(
      const ::remote_cocoa::mojom::SelectFileTypeInfoPtr& input) {
    return input->keep_extension_visible;
  }

  static bool Read(::remote_cocoa::mojom::SelectFileTypeInfo::DataView input, ::remote_cocoa::mojom::SelectFileTypeInfoPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_SELECT_FILE_DIALOG_MOJOM_H_