// components/remote_cocoa/common/select_file_dialog.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_SELECT_FILE_DIALOG_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_SELECT_FILE_DIALOG_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace remote_cocoa::mojom {
namespace internal {
class  SelectFileDialog_Show_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  int32_t file_type_index;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> title;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> file_path;
  mojo::internal::Pointer<internal::SelectFileTypeInfo_Data> file_types;
  mojo::internal::Pointer<mojo::internal::String_Data> default_extension;

 private:
  friend class mojo::internal::MessageFragment<SelectFileDialog_Show_Params_Data>;

  SelectFileDialog_Show_Params_Data();
  ~SelectFileDialog_Show_Params_Data() = delete;
};
static_assert(sizeof(SelectFileDialog_Show_Params_Data) == 48,
              "Bad sizeof(SelectFileDialog_Show_Params_Data)");
class  SelectFileDialog_Show_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t was_cancelled : 1;
  uint8_t pad0_[3];
  int32_t index;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data>>> files;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> file_tags;

 private:
  friend class mojo::internal::MessageFragment<SelectFileDialog_Show_ResponseParams_Data>;

  SelectFileDialog_Show_ResponseParams_Data();
  ~SelectFileDialog_Show_ResponseParams_Data() = delete;
};
static_assert(sizeof(SelectFileDialog_Show_ResponseParams_Data) == 32,
              "Bad sizeof(SelectFileDialog_Show_ResponseParams_Data)");

}  // namespace internal


class SelectFileDialog_Show_ParamsDataView {
 public:
  SelectFileDialog_Show_ParamsDataView() = default;

  SelectFileDialog_Show_ParamsDataView(
      internal::SelectFileDialog_Show_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::remote_cocoa::mojom::SelectFileDialogType>(
        data_value, output);
  }
  SelectFileDialogType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::remote_cocoa::mojom::SelectFileDialogType>(data_->type));
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetFilePathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePath(UserType* output) {
    
    auto* pointer = data_->file_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetFileTypesDataView(
      SelectFileTypeInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileTypes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::remote_cocoa::mojom::SelectFileTypeInfoDataView, UserType>(),
    "Attempting to read the optional `file_types` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileTypes` instead "
    "of `ReadFileTypes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_types.Get();
    return mojo::internal::Deserialize<::remote_cocoa::mojom::SelectFileTypeInfoDataView>(
        pointer, output, message_);
  }
  int32_t file_type_index() const {
    return data_->file_type_index;
  }
  inline void GetDefaultExtensionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultExtension(UserType* output) {
    
    auto* pointer = data_->default_extension.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SelectFileDialog_Show_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectFileDialog_Show_ResponseParamsDataView {
 public:
  SelectFileDialog_Show_ResponseParamsDataView() = default;

  SelectFileDialog_Show_ResponseParamsDataView(
      internal::SelectFileDialog_Show_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool was_cancelled() const {
    return data_->was_cancelled;
  }
  inline void GetFilesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFiles(UserType* output) {
    
    auto* pointer = data_->files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
        pointer, output, message_);
  }
  int32_t index() const {
    return data_->index;
  }
  inline void GetFileTagsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileTags(UserType* output) {
    
    auto* pointer = data_->file_tags.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SelectFileDialog_Show_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void SelectFileDialog_Show_ParamsDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SelectFileDialog_Show_ParamsDataView::GetFilePathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->file_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void SelectFileDialog_Show_ParamsDataView::GetFileTypesDataView(
    SelectFileTypeInfoDataView* output) {
  auto pointer = data_->file_types.Get();
  *output = SelectFileTypeInfoDataView(pointer, message_);
}
inline void SelectFileDialog_Show_ParamsDataView::GetDefaultExtensionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->default_extension.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SelectFileDialog_Show_ResponseParamsDataView::GetFilesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output) {
  auto pointer = data_->files.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>(pointer, message_);
}
inline void SelectFileDialog_Show_ResponseParamsDataView::GetFileTagsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->file_tags.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}



}  // remote_cocoa::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_SELECT_FILE_DIALOG_MOJOM_PARAMS_DATA_H_