// components/remote_cocoa/common/native_widget_ns_window.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/remote_cocoa/common/native_widget_ns_window.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/native_widget_ns_window.mojom-params-data.h"
namespace remote_cocoa {
namespace mojom {

NOINLINE static const char* WindowClassToStringHelper(WindowClass value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowClass::kDefault:
      return "kDefault";
    case WindowClass::kBrowser:
      return "kBrowser";
    case WindowClass::kFrameless:
      return "kFrameless";
    case WindowClass::kOverlay:
      return "kOverlay";
    default:
      return nullptr;
  }
}

std::string WindowClassToString(WindowClass value) {
  const char *str = WindowClassToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowClass value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowClass value) {
  return os << WindowClassToString(value);
}

NOINLINE static const char* WindowVisibilityStateToStringHelper(WindowVisibilityState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowVisibilityState::kHideWindow:
      return "kHideWindow";
    case WindowVisibilityState::kShowAndActivateWindow:
      return "kShowAndActivateWindow";
    case WindowVisibilityState::kShowInactive:
      return "kShowInactive";
    case WindowVisibilityState::kMiniaturizeWindow:
      return "kMiniaturizeWindow";
    default:
      return nullptr;
  }
}

std::string WindowVisibilityStateToString(WindowVisibilityState value) {
  const char *str = WindowVisibilityStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowVisibilityState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowVisibilityState value) {
  return os << WindowVisibilityStateToString(value);
}

NOINLINE static const char* VisibilityTransitionToStringHelper(VisibilityTransition value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case VisibilityTransition::kShow:
      return "kShow";
    case VisibilityTransition::kHide:
      return "kHide";
    case VisibilityTransition::kBoth:
      return "kBoth";
    case VisibilityTransition::kNone:
      return "kNone";
    default:
      return nullptr;
  }
}

std::string VisibilityTransitionToString(VisibilityTransition value) {
  const char *str = VisibilityTransitionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown VisibilityTransition value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, VisibilityTransition value) {
  return os << VisibilityTransitionToString(value);
}

NOINLINE static const char* ToolbarVisibilityStyleToStringHelper(ToolbarVisibilityStyle value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ToolbarVisibilityStyle::kNone:
      return "kNone";
    case ToolbarVisibilityStyle::kAlways:
      return "kAlways";
    case ToolbarVisibilityStyle::kAutohide:
      return "kAutohide";
    default:
      return nullptr;
  }
}

std::string ToolbarVisibilityStyleToString(ToolbarVisibilityStyle value) {
  const char *str = ToolbarVisibilityStyleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ToolbarVisibilityStyle value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ToolbarVisibilityStyle value) {
  return os << ToolbarVisibilityStyleToString(value);
}

namespace internal {


// static
bool CreateWindowParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CreateWindowParams_Data* object =
      static_cast<const CreateWindowParams_Data*>(data);


  if (!::remote_cocoa::mojom::internal::WindowClass_Data
        ::Validate(object->window_class, validation_context))
    return false;

  return true;
}

CreateWindowParams_Data::CreateWindowParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindowInitParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindowInitParams_Data* object =
      static_cast<const NativeWidgetNSWindowInitParams_Data*>(data);


  if (!::ui::mojom::internal::ModalType_Data
        ::Validate(object->modal_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state_restoration_data, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& state_restoration_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->state_restoration_data, validation_context,
                                         &state_restoration_data_validate_params)) {
    return false;
  }

  return true;
}

NativeWidgetNSWindowInitParams_Data::NativeWidgetNSWindowInitParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_CreateWindow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_CreateWindow_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_CreateWindow_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_CreateWindow_Params_Data::NativeWidgetNSWindow_CreateWindow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetParent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetParent_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetParent_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetParent_Params_Data::NativeWidgetNSWindow_SetParent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_CreateSelectFileDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_CreateSelectFileDialog_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_CreateSelectFileDialog_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->dialog, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->dialog,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NativeWidgetNSWindow_CreateSelectFileDialog_Params_Data::NativeWidgetNSWindow_CreateSelectFileDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_ShowCertificateViewer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_ShowCertificateViewer_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_ShowCertificateViewer_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->certificate, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_ShowCertificateViewer_Params_Data::NativeWidgetNSWindow_ShowCertificateViewer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_StackAbove_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_StackAbove_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_StackAbove_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_StackAbove_Params_Data::NativeWidgetNSWindow_StackAbove_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_StackAtTop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_StackAtTop_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_StackAtTop_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_StackAtTop_Params_Data::NativeWidgetNSWindow_StackAtTop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_ShowEmojiPanel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_ShowEmojiPanel_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_ShowEmojiPanel_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_ShowEmojiPanel_Params_Data::NativeWidgetNSWindow_ShowEmojiPanel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_InitWindow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_InitWindow_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_InitWindow_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_InitWindow_Params_Data::NativeWidgetNSWindow_InitWindow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_InitCompositorView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_InitCompositorView_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_InitCompositorView_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_InitCompositorView_Params_Data::NativeWidgetNSWindow_InitCompositorView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_InitCompositorView_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_InitCompositorView_ResponseParams_Data* object =
      static_cast<const NativeWidgetNSWindow_InitCompositorView_ResponseParams_Data*>(data);

  return true;
}

NativeWidgetNSWindow_InitCompositorView_ResponseParams_Data::NativeWidgetNSWindow_InitCompositorView_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_CreateContentView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_CreateContentView_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_CreateContentView_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_CreateContentView_Params_Data::NativeWidgetNSWindow_CreateContentView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_DestroyContentView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_DestroyContentView_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_DestroyContentView_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_DestroyContentView_Params_Data::NativeWidgetNSWindow_DestroyContentView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_CloseWindow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_CloseWindow_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_CloseWindow_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_CloseWindow_Params_Data::NativeWidgetNSWindow_CloseWindow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_CloseWindowNow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_CloseWindowNow_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_CloseWindowNow_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_CloseWindowNow_Params_Data::NativeWidgetNSWindow_CloseWindowNow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetInitialBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetInitialBounds_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetInitialBounds_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->minimum_content_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->minimum_content_size, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetInitialBounds_Params_Data::NativeWidgetNSWindow_SetInitialBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetBounds_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetBounds_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->minimum_content_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->minimum_content_size, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->maximum_content_size, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetBounds_Params_Data::NativeWidgetNSWindow_SetBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetSize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetSize_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetSize_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->minimum_content_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->minimum_content_size, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetSize_Params_Data::NativeWidgetNSWindow_SetSize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetSizeAndCenter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetSizeAndCenter_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetSizeAndCenter_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->minimum_content_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->minimum_content_size, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetSizeAndCenter_Params_Data::NativeWidgetNSWindow_SetSizeAndCenter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetVisibilityState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetVisibilityState_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetVisibilityState_Params_Data*>(data);


  if (!::remote_cocoa::mojom::internal::WindowVisibilityState_Data
        ::Validate(object->new_state, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetVisibilityState_Params_Data::NativeWidgetNSWindow_SetVisibilityState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetAnimationEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetAnimationEnabled_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetAnimationEnabled_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetAnimationEnabled_Params_Data::NativeWidgetNSWindow_SetAnimationEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetTransitionsToAnimate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetTransitionsToAnimate_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetTransitionsToAnimate_Params_Data*>(data);


  if (!::remote_cocoa::mojom::internal::VisibilityTransition_Data
        ::Validate(object->transitions, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetTransitionsToAnimate_Params_Data::NativeWidgetNSWindow_SetTransitionsToAnimate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetVisibleOnAllSpaces_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetVisibleOnAllSpaces_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetVisibleOnAllSpaces_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetVisibleOnAllSpaces_Params_Data::NativeWidgetNSWindow_SetVisibleOnAllSpaces_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_EnterFullscreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_EnterFullscreen_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_EnterFullscreen_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_EnterFullscreen_Params_Data::NativeWidgetNSWindow_EnterFullscreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_ExitFullscreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_ExitFullscreen_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_ExitFullscreen_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_ExitFullscreen_Params_Data::NativeWidgetNSWindow_ExitFullscreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetCanAppearInExistingFullscreenSpaces_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetCanAppearInExistingFullscreenSpaces_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetCanAppearInExistingFullscreenSpaces_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetCanAppearInExistingFullscreenSpaces_Params_Data::NativeWidgetNSWindow_SetCanAppearInExistingFullscreenSpaces_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetMiniaturized_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetMiniaturized_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetMiniaturized_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetMiniaturized_Params_Data::NativeWidgetNSWindow_SetMiniaturized_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetZoomed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetZoomed_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetZoomed_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetZoomed_Params_Data::NativeWidgetNSWindow_SetZoomed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetSizeConstraints_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetSizeConstraints_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetSizeConstraints_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_size, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetSizeConstraints_Params_Data::NativeWidgetNSWindow_SetSizeConstraints_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetOpacity_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetOpacity_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetOpacity_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetOpacity_Params_Data::NativeWidgetNSWindow_SetOpacity_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetWindowLevel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetWindowLevel_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetWindowLevel_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetWindowLevel_Params_Data::NativeWidgetNSWindow_SetWindowLevel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetActivationIndependence_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetActivationIndependence_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetActivationIndependence_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetActivationIndependence_Params_Data::NativeWidgetNSWindow_SetActivationIndependence_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetAspectRatio_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetAspectRatio_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetAspectRatio_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->aspect_ratio, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->aspect_ratio, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->excluded_margin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->excluded_margin, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetAspectRatio_Params_Data::NativeWidgetNSWindow_SetAspectRatio_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetCALayerParams_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetCALayerParams_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetCALayerParams_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ca_layer_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ca_layer_params, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetCALayerParams_Params_Data::NativeWidgetNSWindow_SetCALayerParams_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetWindowTitle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetWindowTitle_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetWindowTitle_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetWindowTitle_Params_Data::NativeWidgetNSWindow_SetWindowTitle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetIgnoresMouseEvents_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetIgnoresMouseEvents_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetIgnoresMouseEvents_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetIgnoresMouseEvents_Params_Data::NativeWidgetNSWindow_SetIgnoresMouseEvents_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_MakeFirstResponder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_MakeFirstResponder_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_MakeFirstResponder_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_MakeFirstResponder_Params_Data::NativeWidgetNSWindow_MakeFirstResponder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SortSubviews_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SortSubviews_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SortSubviews_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attached_subview_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attached_subview_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attached_subview_ids, validation_context,
                                         &attached_subview_ids_validate_params)) {
    return false;
  }

  return true;
}

NativeWidgetNSWindow_SortSubviews_Params_Data::NativeWidgetNSWindow_SortSubviews_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_ClearTouchBar_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_ClearTouchBar_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_ClearTouchBar_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_ClearTouchBar_Params_Data::NativeWidgetNSWindow_ClearTouchBar_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_UpdateTooltip_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_UpdateTooltip_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_UpdateTooltip_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_UpdateTooltip_Params_Data::NativeWidgetNSWindow_UpdateTooltip_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_AcquireCapture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_AcquireCapture_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_AcquireCapture_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_AcquireCapture_Params_Data::NativeWidgetNSWindow_AcquireCapture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_ReleaseCapture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_ReleaseCapture_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_ReleaseCapture_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_ReleaseCapture_Params_Data::NativeWidgetNSWindow_ReleaseCapture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_RedispatchKeyEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_RedispatchKeyEvent_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_RedispatchKeyEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_event_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& native_event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->native_event_data, validation_context,
                                         &native_event_data_validate_params)) {
    return false;
  }

  return true;
}

NativeWidgetNSWindow_RedispatchKeyEvent_Params_Data::NativeWidgetNSWindow_RedispatchKeyEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetLocalEventMonitorEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetLocalEventMonitorEnabled_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetLocalEventMonitorEnabled_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetLocalEventMonitorEnabled_Params_Data::NativeWidgetNSWindow_SetLocalEventMonitorEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetCursor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetCursor_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetCursor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cursor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cursor, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetCursor_Params_Data::NativeWidgetNSWindow_SetCursor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_EnableImmersiveFullscreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_EnableImmersiveFullscreen_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_EnableImmersiveFullscreen_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_EnableImmersiveFullscreen_Params_Data::NativeWidgetNSWindow_EnableImmersiveFullscreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_DisableImmersiveFullscreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_DisableImmersiveFullscreen_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_DisableImmersiveFullscreen_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_DisableImmersiveFullscreen_Params_Data::NativeWidgetNSWindow_DisableImmersiveFullscreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_UpdateToolbarVisibility_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_UpdateToolbarVisibility_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_UpdateToolbarVisibility_Params_Data*>(data);


  if (!::remote_cocoa::mojom::internal::ToolbarVisibilityStyle_Data
        ::Validate(object->style, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_UpdateToolbarVisibility_Params_Data::NativeWidgetNSWindow_UpdateToolbarVisibility_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_OnTopContainerViewBoundsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_OnTopContainerViewBoundsChanged_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_OnTopContainerViewBoundsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_OnTopContainerViewBoundsChanged_Params_Data::NativeWidgetNSWindow_OnTopContainerViewBoundsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_ImmersiveFullscreenRevealLock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_ImmersiveFullscreenRevealLock_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_ImmersiveFullscreenRevealLock_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_ImmersiveFullscreenRevealLock_Params_Data::NativeWidgetNSWindow_ImmersiveFullscreenRevealLock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_ImmersiveFullscreenRevealUnlock_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_ImmersiveFullscreenRevealUnlock_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_ImmersiveFullscreenRevealUnlock_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_ImmersiveFullscreenRevealUnlock_Params_Data::NativeWidgetNSWindow_ImmersiveFullscreenRevealUnlock_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetCanGoBack_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetCanGoBack_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetCanGoBack_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetCanGoBack_Params_Data::NativeWidgetNSWindow_SetCanGoBack_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetCanGoForward_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetCanGoForward_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetCanGoForward_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetCanGoForward_Params_Data::NativeWidgetNSWindow_SetCanGoForward_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_DisplayContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_DisplayContextMenu_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_DisplayContextMenu_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->menu, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->menu, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NativeWidgetNSWindow_DisplayContextMenu_Params_Data::NativeWidgetNSWindow_DisplayContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetAllowScreenshots_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetAllowScreenshots_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetAllowScreenshots_Params_Data*>(data);

  return true;
}

NativeWidgetNSWindow_SetAllowScreenshots_Params_Data::NativeWidgetNSWindow_SetAllowScreenshots_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NativeWidgetNSWindow_SetColorMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NativeWidgetNSWindow_SetColorMode_Params_Data* object =
      static_cast<const NativeWidgetNSWindow_SetColorMode_Params_Data*>(data);


  if (!::ui::mojom::internal::ColorMode_Data
        ::Validate(object->color_mode, validation_context))
    return false;

  return true;
}

NativeWidgetNSWindow_SetColorMode_Params_Data::NativeWidgetNSWindow_SetColorMode_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace remote_cocoa

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::WindowClass>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::WindowClass value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::WindowClassToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::WindowVisibilityState>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::WindowVisibilityState value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::WindowVisibilityStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::VisibilityTransition>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::VisibilityTransition value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::VisibilityTransitionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::remote_cocoa::mojom::ToolbarVisibilityStyle>::WriteIntoTrace(
   perfetto::TracedValue context, ::remote_cocoa::mojom::ToolbarVisibilityStyle value) {
  return std::move(context).WriteString(::remote_cocoa::mojom::ToolbarVisibilityStyleToString(value));
}

} // namespace perfetto