// components/remote_cocoa/common/menu.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/remote_cocoa/common/menu.mojom-features.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/menu.mojom-shared.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/menu.mojom-forward.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/font.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-forward.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace remote_cocoa::mojom {

class MenuHostProxy;

template <typename ImplRefTraits>
class MenuHostStub;

class MenuHostRequestValidator;


class MenuHost
    : public MenuHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.MenuHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MenuHostInterfaceBase;
  using Proxy_ = MenuHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = MenuHostStub<ImplRefTraits>;

  using RequestValidator_ = MenuHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCommandActivatedMinVersion = 0,
    kMenuClosedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CommandActivated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MenuClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MenuHost() = default;

  virtual void CommandActivated(int32_t command_id, int32_t event_flags) = 0;

  virtual void MenuClosed() = 0;
};

class MenuProxy;

template <typename ImplRefTraits>
class MenuStub;

class MenuRequestValidator;


class Menu
    : public MenuInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.Menu";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MenuInterfaceBase;
  using Proxy_ = MenuProxy;

  template <typename ImplRefTraits>
  using Stub_ = MenuStub<ImplRefTraits>;

  using RequestValidator_ = MenuRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCancelMinVersion = 0,
    kUpdateMenuItemMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateMenuItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Menu() = default;

  virtual void Cancel() = 0;

  virtual void UpdateMenuItem(int32_t command_id, bool enabled, bool visible, const ::std::u16string& label) = 0;
};



class  MenuHostProxy
    : public MenuHost {
 public:
  using InterfaceType = MenuHost;

  explicit MenuHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CommandActivated(int32_t command_id, int32_t event_flags) final;
  
  void MenuClosed() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MenuProxy
    : public Menu {
 public:
  using InterfaceType = Menu;

  explicit MenuProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Cancel() final;
  
  void UpdateMenuItem(int32_t command_id, bool enabled, bool visible, const ::std::u16string& label) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MenuHostStubDispatch {
 public:
  static bool Accept(MenuHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MenuHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MenuHost>>
class MenuHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MenuHostStub() = default;
  ~MenuHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MenuHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MenuHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MenuStubDispatch {
 public:
  static bool Accept(Menu* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Menu* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Menu>>
class MenuStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MenuStub() = default;
  ~MenuStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MenuStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MenuStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MenuHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MenuRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  MenuItem {
 public:
  using DataView = MenuItemDataView;
  using Data_ = internal::MenuItem_Data;
  using Tag = Data_::MenuItem_Tag;

  template <typename... Args>
  static MenuItemPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |separator|.
  static MenuItemPtr NewSeparator(
      MenuItemCommonFieldsPtr value);
  // Construct an instance holding |regular|.
  static MenuItemPtr NewRegular(
      MenuItemCommonFieldsPtr value);
  // Construct an instance holding |submenu|.
  static MenuItemPtr NewSubmenu(
      SubmenuMenuItemPtr value);

  template <typename U>
  static MenuItemPtr From(const U& u) {
    return mojo::TypeConverter<MenuItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MenuItem>::Convert(*this);
  }
  ~MenuItem();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  MenuItem(const MenuItem& other) = delete;
  MenuItem& operator=(const MenuItem& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = MenuItemPtr>
  MenuItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, MenuItem>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, MenuItem>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_separator() const { return tag_ == Tag::kSeparator; }
  const MenuItemCommonFieldsPtr& get_separator() const {
    CHECK(tag_ == Tag::kSeparator);
    return data_.separator;
  }
  MenuItemCommonFieldsPtr& get_separator() {
    CHECK(tag_ == Tag::kSeparator);
    return data_.separator;
  }
  void set_separator(MenuItemCommonFieldsPtr separator);

  bool is_regular() const { return tag_ == Tag::kRegular; }
  const MenuItemCommonFieldsPtr& get_regular() const {
    CHECK(tag_ == Tag::kRegular);
    return data_.regular;
  }
  MenuItemCommonFieldsPtr& get_regular() {
    CHECK(tag_ == Tag::kRegular);
    return data_.regular;
  }
  void set_regular(MenuItemCommonFieldsPtr regular);

  bool is_submenu() const { return tag_ == Tag::kSubmenu; }
  const SubmenuMenuItemPtr& get_submenu() const {
    CHECK(tag_ == Tag::kSubmenu);
    return data_.submenu;
  }
  SubmenuMenuItemPtr& get_submenu() {
    CHECK(tag_ == Tag::kSubmenu);
    return data_.submenu;
  }
  void set_submenu(SubmenuMenuItemPtr submenu);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MenuItem::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<MenuItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSeparator)>,
        MenuItemCommonFieldsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRegular)>,
        MenuItemCommonFieldsPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSubmenu)>,
        SubmenuMenuItemPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    MenuItemCommonFieldsPtr separator;
    MenuItemCommonFieldsPtr regular;
    SubmenuMenuItemPtr submenu;
  };

  MenuItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kSeparator)>,
      MenuItemCommonFieldsPtr value);
  MenuItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kRegular)>,
      MenuItemCommonFieldsPtr value);
  MenuItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kSubmenu)>,
      SubmenuMenuItemPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  MenuItemCommonFields {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MenuItemCommonFields, T>::value>;
  using DataView = MenuItemCommonFieldsDataView;
  using Data_ = internal::MenuItemCommonFields_Data;

  template <typename... Args>
  static MenuItemCommonFieldsPtr New(Args&&... args) {
    return MenuItemCommonFieldsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MenuItemCommonFieldsPtr From(const U& u) {
    return mojo::TypeConverter<MenuItemCommonFieldsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MenuItemCommonFields>::Convert(*this);
  }


  MenuItemCommonFields();

  MenuItemCommonFields(
      int32_t command_id,
      const ::std::u16string& label,
      bool may_have_mnemonics,
      bool is_checked,
      const ::gfx::ImageSkia& icon,
      bool is_enabled,
      bool is_visible,
      bool is_alerted,
      bool is_new_feature);


  ~MenuItemCommonFields();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MenuItemCommonFieldsPtr>
  MenuItemCommonFieldsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MenuItemCommonFields::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MenuItemCommonFields::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MenuItemCommonFields::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MenuItemCommonFields::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MenuItemCommonFields_UnserializedMessageContext<
            UserType, MenuItemCommonFields::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MenuItemCommonFields::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MenuItemCommonFields::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MenuItemCommonFields_UnserializedMessageContext<
            UserType, MenuItemCommonFields::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MenuItemCommonFields::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t command_id;
  
  ::std::u16string label;
  
  bool may_have_mnemonics;
  
  bool is_checked;
  
  ::gfx::ImageSkia icon;
  
  bool is_enabled;
  
  bool is_visible;
  
  bool is_alerted;
  
  bool is_new_feature;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MenuItemCommonFields::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MenuItemCommonFields::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MenuItemCommonFields::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MenuItemCommonFields::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SubmenuMenuItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubmenuMenuItem, T>::value>;
  using DataView = SubmenuMenuItemDataView;
  using Data_ = internal::SubmenuMenuItem_Data;

  template <typename... Args>
  static SubmenuMenuItemPtr New(Args&&... args) {
    return SubmenuMenuItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubmenuMenuItemPtr From(const U& u) {
    return mojo::TypeConverter<SubmenuMenuItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubmenuMenuItem>::Convert(*this);
  }


  SubmenuMenuItem();

  SubmenuMenuItem(
      MenuItemCommonFieldsPtr common,
      std::vector<MenuItemPtr> children);

SubmenuMenuItem(const SubmenuMenuItem&) = delete;
SubmenuMenuItem& operator=(const SubmenuMenuItem&) = delete;

  ~SubmenuMenuItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubmenuMenuItemPtr>
  SubmenuMenuItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubmenuMenuItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SubmenuMenuItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SubmenuMenuItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubmenuMenuItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubmenuMenuItem_UnserializedMessageContext<
            UserType, SubmenuMenuItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SubmenuMenuItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SubmenuMenuItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubmenuMenuItem_UnserializedMessageContext<
            UserType, SubmenuMenuItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubmenuMenuItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  MenuItemCommonFieldsPtr common;
  
  std::vector<MenuItemPtr> children;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubmenuMenuItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubmenuMenuItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubmenuMenuItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubmenuMenuItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MenuControllerParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MenuControllerParams, T>::value>;
  using DataView = MenuControllerParamsDataView;
  using Data_ = internal::MenuControllerParams_Data;

  template <typename... Args>
  static MenuControllerParamsPtr New(Args&&... args) {
    return MenuControllerParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MenuControllerParamsPtr From(const U& u) {
    return mojo::TypeConverter<MenuControllerParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MenuControllerParams>::Convert(*this);
  }


  MenuControllerParams();

  MenuControllerParams(
      const gfx::Font& badge_font,
      ::SkColor badge_color,
      ::SkColor badge_text_color,
      uint32_t badge_horizontal_margin,
      uint32_t badge_internal_padding,
      uint32_t badge_min_height,
      uint32_t badge_radius,
      ::SkColor iph_dot_color);


  ~MenuControllerParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MenuControllerParamsPtr>
  MenuControllerParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MenuControllerParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MenuControllerParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MenuControllerParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MenuControllerParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MenuControllerParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MenuControllerParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MenuControllerParams_UnserializedMessageContext<
            UserType, MenuControllerParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MenuControllerParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MenuControllerParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MenuControllerParams_UnserializedMessageContext<
            UserType, MenuControllerParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MenuControllerParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  gfx::Font badge_font;
  
  ::SkColor badge_color;
  
  ::SkColor badge_text_color;
  
  uint32_t badge_horizontal_margin;
  
  uint32_t badge_internal_padding;
  
  uint32_t badge_min_height;
  
  uint32_t badge_radius;
  
  ::SkColor iph_dot_color;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MenuControllerParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MenuControllerParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MenuControllerParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MenuControllerParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ContextMenu {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContextMenu, T>::value>;
  using DataView = ContextMenuDataView;
  using Data_ = internal::ContextMenu_Data;

  template <typename... Args>
  static ContextMenuPtr New(Args&&... args) {
    return ContextMenuPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContextMenuPtr From(const U& u) {
    return mojo::TypeConverter<ContextMenuPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContextMenu>::Convert(*this);
  }


  ContextMenu();

  ContextMenu(
      std::vector<MenuItemPtr> items,
      const ::gfx::Point& anchor,
      uint64_t target_view_id,
      MenuControllerParamsPtr params);

ContextMenu(const ContextMenu&) = delete;
ContextMenu& operator=(const ContextMenu&) = delete;

  ~ContextMenu();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContextMenuPtr>
  ContextMenuPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContextMenu::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContextMenu::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContextMenu::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContextMenu::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContextMenu_UnserializedMessageContext<
            UserType, ContextMenu::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContextMenu::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContextMenu::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContextMenu_UnserializedMessageContext<
            UserType, ContextMenu::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContextMenu::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<MenuItemPtr> items;
  
  ::gfx::Point anchor;
  
  uint64_t target_view_id;
  
  MenuControllerParamsPtr params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContextMenu::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContextMenu::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContextMenu::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContextMenu::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
MenuItemPtr MenuItem::Clone() const {
  switch (tag_) {
    case Tag::kSeparator:
      return NewSeparator(
          mojo::Clone(data_.separator));
    case Tag::kRegular:
      return NewRegular(
          mojo::Clone(data_.regular));
    case Tag::kSubmenu:
      return NewSubmenu(
          mojo::Clone(data_.submenu));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, MenuItem>::value>::type*>
bool MenuItem::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSeparator:
      return mojo::Equals(data_.separator, other.data_.separator);
    case Tag::kRegular:
      return mojo::Equals(data_.regular, other.data_.regular);
    case Tag::kSubmenu:
      return mojo::Equals(data_.submenu, other.data_.submenu);
  }

  return false;
}
template <typename StructPtrType>
MenuItemCommonFieldsPtr MenuItemCommonFields::Clone() const {
  return New(
      mojo::Clone(command_id),
      mojo::Clone(label),
      mojo::Clone(may_have_mnemonics),
      mojo::Clone(is_checked),
      mojo::Clone(icon),
      mojo::Clone(is_enabled),
      mojo::Clone(is_visible),
      mojo::Clone(is_alerted),
      mojo::Clone(is_new_feature)
  );
}

template <typename T, MenuItemCommonFields::EnableIfSame<T>*>
bool MenuItemCommonFields::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->command_id, other_struct.command_id))
    return false;
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->may_have_mnemonics, other_struct.may_have_mnemonics))
    return false;
  if (!mojo::Equals(this->is_checked, other_struct.is_checked))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  if (!mojo::Equals(this->is_enabled, other_struct.is_enabled))
    return false;
  if (!mojo::Equals(this->is_visible, other_struct.is_visible))
    return false;
  if (!mojo::Equals(this->is_alerted, other_struct.is_alerted))
    return false;
  if (!mojo::Equals(this->is_new_feature, other_struct.is_new_feature))
    return false;
  return true;
}

template <typename T, MenuItemCommonFields::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.command_id < rhs.command_id)
    return true;
  if (rhs.command_id < lhs.command_id)
    return false;
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.may_have_mnemonics < rhs.may_have_mnemonics)
    return true;
  if (rhs.may_have_mnemonics < lhs.may_have_mnemonics)
    return false;
  if (lhs.is_checked < rhs.is_checked)
    return true;
  if (rhs.is_checked < lhs.is_checked)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  if (lhs.is_enabled < rhs.is_enabled)
    return true;
  if (rhs.is_enabled < lhs.is_enabled)
    return false;
  if (lhs.is_visible < rhs.is_visible)
    return true;
  if (rhs.is_visible < lhs.is_visible)
    return false;
  if (lhs.is_alerted < rhs.is_alerted)
    return true;
  if (rhs.is_alerted < lhs.is_alerted)
    return false;
  if (lhs.is_new_feature < rhs.is_new_feature)
    return true;
  if (rhs.is_new_feature < lhs.is_new_feature)
    return false;
  return false;
}
template <typename StructPtrType>
SubmenuMenuItemPtr SubmenuMenuItem::Clone() const {
  return New(
      mojo::Clone(common),
      mojo::Clone(children)
  );
}

template <typename T, SubmenuMenuItem::EnableIfSame<T>*>
bool SubmenuMenuItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->common, other_struct.common))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  return true;
}

template <typename T, SubmenuMenuItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.common < rhs.common)
    return true;
  if (rhs.common < lhs.common)
    return false;
  if (lhs.children < rhs.children)
    return true;
  if (rhs.children < lhs.children)
    return false;
  return false;
}
template <typename StructPtrType>
MenuControllerParamsPtr MenuControllerParams::Clone() const {
  return New(
      mojo::Clone(badge_font),
      mojo::Clone(badge_color),
      mojo::Clone(badge_text_color),
      mojo::Clone(badge_horizontal_margin),
      mojo::Clone(badge_internal_padding),
      mojo::Clone(badge_min_height),
      mojo::Clone(badge_radius),
      mojo::Clone(iph_dot_color)
  );
}

template <typename T, MenuControllerParams::EnableIfSame<T>*>
bool MenuControllerParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->badge_font, other_struct.badge_font))
    return false;
  if (!mojo::Equals(this->badge_color, other_struct.badge_color))
    return false;
  if (!mojo::Equals(this->badge_text_color, other_struct.badge_text_color))
    return false;
  if (!mojo::Equals(this->badge_horizontal_margin, other_struct.badge_horizontal_margin))
    return false;
  if (!mojo::Equals(this->badge_internal_padding, other_struct.badge_internal_padding))
    return false;
  if (!mojo::Equals(this->badge_min_height, other_struct.badge_min_height))
    return false;
  if (!mojo::Equals(this->badge_radius, other_struct.badge_radius))
    return false;
  if (!mojo::Equals(this->iph_dot_color, other_struct.iph_dot_color))
    return false;
  return true;
}

template <typename T, MenuControllerParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.badge_font < rhs.badge_font)
    return true;
  if (rhs.badge_font < lhs.badge_font)
    return false;
  if (lhs.badge_color < rhs.badge_color)
    return true;
  if (rhs.badge_color < lhs.badge_color)
    return false;
  if (lhs.badge_text_color < rhs.badge_text_color)
    return true;
  if (rhs.badge_text_color < lhs.badge_text_color)
    return false;
  if (lhs.badge_horizontal_margin < rhs.badge_horizontal_margin)
    return true;
  if (rhs.badge_horizontal_margin < lhs.badge_horizontal_margin)
    return false;
  if (lhs.badge_internal_padding < rhs.badge_internal_padding)
    return true;
  if (rhs.badge_internal_padding < lhs.badge_internal_padding)
    return false;
  if (lhs.badge_min_height < rhs.badge_min_height)
    return true;
  if (rhs.badge_min_height < lhs.badge_min_height)
    return false;
  if (lhs.badge_radius < rhs.badge_radius)
    return true;
  if (rhs.badge_radius < lhs.badge_radius)
    return false;
  if (lhs.iph_dot_color < rhs.iph_dot_color)
    return true;
  if (rhs.iph_dot_color < lhs.iph_dot_color)
    return false;
  return false;
}
template <typename StructPtrType>
ContextMenuPtr ContextMenu::Clone() const {
  return New(
      mojo::Clone(items),
      mojo::Clone(anchor),
      mojo::Clone(target_view_id),
      mojo::Clone(params)
  );
}

template <typename T, ContextMenu::EnableIfSame<T>*>
bool ContextMenu::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->items, other_struct.items))
    return false;
  if (!mojo::Equals(this->anchor, other_struct.anchor))
    return false;
  if (!mojo::Equals(this->target_view_id, other_struct.target_view_id))
    return false;
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  return true;
}

template <typename T, ContextMenu::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.items < rhs.items)
    return true;
  if (rhs.items < lhs.items)
    return false;
  if (lhs.anchor < rhs.anchor)
    return true;
  if (rhs.anchor < lhs.anchor)
    return false;
  if (lhs.target_view_id < rhs.target_view_id)
    return true;
  if (rhs.target_view_id < lhs.target_view_id)
    return false;
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  return false;
}


}  // remote_cocoa::mojom

namespace mojo {


template <>
struct  StructTraits<::remote_cocoa::mojom::MenuItemCommonFields::DataView,
                                         ::remote_cocoa::mojom::MenuItemCommonFieldsPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::MenuItemCommonFieldsPtr* output) { output->reset(); }

  static decltype(::remote_cocoa::mojom::MenuItemCommonFields::command_id) command_id(
      const ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& input) {
    return input->command_id;
  }

  static const decltype(::remote_cocoa::mojom::MenuItemCommonFields::label)& label(
      const ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& input) {
    return input->label;
  }

  static decltype(::remote_cocoa::mojom::MenuItemCommonFields::may_have_mnemonics) may_have_mnemonics(
      const ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& input) {
    return input->may_have_mnemonics;
  }

  static decltype(::remote_cocoa::mojom::MenuItemCommonFields::is_checked) is_checked(
      const ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& input) {
    return input->is_checked;
  }

  static  decltype(::remote_cocoa::mojom::MenuItemCommonFields::icon)& icon(
       ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& input) {
    return input->icon;
  }

  static decltype(::remote_cocoa::mojom::MenuItemCommonFields::is_enabled) is_enabled(
      const ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& input) {
    return input->is_enabled;
  }

  static decltype(::remote_cocoa::mojom::MenuItemCommonFields::is_visible) is_visible(
      const ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& input) {
    return input->is_visible;
  }

  static decltype(::remote_cocoa::mojom::MenuItemCommonFields::is_alerted) is_alerted(
      const ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& input) {
    return input->is_alerted;
  }

  static decltype(::remote_cocoa::mojom::MenuItemCommonFields::is_new_feature) is_new_feature(
      const ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& input) {
    return input->is_new_feature;
  }

  static bool Read(::remote_cocoa::mojom::MenuItemCommonFields::DataView input, ::remote_cocoa::mojom::MenuItemCommonFieldsPtr* output);
};


template <>
struct  StructTraits<::remote_cocoa::mojom::SubmenuMenuItem::DataView,
                                         ::remote_cocoa::mojom::SubmenuMenuItemPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::SubmenuMenuItemPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::SubmenuMenuItemPtr* output) { output->reset(); }

  static  decltype(::remote_cocoa::mojom::SubmenuMenuItem::common)& common(
       ::remote_cocoa::mojom::SubmenuMenuItemPtr& input) {
    return input->common;
  }

  static  decltype(::remote_cocoa::mojom::SubmenuMenuItem::children)& children(
       ::remote_cocoa::mojom::SubmenuMenuItemPtr& input) {
    return input->children;
  }

  static bool Read(::remote_cocoa::mojom::SubmenuMenuItem::DataView input, ::remote_cocoa::mojom::SubmenuMenuItemPtr* output);
};


template <>
struct  StructTraits<::remote_cocoa::mojom::MenuControllerParams::DataView,
                                         ::remote_cocoa::mojom::MenuControllerParamsPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::MenuControllerParamsPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::MenuControllerParamsPtr* output) { output->reset(); }

  static const decltype(::remote_cocoa::mojom::MenuControllerParams::badge_font)& badge_font(
      const ::remote_cocoa::mojom::MenuControllerParamsPtr& input) {
    return input->badge_font;
  }

  static const decltype(::remote_cocoa::mojom::MenuControllerParams::badge_color)& badge_color(
      const ::remote_cocoa::mojom::MenuControllerParamsPtr& input) {
    return input->badge_color;
  }

  static const decltype(::remote_cocoa::mojom::MenuControllerParams::badge_text_color)& badge_text_color(
      const ::remote_cocoa::mojom::MenuControllerParamsPtr& input) {
    return input->badge_text_color;
  }

  static decltype(::remote_cocoa::mojom::MenuControllerParams::badge_horizontal_margin) badge_horizontal_margin(
      const ::remote_cocoa::mojom::MenuControllerParamsPtr& input) {
    return input->badge_horizontal_margin;
  }

  static decltype(::remote_cocoa::mojom::MenuControllerParams::badge_internal_padding) badge_internal_padding(
      const ::remote_cocoa::mojom::MenuControllerParamsPtr& input) {
    return input->badge_internal_padding;
  }

  static decltype(::remote_cocoa::mojom::MenuControllerParams::badge_min_height) badge_min_height(
      const ::remote_cocoa::mojom::MenuControllerParamsPtr& input) {
    return input->badge_min_height;
  }

  static decltype(::remote_cocoa::mojom::MenuControllerParams::badge_radius) badge_radius(
      const ::remote_cocoa::mojom::MenuControllerParamsPtr& input) {
    return input->badge_radius;
  }

  static const decltype(::remote_cocoa::mojom::MenuControllerParams::iph_dot_color)& iph_dot_color(
      const ::remote_cocoa::mojom::MenuControllerParamsPtr& input) {
    return input->iph_dot_color;
  }

  static bool Read(::remote_cocoa::mojom::MenuControllerParams::DataView input, ::remote_cocoa::mojom::MenuControllerParamsPtr* output);
};


template <>
struct  StructTraits<::remote_cocoa::mojom::ContextMenu::DataView,
                                         ::remote_cocoa::mojom::ContextMenuPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::ContextMenuPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::ContextMenuPtr* output) { output->reset(); }

  static  decltype(::remote_cocoa::mojom::ContextMenu::items)& items(
       ::remote_cocoa::mojom::ContextMenuPtr& input) {
    return input->items;
  }

  static const decltype(::remote_cocoa::mojom::ContextMenu::anchor)& anchor(
      const ::remote_cocoa::mojom::ContextMenuPtr& input) {
    return input->anchor;
  }

  static decltype(::remote_cocoa::mojom::ContextMenu::target_view_id) target_view_id(
      const ::remote_cocoa::mojom::ContextMenuPtr& input) {
    return input->target_view_id;
  }

  static const decltype(::remote_cocoa::mojom::ContextMenu::params)& params(
      const ::remote_cocoa::mojom::ContextMenuPtr& input) {
    return input->params;
  }

  static bool Read(::remote_cocoa::mojom::ContextMenu::DataView input, ::remote_cocoa::mojom::ContextMenuPtr* output);
};


template <>
struct  UnionTraits<::remote_cocoa::mojom::MenuItem::DataView,
                                        ::remote_cocoa::mojom::MenuItemPtr> {
  static bool IsNull(const ::remote_cocoa::mojom::MenuItemPtr& input) { return !input; }
  static void SetToNull(::remote_cocoa::mojom::MenuItemPtr* output) { output->reset(); }

  static ::remote_cocoa::mojom::MenuItem::Tag GetTag(const ::remote_cocoa::mojom::MenuItemPtr& input) {
    return input->which();
  }

  static  ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& separator( ::remote_cocoa::mojom::MenuItemPtr& input) {
    return input->get_separator();
  }

  static  ::remote_cocoa::mojom::MenuItemCommonFieldsPtr& regular( ::remote_cocoa::mojom::MenuItemPtr& input) {
    return input->get_regular();
  }

  static  ::remote_cocoa::mojom::SubmenuMenuItemPtr& submenu( ::remote_cocoa::mojom::MenuItemPtr& input) {
    return input->get_submenu();
  }

  static bool Read(::remote_cocoa::mojom::MenuItem::DataView input, ::remote_cocoa::mojom::MenuItemPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_MENU_MOJOM_H_