// components/remote_cocoa/common/menu.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/remote_cocoa/common/menu.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/remote_cocoa/common/menu.mojom-params-data.h"
#include "components/remote_cocoa/common/menu.mojom-shared-message-ids.h"

#include "components/remote_cocoa/common/menu.mojom-import-headers.h"
#include "components/remote_cocoa/common/menu.mojom-test-utils.h"


namespace remote_cocoa::mojom {
MenuItemCommonFields::MenuItemCommonFields()
    : command_id(),
      label(),
      may_have_mnemonics(false),
      is_checked(false),
      icon(),
      is_enabled(false),
      is_visible(false),
      is_alerted(false),
      is_new_feature(false) {}

MenuItemCommonFields::MenuItemCommonFields(
    int32_t command_id_in,
    const ::std::u16string& label_in,
    bool may_have_mnemonics_in,
    bool is_checked_in,
    const ::gfx::ImageSkia& icon_in,
    bool is_enabled_in,
    bool is_visible_in,
    bool is_alerted_in,
    bool is_new_feature_in)
    : command_id(std::move(command_id_in)),
      label(std::move(label_in)),
      may_have_mnemonics(std::move(may_have_mnemonics_in)),
      is_checked(std::move(is_checked_in)),
      icon(std::move(icon_in)),
      is_enabled(std::move(is_enabled_in)),
      is_visible(std::move(is_visible_in)),
      is_alerted(std::move(is_alerted_in)),
      is_new_feature(std::move(is_new_feature_in)) {}

MenuItemCommonFields::~MenuItemCommonFields() = default;

void MenuItemCommonFields::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "command_id"), this->command_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_have_mnemonics"), this->may_have_mnemonics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_checked"), this->is_checked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ImageSkia&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_enabled"), this->is_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_visible"), this->is_visible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_alerted"), this->is_alerted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_new_feature"), this->is_new_feature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MenuItemCommonFields::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SubmenuMenuItem::SubmenuMenuItem()
    : common(),
      children() {}

SubmenuMenuItem::SubmenuMenuItem(
    MenuItemCommonFieldsPtr common_in,
    std::vector<MenuItemPtr> children_in)
    : common(std::move(common_in)),
      children(std::move(children_in)) {}

SubmenuMenuItem::~SubmenuMenuItem() = default;

void SubmenuMenuItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "common"), this->common,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MenuItemCommonFieldsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children"), this->children,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MenuItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SubmenuMenuItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MenuControllerParams::MenuControllerParams()
    : badge_font(),
      badge_color(),
      badge_text_color(),
      badge_horizontal_margin(),
      badge_internal_padding(),
      badge_min_height(),
      badge_radius(),
      iph_dot_color() {}

MenuControllerParams::MenuControllerParams(
    const gfx::Font& badge_font_in,
    ::SkColor badge_color_in,
    ::SkColor badge_text_color_in,
    uint32_t badge_horizontal_margin_in,
    uint32_t badge_internal_padding_in,
    uint32_t badge_min_height_in,
    uint32_t badge_radius_in,
    ::SkColor iph_dot_color_in)
    : badge_font(std::move(badge_font_in)),
      badge_color(std::move(badge_color_in)),
      badge_text_color(std::move(badge_text_color_in)),
      badge_horizontal_margin(std::move(badge_horizontal_margin_in)),
      badge_internal_padding(std::move(badge_internal_padding_in)),
      badge_min_height(std::move(badge_min_height_in)),
      badge_radius(std::move(badge_radius_in)),
      iph_dot_color(std::move(iph_dot_color_in)) {}

MenuControllerParams::~MenuControllerParams() = default;

void MenuControllerParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "badge_font"), this->badge_font,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const gfx::Font&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "badge_color"), this->badge_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "badge_text_color"), this->badge_text_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "badge_horizontal_margin"), this->badge_horizontal_margin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "badge_internal_padding"), this->badge_internal_padding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "badge_min_height"), this->badge_min_height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "badge_radius"), this->badge_radius,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iph_dot_color"), this->iph_dot_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MenuControllerParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContextMenu::ContextMenu()
    : items(),
      anchor(),
      target_view_id(),
      params() {}

ContextMenu::ContextMenu(
    std::vector<MenuItemPtr> items_in,
    const ::gfx::Point& anchor_in,
    uint64_t target_view_id_in,
    MenuControllerParamsPtr params_in)
    : items(std::move(items_in)),
      anchor(std::move(anchor_in)),
      target_view_id(std::move(target_view_id_in)),
      params(std::move(params_in)) {}

ContextMenu::~ContextMenu() = default;

void ContextMenu::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "items"), this->items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MenuItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor"), this->anchor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_view_id"), this->target_view_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MenuControllerParamsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContextMenu::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MenuItemPtr
MenuItem::NewSeparator(
    MenuItemCommonFieldsPtr value) {
  return MenuItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSeparator)>,
      std::move(value));
}

MenuItemPtr
MenuItem::NewRegular(
    MenuItemCommonFieldsPtr value) {
  return MenuItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRegular)>,
      std::move(value));
}

MenuItemPtr
MenuItem::NewSubmenu(
    SubmenuMenuItemPtr value) {
  return MenuItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSubmenu)>,
      std::move(value));
}

MenuItem::MenuItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kSeparator)>,
    MenuItemCommonFieldsPtr value)
    : tag_(Tag::kSeparator),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSeparator)>,
            std::move(value)) {}

MenuItem::MenuItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegular)>,
    MenuItemCommonFieldsPtr value)
    : tag_(Tag::kRegular),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRegular)>,
            std::move(value)) {}

MenuItem::MenuItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kSubmenu)>,
    SubmenuMenuItemPtr value)
    : tag_(Tag::kSubmenu),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSubmenu)>,
            std::move(value)) {}
MenuItem::~MenuItem() {
  DestroyActive();
}

void MenuItem::set_separator(MenuItemCommonFieldsPtr separator) {
  if (tag_ == Tag::kSeparator) {
    data_.separator = std::move(separator);
  } else {
    DestroyActive();
    tag_ = Tag::kSeparator;
    new (&data_.separator) MenuItemCommonFieldsPtr(
        std::move(separator));
  }
}

void MenuItem::set_regular(MenuItemCommonFieldsPtr regular) {
  if (tag_ == Tag::kRegular) {
    data_.regular = std::move(regular);
  } else {
    DestroyActive();
    tag_ = Tag::kRegular;
    new (&data_.regular) MenuItemCommonFieldsPtr(
        std::move(regular));
  }
}

void MenuItem::set_submenu(SubmenuMenuItemPtr submenu) {
  if (tag_ == Tag::kSubmenu) {
    data_.submenu = std::move(submenu);
  } else {
    DestroyActive();
    tag_ = Tag::kSubmenu;
    new (&data_.submenu) SubmenuMenuItemPtr(
        std::move(submenu));
  }
}


MenuItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSeparator)>,
    MenuItemCommonFieldsPtr value)
    : separator(std::move(value)) {}

MenuItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegular)>,
    MenuItemCommonFieldsPtr value)
    : regular(std::move(value)) {}

MenuItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSubmenu)>,
    SubmenuMenuItemPtr value)
    : submenu(std::move(value)) {}

void MenuItem::DestroyActive() {
  switch (tag_) {

    case Tag::kSeparator:
      std::destroy_at(&data_.separator);
      break;
    case Tag::kRegular:
      std::destroy_at(&data_.regular);
      break;
    case Tag::kSubmenu:
      std::destroy_at(&data_.submenu);
      break;
  }
}

bool MenuItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

MenuHost::IPCStableHashFunction MenuHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MenuHost>(message.name())) {
    case messages::MenuHost::kCommandActivated: {
      return &MenuHost::CommandActivated_Sym::IPCStableHash;
    }
    case messages::MenuHost::kMenuClosed: {
      return &MenuHost::MenuClosed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MenuHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MenuHost>(message.name())) {
      case messages::MenuHost::kCommandActivated:
            return "Receive remote_cocoa::mojom::MenuHost::CommandActivated";
      case messages::MenuHost::kMenuClosed:
            return "Receive remote_cocoa::mojom::MenuHost::MenuClosed";
    }
  } else {
    switch (static_cast<messages::MenuHost>(message.name())) {
      case messages::MenuHost::kCommandActivated:
            return "Receive reply remote_cocoa::mojom::MenuHost::CommandActivated";
      case messages::MenuHost::kMenuClosed:
            return "Receive reply remote_cocoa::mojom::MenuHost::MenuClosed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MenuHost::CommandActivated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c1e8cf9;  // IPCStableHash for remote_cocoa::mojom::MenuHost::CommandActivated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MenuHost::MenuClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8349da83;  // IPCStableHash for remote_cocoa::mojom::MenuHost::MenuClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MenuHostProxy::MenuHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MenuHostProxy::CommandActivated(
    int32_t in_command_id, int32_t in_event_flags) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::MenuHost::CommandActivated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command_id"), in_command_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_flags"), in_event_flags,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MenuHost::kCommandActivated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::MenuHost_CommandActivated_Params_Data> params(
          message);
  params.Allocate();

  params->command_id = in_command_id;

  params->event_flags = in_event_flags;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MenuHost::Name_);
  message.set_method_name("CommandActivated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MenuHostProxy::MenuClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::MenuHost::MenuClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MenuHost::kMenuClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::MenuHost_MenuClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MenuHost::Name_);
  message.set_method_name("MenuClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MenuHostStubDispatch::Accept(
    MenuHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MenuHost>(message->header()->name)) {
    case messages::MenuHost::kCommandActivated: {
      DCHECK(message->is_serialized());
      internal::MenuHost_CommandActivated_Params_Data* params =
          reinterpret_cast<internal::MenuHost_CommandActivated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MenuHost.0
      bool success = true;
      int32_t p_command_id{};
      int32_t p_event_flags{};
      MenuHost_CommandActivated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_command_id = input_data_view.command_id();
      if (success)
        p_event_flags = input_data_view.event_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MenuHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommandActivated(        
        std::move(p_command_id), 
        std::move(p_event_flags));
      return true;
    }
    case messages::MenuHost::kMenuClosed: {
      DCHECK(message->is_serialized());
      internal::MenuHost_MenuClosed_Params_Data* params =
          reinterpret_cast<internal::MenuHost_MenuClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MenuHost.1
      bool success = true;
      MenuHost_MenuClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MenuHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MenuClosed(        );
      return true;
    }
  }
  return false;
}

// static
bool MenuHostStubDispatch::AcceptWithResponder(
    MenuHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MenuHost>(message->header()->name)) {
    case messages::MenuHost::kCommandActivated: {
      break;
    }
    case messages::MenuHost::kMenuClosed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMenuHostValidationInfo[] = {
    { &internal::MenuHost_CommandActivated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MenuHost_MenuClosed_Params_Data::Validate,
     nullptr /* no response */},
};

bool MenuHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::MenuHost::Name_,
    kMenuHostValidationInfo);
}

// The declaration includes the definition on other builds.

Menu::IPCStableHashFunction Menu::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Menu>(message.name())) {
    case messages::Menu::kCancel: {
      return &Menu::Cancel_Sym::IPCStableHash;
    }
    case messages::Menu::kUpdateMenuItem: {
      return &Menu::UpdateMenuItem_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Menu::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Menu>(message.name())) {
      case messages::Menu::kCancel:
            return "Receive remote_cocoa::mojom::Menu::Cancel";
      case messages::Menu::kUpdateMenuItem:
            return "Receive remote_cocoa::mojom::Menu::UpdateMenuItem";
    }
  } else {
    switch (static_cast<messages::Menu>(message.name())) {
      case messages::Menu::kCancel:
            return "Receive reply remote_cocoa::mojom::Menu::Cancel";
      case messages::Menu::kUpdateMenuItem:
            return "Receive reply remote_cocoa::mojom::Menu::UpdateMenuItem";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Menu::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa55af15e;  // IPCStableHash for remote_cocoa::mojom::Menu::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Menu::UpdateMenuItem_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a7b3fe5;  // IPCStableHash for remote_cocoa::mojom::Menu::UpdateMenuItem
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MenuProxy::MenuProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MenuProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send remote_cocoa::mojom::Menu::Cancel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Menu::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::Menu_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Menu::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MenuProxy::UpdateMenuItem(
    int32_t in_command_id, bool in_enabled, bool in_visible, const ::std::u16string& in_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send remote_cocoa::mojom::Menu::UpdateMenuItem", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command_id"), in_command_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Menu::kUpdateMenuItem), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::remote_cocoa::mojom::internal::Menu_UpdateMenuItem_Params_Data> params(
          message);
  params.Allocate();

  params->command_id = in_command_id;

  params->enabled = in_enabled;

  params->visible = in_visible;
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in Menu.UpdateMenuItem request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Menu::Name_);
  message.set_method_name("UpdateMenuItem");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MenuStubDispatch::Accept(
    Menu* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Menu>(message->header()->name)) {
    case messages::Menu::kCancel: {
      DCHECK(message->is_serialized());
      internal::Menu_Cancel_Params_Data* params =
          reinterpret_cast<internal::Menu_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Menu.0
      bool success = true;
      Menu_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Menu::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        );
      return true;
    }
    case messages::Menu::kUpdateMenuItem: {
      DCHECK(message->is_serialized());
      internal::Menu_UpdateMenuItem_Params_Data* params =
          reinterpret_cast<internal::Menu_UpdateMenuItem_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Menu.1
      bool success = true;
      int32_t p_command_id{};
      bool p_enabled{};
      bool p_visible{};
      ::std::u16string p_label{};
      Menu_UpdateMenuItem_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_command_id = input_data_view.command_id();
      if (success)
        p_enabled = input_data_view.enabled();
      if (success)
        p_visible = input_data_view.visible();
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Menu::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateMenuItem(        
        std::move(p_command_id), 
        std::move(p_enabled), 
        std::move(p_visible), 
        std::move(p_label));
      return true;
    }
  }
  return false;
}

// static
bool MenuStubDispatch::AcceptWithResponder(
    Menu* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Menu>(message->header()->name)) {
    case messages::Menu::kCancel: {
      break;
    }
    case messages::Menu::kUpdateMenuItem: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMenuValidationInfo[] = {
    { &internal::Menu_Cancel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Menu_UpdateMenuItem_Params_Data::Validate,
     nullptr /* no response */},
};

bool MenuRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::remote_cocoa::mojom::Menu::Name_,
    kMenuValidationInfo);
}



}  // remote_cocoa::mojom


namespace mojo {


// static
bool StructTraits<::remote_cocoa::mojom::MenuItemCommonFields::DataView, ::remote_cocoa::mojom::MenuItemCommonFieldsPtr>::Read(
    ::remote_cocoa::mojom::MenuItemCommonFields::DataView input,
    ::remote_cocoa::mojom::MenuItemCommonFieldsPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::MenuItemCommonFieldsPtr result(::remote_cocoa::mojom::MenuItemCommonFields::New());
  
      if (success)
        result->command_id = input.command_id();
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success)
        result->may_have_mnemonics = input.may_have_mnemonics();
      if (success)
        result->is_checked = input.is_checked();
      if (success && !input.ReadIcon(&result->icon))
        success = false;
      if (success)
        result->is_enabled = input.is_enabled();
      if (success)
        result->is_visible = input.is_visible();
      if (success)
        result->is_alerted = input.is_alerted();
      if (success)
        result->is_new_feature = input.is_new_feature();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::remote_cocoa::mojom::SubmenuMenuItem::DataView, ::remote_cocoa::mojom::SubmenuMenuItemPtr>::Read(
    ::remote_cocoa::mojom::SubmenuMenuItem::DataView input,
    ::remote_cocoa::mojom::SubmenuMenuItemPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::SubmenuMenuItemPtr result(::remote_cocoa::mojom::SubmenuMenuItem::New());
  
      if (success && !input.ReadCommon(&result->common))
        success = false;
      if (success && !input.ReadChildren(&result->children))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::remote_cocoa::mojom::MenuControllerParams::DataView, ::remote_cocoa::mojom::MenuControllerParamsPtr>::Read(
    ::remote_cocoa::mojom::MenuControllerParams::DataView input,
    ::remote_cocoa::mojom::MenuControllerParamsPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::MenuControllerParamsPtr result(::remote_cocoa::mojom::MenuControllerParams::New());
  
      if (success && !input.ReadBadgeFont(&result->badge_font))
        success = false;
      if (success && !input.ReadBadgeColor(&result->badge_color))
        success = false;
      if (success && !input.ReadBadgeTextColor(&result->badge_text_color))
        success = false;
      if (success)
        result->badge_horizontal_margin = input.badge_horizontal_margin();
      if (success)
        result->badge_internal_padding = input.badge_internal_padding();
      if (success)
        result->badge_min_height = input.badge_min_height();
      if (success)
        result->badge_radius = input.badge_radius();
      if (success && !input.ReadIphDotColor(&result->iph_dot_color))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::remote_cocoa::mojom::ContextMenu::DataView, ::remote_cocoa::mojom::ContextMenuPtr>::Read(
    ::remote_cocoa::mojom::ContextMenu::DataView input,
    ::remote_cocoa::mojom::ContextMenuPtr* output) {
  bool success = true;
  ::remote_cocoa::mojom::ContextMenuPtr result(::remote_cocoa::mojom::ContextMenu::New());
  
      if (success && !input.ReadItems(&result->items))
        success = false;
      if (success && !input.ReadAnchor(&result->anchor))
        success = false;
      if (success)
        result->target_view_id = input.target_view_id();
      if (success && !input.ReadParams(&result->params))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::remote_cocoa::mojom::MenuItem::DataView, ::remote_cocoa::mojom::MenuItemPtr>::Read(
    ::remote_cocoa::mojom::MenuItem::DataView input,
    ::remote_cocoa::mojom::MenuItemPtr* output) {
  using UnionType = ::remote_cocoa::mojom::MenuItem;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSeparator: {
      ::remote_cocoa::mojom::MenuItemCommonFieldsPtr result_separator{};
      if (!input.ReadSeparator(&result_separator))
        return false;

      *output = UnionType::NewSeparator(
          std::move(result_separator));
      break;
    }
    case Tag::kRegular: {
      ::remote_cocoa::mojom::MenuItemCommonFieldsPtr result_regular{};
      if (!input.ReadRegular(&result_regular))
        return false;

      *output = UnionType::NewRegular(
          std::move(result_regular));
      break;
    }
    case Tag::kSubmenu: {
      ::remote_cocoa::mojom::SubmenuMenuItemPtr result_submenu{};
      if (!input.ReadSubmenu(&result_submenu))
        return false;

      *output = UnionType::NewSubmenu(
          std::move(result_submenu));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace remote_cocoa::mojom {


void MenuHostInterceptorForTesting::CommandActivated(int32_t command_id, int32_t event_flags) {
  GetForwardingInterface()->CommandActivated(
    std::move(command_id)
    , 
    std::move(event_flags)
    );
}
void MenuHostInterceptorForTesting::MenuClosed() {
  GetForwardingInterface()->MenuClosed();
}
MenuHostAsyncWaiter::MenuHostAsyncWaiter(
    MenuHost* proxy) : proxy_(proxy) {}

MenuHostAsyncWaiter::~MenuHostAsyncWaiter() = default;





void MenuInterceptorForTesting::Cancel() {
  GetForwardingInterface()->Cancel();
}
void MenuInterceptorForTesting::UpdateMenuItem(int32_t command_id, bool enabled, bool visible, const ::std::u16string& label) {
  GetForwardingInterface()->UpdateMenuItem(
    std::move(command_id)
    , 
    std::move(enabled)
    , 
    std::move(visible)
    , 
    std::move(label)
    );
}
MenuAsyncWaiter::MenuAsyncWaiter(
    Menu* proxy) : proxy_(proxy) {}

MenuAsyncWaiter::~MenuAsyncWaiter() = default;







}  // remote_cocoa::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif