// components/remote_cocoa/common/font.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_SEND_VALIDATION_H_

#include "components/remote_cocoa/common/font.mojom-shared-internal.h"

#include "components/remote_cocoa/common/font.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::remote_cocoa::mojom::SystemFont, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::remote_cocoa::mojom::FontWeight, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::remote_cocoa::mojom::FontDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::remote_cocoa::mojom::FontDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::remote_cocoa::mojom::internal::Font_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<decltype(fragment->name)>
          name_fragment(fragment.message());
      name_fragment.Claim(&fragment->name);
      
      mojo::internal::Serialize<::remote_cocoa::mojom::FontNameDataView, send_validation>(
        in_name,
        name_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in Font struct");

      fragment->size = Traits::size(input);

      fragment->style = Traits::style(input);

      
      mojo::internal::Serialize<::remote_cocoa::mojom::FontWeight>(
        Traits::weight(input),
        &fragment->weight);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::remote_cocoa::mojom::FontNameDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::remote_cocoa::mojom::FontNameDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::remote_cocoa::mojom::internal::FontName_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::remote_cocoa::mojom::FontNameDataView::Tag::kSystemFont: {
    decltype(Traits::system_font(input))
    in_system_font = Traits::system_font(input);
        
mojo::internal::Serialize<::remote_cocoa::mojom::SystemFont, send_validation>(
  in_system_font,
  &fragment->data.f_system_font);
    break;
  }
  case ::remote_cocoa::mojom::FontNameDataView::Tag::kRegularFont: {
    decltype(Traits::regular_font(input))
    in_regular_font = Traits::regular_font(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_regular_font)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView, send_validation>(
  in_regular_font,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null regular_font in FontName union");
    fragment->data.f_regular_font.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_SEND_VALIDATION_H_