// components/remote_cocoa/common/font.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_DATA_VIEW_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/remote_cocoa/common/font.mojom-shared-internal.h"


namespace remote_cocoa::mojom {
class FontDataView;

class FontNameDataView;


}  // remote_cocoa::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::FontDataView> {
  using Data = ::remote_cocoa::mojom::internal::Font_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::remote_cocoa::mojom::FontNameDataView> {
  using Data = ::remote_cocoa::mojom::internal::FontName_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace remote_cocoa::mojom {


enum class SystemFont : int32_t {
  
  kGeneral = 0,
  
  kMenu = 1,
  
  kToolTip = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SystemFont value);
inline bool IsKnownEnumValue(SystemFont value) {
  return internal::SystemFont_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FontWeight : int32_t {
  
  kThin = 100,
  
  kExtraLight = 200,
  
  kLight = 300,
  
  kNormal = 400,
  
  kMedium = 500,
  
  kSemibold = 600,
  
  kBold = 700,
  
  kExtraBold = 800,
  
  kBlack = 900,
  kMinValue = 100,
  kMaxValue = 900,
};

 std::ostream& operator<<(std::ostream& os, FontWeight value);
inline bool IsKnownEnumValue(FontWeight value) {
  return internal::FontWeight_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FontDataView {
 public:
  FontDataView() = default;

  FontDataView(
      internal::Font_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      FontNameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = !data_->name.is_null() ? &data_->name : nullptr;
    return mojo::internal::Deserialize<::remote_cocoa::mojom::FontNameDataView>(
        pointer, output, message_);
  }
  uint32_t size() const {
    return data_->size;
  }
  uint32_t style() const {
    return data_->style;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWeight(UserType* output) const {
    auto data_value = data_->weight;
    return mojo::internal::Deserialize<::remote_cocoa::mojom::FontWeight>(
        data_value, output);
  }
  FontWeight weight() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::remote_cocoa::mojom::FontWeight>(data_->weight));
  }
 private:
  internal::Font_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FontNameDataView {
 public:
  using Tag = internal::FontName_Data::FontName_Tag;

  FontNameDataView() = default;

  FontNameDataView(
      internal::FontName_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_system_font() const { return data_->tag == Tag::kSystemFont; }
  template <typename UserType>
  [[nodiscard]] bool ReadSystemFont(UserType* output) const {
    CHECK(is_system_font());
    return mojo::internal::Deserialize<::remote_cocoa::mojom::SystemFont>(
        data_->data.f_system_font, output);
  }
  SystemFont system_font() const {
    CHECK(is_system_font());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::remote_cocoa::mojom::SystemFont>(data_->data.f_system_font));
  }
  bool is_regular_font() const { return data_->tag == Tag::kRegularFont; }
  inline void GetRegularFontDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRegularFont(UserType* output) const {
    
    CHECK(is_regular_font());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_regular_font.Get(), output, message_);
  }

 private:
  internal::FontName_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // remote_cocoa::mojom

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_FONT_MOJOM_DATA_VIEW_H_