// components/remote_cocoa/common/application.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_REMOTE_COCOA_COMMON_APPLICATION_MOJOM_H_
#define COMPONENTS_REMOTE_COCOA_COMMON_APPLICATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/remote_cocoa/common/application.mojom-features.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/application.mojom-shared.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/application.mojom-forward.h"  // IWYU pragma: export
#include "components/remote_cocoa/common/alert.mojom-forward.h"
#include "components/remote_cocoa/common/native_widget_ns_window.mojom-forward.h"
#include "components/remote_cocoa/common/native_widget_ns_window_host.mojom-forward.h"
#include "components/remote_cocoa/common/text_input_host.mojom-forward.h"
#include "components/system_media_controls/mac/remote_cocoa/system_media_controls.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace remote_cocoa::mojom {

class StubInterfaceProxy;

template <typename ImplRefTraits>
class StubInterfaceStub;

class StubInterfaceRequestValidator;


class StubInterface
    : public StubInterfaceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.StubInterface";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StubInterfaceInterfaceBase;
  using Proxy_ = StubInterfaceProxy;

  template <typename ImplRefTraits>
  using Stub_ = StubInterfaceStub<ImplRefTraits>;

  using RequestValidator_ = StubInterfaceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StubInterface() = default;
};

class ApplicationProxy;

template <typename ImplRefTraits>
class ApplicationStub;

class ApplicationRequestValidator;


class Application
    : public ApplicationInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "remote_cocoa.mojom.Application";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ApplicationInterfaceBase;
  using Proxy_ = ApplicationProxy;

  template <typename ImplRefTraits>
  using Stub_ = ApplicationStub<ImplRefTraits>;

  using RequestValidator_ = ApplicationRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateAlertMinVersion = 0,
    kCreateNativeWidgetNSWindowMinVersion = 0,
    kCreateRenderWidgetHostNSViewMinVersion = 0,
    kCreateSystemMediaControlsBridgeMinVersion = 0,
    kCreateWebContentsNSViewMinVersion = 0,
    kForwardCutCopyPasteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateAlert_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateNativeWidgetNSWindow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateRenderWidgetHostNSView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateSystemMediaControlsBridge_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateWebContentsNSView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForwardCutCopyPaste_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Application() = default;

  virtual void CreateAlert(::mojo::PendingReceiver<::remote_cocoa::mojom::AlertBridge> alert_bridge_receiver) = 0;

  virtual void CreateNativeWidgetNSWindow(uint64_t bridge_id, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::NativeWidgetNSWindow> window_receiver, ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::NativeWidgetNSWindowHost> host, ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::TextInputHost> text_input_host) = 0;

  virtual void CreateRenderWidgetHostNSView(uint64_t view_id, ::mojo::PendingAssociatedRemote<StubInterface> host, ::mojo::PendingAssociatedReceiver<StubInterface> view_receiver) = 0;

  virtual void CreateSystemMediaControlsBridge(::mojo::PendingReceiver<::system_media_controls::mojom::SystemMediaControls> receiver, ::mojo::PendingRemote<::system_media_controls::mojom::SystemMediaControlsObserver> host) = 0;

  virtual void CreateWebContentsNSView(uint64_t view_id, ::mojo::PendingAssociatedRemote<StubInterface> host, ::mojo::PendingAssociatedReceiver<StubInterface> view_receiver) = 0;

  virtual void ForwardCutCopyPaste(CutCopyPasteCommand command) = 0;
};



class  StubInterfaceProxy
    : public StubInterface {
 public:
  using InterfaceType = StubInterface;

  explicit StubInterfaceProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ApplicationProxy
    : public Application {
 public:
  using InterfaceType = Application;

  explicit ApplicationProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateAlert(::mojo::PendingReceiver<::remote_cocoa::mojom::AlertBridge> alert_bridge_receiver) final;
  
  void CreateNativeWidgetNSWindow(uint64_t bridge_id, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::NativeWidgetNSWindow> window_receiver, ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::NativeWidgetNSWindowHost> host, ::mojo::PendingAssociatedRemote<::remote_cocoa::mojom::TextInputHost> text_input_host) final;
  
  void CreateRenderWidgetHostNSView(uint64_t view_id, ::mojo::PendingAssociatedRemote<StubInterface> host, ::mojo::PendingAssociatedReceiver<StubInterface> view_receiver) final;
  
  void CreateSystemMediaControlsBridge(::mojo::PendingReceiver<::system_media_controls::mojom::SystemMediaControls> receiver, ::mojo::PendingRemote<::system_media_controls::mojom::SystemMediaControlsObserver> host) final;
  
  void CreateWebContentsNSView(uint64_t view_id, ::mojo::PendingAssociatedRemote<StubInterface> host, ::mojo::PendingAssociatedReceiver<StubInterface> view_receiver) final;
  
  void ForwardCutCopyPaste(CutCopyPasteCommand command) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  StubInterfaceStubDispatch {
 public:
  static bool Accept(StubInterface* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StubInterface* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StubInterface>>
class StubInterfaceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StubInterfaceStub() = default;
  ~StubInterfaceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StubInterfaceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StubInterfaceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ApplicationStubDispatch {
 public:
  static bool Accept(Application* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Application* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Application>>
class ApplicationStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ApplicationStub() = default;
  ~ApplicationStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ApplicationStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ApplicationStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  StubInterfaceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ApplicationRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // remote_cocoa::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_REMOTE_COCOA_COMMON_APPLICATION_MOJOM_H_